#!/bin/bash
CONTROLLER_NODE=${CONTROLLER_NODE:-}
COMPUTE_NODE=${COMPUTE_NODE:-}

if [ $(id -u) != 0 ]; then
    SUDO='sudo'
fi

echo -e "Generating packstack config for:
- keystone
- glance (swift backend)
- nova
- neutron (ovs+vxlan)
- lbaasv2
- swift
- sahara
- trove
- tempest (regex: 'smoke dashboard')"
echo "tempest will run if packstack's installation completes successfully."
echo

if [ -z $COMPUTE_NODE ]; then
  NODE_FLAGS="--allinone"
else
  NODE_FLAGS="--allinone --os-controller-host=$CONTROLLER_NODE --os-network-hosts=$CONTROLLER_NODE --os-compute-hosts=$COMPUTE_NODE"
fi

$SUDO packstack ${ADDITIONAL_ARGS} \
          ${NODE_FLAGS} \
          --debug \
          --os-debug-mode=y \
          --service-workers=2 \
          --default-password="packstack" \
          --os-aodh-install=n \
          --os-ceilometer-install=n \
          --os-cinder-install=n \
          --os-horizon-install=n \
          --glance-backend=swift \
          --os-neutron-lbaas-install=y \
          --os-neutron-vpnaas-install=n \
          --os-sahara-install=y \
          --os-trove-install=y \
          --keystone-token-format=UUID \
          --provision-uec-kernel-url="/tmp/cirros/cirros-0.3.5-x86_64-vmlinuz" \
          --provision-uec-ramdisk-url="/tmp/cirros/cirros-0.3.5-x86_64-initrd" \
          --provision-uec-disk-url="/tmp/cirros/cirros-0.3.5-x86_64-disk.img" \
          --provision-demo=y \
          --provision-tempest=y \
          --run-tempest=y \
          --run-tempest-tests="smoke" || export FAILURE=true
