"""Initial revision

Revision ID: 414bf1d36e7d
Revises: None
Create Date: 2015-04-08 15:05:50.942578

"""

# revision identifiers, used by Alembic.
revision = '414bf1d36e7d'
down_revision = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.create_table('audit_templates',
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('deleted_at', sa.DateTime(), nullable=True),
    sa.Column('deleted', sa.Integer(), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('uuid', sa.String(length=36), nullable=True),
    sa.Column('name', sa.String(length=63), nullable=True),
    sa.Column('description', sa.String(length=255), nullable=True),
    sa.Column('host_aggregate', sa.Integer(), nullable=True),
    sa.Column('goal', sa.String(length=63), nullable=True),
    sa.Column('extra', watcher.db.sqlalchemy.models.JSONEncodedDict(), nullable=True),
    sa.Column('version', sa.String(length=15), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name', name='uniq_audit_templates0name'),
    sa.UniqueConstraint('uuid', name='uniq_audit_templates0uuid')
    )
    op.create_table('audits',
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('deleted_at', sa.DateTime(), nullable=True),
    sa.Column('deleted', sa.Integer(), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('uuid', sa.String(length=36), nullable=True),
    sa.Column('type', sa.String(length=20), nullable=True),
    sa.Column('state', sa.String(length=20), nullable=True),
    sa.Column('deadline', sa.DateTime(), nullable=True),
    sa.Column('audit_template_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['audit_template_id'], ['audit_templates.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('uuid', name='uniq_audits0uuid')
    )
    op.create_table('action_plans',
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('deleted_at', sa.DateTime(), nullable=True),
    sa.Column('deleted', sa.Integer(), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('uuid', sa.String(length=36), nullable=True),
    sa.Column('first_action_id', sa.Integer(), nullable=True),
    sa.Column('audit_id', sa.Integer(), nullable=True),
    sa.Column('state', sa.String(length=20), nullable=True),
    sa.ForeignKeyConstraint(['audit_id'], ['audits.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('uuid', name='uniq_action_plans0uuid')
    )
    op.create_table('actions',
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('deleted_at', sa.DateTime(), nullable=True),
    sa.Column('deleted', sa.Integer(), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('uuid', sa.String(length=36), nullable=True),
    sa.Column('action_plan_id', sa.Integer(), nullable=True),
    sa.Column('description', sa.String(length=255), nullable=True),
    sa.Column('state', sa.String(length=20), nullable=True),
    sa.Column('alarm', sa.String(length=36), nullable=True),
    sa.Column('next', sa.String(length=36), nullable=True),
    sa.ForeignKeyConstraint(['action_plan_id'], ['action_plans.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('uuid', name='uniq_actions0uuid')
    )
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('actions')
    op.drop_table('action_plans')
    op.drop_table('audits')
    op.drop_table('audit_templates')
    ### end Alembic commands ###
