@ECHO OFF

REM This is an automatically generated Windows batch file. It creates the
REM base disk for an OpenStack training-labs setup.

SETLOCAL ENABLEDELAYEDEXPANSION

ECHO.
ECHO OpenStack labs for VirtualBox on Windows
ECHO Generated by osbash
ECHO.
ECHO Create base disk
ECHO.

REM vim: set ai ts=4 sw=4 et ft=dosbatch:

REM Load likely VBoxManage location from configuration file
CALL "%~dp0\CONFIG.BAT"

IF EXIST "%VBM%" GOTO vbm_found

REM Before searching, try a likely alternative

SET VBM=d:\Program Files\Oracle\VirtualBox\VBoxManage.exe

IF EXIST "%VBM%" GOTO vbm_found

ECHO.
ECHO %time% Searching %SystemDrive% for VBoxManage, this may take a while
ECHO.
ECHO To skip the search process and speed up script execution, edit
ECHO config.bat so that VBM contains the full path to VBoxManage.exe.
ECHO.

FOR /r %SystemDrive%\ %%a IN (*) DO (
    IF "%%~nxa"=="VBoxManage.exe" SET VBM=%%~dpnxa && GOTO vbm_found
)

ECHO.
ECHO %time% Cannot find VBoxManage.exe (part of VirtualBox) on %SystemDrive%.

ECHO.
ECHO %time% Searching D: for VBoxManage, this may take a while
ECHO.

FOR /r D:\ %%a IN (*) DO (
    IF "%%~nxa"=="VBoxManage.exe" SET VBM=%%~dpnxa && GOTO vbm_found
)

ECHO.
ECHO %time% Cannot find VBoxManage.exe (part of VirtualBox) on D:.
ECHO %time% Giving up. Program stops.
ECHO.
GOTO :terminate

:vbm_found
ECHO VBoxManage.exe found:
ECHO "%VBM%"
ECHO Version:
"%VBM%" --version

REM vim: set ai ts=4 sw=4 et ft=dosbatch:

SET BATDIR=%~dp0
PUSHD %BATDIR%..
SET TOPDIR=%cd%
POPD

SET AUTODIR=%TOPDIR%\autostart
SET IMGDIR=%TOPDIR%\img
SET LOGDIR=%TOPDIR%\log
SET STATUSDIR=%TOPDIR%\log\status
SET SHAREDIR=%TOPDIR%
SET TOOLSDIR=%TOPDIR%\tools

ECHO %time% Creating directories (if needed)
IF NOT EXIST %AUTODIR% mkdir %AUTODIR%
IF NOT EXIST %IMGDIR% mkdir %IMGDIR%
IF NOT EXIST %LOGDIR% mkdir %LOGDIR%
IF NOT EXIST %SHAREDIR% mkdir %SHAREDIR%

REM vim: set ai ts=4 sw=4 et ft=dosbatch:

ECHO %time% Cleaning up autostart and log directories
DEL /S /Q %AUTODIR%
DEL /S /Q %LOGDIR%

ECHO %time% Looking for %IMGDIR%\ubuntu-18.04.4-server-amd64.iso
IF EXIST %IMGDIR%\ubuntu-18.04.4-server-amd64.iso goto got_install_iso

ECHO.
ECHO ubuntu-18.04.4-server-amd64.iso not found in %IMGDIR%.
ECHO.
ECHO Trying to download the install ISO from
ECHO http://cdimage.ubuntu.com/releases/18.04/release/ubuntu-18.04.4-server-amd64.iso
ECHO.
ECHO Expect this to take several minutes or longer, depending on your
ECHO Internet connection.
ECHO.
cscript /nologo %TOOLSDIR%\downloader.js http://cdimage.ubuntu.com/releases/18.04/release/ubuntu-18.04.4-server-amd64.iso
RENAME downloaded.bin ubuntu-18.04.4-server-amd64.iso
MOVE ubuntu-18.04.4-server-amd64.iso %IMGDIR%
IF EXIST %IMGDIR%\ubuntu-18.04.4-server-amd64.iso goto got_install_iso
ECHO.
ECHO ubuntu-18.04.4-server-amd64.iso still not found in %IMGDIR%.
ECHO Aborting.
ECHO.

goto :terminate

:got_install_iso
ECHO.
ECHO %time% Found %IMGDIR%\ubuntu-18.04.4-server-amd64.iso
ECHO.
ECHO %time% Initialization done. Hit any key to continue.
ECHO.
PAUSE

REM vim: set ai ts=4 sw=4 et ft=dosbatch:

IF EXIST %IMGDIR%\tmp-disk.vdi DEL %IMGDIR%\tmp-disk.vdi
CALL :vm_exists base
ECHO VBoxManage createvm --name base --register --ostype Ubuntu_64 --groups /labs
"%VBM%" createvm --name base --register --ostype Ubuntu_64 --groups /labs
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm base --rtcuseutc on
"%VBM%" modifyvm base --rtcuseutc on
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm base --biosbootmenu disabled
"%VBM%" modifyvm base --biosbootmenu disabled
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm base --largepages on
"%VBM%" modifyvm base --largepages on
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm base --boot1 disk
"%VBM%" modifyvm base --boot1 disk
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm base --boot3 net
"%VBM%" modifyvm base --boot3 net
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage storagectl base --name SATA --add sata --portcount 3
"%VBM%" storagectl base --name SATA --add sata --portcount 3
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage storagectl base --name SATA --hostiocache on
"%VBM%" storagectl base --name SATA --hostiocache on
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage storagectl base --name IDE --add ide
"%VBM%" storagectl base --name IDE --add ide
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm base --memory 1024
"%VBM%" modifyvm base --memory 1024
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage storageattach base --storagectl IDE --port 0 --device 0 --type dvddrive --medium %IMGDIR%\ubuntu-18.04.4-server-amd64.iso
"%VBM%" storageattach base --storagectl IDE --port 0 --device 0 --type dvddrive --medium %IMGDIR%\ubuntu-18.04.4-server-amd64.iso
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage storageattach base --storagectl IDE --port 1 --device 0 --type dvddrive --medium emptydrive
"%VBM%" storageattach base --storagectl IDE --port 1 --device 0 --type dvddrive --medium emptydrive
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage storageattach base --storagectl IDE --port 1 --device 0 --type dvddrive --medium additions
"%VBM%" storageattach base --storagectl IDE --port 1 --device 0 --type dvddrive --medium additions
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage createhd --format VDI --filename %IMGDIR%\tmp-disk.vdi --size 10000
"%VBM%" createhd --format VDI --filename %IMGDIR%\tmp-disk.vdi --size 10000
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage storageattach base --storagectl SATA --port 0 --device 0 --type hdd --medium %IMGDIR%\tmp-disk.vdi
"%VBM%" storageattach base --storagectl SATA --port 0 --device 0 --type hdd --medium %IMGDIR%\tmp-disk.vdi
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage sharedfolder add base --name bootstrap --hostpath %SHAREDIR% --automount
"%VBM%" sharedfolder add base --name bootstrap --hostpath %SHAREDIR% --automount
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage sharedfolder add base --name osbash --hostpath %SHAREDIR%
"%VBM%" sharedfolder add base --name osbash --hostpath %SHAREDIR%
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm base --boot1 dvd
"%VBM%" modifyvm base --boot1 dvd
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm base --boot2 disk
"%VBM%" modifyvm base --boot2 disk
IF %errorlevel% NEQ 0 GOTO :vbm_error

COPY %TOPDIR%\scripts\osbash\activate_autostart.sh %AUTODIR%\00_activate_autostart.sh
COPY %TOPDIR%\scripts\osbash\base_fixups.sh %AUTODIR%\01_base_fixups.sh
COPY %TOPDIR%\scripts\ubuntu\apt_init.sh %AUTODIR%\02_apt_init.sh
COPY %TOPDIR%\scripts\ubuntu\apt_upgrade.sh %AUTODIR%\03_apt_upgrade.sh
COPY %TOPDIR%\scripts\pre-download.sh %AUTODIR%\04_pre-download.sh
COPY %TOPDIR%\scripts\ubuntu\apt_pre-download.sh %AUTODIR%\05_apt_pre-download.sh
COPY %TOPDIR%\scripts\osbash\enable_osbash_ssh_keys.sh %AUTODIR%\06_enable_osbash_ssh_keys.sh
COPY %TOPDIR%\scripts\zero_empty.sh %AUTODIR%\07_zero_empty.sh
COPY %TOPDIR%\scripts\shutdown.sh %AUTODIR%\08_shutdown.sh
ECHO VBoxManage startvm base --type separate
"%VBM%" startvm base --type separate
IF %errorlevel% NEQ 0 GOTO :vbm_error

TIMEOUT /T 10 /NOBREAK
ECHO VBoxManage controlvm base keyboardputscancode 1c 9c
"%VBM%" controlvm base keyboardputscancode 1c 9c
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 40 c0
"%VBM%" controlvm base keyboardputscancode 40 c0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 01 81
"%VBM%" controlvm base keyboardputscancode 01 81
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0e 8e
"%VBM%" controlvm base keyboardputscancode 0e 8e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 35 b5
"%VBM%" controlvm base keyboardputscancode 35 b5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 17 97
"%VBM%" controlvm base keyboardputscancode 17 97
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 26 a6
"%VBM%" controlvm base keyboardputscancode 26 a6
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 26 a6
"%VBM%" controlvm base keyboardputscancode 26 a6
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 35 b5
"%VBM%" controlvm base keyboardputscancode 35 b5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2f af
"%VBM%" controlvm base keyboardputscancode 2f af
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 32 b2
"%VBM%" controlvm base keyboardputscancode 32 b2
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 26 a6
"%VBM%" controlvm base keyboardputscancode 26 a6
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 17 97
"%VBM%" controlvm base keyboardputscancode 17 97
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 16 96
"%VBM%" controlvm base keyboardputscancode 16 96
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2c ac
"%VBM%" controlvm base keyboardputscancode 2c ac
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 39 b9
"%VBM%" controlvm base keyboardputscancode 39 b9
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 19 99
"%VBM%" controlvm base keyboardputscancode 19 99
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 17 97
"%VBM%" controlvm base keyboardputscancode 17 97
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2e ae
"%VBM%" controlvm base keyboardputscancode 2e ae
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 39 b9
"%VBM%" controlvm base keyboardputscancode 39 b9
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 20 a0
"%VBM%" controlvm base keyboardputscancode 20 a0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 30 b0
"%VBM%" controlvm base keyboardputscancode 30 b0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 17 97
"%VBM%" controlvm base keyboardputscancode 17 97
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0c 8c
"%VBM%" controlvm base keyboardputscancode 0c 8c
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 17 97
"%VBM%" controlvm base keyboardputscancode 17 97
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 26 a6
"%VBM%" controlvm base keyboardputscancode 26 a6
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 26 a6
"%VBM%" controlvm base keyboardputscancode 26 a6
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 13 93
"%VBM%" controlvm base keyboardputscancode 13 93
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 35 b5
"%VBM%" controlvm base keyboardputscancode 35 b5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 26 a6
"%VBM%" controlvm base keyboardputscancode 26 a6
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 26 a6
"%VBM%" controlvm base keyboardputscancode 26 a6
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 11 91
"%VBM%" controlvm base keyboardputscancode 11 91
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2a 0c 8c aa
"%VBM%" controlvm base keyboardputscancode 2a 0c 8c aa
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 16 96
"%VBM%" controlvm base keyboardputscancode 16 96
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

TIMEOUT /T 1 /NOBREAK
ECHO VBoxManage controlvm base keyboardputscancode 16 96
"%VBM%" controlvm base keyboardputscancode 16 96
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 23 a3
"%VBM%" controlvm base keyboardputscancode 23 a3
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 17 97
"%VBM%" controlvm base keyboardputscancode 17 97
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2e ae
"%VBM%" controlvm base keyboardputscancode 2e ae
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 20 a0
"%VBM%" controlvm base keyboardputscancode 20 a0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2a 0c 8c aa
"%VBM%" controlvm base keyboardputscancode 2a 0c 8c aa
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 26 a6
"%VBM%" controlvm base keyboardputscancode 26 a6
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0d 8d
"%VBM%" controlvm base keyboardputscancode 0d 8d
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 13 93
"%VBM%" controlvm base keyboardputscancode 13 93
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 16 96
"%VBM%" controlvm base keyboardputscancode 16 96
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 39 b9
"%VBM%" controlvm base keyboardputscancode 39 b9
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 19 99
"%VBM%" controlvm base keyboardputscancode 19 99
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 13 93
"%VBM%" controlvm base keyboardputscancode 13 93
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 20 a0
"%VBM%" controlvm base keyboardputscancode 20 a0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 35 b5
"%VBM%" controlvm base keyboardputscancode 35 b5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 16 96
"%VBM%" controlvm base keyboardputscancode 16 96
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 13 93
"%VBM%" controlvm base keyboardputscancode 13 93
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 26 a6
"%VBM%" controlvm base keyboardputscancode 26 a6
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0d 8d
"%VBM%" controlvm base keyboardputscancode 0d 8d
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 23 a3
"%VBM%" controlvm base keyboardputscancode 23 a3
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 19 99
"%VBM%" controlvm base keyboardputscancode 19 99
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2a 27 a7 aa
"%VBM%" controlvm base keyboardputscancode 2a 27 a7 aa
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 35 b5
"%VBM%" controlvm base keyboardputscancode 35 b5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 35 b5
"%VBM%" controlvm base keyboardputscancode 35 b5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 19 99
"%VBM%" controlvm base keyboardputscancode 19 99
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 20 a0
"%VBM%" controlvm base keyboardputscancode 20 a0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2f af
"%VBM%" controlvm base keyboardputscancode 2f af
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 34 b4
"%VBM%" controlvm base keyboardputscancode 34 b4
IF %errorlevel% NEQ 0 GOTO :vbm_error

TIMEOUT /T 1 /NOBREAK
ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 13 93
"%VBM%" controlvm base keyboardputscancode 13 93
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 22 a2
"%VBM%" controlvm base keyboardputscancode 22 a2
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 35 b5
"%VBM%" controlvm base keyboardputscancode 35 b5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 19 99
"%VBM%" controlvm base keyboardputscancode 19 99
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2e ae
"%VBM%" controlvm base keyboardputscancode 2e ae
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 25 a5
"%VBM%" controlvm base keyboardputscancode 25 a5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 35 b5
"%VBM%" controlvm base keyboardputscancode 35 b5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 13 93
"%VBM%" controlvm base keyboardputscancode 13 93
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 17 97
"%VBM%" controlvm base keyboardputscancode 17 97
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 17 97
"%VBM%" controlvm base keyboardputscancode 17 97
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 22 a2
"%VBM%" controlvm base keyboardputscancode 22 a2
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0c 8c
"%VBM%" controlvm base keyboardputscancode 0c 8c
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 26 a6
"%VBM%" controlvm base keyboardputscancode 26 a6
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 30 b0
"%VBM%" controlvm base keyboardputscancode 30 b0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 35 b5
"%VBM%" controlvm base keyboardputscancode 35 b5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 13 93
"%VBM%" controlvm base keyboardputscancode 13 93
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 11 91
"%VBM%" controlvm base keyboardputscancode 11 91
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 35 b5
"%VBM%" controlvm base keyboardputscancode 35 b5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 30 b0
"%VBM%" controlvm base keyboardputscancode 30 b0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 13 93
"%VBM%" controlvm base keyboardputscancode 13 93
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2e ae
"%VBM%" controlvm base keyboardputscancode 2e ae
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 23 a3
"%VBM%" controlvm base keyboardputscancode 23 a3
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 35 b5
"%VBM%" controlvm base keyboardputscancode 35 b5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 32 b2
"%VBM%" controlvm base keyboardputscancode 32 b2
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 13 93
"%VBM%" controlvm base keyboardputscancode 13 93
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 35 b5
"%VBM%" controlvm base keyboardputscancode 35 b5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 26 a6
"%VBM%" controlvm base keyboardputscancode 26 a6
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 30 b0
"%VBM%" controlvm base keyboardputscancode 30 b0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

TIMEOUT /T 1 /NOBREAK
ECHO VBoxManage controlvm base keyboardputscancode 35 b5
"%VBM%" controlvm base keyboardputscancode 35 b5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 30 b0
"%VBM%" controlvm base keyboardputscancode 30 b0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 23 a3
"%VBM%" controlvm base keyboardputscancode 23 a3
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 35 b5
"%VBM%" controlvm base keyboardputscancode 35 b5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 26 a6
"%VBM%" controlvm base keyboardputscancode 26 a6
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 17 97
"%VBM%" controlvm base keyboardputscancode 17 97
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 30 b0
"%VBM%" controlvm base keyboardputscancode 30 b0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 35 b5
"%VBM%" controlvm base keyboardputscancode 35 b5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 30 b0
"%VBM%" controlvm base keyboardputscancode 30 b0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 23 a3
"%VBM%" controlvm base keyboardputscancode 23 a3
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 35 b5
"%VBM%" controlvm base keyboardputscancode 35 b5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 30 b0
"%VBM%" controlvm base keyboardputscancode 30 b0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 35 b5
"%VBM%" controlvm base keyboardputscancode 35 b5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 19 99
"%VBM%" controlvm base keyboardputscancode 19 99
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 13 93
"%VBM%" controlvm base keyboardputscancode 13 93
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 20 a0
"%VBM%" controlvm base keyboardputscancode 20 a0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0c 8c
"%VBM%" controlvm base keyboardputscancode 0c 8c
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2f af
"%VBM%" controlvm base keyboardputscancode 2f af
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 30 b0
"%VBM%" controlvm base keyboardputscancode 30 b0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 20 a0
"%VBM%" controlvm base keyboardputscancode 20 a0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 20 a0
"%VBM%" controlvm base keyboardputscancode 20 a0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0c 8c
"%VBM%" controlvm base keyboardputscancode 0c 8c
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2f af
"%VBM%" controlvm base keyboardputscancode 2f af
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 08 88
"%VBM%" controlvm base keyboardputscancode 08 88
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 34 b4
"%VBM%" controlvm base keyboardputscancode 34 b4
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2e ae
"%VBM%" controlvm base keyboardputscancode 2e ae
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 21 a1
"%VBM%" controlvm base keyboardputscancode 21 a1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 22 a2
"%VBM%" controlvm base keyboardputscancode 22 a2
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 39 b9
"%VBM%" controlvm base keyboardputscancode 39 b9
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 20 a0
"%VBM%" controlvm base keyboardputscancode 20 a0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

TIMEOUT /T 1 /NOBREAK
ECHO VBoxManage controlvm base keyboardputscancode 30 b0
"%VBM%" controlvm base keyboardputscancode 30 b0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 17 97
"%VBM%" controlvm base keyboardputscancode 17 97
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0c 8c
"%VBM%" controlvm base keyboardputscancode 0c 8c
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 17 97
"%VBM%" controlvm base keyboardputscancode 17 97
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 26 a6
"%VBM%" controlvm base keyboardputscancode 26 a6
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 26 a6
"%VBM%" controlvm base keyboardputscancode 26 a6
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 13 93
"%VBM%" controlvm base keyboardputscancode 13 93
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0d 8d
"%VBM%" controlvm base keyboardputscancode 0d 8d
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2a 0c 8c aa
"%VBM%" controlvm base keyboardputscancode 2a 0c 8c aa
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2a 16 96 aa
"%VBM%" controlvm base keyboardputscancode 2a 16 96 aa
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2a 1f 9f aa
"%VBM%" controlvm base keyboardputscancode 2a 1f 9f aa
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 39 b9
"%VBM%" controlvm base keyboardputscancode 39 b9
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 16 96
"%VBM%" controlvm base keyboardputscancode 16 96
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0d 8d
"%VBM%" controlvm base keyboardputscancode 0d 8d
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 13 93
"%VBM%" controlvm base keyboardputscancode 13 93
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 16 96
"%VBM%" controlvm base keyboardputscancode 16 96
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 39 b9
"%VBM%" controlvm base keyboardputscancode 39 b9
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 26 a6
"%VBM%" controlvm base keyboardputscancode 26 a6
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2e ae
"%VBM%" controlvm base keyboardputscancode 2e ae
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 26 a6
"%VBM%" controlvm base keyboardputscancode 26 a6
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0d 8d
"%VBM%" controlvm base keyboardputscancode 0d 8d
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2a 0c 8c aa
"%VBM%" controlvm base keyboardputscancode 2a 0c 8c aa
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2a 16 96 aa
"%VBM%" controlvm base keyboardputscancode 2a 16 96 aa
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2a 1f 9f aa
"%VBM%" controlvm base keyboardputscancode 2a 1f 9f aa
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 39 b9
"%VBM%" controlvm base keyboardputscancode 39 b9
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 23 a3
"%VBM%" controlvm base keyboardputscancode 23 a3
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

TIMEOUT /T 1 /NOBREAK
ECHO VBoxManage controlvm base keyboardputscancode 32 b2
"%VBM%" controlvm base keyboardputscancode 32 b2
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0d 8d
"%VBM%" controlvm base keyboardputscancode 0d 8d
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 30 b0
"%VBM%" controlvm base keyboardputscancode 30 b0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 23 a3
"%VBM%" controlvm base keyboardputscancode 23 a3
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 39 b9
"%VBM%" controlvm base keyboardputscancode 39 b9
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 21 a1
"%VBM%" controlvm base keyboardputscancode 21 a1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 30 b0
"%VBM%" controlvm base keyboardputscancode 30 b0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0d 8d
"%VBM%" controlvm base keyboardputscancode 0d 8d
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 21 a1
"%VBM%" controlvm base keyboardputscancode 21 a1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 26 a6
"%VBM%" controlvm base keyboardputscancode 26 a6
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 39 b9
"%VBM%" controlvm base keyboardputscancode 39 b9
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 20 a0
"%VBM%" controlvm base keyboardputscancode 20 a0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 30 b0
"%VBM%" controlvm base keyboardputscancode 30 b0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2e ae
"%VBM%" controlvm base keyboardputscancode 2e ae
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 21 a1
"%VBM%" controlvm base keyboardputscancode 21 a1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 35 b5
"%VBM%" controlvm base keyboardputscancode 35 b5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 21 a1
"%VBM%" controlvm base keyboardputscancode 21 a1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 13 93
"%VBM%" controlvm base keyboardputscancode 13 93
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 20 a0
"%VBM%" controlvm base keyboardputscancode 20 a0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0d 8d
"%VBM%" controlvm base keyboardputscancode 0d 8d
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 17 97
"%VBM%" controlvm base keyboardputscancode 17 97
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 13 93
"%VBM%" controlvm base keyboardputscancode 13 93
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2e ae
"%VBM%" controlvm base keyboardputscancode 2e ae
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 17 97
"%VBM%" controlvm base keyboardputscancode 17 97
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2f af
"%VBM%" controlvm base keyboardputscancode 2f af
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

TIMEOUT /T 1 /NOBREAK
ECHO VBoxManage controlvm base keyboardputscancode 39 b9
"%VBM%" controlvm base keyboardputscancode 39 b9
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 25 a5
"%VBM%" controlvm base keyboardputscancode 25 a5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 15 95
"%VBM%" controlvm base keyboardputscancode 15 95
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 30 b0
"%VBM%" controlvm base keyboardputscancode 30 b0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 13 93
"%VBM%" controlvm base keyboardputscancode 13 93
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 20 a0
"%VBM%" controlvm base keyboardputscancode 20 a0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0c 8c
"%VBM%" controlvm base keyboardputscancode 0c 8c
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2e ae
"%VBM%" controlvm base keyboardputscancode 2e ae
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 21 a1
"%VBM%" controlvm base keyboardputscancode 21 a1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 17 97
"%VBM%" controlvm base keyboardputscancode 17 97
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 22 a2
"%VBM%" controlvm base keyboardputscancode 22 a2
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 16 96
"%VBM%" controlvm base keyboardputscancode 16 96
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 13 93
"%VBM%" controlvm base keyboardputscancode 13 93
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 17 97
"%VBM%" controlvm base keyboardputscancode 17 97
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 35 b5
"%VBM%" controlvm base keyboardputscancode 35 b5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 32 b2
"%VBM%" controlvm base keyboardputscancode 32 b2
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 20 a0
"%VBM%" controlvm base keyboardputscancode 20 a0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 26 a6
"%VBM%" controlvm base keyboardputscancode 26 a6
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2e ae
"%VBM%" controlvm base keyboardputscancode 2e ae
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 20 a0
"%VBM%" controlvm base keyboardputscancode 20 a0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0d 8d
"%VBM%" controlvm base keyboardputscancode 0d 8d
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2a 1f 9f aa
"%VBM%" controlvm base keyboardputscancode 2a 1f 9f aa
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2a 25 a5 aa
"%VBM%" controlvm base keyboardputscancode 2a 25 a5 aa
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2a 17 97 aa
"%VBM%" controlvm base keyboardputscancode 2a 17 97 aa
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2a 19 99 aa
"%VBM%" controlvm base keyboardputscancode 2a 19 99 aa
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 39 b9
"%VBM%" controlvm base keyboardputscancode 39 b9
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 17 97
"%VBM%" controlvm base keyboardputscancode 17 97
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 17 97
"%VBM%" controlvm base keyboardputscancode 17 97
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 13 93
"%VBM%" controlvm base keyboardputscancode 13 93
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 20 a0
"%VBM%" controlvm base keyboardputscancode 20 a0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0d 8d
"%VBM%" controlvm base keyboardputscancode 0d 8d
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 35 b5
"%VBM%" controlvm base keyboardputscancode 35 b5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 17 97
"%VBM%" controlvm base keyboardputscancode 17 97
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

TIMEOUT /T 1 /NOBREAK
ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 26 a6
"%VBM%" controlvm base keyboardputscancode 26 a6
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 26 a6
"%VBM%" controlvm base keyboardputscancode 26 a6
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 35 b5
"%VBM%" controlvm base keyboardputscancode 35 b5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 17 97
"%VBM%" controlvm base keyboardputscancode 17 97
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 17 97
"%VBM%" controlvm base keyboardputscancode 17 97
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 13 93
"%VBM%" controlvm base keyboardputscancode 13 93
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 20 a0
"%VBM%" controlvm base keyboardputscancode 20 a0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 34 b4
"%VBM%" controlvm base keyboardputscancode 34 b4
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 22 a2
"%VBM%" controlvm base keyboardputscancode 22 a2
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2c ac
"%VBM%" controlvm base keyboardputscancode 2c ac
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 39 b9
"%VBM%" controlvm base keyboardputscancode 39 b9
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2e ae
"%VBM%" controlvm base keyboardputscancode 2e ae
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 31 b1
"%VBM%" controlvm base keyboardputscancode 31 b1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 18 98
"%VBM%" controlvm base keyboardputscancode 18 98
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 26 a6
"%VBM%" controlvm base keyboardputscancode 26 a6
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0c 8c
"%VBM%" controlvm base keyboardputscancode 0c 8c
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 16 96
"%VBM%" controlvm base keyboardputscancode 16 96
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 19 99
"%VBM%" controlvm base keyboardputscancode 19 99
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 35 b5
"%VBM%" controlvm base keyboardputscancode 35 b5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 25 a5
"%VBM%" controlvm base keyboardputscancode 25 a5
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2a 0c 8c aa
"%VBM%" controlvm base keyboardputscancode 2a 0c 8c aa
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 20 a0
"%VBM%" controlvm base keyboardputscancode 20 a0
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 2e ae
"%VBM%" controlvm base keyboardputscancode 2e ae
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 14 94
"%VBM%" controlvm base keyboardputscancode 14 94
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 0d 8d
"%VBM%" controlvm base keyboardputscancode 0d 8d
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 21 a1
"%VBM%" controlvm base keyboardputscancode 21 a1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1e 9e
"%VBM%" controlvm base keyboardputscancode 1e 9e
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 26 a6
"%VBM%" controlvm base keyboardputscancode 26 a6
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1f 9f
"%VBM%" controlvm base keyboardputscancode 1f 9f
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 12 92
"%VBM%" controlvm base keyboardputscancode 12 92
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage controlvm base keyboardputscancode 1c 9c
"%VBM%" controlvm base keyboardputscancode 1c 9c
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO %time% Waiting for autostart files to execute.
CALL :wait_auto
ECHO %time% All autostart files executed.
ECHO %time% Waiting for VM base to power off.
CALL :wait_poweroff base
ECHO %time% VM base powered off.
TIMEOUT /T 1 /NOBREAK
ECHO VBoxManage storageattach base --storagectl SATA --port 0 --device 0 --type hdd --medium none
"%VBM%" storageattach base --storagectl SATA --port 0 --device 0 --type hdd --medium none
IF %errorlevel% NEQ 0 GOTO :vbm_error

TIMEOUT /T 1 /NOBREAK
ECHO VBoxManage unregistervm base --delete
"%VBM%" unregistervm base --delete
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyhd %IMGDIR%\tmp-disk.vdi --compact
"%VBM%" modifyhd %IMGDIR%\tmp-disk.vdi --compact
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage closemedium disk %IMGDIR%\tmp-disk.vdi
"%VBM%" closemedium disk %IMGDIR%\tmp-disk.vdi
IF %errorlevel% NEQ 0 GOTO :vbm_error

MOVE /y %IMGDIR%\tmp-disk.vdi %IMGDIR%\base-shared_folder-stein-ubuntu-18.04-amd64.vdi
ECHO.
ECHO %time% Batch script seems to have succeeded.
ECHO.

GOTO :terminate

REM Note: vbm_error falls through to terminate
:vbm_error
ECHO.
ECHO %time% VBoxManage returned with an error. Aborting.
ECHO.

:terminate
ENDLOCAL
PAUSE
EXIT
GOTO :eof

REM ============================================================================
REM
REM End of program, function definitions follow
REM
REM ============================================================================
:wait_auto
IF EXIST %STATUSDIR%\done (
    DEL %STATUSDIR%\done
    GOTO :eof
)
IF EXIST %STATUSDIR%\error (
    ECHO.
    ECHO %time% ERROR Script returned error:
    ECHO.
    TYPE %STATUSDIR%\error
    ECHO.
    ECHO %time% Aborting.
    ECHO.
    DEL %STATUSDIR%\error
    GOTO :terminate
)
TIMEOUT /T 5 /NOBREAK
GOTO :wait_auto
REM - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
:wait_poweroff
"%VBM%" showvminfo %~1 --machinereadable|findstr poweroff
IF %errorlevel% EQU 0 GOTO :eof
TIMEOUT /T 2 /NOBREAK
GOTO :wait_poweroff
REM - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
:vm_exists
"%VBM%" list vms|findstr %~1
IF %errorlevel% NEQ 0 GOTO :eof
ECHO.
ECHO %time% VM %~1 already exists. Aborting.
ECHO.
GOTO :terminate
REM - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

REM vim: set ai ts=4 sw=4 et ft=dosbatch:

