@ECHO OFF

REM This is an automatically generated Windows batch file. It creates the
REM host-only networks for an OpenStack training-labs setup.

SETLOCAL ENABLEDELAYEDEXPANSION

ECHO.
ECHO OpenStack labs for VirtualBox on Windows
ECHO Generated by osbash
ECHO.
ECHO Create host-only networks
ECHO.

REM vim: set ai ts=4 sw=4 et ft=dosbatch:

REM Elevate credentials, code courtesy of Matthew Newton
REM http://blog.mnewton.com/articles/Windows-Installer-Batch-Script-Revisited.html
REM Check for permissions
>nul 2>&1 "%SYSTEMROOT%\system32\cacls.exe" "%SYSTEMROOT%\system32\config\system"

REM If error flag set, we do not have admin.
if '%errorlevel%' NEQ '0' (
  echo Requesting administrative privileges...
  goto UACPrompt
) else ( goto gotAdmin )


:UACPrompt
  echo Set UAC = CreateObject^("Shell.Application"^) > "%temp%\getadmin.vbs"
  echo UAC.ShellExecute "%~s0", "", "", "runas", 1  >> "%temp%\getadmin.vbs"

  "%temp%\getadmin.vbs"
  REM we are done, exiting recursive call
  exit /B

:gotAdmin
  if exist "%temp%\getadmin.vbs" ( del "%temp%\getadmin.vbs" )
  echo We have admin privileges, proceeding...

REM vim: set ai ts=4 sw=4 et ft=dosbatch:

REM Load likely VBoxManage location from configuration file
CALL "%~dp0\CONFIG.BAT"

IF EXIST "%VBM%" GOTO vbm_found

ECHO.
ECHO %time% Searching %SystemDrive% for VBoxManage, this may take a while
ECHO.
ECHO To skip the search process and speed up script execution, edit
ECHO config.bat so that VBM contains the full path to VBoxManage.exe.
ECHO.

FOR /r %SystemDrive%\ %%a IN (*) DO (
    IF "%%~nxa"=="VBoxManage.exe" SET VBM=%%~dpnxa && GOTO vbm_found
)

ECHO.
ECHO %time% Cannot find VBoxManage.exe (part of VirtualBox) on %SystemDrive%.

ECHO.
ECHO %time% Searching D: for VBoxManage, this may take a while
ECHO.

FOR /r D:\ %%a IN (*) DO (
    IF "%%~nxa"=="VBoxManage.exe" SET VBM=%%~dpnxa && GOTO vbm_found
)

ECHO.
ECHO %time% Cannot find VBoxManage.exe (part of VirtualBox) on D:.
ECHO %time% Giving up. Program stops.
ECHO.
GOTO :terminate

:vbm_found
ECHO VBoxManage.exe found:
ECHO "%VBM%"
ECHO Version:
"%VBM%" --version

REM vim: set ai ts=4 sw=4 et ft=dosbatch:

ECHO VBoxManage hostonlyif create
"%VBM%" hostonlyif create
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage hostonlyif ipconfig "VirtualBox Host-Only Ethernet Adapter" --ip 10.0.0.1 --netmask 255.255.255.0
"%VBM%" hostonlyif ipconfig "VirtualBox Host-Only Ethernet Adapter" --ip 10.0.0.1 --netmask 255.255.255.0
IF %errorlevel% NEQ 0 GOTO :vbm_error

REM vim: set ai ts=4 sw=4 et ft=dosbatch:

ECHO VBoxManage hostonlyif create
"%VBM%" hostonlyif create
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage hostonlyif ipconfig "VirtualBox Host-Only Ethernet Adapter #2" --ip 203.0.113.1 --netmask 255.255.255.0
"%VBM%" hostonlyif ipconfig "VirtualBox Host-Only Ethernet Adapter #2" --ip 203.0.113.1 --netmask 255.255.255.0
IF %errorlevel% NEQ 0 GOTO :vbm_error

REM vim: set ai ts=4 sw=4 et ft=dosbatch:

ECHO.
ECHO %time% Batch script seems to have succeeded.
ECHO.

GOTO :terminate

REM Note: vbm_error falls through to terminate
:vbm_error
ECHO.
ECHO %time% VBoxManage returned with an error. Aborting.
ECHO.

:terminate
ENDLOCAL
PAUSE
EXIT
GOTO :eof

REM ============================================================================
REM
REM End of program, function definitions follow
REM
REM ============================================================================
:wait_auto
IF EXIST %STATUSDIR%\done (
    DEL %STATUSDIR%\done
    GOTO :eof
)
IF EXIST %STATUSDIR%\error (
    ECHO.
    ECHO %time% ERROR Script returned error:
    ECHO.
    TYPE %STATUSDIR%\error
    ECHO.
    ECHO %time% Aborting.
    ECHO.
    DEL %STATUSDIR%\error
    GOTO :terminate
)
TIMEOUT /T 5 /NOBREAK
GOTO :wait_auto
REM - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
:wait_poweroff
"%VBM%" showvminfo %~1 --machinereadable|findstr poweroff
IF %errorlevel% EQU 0 GOTO :eof
TIMEOUT /T 2 /NOBREAK
GOTO :wait_poweroff
REM - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
:vm_exists
"%VBM%" list vms|findstr %~1
IF %errorlevel% NEQ 0 GOTO :eof
ECHO.
ECHO %time% VM %~1 already exists. Aborting.
ECHO.
GOTO :terminate
REM - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

REM vim: set ai ts=4 sw=4 et ft=dosbatch:

