@ECHO OFF

REM This is an automatically generated Windows batch file. It creates the
REM ubuntu_cluster VM for an OpenStack training-labs setup.

SETLOCAL ENABLEDELAYEDEXPANSION

ECHO.
ECHO OpenStack labs for VirtualBox on Windows
ECHO Generated by osbash
ECHO.
ECHO Create ubuntu_cluster VM
ECHO.

REM vim: set ai ts=4 sw=4 et ft=dosbatch:

REM Load likely VBoxManage location from configuration file
CALL "%~dp0\CONFIG.BAT"

IF EXIST "%VBM%" GOTO vbm_found

REM Before searching, try a likely alternative

SET VBM=d:\Program Files\Oracle\VirtualBox\VBoxManage.exe

IF EXIST "%VBM%" GOTO vbm_found

ECHO.
ECHO %time% Searching %SystemDrive% for VBoxManage, this may take a while
ECHO.
ECHO To skip the search process and speed up script execution, edit
ECHO config.bat so that VBM contains the full path to VBoxManage.exe.
ECHO.

FOR /r %SystemDrive%\ %%a IN (*) DO (
    IF "%%~nxa"=="VBoxManage.exe" SET VBM=%%~dpnxa && GOTO vbm_found
)

ECHO.
ECHO %time% Cannot find VBoxManage.exe (part of VirtualBox) on %SystemDrive%.

ECHO.
ECHO %time% Searching D: for VBoxManage, this may take a while
ECHO.

FOR /r D:\ %%a IN (*) DO (
    IF "%%~nxa"=="VBoxManage.exe" SET VBM=%%~dpnxa && GOTO vbm_found
)

ECHO.
ECHO %time% Cannot find VBoxManage.exe (part of VirtualBox) on D:.
ECHO %time% Giving up. Program stops.
ECHO.
GOTO :terminate

:vbm_found
ECHO VBoxManage.exe found:
ECHO "%VBM%"
ECHO Version:
"%VBM%" --version

REM vim: set ai ts=4 sw=4 et ft=dosbatch:

SET BATDIR=%~dp0
PUSHD %BATDIR%..
SET TOPDIR=%cd%
POPD

SET AUTODIR=%TOPDIR%\autostart
SET IMGDIR=%TOPDIR%\img
SET LOGDIR=%TOPDIR%\log
SET STATUSDIR=%TOPDIR%\log\status
SET SHAREDIR=%TOPDIR%
SET TOOLSDIR=%TOPDIR%\tools

ECHO %time% Creating directories (if needed)
IF NOT EXIST %AUTODIR% mkdir %AUTODIR%
IF NOT EXIST %IMGDIR% mkdir %IMGDIR%
IF NOT EXIST %LOGDIR% mkdir %LOGDIR%
IF NOT EXIST %SHAREDIR% mkdir %SHAREDIR%

REM vim: set ai ts=4 sw=4 et ft=dosbatch:

ECHO %time% Loading network interface names
CALL "%~dp0\iface_config.bat"

ECHO %time% Cleaning up autostart and log directories
DEL /S /Q %AUTODIR%
DEL /S /Q %LOGDIR%

ECHO %time% Looking for %IMGDIR%\base-shared_folder-train-ubuntu-18.04-amd64.vdi
IF EXIST %IMGDIR%\base-shared_folder-train-ubuntu-18.04-amd64.vdi goto got_base_disk
ECHO.
ECHO base-shared_folder-train-ubuntu-18.04-amd64.vdi not found in %IMGDIR%.
ECHO.
ECHO You need to build a base disk before you can create node VMs.
ECHO.
goto :terminate

:got_base_disk
ECHO.
ECHO %time% Found %IMGDIR%\base-shared_folder-train-ubuntu-18.04-amd64.vdi
ECHO.
ECHO %time% Initialization done. Hit any key to continue.
ECHO.
PAUSE

REM vim: set ai ts=4 sw=4 et ft=dosbatch:

CALL :vm_exists controller
ECHO VBoxManage createvm --name controller --register --ostype Ubuntu_64 --groups /labs
"%VBM%" createvm --name controller --register --ostype Ubuntu_64 --groups /labs
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm controller --rtcuseutc on
"%VBM%" modifyvm controller --rtcuseutc on
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm controller --biosbootmenu disabled
"%VBM%" modifyvm controller --biosbootmenu disabled
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm controller --largepages on
"%VBM%" modifyvm controller --largepages on
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm controller --boot1 disk
"%VBM%" modifyvm controller --boot1 disk
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm controller --boot3 net
"%VBM%" modifyvm controller --boot3 net
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage storagectl controller --name SATA --add sata --portcount 3
"%VBM%" storagectl controller --name SATA --add sata --portcount 3
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage storagectl controller --name SATA --hostiocache on
"%VBM%" storagectl controller --name SATA --hostiocache on
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage storagectl controller --name IDE --add ide
"%VBM%" storagectl controller --name IDE --add ide
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm controller --memory 5120
"%VBM%" modifyvm controller --memory 5120
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm controller --cpus 1
"%VBM%" modifyvm controller --cpus 1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm controller --nictype1 virtio --nic1 nat
"%VBM%" modifyvm controller --nictype1 virtio --nic1 nat
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm controller --nictype2 virtio --nic2 hostonly --hostonlyadapter2 "%vboxnet0%" --nicpromisc2 allow-all
"%VBM%" modifyvm controller --nictype2 virtio --nic2 hostonly --hostonlyadapter2 "%vboxnet0%" --nicpromisc2 allow-all
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm controller --nicbootprio2 1
"%VBM%" modifyvm controller --nicbootprio2 1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm controller --nictype3 virtio --nic3 hostonly --hostonlyadapter3 "%vboxnet1%" --nicpromisc3 allow-all
"%VBM%" modifyvm controller --nictype3 virtio --nic3 hostonly --hostonlyadapter3 "%vboxnet1%" --nicpromisc3 allow-all
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm controller --natpf1 ssh,tcp,127.0.0.1,2230,,22
"%VBM%" modifyvm controller --natpf1 ssh,tcp,127.0.0.1,2230,,22
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm controller --natpf1 http,tcp,127.0.0.1,8888,,80
"%VBM%" modifyvm controller --natpf1 http,tcp,127.0.0.1,8888,,80
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage sharedfolder add controller --name osbash --hostpath %SHAREDIR%
"%VBM%" sharedfolder add controller --name osbash --hostpath %SHAREDIR%
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage storageattach controller --storagectl SATA --port 0 --device 0 --type hdd --medium %IMGDIR%\base-shared_folder-train-ubuntu-18.04-amd64.vdi
"%VBM%" storageattach controller --storagectl SATA --port 0 --device 0 --type hdd --medium %IMGDIR%\base-shared_folder-train-ubuntu-18.04-amd64.vdi
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage storageattach controller --storagectl SATA --port 0 --device 0 --type hdd --medium none
"%VBM%" storageattach controller --storagectl SATA --port 0 --device 0 --type hdd --medium none
IF %errorlevel% NEQ 0 GOTO :vbm_error

TIMEOUT /T 1 /NOBREAK
ECHO VBoxManage modifyhd --type multiattach %IMGDIR%\base-shared_folder-train-ubuntu-18.04-amd64.vdi
"%VBM%" modifyhd --type multiattach %IMGDIR%\base-shared_folder-train-ubuntu-18.04-amd64.vdi
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage storageattach controller --storagectl SATA --port 0 --device 0 --type hdd --medium %IMGDIR%\base-shared_folder-train-ubuntu-18.04-amd64.vdi
"%VBM%" storageattach controller --storagectl SATA --port 0 --device 0 --type hdd --medium %IMGDIR%\base-shared_folder-train-ubuntu-18.04-amd64.vdi
IF %errorlevel% NEQ 0 GOTO :vbm_error

COPY %TOPDIR%\scripts\osbash\init_xxx_node.sh %AUTODIR%\00_init_controller_node.sh
COPY %TOPDIR%\scripts\etc_hosts.sh %AUTODIR%\01_etc_hosts.sh
COPY %TOPDIR%\scripts\osbash\enable_osbash_ssh_keys.sh %AUTODIR%\02_enable_osbash_ssh_keys.sh
COPY %TOPDIR%\scripts\osbash\copy_openrc.sh %AUTODIR%\03_copy_openrc.sh
COPY %TOPDIR%\scripts\ubuntu\apt_install_mysql.sh %AUTODIR%\04_apt_install_mysql.sh
COPY %TOPDIR%\scripts\ubuntu\install_rabbitmq.sh %AUTODIR%\05_install_rabbitmq.sh
COPY %TOPDIR%\scripts\ubuntu\install_memcached.sh %AUTODIR%\06_install_memcached.sh
COPY %TOPDIR%\scripts\ubuntu\setup_keystone.sh %AUTODIR%\07_setup_keystone.sh
COPY %TOPDIR%\scripts\test\get_auth_token.sh %AUTODIR%\08_get_auth_token.sh
COPY %TOPDIR%\scripts\ubuntu\setup_glance.sh %AUTODIR%\09_setup_glance.sh
COPY %TOPDIR%\scripts\ubuntu\setup_nova_controller.sh %AUTODIR%\10_setup_nova_controller.sh
COPY %TOPDIR%\scripts\ubuntu\setup_placement_controller.sh %AUTODIR%\11_setup_placement_controller.sh
COPY %TOPDIR%\scripts\ubuntu\setup_neutron_controller.sh %AUTODIR%\12_setup_neutron_controller.sh
COPY %TOPDIR%\scripts\ubuntu\setup_self-service_controller.sh %AUTODIR%\13_setup_self-service_controller.sh
COPY %TOPDIR%\scripts\ubuntu\setup_neutron_controller_part_2.sh %AUTODIR%\14_setup_neutron_controller_part_2.sh
COPY %TOPDIR%\scripts\ubuntu\setup_horizon.sh %AUTODIR%\15_setup_horizon.sh
COPY %TOPDIR%\scripts\ubuntu\setup_cinder_controller.sh %AUTODIR%\16_setup_cinder_controller.sh
COPY %TOPDIR%\scripts\ubuntu\setup_heat_controller.sh %AUTODIR%\17_setup_heat_controller.sh
ECHO VBoxManage startvm controller --type separate
"%VBM%" startvm controller --type separate
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO %time% Waiting for autostart files to execute.
CALL :wait_auto
ECHO %time% All autostart files executed.
CALL :vm_exists compute1
ECHO VBoxManage createvm --name compute1 --register --ostype Ubuntu_64 --groups /labs
"%VBM%" createvm --name compute1 --register --ostype Ubuntu_64 --groups /labs
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm compute1 --rtcuseutc on
"%VBM%" modifyvm compute1 --rtcuseutc on
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm compute1 --biosbootmenu disabled
"%VBM%" modifyvm compute1 --biosbootmenu disabled
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm compute1 --largepages on
"%VBM%" modifyvm compute1 --largepages on
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm compute1 --boot1 disk
"%VBM%" modifyvm compute1 --boot1 disk
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm compute1 --boot3 net
"%VBM%" modifyvm compute1 --boot3 net
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage storagectl compute1 --name SATA --add sata --portcount 3
"%VBM%" storagectl compute1 --name SATA --add sata --portcount 3
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage storagectl compute1 --name SATA --hostiocache on
"%VBM%" storagectl compute1 --name SATA --hostiocache on
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage storagectl compute1 --name IDE --add ide
"%VBM%" storagectl compute1 --name IDE --add ide
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm compute1 --memory 1024
"%VBM%" modifyvm compute1 --memory 1024
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm compute1 --cpus 1
"%VBM%" modifyvm compute1 --cpus 1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm compute1 --nictype1 virtio --nic1 nat
"%VBM%" modifyvm compute1 --nictype1 virtio --nic1 nat
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm compute1 --nictype2 virtio --nic2 hostonly --hostonlyadapter2 "%vboxnet0%" --nicpromisc2 allow-all
"%VBM%" modifyvm compute1 --nictype2 virtio --nic2 hostonly --hostonlyadapter2 "%vboxnet0%" --nicpromisc2 allow-all
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm compute1 --nicbootprio2 1
"%VBM%" modifyvm compute1 --nicbootprio2 1
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm compute1 --nictype3 virtio --nic3 hostonly --hostonlyadapter3 "%vboxnet1%" --nicpromisc3 allow-all
"%VBM%" modifyvm compute1 --nictype3 virtio --nic3 hostonly --hostonlyadapter3 "%vboxnet1%" --nicpromisc3 allow-all
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage modifyvm compute1 --natpf1 ssh,tcp,127.0.0.1,2232,,22
"%VBM%" modifyvm compute1 --natpf1 ssh,tcp,127.0.0.1,2232,,22
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage sharedfolder add compute1 --name osbash --hostpath %SHAREDIR%
"%VBM%" sharedfolder add compute1 --name osbash --hostpath %SHAREDIR%
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage storageattach compute1 --storagectl SATA --port 0 --device 0 --type hdd --medium %IMGDIR%\base-shared_folder-train-ubuntu-18.04-amd64.vdi
"%VBM%" storageattach compute1 --storagectl SATA --port 0 --device 0 --type hdd --medium %IMGDIR%\base-shared_folder-train-ubuntu-18.04-amd64.vdi
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage storageattach compute1 --storagectl SATA --port 0 --device 0 --type hdd --medium none
"%VBM%" storageattach compute1 --storagectl SATA --port 0 --device 0 --type hdd --medium none
IF %errorlevel% NEQ 0 GOTO :vbm_error

TIMEOUT /T 1 /NOBREAK
ECHO VBoxManage modifyhd --type multiattach %IMGDIR%\base-shared_folder-train-ubuntu-18.04-amd64.vdi
"%VBM%" modifyhd --type multiattach %IMGDIR%\base-shared_folder-train-ubuntu-18.04-amd64.vdi
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage storageattach compute1 --storagectl SATA --port 0 --device 0 --type hdd --medium %IMGDIR%\base-shared_folder-train-ubuntu-18.04-amd64.vdi
"%VBM%" storageattach compute1 --storagectl SATA --port 0 --device 0 --type hdd --medium %IMGDIR%\base-shared_folder-train-ubuntu-18.04-amd64.vdi
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage createhd --format VDI --filename %IMGDIR%\compute1-sdb.vdi --size 1280
"%VBM%" createhd --format VDI --filename %IMGDIR%\compute1-sdb.vdi --size 1280
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO VBoxManage storageattach compute1 --storagectl SATA --port 1 --device 0 --type hdd --medium %IMGDIR%\compute1-sdb.vdi
"%VBM%" storageattach compute1 --storagectl SATA --port 1 --device 0 --type hdd --medium %IMGDIR%\compute1-sdb.vdi
IF %errorlevel% NEQ 0 GOTO :vbm_error

COPY %TOPDIR%\scripts\osbash\init_xxx_node.sh %AUTODIR%\00_init_compute1_node.sh
COPY %TOPDIR%\scripts\etc_hosts.sh %AUTODIR%\01_etc_hosts.sh
COPY %TOPDIR%\scripts\osbash\enable_osbash_ssh_keys.sh %AUTODIR%\02_enable_osbash_ssh_keys.sh
COPY %TOPDIR%\scripts\osbash\copy_openrc.sh %AUTODIR%\03_copy_openrc.sh
COPY %TOPDIR%\scripts\ubuntu\setup_nova_compute.sh %AUTODIR%\04_setup_nova_compute.sh
COPY %TOPDIR%\scripts\ubuntu\setup_neutron_compute.sh %AUTODIR%\05_setup_neutron_compute.sh
COPY %TOPDIR%\scripts\ubuntu\setup_self-service_compute.sh %AUTODIR%\06_setup_self-service_compute.sh
COPY %TOPDIR%\scripts\ubuntu\setup_neutron_compute_part_2.sh %AUTODIR%\07_setup_neutron_compute_part_2.sh
COPY %TOPDIR%\scripts\ubuntu\setup_cinder_volumes.sh %AUTODIR%\08_setup_cinder_volumes.sh
ECHO VBoxManage startvm compute1 --type separate
"%VBM%" startvm compute1 --type separate
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO %time% Waiting for autostart files to execute.
CALL :wait_auto
ECHO %time% All autostart files executed.
ECHO VBoxManage controlvm controller acpipowerbutton
"%VBM%" controlvm controller acpipowerbutton
IF %errorlevel% NEQ 0 GOTO :vbm_error

TIMEOUT /T 1 /NOBREAK
ECHO %time% Waiting for VM controller to power off.
CALL :wait_poweroff controller
ECHO %time% VM controller powered off.
TIMEOUT /T 1 /NOBREAK
COPY %TOPDIR%\scripts\config_public_network.sh %AUTODIR%\00_config_public_network.sh
COPY %TOPDIR%\scripts\config_private_network.sh %AUTODIR%\01_config_private_network.sh
ECHO VBoxManage startvm controller --type separate
"%VBM%" startvm controller --type separate
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO %time% Waiting for autostart files to execute.
CALL :wait_auto
ECHO %time% All autostart files executed.
ECHO VBoxManage controlvm controller acpipowerbutton
"%VBM%" controlvm controller acpipowerbutton
IF %errorlevel% NEQ 0 GOTO :vbm_error

TIMEOUT /T 1 /NOBREAK
ECHO %time% Waiting for VM controller to power off.
CALL :wait_poweroff controller
ECHO %time% VM controller powered off.
TIMEOUT /T 1 /NOBREAK
ECHO VBoxManage controlvm compute1 acpipowerbutton
"%VBM%" controlvm compute1 acpipowerbutton
IF %errorlevel% NEQ 0 GOTO :vbm_error

TIMEOUT /T 1 /NOBREAK
ECHO %time% Waiting for VM compute1 to power off.
CALL :wait_poweroff compute1
ECHO %time% VM compute1 powered off.
TIMEOUT /T 1 /NOBREAK
ECHO VBoxManage snapshot controller take controller_-_cluster_installed
"%VBM%" snapshot controller take controller_-_cluster_installed
IF %errorlevel% NEQ 0 GOTO :vbm_error

TIMEOUT /T 1 /NOBREAK
ECHO VBoxManage snapshot compute1 take compute-_cluster_installed
"%VBM%" snapshot compute1 take compute-_cluster_installed
IF %errorlevel% NEQ 0 GOTO :vbm_error

TIMEOUT /T 1 /NOBREAK
ECHO VBoxManage startvm compute1 --type separate
"%VBM%" startvm compute1 --type separate
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO %time% Waiting for autostart files to execute.
CALL :wait_auto
ECHO %time% All autostart files executed.
ECHO VBoxManage startvm controller --type separate
"%VBM%" startvm controller --type separate
IF %errorlevel% NEQ 0 GOTO :vbm_error

ECHO %time% Waiting for autostart files to execute.
CALL :wait_auto
ECHO %time% All autostart files executed.
ECHO.
ECHO %time% Batch script seems to have succeeded.
ECHO.

GOTO :terminate

REM Note: vbm_error falls through to terminate
:vbm_error
ECHO.
ECHO %time% VBoxManage returned with an error. Aborting.
ECHO.

:terminate
ENDLOCAL
PAUSE
EXIT
GOTO :eof

REM ============================================================================
REM
REM End of program, function definitions follow
REM
REM ============================================================================
:wait_auto
IF EXIST %STATUSDIR%\done (
    DEL %STATUSDIR%\done
    GOTO :eof
)
IF EXIST %STATUSDIR%\error (
    ECHO.
    ECHO %time% ERROR Script returned error:
    ECHO.
    TYPE %STATUSDIR%\error
    ECHO.
    ECHO %time% Aborting.
    ECHO.
    DEL %STATUSDIR%\error
    GOTO :terminate
)
TIMEOUT /T 5 /NOBREAK
GOTO :wait_auto
REM - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
:wait_poweroff
"%VBM%" showvminfo %~1 --machinereadable|findstr poweroff
IF %errorlevel% EQU 0 GOTO :eof
TIMEOUT /T 2 /NOBREAK
GOTO :wait_poweroff
REM - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
:vm_exists
"%VBM%" list vms|findstr %~1
IF %errorlevel% NEQ 0 GOTO :eof
ECHO.
ECHO %time% VM %~1 already exists. Aborting.
ECHO.
GOTO :terminate
REM - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

REM vim: set ai ts=4 sw=4 et ft=dosbatch:

