/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.workflow.lite;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.validation.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.LiteWorkflowStoreService;
import org.apache.oozie.service.SchemaService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.lite.ActionNodeDef;
import org.apache.oozie.workflow.lite.DecisionNodeDef;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.ForkNodeDef;
import org.apache.oozie.workflow.lite.JoinNodeDef;
import org.apache.oozie.workflow.lite.KillNodeDef;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.LiteWorkflowAppParser;
import org.apache.oozie.workflow.lite.LiteWorkflowValidator;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.StartNodeDef;
import org.apache.oozie.workflow.lite.TestLiteWorkflowLib;

public class TestLiteWorkflowAppParser
extends XTestCase {
    public static String dummyConf = "<java></java>";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setSystemProperty("oozie.service.SchemaService.wf.ext.schemas", "hive-action-0.2.xsd,email-action-0.2.xsd");
        new Services().init();
    }

    @Override
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    private String cleanupXml(String xml) {
        xml = xml.replaceAll(" xmlns=?(\"|')(\"|')", "");
        xml = xml.replaceAll("\\s*<source>.*</source>", "");
        xml = xml.replaceAll("\\s*<!--Loaded from Unknown-->", "");
        return xml;
    }

    public void testParserGlobal() throws Exception {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp app = parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-schema-valid-global.xml", (int)-1), new Configuration());
        String d = app.getNode("d").getConf();
        String expectedD = "<map-reduce xmlns=\"uri:oozie:workflow:0.4\">\r\n  <prepare>\r\n    <delete path=\"/tmp\" />\r\n    <mkdir path=\"/tmp\" />\r\n  </prepare>\r\n  <streaming>\r\n    <mapper>/mycat.sh</mapper>\r\n    <reducer>/mywc.sh</reducer>\r\n  </streaming>\r\n  <file>/tmp</file>\r\n  <archive>/tmp</archive>\r\n  <name-node>bar</name-node>\r\n  <job-tracker>${foo}</job-tracker>\r\n  <configuration>\r\n    <property>\r\n      <name>b</name>\r\n      <value>B</value>\r\n    </property>\r\n    <property>\r\n      <name>a</name>\r\n      <value>A</value>\r\n    </property>\r\n  </configuration>\r\n</map-reduce>";
        d = this.cleanupXml(d);
        TestLiteWorkflowAppParser.assertEquals((String)expectedD.replaceAll(" ", ""), (String)d.replaceAll(" ", ""));
    }

    public void testParserGlobalJobXML() throws Exception {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp app = parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-schema-valid-global-jobXml.xml", (int)-1), new Configuration());
        String d = app.getNode("d").getConf();
        String expectedD = "<map-reduce xmlns=\"uri:oozie:workflow:0.4\">\r\n  <prepare>\r\n    <delete path=\"/tmp\" />\r\n    <mkdir path=\"/tmp\" />\r\n  </prepare>\r\n  <streaming>\r\n    <mapper>/mycat.sh</mapper>\r\n    <reducer>/mywc.sh</reducer>\r\n  </streaming>\r\n  <job-xml>/tmp</job-xml>\r\n  <file>/tmp</file>\r\n  <archive>/tmp</archive>\r\n  <name-node>bar</name-node>\r\n  <job-tracker>foo</job-tracker>\r\n  <job-xml>/spam1</job-xml>\r\n  <job-xml>/spam2</job-xml>\r\n  <configuration>\r\n    <property>\r\n      <name>b</name>\r\n      <value>B</value>\r\n    </property>\r\n    <property>\r\n      <name>a</name>\r\n      <value>A</value>\r\n    </property>\r\n  </configuration>\r\n</map-reduce>";
        d = this.cleanupXml(d);
        TestLiteWorkflowAppParser.assertEquals((String)expectedD.replaceAll(" ", ""), (String)d.replaceAll(" ", ""));
    }

    public void testParserGlobalLocalAlreadyExists() throws Exception {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp app = parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-schema-valid-global.xml", (int)-1), new Configuration());
        String e = app.getNode("e").getConf();
        String expectedE = "<pig xmlns=\"uri:oozie:workflow:0.4\">\r\n  <prepare>\r\n    <delete path=\"/tmp\" />\r\n    <mkdir path=\"/tmp\" />\r\n  </prepare>\r\n  <configuration>\r\n    <property>\r\n      <name>b</name>\r\n      <value>B</value>\r\n    </property>\r\n    <property>\r\n      <name>a</name>\r\n      <value>A2</value>\r\n    </property>\r\n  </configuration>\r\n  <script>/tmp</script>\r\n  <param>x</param>\r\n  <file>/tmp</file>\r\n  <file>/tmp</file>\r\n  <name-node>bar</name-node>\r\n  <job-tracker>${foo}</job-tracker>\r\n</pig>";
        e = this.cleanupXml(e);
        TestLiteWorkflowAppParser.assertEquals((String)expectedE.replaceAll(" ", ""), (String)e.replaceAll(" ", ""));
    }

    public void testParserGlobalExtensionActions() throws Exception {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp app = parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-schema-valid-global-ext.xml", (int)-1), new Configuration());
        String a = app.getNode("a").getConf();
        String expectedA = "<hive xmlns=\"uri:oozie:hive-action:0.2\">\r\n  <prepare>\r\n    <delete path=\"/tmp\" />\r\n    <mkdir path=\"/tmp\" />\r\n  </prepare>\r\n  <configuration>\r\n    <property>\r\n      <name>b</name>\r\n      <value>B</value>\r\n    </property>\r\n    <property>\r\n      <name>a</name>\r\n      <value>A</value>\r\n    </property>\r\n    <property>\r\n      <name>c</name>\r\n      <value>C</value>\r\n    </property>\r\n  </configuration>\r\n  <script>script.q</script>\r\n  <param>INPUT=/tmp/table</param>\r\n  <param>OUTPUT=/tmp/hive</param>\r\n  <name-node>bar</name-node>\r\n  <job-tracker>foo</job-tracker>\r\n</hive>";
        a = this.cleanupXml(a);
        TestLiteWorkflowAppParser.assertEquals((String)expectedA.replaceAll(" ", ""), (String)a.replaceAll(" ", ""));
    }

    public void testParserGlobalExtensionActionsLocalAlreadyExists() throws Exception {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp app = parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-schema-valid-global-ext.xml", (int)-1), new Configuration());
        String b = app.getNode("b").getConf();
        String expectedB = "<distcp xmlns=\"uri:oozie:distcp-action:0.1\">\r\n  <job-tracker>blah</job-tracker>\r\n  <name-node>meh</name-node>\r\n  <prepare>\r\n    <delete path=\"/tmp2\" />\r\n    <mkdir path=\"/tmp2\" />\r\n  </prepare>\r\n  <configuration>\r\n    <property>\r\n      <name>b</name>\r\n      <value>B</value>\r\n    </property>\r\n    <property>\r\n      <name>a</name>\r\n      <value>A2</value>\r\n    </property>\r\n  </configuration>\r\n  <arg>/tmp/data.txt</arg>\r\n  <arg>/tmp2/data.txt</arg>\r\n</distcp>";
        b = this.cleanupXml(b);
        TestLiteWorkflowAppParser.assertEquals((String)expectedB.replaceAll(" ", ""), (String)b.replaceAll(" ", ""));
    }

    public void testParserGlobalExtensionActionsNotApplicable() throws Exception {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp app = parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-schema-valid-global-ext.xml", (int)-1), new Configuration());
        String c1 = app.getNode("c1").getConf();
        String expectedC1 = "<email xmlns=\"uri:oozie:email-action:0.2\">\r\n  <to>foo@bar.com</to>\r\n  <subject>foo</subject>\r\n  <body>bar</body>\r\n</email>";
        c1 = this.cleanupXml(c1);
        TestLiteWorkflowAppParser.assertEquals((String)expectedC1.replaceAll(" ", ""), (String)c1.replaceAll(" ", ""));
    }

    public void testParserGlobalExtensionActionsNoGlobal() throws Exception {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-schema-valid-global-ext-no-global.xml", (int)-1), new Configuration());
        try {
            parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-schema-invalid-global-ext-no-global.xml", (int)-1), new Configuration());
            TestLiteWorkflowAppParser.fail();
        }
        catch (WorkflowException ex) {
            TestLiteWorkflowAppParser.assertEquals((Object)ErrorCode.E0701, (Object)ex.getErrorCode());
        }
        catch (Exception ex) {
            TestLiteWorkflowAppParser.fail();
        }
    }

    public void testParserDefaultNameNode() throws Exception {
        ConfigurationService.set((String)"oozie.actions.default.name-node", (String)"default-nn");
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp app = parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-schema-no-namenode.xml", (int)-1), new Configuration());
        String a = app.getNode("a").getConf();
        String expectedA = "<hive xmlns=\"uri:oozie:hive-action:0.2\">\r\n  <prepare>\r\n    <delete path=\"/tmp\" />\r\n    <mkdir path=\"/tmp\" />\r\n  </prepare>\r\n  <job-tracker>foo</job-tracker>\r\n  <configuration>\r\n    <property>\r\n      <name>c</name>\r\n      <value>C</value>\r\n    </property>\r\n  </configuration>\r\n  <script>script.q</script>\r\n  <param>INPUT=/tmp/table</param>\r\n  <param>OUTPUT=/tmp/hive</param>\r\n  <name-node>default-nn</name-node>\r\n</hive>";
        a = this.cleanupXml(a);
        TestLiteWorkflowAppParser.assertEquals((String)expectedA.replaceAll(" ", ""), (String)a.replaceAll(" ", ""));
    }

    public void testParserDefaultNameNodeWithGlobal() throws Exception {
        ConfigurationService.set((String)"oozie.actions.default.name-node", (String)"default-nn");
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp app = parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-schema-no-namenode-global.xml", (int)-1), new Configuration());
        String a = app.getNode("a").getConf();
        String expectedA = "<hive xmlns=\"uri:oozie:hive-action:0.2\">\r\n  <prepare>\r\n    <delete path=\"/tmp\" />\r\n    <mkdir path=\"/tmp\" />\r\n  </prepare>\r\n  <job-tracker>foo</job-tracker>\r\n  <configuration>\r\n    <property>\r\n      <name>c</name>\r\n      <value>C</value>\r\n    </property>\r\n  </configuration>\r\n  <script>script.q</script>\r\n  <param>INPUT=/tmp/table</param>\r\n  <param>OUTPUT=/tmp/hive</param>\r\n  <name-node>global-nn</name-node>\r\n</hive>";
        a = this.cleanupXml(a);
        TestLiteWorkflowAppParser.assertEquals((String)expectedA.replaceAll(" ", ""), (String)a.replaceAll(" ", ""));
    }

    public void testParserDefaultNameNodeNotApplicable() throws Exception {
        ConfigurationService.set((String)"oozie.actions.default.name-node", (String)"default-nn");
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp app = parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-schema-no-namenode.xml", (int)-1), new Configuration());
        String b1 = app.getNode("b1").getConf();
        String expectedB1 = "<email xmlns=\"uri:oozie:email-action:0.2\">\r\n  <to>foo@bar.com</to>\r\n  <subject>foo</subject>\r\n  <body>bar</body>\r\n</email>";
        b1 = this.cleanupXml(b1);
        TestLiteWorkflowAppParser.assertEquals((String)expectedB1.replaceAll(" ", ""), (String)b1.replaceAll(" ", ""));
    }

    public void testParserDefaultNameNodeFail() throws Exception {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        try {
            parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-schema-no-namenode.xml", (int)-1), new Configuration());
            TestLiteWorkflowAppParser.fail();
        }
        catch (WorkflowException e) {
            TestLiteWorkflowAppParser.assertEquals((Object)ErrorCode.E0701, (Object)e.getErrorCode());
            TestLiteWorkflowAppParser.assertTrue((boolean)e.getMessage().contains("No name-node defined"));
        }
    }

    public void testParserDefaultJobTracker() throws Exception {
        ConfigurationService.set((String)"oozie.actions.default.job-tracker", (String)"default-jt");
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp app = parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-schema-no-jobtracker.xml", (int)-1), new Configuration());
        String a = app.getNode("a").getConf();
        String expectedA = "<hive xmlns=\"uri:oozie:hive-action:0.2\">\r\n  <prepare>\r\n    <delete path=\"/tmp\" />\r\n    <mkdir path=\"/tmp\" />\r\n  </prepare>\r\n  <name-node>bar</name-node>\r\n  <configuration>\r\n    <property>\r\n      <name>c</name>\r\n      <value>C</value>\r\n    </property>\r\n  </configuration>\r\n  <script>script.q</script>\r\n  <param>INPUT=/tmp/table</param>\r\n  <param>OUTPUT=/tmp/hive</param>\r\n  <job-tracker>default-jt</job-tracker>\r\n</hive>";
        a = this.cleanupXml(a);
        TestLiteWorkflowAppParser.assertEquals((String)expectedA.replaceAll(" ", ""), (String)a.replaceAll(" ", ""));
    }

    public void testParserDefaultJobTrackerWithGlobal() throws Exception {
        ConfigurationService.set((String)"oozie.actions.default.job-tracker", (String)"default-jt");
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp app = parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-schema-no-jobtracker-global.xml", (int)-1), new Configuration());
        String a = app.getNode("a").getConf();
        String expectedA = "<hive xmlns=\"uri:oozie:hive-action:0.2\">\r\n  <prepare>\r\n    <delete path=\"/tmp\" />\r\n    <mkdir path=\"/tmp\" />\r\n  </prepare>\r\n  <name-node>bar</name-node>\r\n  <configuration>\r\n    <property>\r\n      <name>c</name>\r\n      <value>C</value>\r\n    </property>\r\n  </configuration>\r\n  <script>script.q</script>\r\n  <param>INPUT=/tmp/table</param>\r\n  <param>OUTPUT=/tmp/hive</param>\r\n  <job-tracker>global-jt</job-tracker>\r\n</hive>";
        a = this.cleanupXml(a);
        TestLiteWorkflowAppParser.assertEquals((String)expectedA.replaceAll(" ", ""), (String)a.replaceAll(" ", ""));
    }

    public void testParserDefaultJobTrackerNotApplicable() throws Exception {
        ConfigurationService.set((String)"oozie.actions.default.job-tracker", (String)"default-jt");
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp app = parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-schema-no-jobtracker.xml", (int)-1), new Configuration());
        String b1 = app.getNode("b1").getConf();
        String expectedB1 = "<email xmlns=\"uri:oozie:email-action:0.2\">\r\n  <to>foo@bar.com</to>\r\n  <subject>foo</subject>\r\n  <body>bar</body>\r\n</email>";
        b1 = this.cleanupXml(b1);
        TestLiteWorkflowAppParser.assertEquals((String)expectedB1.replaceAll(" ", ""), (String)b1.replaceAll(" ", ""));
    }

    public void testParserDefaultJobTrackerFail() throws Exception {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        try {
            parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-schema-no-jobtracker.xml", (int)-1), new Configuration());
            TestLiteWorkflowAppParser.fail();
        }
        catch (WorkflowException e) {
            TestLiteWorkflowAppParser.assertEquals((Object)ErrorCode.E0701, (Object)e.getErrorCode());
            TestLiteWorkflowAppParser.assertTrue((boolean)e.getMessage().contains("No job-tracker defined"));
        }
    }

    public void testParserSubWorkflowPropagateNoGlobal() throws Exception {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp app = parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-schema-subworkflow-propagate-no-global.xml", (int)-1), new Configuration());
        String a = app.getNode("a").getConf();
        String expectedA = "<sub-workflowxmlns=\"uri:oozie:workflow:0.4\">\r\n<app-path>/tmp/foo/</app-path>\r\n<propagate-configuration/>\r\n<configuration/>\r\n</sub-workflow>";
        a = this.cleanupXml(a);
        TestLiteWorkflowAppParser.assertEquals((String)expectedA.replaceAll(" ", ""), (String)a.replaceAll(" ", ""));
    }

    public void testParserFsGlobalNN() throws Exception {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp app = parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-schema-fs-no-namenode-global.xml", (int)-1), new Configuration());
        String a = app.getNode("a").getConf();
        String expectedA = "<fs xmlns=\"uri:oozie:workflow:0.4\">\r\n  <name-node>action-nn</name-node>\r\n  <mkdir path=\"/foo\" />\r\n  <configuration />\r\n</fs>";
        a = this.cleanupXml(a);
        TestLiteWorkflowAppParser.assertEquals((String)expectedA.replaceAll(" ", ""), (String)a.replaceAll(" ", ""));
        String b = app.getNode("b").getConf();
        String expectedB = "<fs xmlns=\"uri:oozie:workflow:0.4\">\r\n  <mkdir path=\"/foo\" />\r\n  <name-node>global-nn</name-node>\r\n  <configuration />\r\n</fs>";
        b = this.cleanupXml(b);
        TestLiteWorkflowAppParser.assertEquals((String)expectedB.replaceAll(" ", ""), (String)b.replaceAll(" ", ""));
    }

    public void testParserFsDefaultNN() throws Exception {
        ConfigurationService.set((String)"oozie.actions.default.name-node", (String)"default-nn");
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp app = parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-schema-fs-no-namenode.xml", (int)-1), new Configuration());
        String a = app.getNode("a").getConf();
        String expectedA = "<fs xmlns=\"uri:oozie:workflow:0.4\">\r\n  <name-node>action-nn</name-node>\r\n  <mkdir path=\"/foo\" />\r\n  <configuration />\r\n</fs>";
        a = this.cleanupXml(a);
        TestLiteWorkflowAppParser.assertEquals((String)expectedA.replaceAll(" ", ""), (String)a.replaceAll(" ", ""));
        String b = app.getNode("b").getConf();
        String expectedB = "<fs xmlns=\"uri:oozie:workflow:0.4\">\r\n  <mkdir path=\"/foo\" />\r\n  <name-node>default-nn</name-node>\r\n  <configuration />\r\n</fs>";
        b = this.cleanupXml(b);
        TestLiteWorkflowAppParser.assertEquals((String)expectedB.replaceAll(" ", ""), (String)b.replaceAll(" ", ""));
    }

    public void testParserFsNoNN() throws Exception {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp app = parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-schema-fs-no-namenode.xml", (int)-1), new Configuration());
        String a = app.getNode("a").getConf();
        String expectedA = "<fs xmlns=\"uri:oozie:workflow:0.4\">\r\n  <name-node>action-nn</name-node>\r\n  <mkdir path=\"/foo\" />\r\n  <configuration />\r\n</fs>";
        a = this.cleanupXml(a);
        TestLiteWorkflowAppParser.assertEquals((String)expectedA.replaceAll(" ", ""), (String)a.replaceAll(" ", ""));
        String b = app.getNode("b").getConf();
        String expectedB = "<fs xmlns=\"uri:oozie:workflow:0.4\">\r\n  <mkdir path=\"/foo\" />\r\n  <configuration />\r\n</fs>";
        b = this.cleanupXml(b);
        TestLiteWorkflowAppParser.assertEquals((String)expectedB.replaceAll(" ", ""), (String)b.replaceAll(" ", ""));
    }

    public void testParser() throws Exception {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-schema-valid.xml", (int)-1), new Configuration());
        try {
            parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-unsupported-action.xml", (int)-1), new Configuration());
            TestLiteWorkflowAppParser.fail();
        }
        catch (WorkflowException ex) {
            TestLiteWorkflowAppParser.assertEquals((Object)ErrorCode.E0723, (Object)ex.getErrorCode());
        }
        catch (Exception ex) {
            TestLiteWorkflowAppParser.fail();
        }
        try {
            parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-loop2-invalid.xml", (int)-1), new Configuration());
            TestLiteWorkflowAppParser.fail();
        }
        catch (WorkflowException ex) {
            TestLiteWorkflowAppParser.assertEquals((Object)ErrorCode.E0706, (Object)ex.getErrorCode());
        }
        catch (Exception ex) {
            TestLiteWorkflowAppParser.fail();
        }
        try {
            parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-transition-invalid.xml", (int)-1), new Configuration());
            TestLiteWorkflowAppParser.fail();
        }
        catch (WorkflowException ex) {
            TestLiteWorkflowAppParser.assertEquals((Object)ErrorCode.E0708, (Object)ex.getErrorCode());
        }
        catch (Exception ex) {
            TestLiteWorkflowAppParser.fail();
        }
    }

    public void testWfNoForkJoin() throws WorkflowException {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp def = new LiteWorkflowApp("name", "def", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "one")).addNode((NodeDef)new ActionNodeDef("one", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "two", "three")).addNode((NodeDef)new ActionNodeDef("two", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "end", "end")).addNode((NodeDef)new ActionNodeDef("three", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "end", "end")).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        try {
            this.invokeForkJoin(parser, def);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLiteWorkflowAppParser.fail((String)"Unexpected Exception");
        }
    }

    public void testSimpleForkJoin() throws WorkflowException {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp def = new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "one")).addNode((NodeDef)new ActionNodeDef("one", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "f", "end")).addNode((NodeDef)new ForkNodeDef("f", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("two", "three"))).addNode((NodeDef)new ActionNodeDef("two", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new ActionNodeDef("three", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new JoinNodeDef("j", LiteWorkflowStoreService.LiteControlNodeHandler.class, "four")).addNode((NodeDef)new ActionNodeDef("four", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "end", "end")).addNode((NodeDef)new KillNodeDef("k", "kill", LiteWorkflowStoreService.LiteControlNodeHandler.class)).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        try {
            this.invokeForkJoin(parser, def);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLiteWorkflowAppParser.fail((String)"Unexpected Exception");
        }
    }

    public void testNestedForkJoin() throws WorkflowException {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp def = new LiteWorkflowApp("testWf", "<worklfow-app/>", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "one")).addNode((NodeDef)new ActionNodeDef("one", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "f", "end")).addNode((NodeDef)new ForkNodeDef("f", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("two", "three"))).addNode((NodeDef)new ActionNodeDef("two", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "f2", "k")).addNode((NodeDef)new ActionNodeDef("three", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new ForkNodeDef("f2", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("four", "five", "six"))).addNode((NodeDef)new ActionNodeDef("four", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j2", "k")).addNode((NodeDef)new ActionNodeDef("five", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j2", "k")).addNode((NodeDef)new ActionNodeDef("six", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j2", "k")).addNode((NodeDef)new JoinNodeDef("j2", LiteWorkflowStoreService.LiteControlNodeHandler.class, "seven")).addNode((NodeDef)new ActionNodeDef("seven", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new JoinNodeDef("j", LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new KillNodeDef("k", "kill", LiteWorkflowStoreService.LiteControlNodeHandler.class)).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        try {
            this.invokeForkJoin(parser, def);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLiteWorkflowAppParser.fail((String)"Unexpected Exception");
        }
    }

    public void testForkJoinFailure() throws WorkflowException {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp def = new LiteWorkflowApp("testWf", "<worklfow-app/>", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "one")).addNode((NodeDef)new ActionNodeDef("one", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "f", "end")).addNode((NodeDef)new ForkNodeDef("f", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("two", "three"))).addNode((NodeDef)new ActionNodeDef("two", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new ActionNodeDef("three", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "end", "k")).addNode((NodeDef)new JoinNodeDef("j", LiteWorkflowStoreService.LiteControlNodeHandler.class, "k")).addNode((NodeDef)new KillNodeDef("k", "kill", LiteWorkflowStoreService.LiteControlNodeHandler.class)).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        try {
            this.invokeForkJoin(parser, def);
            TestLiteWorkflowAppParser.fail((String)"Expected to catch an exception but did not encounter any");
        }
        catch (WorkflowException we) {
            TestLiteWorkflowAppParser.assertEquals((Object)ErrorCode.E0737, (Object)we.getErrorCode());
            TestLiteWorkflowAppParser.assertTrue((boolean)we.getMessage().contains("node [three]"));
            TestLiteWorkflowAppParser.assertTrue((boolean)we.getMessage().contains("node [end]"));
        }
    }

    public void testNestedForkJoinFailure() throws WorkflowException {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp def = new LiteWorkflowApp("testWf", "<worklfow-app/>", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "one")).addNode((NodeDef)new ActionNodeDef("one", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "f", "end")).addNode((NodeDef)new ForkNodeDef("f", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("four", "three", "two"))).addNode((NodeDef)new ActionNodeDef("two", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new ActionNodeDef("three", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new ActionNodeDef("four", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "f2", "k")).addNode((NodeDef)new ForkNodeDef("f2", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("five", "six"))).addNode((NodeDef)new ActionNodeDef("five", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j2", "k")).addNode((NodeDef)new ActionNodeDef("six", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j2", "k")).addNode((NodeDef)new JoinNodeDef("j", LiteWorkflowStoreService.LiteControlNodeHandler.class, "j2")).addNode((NodeDef)new JoinNodeDef("j2", LiteWorkflowStoreService.LiteControlNodeHandler.class, "k")).addNode((NodeDef)new KillNodeDef("k", "kill", LiteWorkflowStoreService.LiteControlNodeHandler.class)).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        try {
            this.invokeForkJoin(parser, def);
            TestLiteWorkflowAppParser.fail((String)"Expected to catch an exception but did not encounter any");
        }
        catch (WorkflowException we) {
            TestLiteWorkflowAppParser.assertEquals((Object)ErrorCode.E0742, (Object)we.getErrorCode());
            TestLiteWorkflowAppParser.assertTrue((boolean)we.getMessage().contains("[j2]"));
        }
    }

    public void testTransitionFailure1() throws WorkflowException {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp def = new LiteWorkflowApp("name", "def", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "one")).addNode((NodeDef)new ActionNodeDef("one", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "f", "end")).addNode((NodeDef)new ForkNodeDef("f", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("two", "three"))).addNode((NodeDef)new ActionNodeDef("two", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "three", "j")).addNode((NodeDef)new ActionNodeDef("three", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new JoinNodeDef("j", LiteWorkflowStoreService.LiteControlNodeHandler.class, "k")).addNode((NodeDef)new KillNodeDef("k", "kill", LiteWorkflowStoreService.LiteControlNodeHandler.class)).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        try {
            this.invokeForkJoin(parser, def);
            TestLiteWorkflowAppParser.fail((String)"Expected to catch an exception but did not encounter any");
        }
        catch (WorkflowException we) {
            TestLiteWorkflowAppParser.assertEquals((Object)ErrorCode.E0743, (Object)we.getErrorCode());
            TestLiteWorkflowAppParser.assertTrue((boolean)we.getMessage().contains("three"));
        }
    }

    public void testTransition2() throws WorkflowException {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp def = new LiteWorkflowApp("name", "def", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "one")).addNode((NodeDef)new ActionNodeDef("one", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "f", "end")).addNode((NodeDef)new ForkNodeDef("f", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("two", "three"))).addNode((NodeDef)new ActionNodeDef("two", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "three")).addNode((NodeDef)new ActionNodeDef("three", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new JoinNodeDef("j", LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new KillNodeDef("k", "kill", LiteWorkflowStoreService.LiteControlNodeHandler.class)).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        try {
            this.invokeForkJoin(parser, def);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TestLiteWorkflowAppParser.fail((String)"Unexpected Exception");
        }
    }

    public void testTransition3() throws WorkflowException {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp def = new LiteWorkflowApp("name", "def", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "one")).addNode((NodeDef)new ActionNodeDef("one", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "f", "end")).addNode((NodeDef)new ForkNodeDef("f", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("two", "three"))).addNode((NodeDef)new ActionNodeDef("two", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "four")).addNode((NodeDef)new ActionNodeDef("three", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "four", "k")).addNode((NodeDef)new ActionNodeDef("four", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new JoinNodeDef("j", LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new KillNodeDef("k", "kill", LiteWorkflowStoreService.LiteControlNodeHandler.class)).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        try {
            this.invokeForkJoin(parser, def);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TestLiteWorkflowAppParser.fail((String)"Unexpected Exception");
        }
    }

    public void testErrorTransitionForkJoin() throws WorkflowException {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp def = new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "one")).addNode((NodeDef)new ActionNodeDef("one", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "f", "end")).addNode((NodeDef)new ForkNodeDef("f", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("two", "three"))).addNode((NodeDef)new ActionNodeDef("two", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "f1")).addNode((NodeDef)new ActionNodeDef("three", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "f1")).addNode((NodeDef)new ForkNodeDef("f1", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("four", "five"))).addNode((NodeDef)new ActionNodeDef("four", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j1", "k")).addNode((NodeDef)new ActionNodeDef("five", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j1", "k")).addNode((NodeDef)new JoinNodeDef("j", LiteWorkflowStoreService.LiteControlNodeHandler.class, "six")).addNode((NodeDef)new JoinNodeDef("j1", LiteWorkflowStoreService.LiteControlNodeHandler.class, "six")).addNode((NodeDef)new ActionNodeDef("six", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "k", "k")).addNode((NodeDef)new KillNodeDef("k", "kill", LiteWorkflowStoreService.LiteControlNodeHandler.class)).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        try {
            this.invokeForkJoin(parser, def);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLiteWorkflowAppParser.fail((String)"Unexpected Exception");
        }
    }

    public void testDecisionForkJoin() throws WorkflowException {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp def = new LiteWorkflowApp("name", "def", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "one")).addNode((NodeDef)new ActionNodeDef("one", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "f", "end")).addNode((NodeDef)new ForkNodeDef("f", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("two", "three"))).addNode((NodeDef)new DecisionNodeDef("two", dummyConf, TestLiteWorkflowLib.TestDecisionNodeHandler.class, Arrays.asList("four", "five", "four"))).addNode((NodeDef)new ActionNodeDef("four", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new ActionNodeDef("five", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new ActionNodeDef("three", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new JoinNodeDef("j", LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new KillNodeDef("k", "kill", LiteWorkflowStoreService.LiteControlNodeHandler.class)).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        try {
            this.invokeForkJoin(parser, def);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLiteWorkflowAppParser.fail((String)"Unexpected Exception");
        }
    }

    public void testDecisionsToJoinForkJoin() throws WorkflowException {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp def = new LiteWorkflowApp("name", "def", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "one")).addNode((NodeDef)new ActionNodeDef("one", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "f", "end")).addNode((NodeDef)new ForkNodeDef("f", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("two", "three"))).addNode((NodeDef)new DecisionNodeDef("two", dummyConf, TestLiteWorkflowLib.TestDecisionNodeHandler.class, Arrays.asList("four", "j", "four"))).addNode((NodeDef)new DecisionNodeDef("three", dummyConf, TestLiteWorkflowLib.TestDecisionNodeHandler.class, Arrays.asList("j", "five", "j"))).addNode((NodeDef)new ActionNodeDef("four", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new ActionNodeDef("five", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new JoinNodeDef("j", LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new KillNodeDef("k", "kill", LiteWorkflowStoreService.LiteControlNodeHandler.class)).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        try {
            this.invokeForkJoin(parser, def);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLiteWorkflowAppParser.fail((String)"Unexpected Exception");
        }
    }

    public void testDecisionsToKillForkJoin() throws WorkflowException {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp def = new LiteWorkflowApp("name", "def", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "one")).addNode((NodeDef)new ActionNodeDef("one", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "f", "end")).addNode((NodeDef)new ForkNodeDef("f", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("two", "three"))).addNode((NodeDef)new DecisionNodeDef("two", dummyConf, TestLiteWorkflowLib.TestDecisionNodeHandler.class, Arrays.asList("four", "k", "four"))).addNode((NodeDef)new DecisionNodeDef("three", dummyConf, TestLiteWorkflowLib.TestDecisionNodeHandler.class, Arrays.asList("k", "five", "k"))).addNode((NodeDef)new ActionNodeDef("four", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new ActionNodeDef("five", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new JoinNodeDef("j", LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new KillNodeDef("k", "kill", LiteWorkflowStoreService.LiteControlNodeHandler.class)).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        try {
            this.invokeForkJoin(parser, def);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLiteWorkflowAppParser.fail((String)"Unexpected Exception");
        }
    }

    public void testDecisionForkJoinFailure() throws WorkflowException {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp def = new LiteWorkflowApp("name", "def", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "one")).addNode((NodeDef)new ActionNodeDef("one", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "f", "end")).addNode((NodeDef)new ForkNodeDef("f", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("two", "three"))).addNode((NodeDef)new DecisionNodeDef("two", dummyConf, TestLiteWorkflowLib.TestDecisionNodeHandler.class, Arrays.asList("four", "three"))).addNode((NodeDef)new ActionNodeDef("three", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new ActionNodeDef("four", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new JoinNodeDef("j", LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new KillNodeDef("k", "kill", LiteWorkflowStoreService.LiteControlNodeHandler.class)).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        try {
            this.invokeForkJoin(parser, def);
            TestLiteWorkflowAppParser.fail((String)"Expected to catch an exception but did not encounter any");
        }
        catch (WorkflowException we) {
            TestLiteWorkflowAppParser.assertEquals((Object)ErrorCode.E0743, (Object)we.getErrorCode());
            TestLiteWorkflowAppParser.assertTrue((boolean)we.getMessage().contains("three"));
        }
    }

    public void testDecisionToEndForkJoinFailure() throws WorkflowException {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp def = new LiteWorkflowApp("name", "def", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "one")).addNode((NodeDef)new ActionNodeDef("one", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "f", "end")).addNode((NodeDef)new ForkNodeDef("f", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("two", "three"))).addNode((NodeDef)new DecisionNodeDef("two", dummyConf, TestLiteWorkflowLib.TestDecisionNodeHandler.class, Arrays.asList("four", "end"))).addNode((NodeDef)new ActionNodeDef("three", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new ActionNodeDef("four", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new JoinNodeDef("j", LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new KillNodeDef("k", "kill", LiteWorkflowStoreService.LiteControlNodeHandler.class)).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        try {
            this.invokeForkJoin(parser, def);
            TestLiteWorkflowAppParser.fail((String)"Expected to catch an exception but did not encounter any");
        }
        catch (WorkflowException we) {
            TestLiteWorkflowAppParser.assertEquals((Object)ErrorCode.E0737, (Object)we.getErrorCode());
            TestLiteWorkflowAppParser.assertTrue((boolean)we.getMessage().contains("node [two]"));
            TestLiteWorkflowAppParser.assertTrue((boolean)we.getMessage().contains("node [end]"));
        }
    }

    public void testDecisionTwoPathsForkJoin() throws WorkflowException {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp def = new LiteWorkflowApp("name", "def", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "one")).addNode((NodeDef)new ActionNodeDef("one", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "f", "end")).addNode((NodeDef)new ForkNodeDef("f", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("two", "j"))).addNode((NodeDef)new DecisionNodeDef("two", dummyConf, TestLiteWorkflowLib.TestDecisionNodeHandler.class, Arrays.asList("three", "four"))).addNode((NodeDef)new ActionNodeDef("three", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "four", "k")).addNode((NodeDef)new ActionNodeDef("four", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new JoinNodeDef("j", LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new KillNodeDef("k", "kill", LiteWorkflowStoreService.LiteControlNodeHandler.class)).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        try {
            this.invokeForkJoin(parser, def);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLiteWorkflowAppParser.fail((String)"Unexpected Exception");
        }
    }

    public void testMultipleDecisionThreePathsForkJoin() throws WorkflowException {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp def = new LiteWorkflowApp("name", "def", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "one")).addNode((NodeDef)new ActionNodeDef("one", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "f", "end")).addNode((NodeDef)new ForkNodeDef("f", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("two", "j"))).addNode((NodeDef)new DecisionNodeDef("two", dummyConf, TestLiteWorkflowLib.TestDecisionNodeHandler.class, Arrays.asList("three", "four"))).addNode((NodeDef)new DecisionNodeDef("three", dummyConf, TestLiteWorkflowLib.TestDecisionNodeHandler.class, Arrays.asList("four", "five"))).addNode((NodeDef)new ActionNodeDef("four", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new ActionNodeDef("five", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "four", "k")).addNode((NodeDef)new JoinNodeDef("j", LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new KillNodeDef("k", "kill", LiteWorkflowStoreService.LiteControlNodeHandler.class)).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        try {
            this.invokeForkJoin(parser, def);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLiteWorkflowAppParser.fail((String)"Unexpected Exception");
        }
    }

    public void testMultipleDecisionThreePathsForkJoinFailure() throws WorkflowException {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp def = new LiteWorkflowApp("name", "def", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "one")).addNode((NodeDef)new ActionNodeDef("one", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "f", "end")).addNode((NodeDef)new ForkNodeDef("f", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("two", "four"))).addNode((NodeDef)new DecisionNodeDef("two", dummyConf, TestLiteWorkflowLib.TestDecisionNodeHandler.class, Arrays.asList("three", "four"))).addNode((NodeDef)new DecisionNodeDef("three", dummyConf, TestLiteWorkflowLib.TestDecisionNodeHandler.class, Arrays.asList("four", "five"))).addNode((NodeDef)new ActionNodeDef("four", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new ActionNodeDef("five", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "four", "k")).addNode((NodeDef)new JoinNodeDef("j", LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new KillNodeDef("k", "kill", LiteWorkflowStoreService.LiteControlNodeHandler.class)).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        try {
            this.invokeForkJoin(parser, def);
            TestLiteWorkflowAppParser.fail((String)"Expected to catch an exception but did not encounter any");
        }
        catch (WorkflowException we) {
            TestLiteWorkflowAppParser.assertEquals((Object)ErrorCode.E0743, (Object)we.getErrorCode());
            TestLiteWorkflowAppParser.assertTrue((boolean)we.getMessage().contains("four"));
        }
    }

    public void testMultipleDecisionThreePathsForkJoinFailure2() throws WorkflowException {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp def = new LiteWorkflowApp("name", "def", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "one")).addNode((NodeDef)new ActionNodeDef("one", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "f", "end")).addNode((NodeDef)new ForkNodeDef("f", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("two", "four"))).addNode((NodeDef)new DecisionNodeDef("two", dummyConf, TestLiteWorkflowLib.TestDecisionNodeHandler.class, Arrays.asList("three", "four"))).addNode((NodeDef)new DecisionNodeDef("three", dummyConf, TestLiteWorkflowLib.TestDecisionNodeHandler.class, Arrays.asList("four", "five"))).addNode((NodeDef)new DecisionNodeDef("six", dummyConf, TestLiteWorkflowLib.TestDecisionNodeHandler.class, Arrays.asList("four", "j"))).addNode((NodeDef)new ActionNodeDef("four", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new ActionNodeDef("five", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "four", "k")).addNode((NodeDef)new JoinNodeDef("j", LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new KillNodeDef("k", "kill", LiteWorkflowStoreService.LiteControlNodeHandler.class)).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        try {
            this.invokeForkJoin(parser, def);
            TestLiteWorkflowAppParser.fail((String)"Expected to catch an exception but did not encounter any");
        }
        catch (WorkflowException we) {
            TestLiteWorkflowAppParser.assertEquals((Object)ErrorCode.E0743, (Object)we.getErrorCode());
            TestLiteWorkflowAppParser.assertTrue((boolean)we.getMessage().contains("four"));
        }
    }

    public void testDecisionMultipleForks() throws WorkflowException {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp def = new LiteWorkflowApp("name", "def", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "one")).addNode((NodeDef)new DecisionNodeDef("one", dummyConf, TestLiteWorkflowLib.TestDecisionNodeHandler.class, Arrays.asList("f1", "f2"))).addNode((NodeDef)new ForkNodeDef("f1", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("two", "three"))).addNode((NodeDef)new ForkNodeDef("f2", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("four", "five"))).addNode((NodeDef)new ActionNodeDef("two", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j1", "k")).addNode((NodeDef)new ActionNodeDef("three", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j1", "k")).addNode((NodeDef)new ActionNodeDef("four", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j2", "k")).addNode((NodeDef)new ActionNodeDef("five", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j2", "k")).addNode((NodeDef)new JoinNodeDef("j1", LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new JoinNodeDef("j2", LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new KillNodeDef("k", "kill", LiteWorkflowStoreService.LiteControlNodeHandler.class)).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        try {
            this.invokeForkJoin(parser, def);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestLiteWorkflowAppParser.fail((String)"Unexpected Exception");
        }
    }

    public void testForkJoinMismatch() throws WorkflowException {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp def = new LiteWorkflowApp("name", "def", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "f")).addNode((NodeDef)new ForkNodeDef("f", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("one", "two"))).addNode((NodeDef)new ActionNodeDef("one", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j1", "k")).addNode((NodeDef)new JoinNodeDef("j1", LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new ActionNodeDef("two", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j2", "k")).addNode((NodeDef)new JoinNodeDef("j2", LiteWorkflowStoreService.LiteControlNodeHandler.class, "f2")).addNode((NodeDef)new ForkNodeDef("f2", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("k", "k"))).addNode((NodeDef)new KillNodeDef("k", "kill", LiteWorkflowStoreService.LiteControlNodeHandler.class)).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        try {
            this.invokeForkJoin(parser, def);
            TestLiteWorkflowAppParser.fail((String)"Expected to catch an exception but did not encounter any");
        }
        catch (WorkflowException we) {
            TestLiteWorkflowAppParser.assertEquals((Object)ErrorCode.E0757, (Object)we.getErrorCode());
            TestLiteWorkflowAppParser.assertTrue((boolean)we.getMessage().contains("Fork node [f]"));
            TestLiteWorkflowAppParser.assertTrue((we.getMessage().contains("[j2,j1]") || we.getMessage().contains("[j1,j2]") ? 1 : 0) != 0);
        }
    }

    public void testForkJoinDuplicateTransitionsFromFork() throws WorkflowException {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        LiteWorkflowApp def = new LiteWorkflowApp("name", "def", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "f")).addNode((NodeDef)new ForkNodeDef("f", LiteWorkflowStoreService.LiteControlNodeHandler.class, Arrays.asList("one", "two", "two"))).addNode((NodeDef)new ActionNodeDef("one", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new JoinNodeDef("j", LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new ActionNodeDef("two", dummyConf, TestLiteWorkflowLib.TestActionNodeHandler.class, "j", "k")).addNode((NodeDef)new KillNodeDef("k", "kill", LiteWorkflowStoreService.LiteControlNodeHandler.class)).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        try {
            this.invokeForkJoin(parser, def);
            TestLiteWorkflowAppParser.fail((String)"Expected to catch an exception but did not encounter any");
        }
        catch (WorkflowException we) {
            TestLiteWorkflowAppParser.assertEquals((Object)ErrorCode.E0744, (Object)we.getErrorCode());
            TestLiteWorkflowAppParser.assertTrue((boolean)we.getMessage().contains("fork, [f],"));
            TestLiteWorkflowAppParser.assertTrue((boolean)we.getMessage().contains("node, [two]"));
        }
    }

    public void testForkJoinValidationTime() throws Exception {
        final LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        final LiteWorkflowApp app = parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-long.xml", (int)-1), new Configuration());
        final AtomicBoolean failure = new AtomicBoolean(false);
        final AtomicBoolean finished = new AtomicBoolean(false);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    TestLiteWorkflowAppParser.this.invokeForkJoin(parser, app);
                    finished.set(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    failure.set(true);
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
        t.join((long)(2000.0f * XTestCase.WAITFOR_RATIO));
        if (!finished.get()) {
            t.stop();
            TestLiteWorkflowAppParser.fail((String)"Workflow validation did not finish in time");
        }
        TestLiteWorkflowAppParser.assertFalse((String)"Workflow validation failed", (boolean)failure.get());
    }

    private void invokeForkJoin(LiteWorkflowAppParser parser, LiteWorkflowApp def) throws WorkflowException {
        LiteWorkflowValidator validator = new LiteWorkflowValidator();
        validator.validateWorkflow(def, true);
    }

    public void testRaceConditionWithOldXerces() throws Exception {
        int i;
        Schema schema = ((SchemaService)Services.get().get(SchemaService.class)).getSchema(SchemaService.SchemaName.WORKFLOW);
        int numThreads = 20;
        final RCThread[] threads = new RCThread[20];
        for (i = 0; i < 20; ++i) {
            LiteWorkflowAppParser parser = new LiteWorkflowAppParser(schema, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
            threads[i] = new RCThread(parser);
        }
        for (i = 0; i < 20; ++i) {
            threads[i].start();
        }
        this.waitFor(120000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                boolean allDone = true;
                for (int i = 0; i < 20; ++i) {
                    allDone &= threads[i].done;
                }
                return allDone;
            }
        });
        boolean error = false;
        for (int i2 = 0; i2 < 20; ++i2) {
            error = error || threads[i2].error;
        }
        TestLiteWorkflowAppParser.assertFalse((boolean)error);
    }

    public void testDisableWFValidateForkJoin() throws Exception {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        try {
            parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-invalid-fork.xml", (int)-1), new Configuration());
        }
        catch (WorkflowException wfe) {
            TestLiteWorkflowAppParser.assertEquals((Object)ErrorCode.E0730, (Object)wfe.getErrorCode());
            TestLiteWorkflowAppParser.assertEquals((String)"E0730: Fork/Join not in pair", (String)wfe.getMessage());
        }
        Configuration conf = new Configuration();
        conf.set("oozie.wf.validate.ForkJoin", "false");
        parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-invalid-fork.xml", (int)-1), conf);
        conf.set("oozie.wf.validate.ForkJoin", "true");
        try {
            parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-invalid-fork.xml", (int)-1), conf);
        }
        catch (WorkflowException wfe) {
            TestLiteWorkflowAppParser.assertEquals((Object)ErrorCode.E0730, (Object)wfe.getErrorCode());
            TestLiteWorkflowAppParser.assertEquals((String)"E0730: Fork/Join not in pair", (String)wfe.getMessage());
        }
        Services.get().destroy();
        this.setSystemProperty("oozie.validate.ForkJoin", "false");
        new Services().init();
        parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-invalid-fork.xml", (int)-1), new Configuration());
        conf.set("oozie.wf.validate.ForkJoin", "false");
        parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-invalid-fork.xml", (int)-1), conf);
        conf.set("oozie.wf.validate.ForkJoin", "true");
        parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-invalid-fork.xml", (int)-1), conf);
        Services.get().destroy();
        this.setSystemProperty("oozie.validate.ForkJoin", "true");
        new Services().init();
        try {
            parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-invalid-fork.xml", (int)-1), new Configuration());
        }
        catch (WorkflowException wfe) {
            TestLiteWorkflowAppParser.assertEquals((Object)ErrorCode.E0730, (Object)wfe.getErrorCode());
            TestLiteWorkflowAppParser.assertEquals((String)"E0730: Fork/Join not in pair", (String)wfe.getMessage());
        }
        conf.set("oozie.wf.validate.ForkJoin", "false");
        parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-invalid-fork.xml", (int)-1), conf);
        conf.set("oozie.wf.validate.ForkJoin", "true");
        try {
            parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-invalid-fork.xml", (int)-1), new Configuration());
        }
        catch (WorkflowException wfe) {
            TestLiteWorkflowAppParser.assertEquals((Object)ErrorCode.E0730, (Object)wfe.getErrorCode());
            TestLiteWorkflowAppParser.assertEquals((String)"E0730: Fork/Join not in pair", (String)wfe.getMessage());
        }
    }

    public void testParameterizationRetry() throws Exception {
        LiteWorkflowAppParser parser = new LiteWorkflowAppParser(null, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class);
        String wf = "<workflow-app xmlns=\"uri:oozie:workflow:0.5\" name=\"test\" > <global> <job-tracker>localhost</job-tracker><name-node>localhost</name-node></global><start to=\"retry\"/><action name=\"retry\" retry-max=\"${retryMax}\" retry-interval=\"${retryInterval}\"><java> <main-class>com.retry</main-class></java><ok to=\"end\"/><error to=\"end\"/></action> <end name=\"end\"/></workflow-app>";
        Configuration conf = new Configuration();
        conf.set("retryMax", "3");
        conf.set("retryInterval", "10");
        LiteWorkflowApp app = parser.validateAndParse((Reader)new StringReader(wf), conf);
        TestLiteWorkflowAppParser.assertEquals((String)app.getNode("retry").getUserRetryMax(), (String)"3");
        TestLiteWorkflowAppParser.assertEquals((String)app.getNode("retry").getUserRetryInterval(), (String)"10");
    }

    public class RCThread
    extends Thread {
        private LiteWorkflowAppParser parser;
        boolean done = false;
        boolean error = false;

        public RCThread(LiteWorkflowAppParser parser) {
            this.parser = parser;
        }

        @Override
        public void run() {
            try {
                this.parser.validateAndParse(IOUtils.getResourceAsReader((String)"wf-race-condition.xml", (int)-1), new Configuration());
            }
            catch (Exception e) {
                this.error = true;
                e.printStackTrace();
            }
            this.done = true;
        }
    }
}

