/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogService;
import org.apache.oozie.service.XLogStreamingService;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XLogFilter;
import org.apache.oozie.util.XLogUserFilterParam;

public class TestXLogUserFilterParam
extends XTestCase {
    static final SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void setLogFile() throws Exception {
        XLogFilter.reset();
        File log4jFile = new File(this.getTestCaseConfDir(), "test-log4j.properties");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("test-no-dash-log4j.properties");
        InputStream errorLogStream = cl.getResourceAsStream("userLogFilterTestlog.log");
        Properties log4jProps = new Properties();
        log4jProps.load(is);
        log4jProps.setProperty("log4j.appender.oozie.File", this.getTestCaseDir() + "/oozie.log");
        log4jProps.store(new FileOutputStream(log4jFile), "");
        this.setSystemProperty("oozie.log4j.file", log4jFile.getName());
        new Services().init();
        File logFile = new File(((XLogService)Services.get().get(XLogService.class)).getOozieLogPath(), ((XLogService)Services.get().get(XLogService.class)).getOozieLogName());
        IOUtils.copyStream((InputStream)errorLogStream, (OutputStream)new FileOutputStream(logFile));
    }

    public void testloglevel_Error() throws Exception {
        this.setLogFile();
        String logLevel = "LOGLEVEL=ERROR";
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        paramMap.put("logfilter", new String[]{logLevel});
        XLogFilter xf = new XLogFilter(new XLogUserFilterParam(paramMap));
        String out = this.doStreamLog(xf);
        int count = 0;
        for (String line : out.split(System.getProperty("line.separator"))) {
            TestXLogUserFilterParam.assertFalse((boolean)line.contains("DEBUG"));
            TestXLogUserFilterParam.assertFalse((boolean)line.contains("INFO"));
            ++count;
        }
        TestXLogUserFilterParam.assertEquals((int)count, (int)20);
    }

    public void testloglevel_DEBUF_INFO() throws Exception {
        this.setLogFile();
        String logLevel = "LOGLEVEL=DEBUG|INFO";
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        paramMap.put("logfilter", new String[]{logLevel});
        XLogFilter xf = new XLogFilter(new XLogUserFilterParam(paramMap));
        String out = this.doStreamLog(xf);
        String[] lines = out.split(System.getProperty("line.separator"));
        TestXLogUserFilterParam.assertEquals((int)lines.length, (int)4);
        TestXLogUserFilterParam.assertTrue((boolean)lines[1].startsWith("2014-02-27 02:06:49,215 DEBUG CoordActionStartXCommand:545 [pool-2-thread-236] - USER[-] GROUP[-] TOKEN[-] APP[-]"));
        TestXLogUserFilterParam.assertTrue((boolean)lines[2].startsWith("2014-02-27 02:06:49,215 DEBUG CoordActionStartXCommand:545 [pool-2-thread-236] - USER[-] GROUP[-] TOKEN[-] APP[-] JOB[0601839-140127221758655-oozie-wrkf-C]"));
        TestXLogUserFilterParam.assertTrue((boolean)lines[3].startsWith("2014-02-27 02:06:49,215 INFO CoordActionStartXCommand:545 [pool-2-thread-236] - USER[-] GROUP[-] TOKEN[-] APP[-] JOB[0601839-140127221758655-oozie-wrkf-C]"));
    }

    public void testloglevel_ErrorWithLen() throws Exception {
        this.setLogFile();
        String logLevel = "LOGLEVEL=ERROR;LIMIT=1";
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        paramMap.put("logfilter", new String[]{logLevel});
        XLogFilter xf = new XLogFilter(new XLogUserFilterParam(paramMap));
        String out = this.doStreamLog(xf);
        String[] lines = out.split(System.getProperty("line.separator"));
        TestXLogUserFilterParam.assertEquals((int)lines.length, (int)1);
    }

    public void testLength() throws Exception {
        this.setLogFile();
        String logLevel = "LIMIT=1";
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        paramMap.put("logfilter", new String[]{logLevel});
        XLogFilter xf = new XLogFilter(new XLogUserFilterParam(paramMap));
        String out = this.doStreamLog(xf);
        String[] lines = out.split(System.getProperty("line.separator"));
        TestXLogUserFilterParam.assertEquals((int)lines.length, (int)1);
    }

    public void testTextSearch() throws Exception {
        this.setLogFile();
        XLogFilter filter = new XLogFilter();
        String param = "TEXT=substitution;LIMIT=2";
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        paramMap.put("logfilter", new String[]{param});
        XLogUserFilterParam logUtil = new XLogUserFilterParam(paramMap);
        filter.setUserLogFilter(logUtil);
        String out = this.doStreamLog(filter);
        String[] lines = out.split(System.getProperty("line.separator"));
        TestXLogUserFilterParam.assertEquals((int)lines.length, (int)2);
        TestXLogUserFilterParam.assertTrue((boolean)lines[0].contains("E0803: IO error, Variable substitution depth too large: 20 ${dniInputDir}"));
        TestXLogUserFilterParam.assertTrue((boolean)lines[1].contains("E0803: IO error, Variable substitution depth too large: 20 ${dniInputDir}"));
    }

    public void testsearchText_logLevel() throws Exception {
        this.setLogFile();
        String param = "TEXT=substitution;LOGLEVEL=DEBUG";
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        paramMap.put("logfilter", new String[]{param});
        XLogFilter filter = new XLogFilter(new XLogUserFilterParam(paramMap));
        String out = this.doStreamLog(filter);
        String[] lines = out.split(System.getProperty("line.separator"));
        TestXLogUserFilterParam.assertEquals((int)lines.length, (int)1);
        TestXLogUserFilterParam.assertTrue((boolean)lines[0].contains("2014-02-27 02:06:47,499 DEBUG CoordActionStartXCommand:536 [pool-2-thread-236] - USER[-]"));
        TestXLogUserFilterParam.assertTrue((boolean)lines[0].contains("E0803: IO error, Variable substitution depth too large: 20 ${dniInputDir}"));
    }

    public void testException() throws Exception {
        File log4jFile = new File(this.getTestCaseConfDir(), "test-log4j.properties");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("test-no-dash-log4j.properties");
        Properties log4jProps = new Properties();
        log4jProps.load(is);
        log4jProps.setProperty("log4j.appender.oozie.File", this.getTestCaseDir() + "/oozie.log");
        log4jProps.store(new FileOutputStream(log4jFile), "");
        this.setSystemProperty("oozie.log4j.file", log4jFile.getName());
        new Services().init();
        Services.get().getConf().setInt(XLogFilter.MAX_SCAN_DURATION, 10);
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        paramMap.put("logfilter", new String[0]);
        XLogFilter filter = new XLogFilter(new XLogUserFilterParam(paramMap));
        Date startDate = new Date();
        Date endDate = new Date(startDate.getTime() + 39600000L);
        try {
            this.doStreamLog(filter, startDate, endDate);
            TestXLogUserFilterParam.fail((String)"should not come here");
        }
        catch (Exception e) {
            e.printStackTrace();
            TestXLogUserFilterParam.assertTrue((boolean)e.getMessage().contains("Request log streaming time range is higher than configured."));
        }
    }

    public void testNoException_Withrecent() throws Exception {
        File log4jFile = new File(this.getTestCaseConfDir(), "test-log4j.properties");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("test-no-dash-log4j.properties");
        Properties log4jProps = new Properties();
        log4jProps.load(is);
        log4jProps.setProperty("log4j.appender.oozie.File", this.getTestCaseDir() + "/oozie.log");
        log4jProps.store(new FileOutputStream(log4jFile), "");
        this.setSystemProperty("oozie.log4j.file", log4jFile.getName());
        new Services().init();
        Services.get().getConf().setInt(XLogFilter.MAX_SCAN_DURATION, 10);
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        String param = "RECENT=9";
        paramMap.put("logfilter", new String[]{param});
        XLogFilter filter = new XLogFilter(new XLogUserFilterParam(paramMap));
        Date startDate = new Date();
        Date endDate = new Date(startDate.getTime() + 54000000L);
        try {
            this.doStreamLog(filter, startDate, endDate);
        }
        catch (Exception e) {
            TestXLogUserFilterParam.fail((String)"should not throw exception");
        }
    }

    public void testCombination() throws Exception {
        File log4jFile = new File(this.getTestCaseConfDir(), "test-log4j.properties");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("test-no-dash-log4j.properties");
        Properties log4jProps = new Properties();
        log4jProps.load(is);
        log4jProps.setProperty("log4j.appender.oozie.File", this.getTestCaseDir() + "/oozie.log");
        log4jProps.store(new FileOutputStream(log4jFile), "");
        this.setSystemProperty("oozie.log4j.file", log4jFile.getName());
        new Services().init();
        XLogFilter.reset();
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        String param = "start=14-02-20 02:06:25,499;end=14-02-27 02:06:47,550;debug;loglevel=ERROR|WARN;recent=3m";
        paramMap.put("logfilter", new String[]{param});
        XLogFilter filter = new XLogFilter(new XLogUserFilterParam(paramMap));
        String out = this.doStreamLog(filter, new Date(), new Date());
        TestXLogUserFilterParam.assertEquals((int)out.split(System.getProperty("line.separator")).length, (int)1);
        TestXLogUserFilterParam.assertTrue((boolean)out.split(System.getProperty("line.separator"))[0].contains("Log start time = Tue Feb 27 02:03:47"));
        TestXLogUserFilterParam.assertTrue((boolean)out.split(System.getProperty("line.separator"))[0].contains("Log end time = Tue Feb 27 02:06:47"));
    }

    public void testStartEnd_EndOffset() throws Exception {
        File log4jFile = new File(this.getTestCaseConfDir(), "test-log4j.properties");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("test-no-dash-log4j.properties");
        Properties log4jProps = new Properties();
        log4jProps.load(is);
        log4jProps.setProperty("log4j.appender.oozie.File", this.getTestCaseDir() + "/oozie.log");
        log4jProps.store(new FileOutputStream(log4jFile), "");
        this.setSystemProperty("oozie.log4j.file", log4jFile.getName());
        new Services().init();
        XLogFilter.reset();
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        String param = "start=14-02-20 02:06:25,499;end=3m;debug";
        paramMap.put("logfilter", new String[]{param});
        XLogFilter filter = new XLogFilter(new XLogUserFilterParam(paramMap));
        String out = this.doStreamLog(filter, dt.parse("14-02-20 02:06:25,499"), new Date());
        TestXLogUserFilterParam.assertEquals((int)out.split(System.getProperty("line.separator")).length, (int)1);
        TestXLogUserFilterParam.assertTrue((boolean)out.split(System.getProperty("line.separator"))[0].contains("Log start time = Tue Feb 20 02:06:25"));
        TestXLogUserFilterParam.assertTrue((boolean)out.split(System.getProperty("line.separator"))[0].contains("Log end time = Tue Feb 20 02:11:25"));
    }

    public void testStartEnd_bothOffset() throws Exception {
        File log4jFile = new File(this.getTestCaseConfDir(), "test-log4j.properties");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("test-no-dash-log4j.properties");
        Properties log4jProps = new Properties();
        log4jProps.load(is);
        log4jProps.setProperty("log4j.appender.oozie.File", this.getTestCaseDir() + "/oozie.log");
        log4jProps.store(new FileOutputStream(log4jFile), "");
        this.setSystemProperty("oozie.log4j.file", log4jFile.getName());
        new Services().init();
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        String param = "start=3m;end=13m;debug";
        paramMap.put("logfilter", new String[]{param});
        XLogFilter filter = new XLogFilter(new XLogUserFilterParam(paramMap));
        String out = this.doStreamLog(filter, dt.parse("14-02-20 02:06:25,499"), new Date());
        TestXLogUserFilterParam.assertEquals((int)out.split(System.getProperty("line.separator")).length, (int)1);
        TestXLogUserFilterParam.assertTrue((boolean)out.split(System.getProperty("line.separator"))[0].contains("Log start time = Tue Feb 20 02:07:25"));
        TestXLogUserFilterParam.assertTrue((boolean)out.split(System.getProperty("line.separator"))[0].contains("Log end time = Tue Feb 20 02:21:25"));
    }

    public void testStartEnd_bothabsoulte() throws Exception {
        File log4jFile = new File(this.getTestCaseConfDir(), "test-log4j.properties");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("test-no-dash-log4j.properties");
        Properties log4jProps = new Properties();
        log4jProps.load(is);
        log4jProps.setProperty("log4j.appender.oozie.File", this.getTestCaseDir() + "/oozie.log");
        log4jProps.store(new FileOutputStream(log4jFile), "");
        this.setSystemProperty("oozie.log4j.file", log4jFile.getName());
        new Services().init();
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        String param = "start=14-03-20 02:06:25,499;end=14-03-20 02:10:25,499;debug";
        paramMap.put("logfilter", new String[]{param});
        XLogFilter filter = new XLogFilter(new XLogUserFilterParam(paramMap));
        String out = this.doStreamLog(filter, dt.parse("14-01-20 02:06:25,499"), dt.parse("14-02-20 02:06:25,499"));
        TestXLogUserFilterParam.assertEquals((int)out.split(System.getProperty("line.separator")).length, (int)1);
        TestXLogUserFilterParam.assertTrue((boolean)out.split(System.getProperty("line.separator"))[0].contains("Log start time = Tue Mar 20 02:06:25"));
        TestXLogUserFilterParam.assertTrue((boolean)out.split(System.getProperty("line.separator"))[0].contains("Log end time = Tue Mar 20 02:10:25"));
        paramMap = new HashMap();
        param = "start=14-03-20 02:06:25;end=14-03-20 02:10:25;debug";
        paramMap.put("logfilter", new String[]{param});
        filter = new XLogFilter(new XLogUserFilterParam(paramMap));
        out = this.doStreamLog(filter, dt.parse("14-01-20 02:06:25,499"), dt.parse("14-02-20 02:06:25,499"));
        TestXLogUserFilterParam.assertEquals((int)out.split(System.getProperty("line.separator")).length, (int)1);
        TestXLogUserFilterParam.assertTrue((boolean)out.split(System.getProperty("line.separator"))[0].contains("Log start time = Tue Mar 20 02:06:25"));
        TestXLogUserFilterParam.assertTrue((boolean)out.split(System.getProperty("line.separator"))[0].contains("Log end time = Tue Mar 20 02:10:25"));
    }

    public void testStartEnd_startAbsolute() throws Exception {
        File log4jFile = new File(this.getTestCaseConfDir(), "test-log4j.properties");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("test-no-dash-log4j.properties");
        Properties log4jProps = new Properties();
        log4jProps.load(is);
        log4jProps.setProperty("log4j.appender.oozie.File", this.getTestCaseDir() + "/oozie.log");
        log4jProps.store(new FileOutputStream(log4jFile), "");
        this.setSystemProperty("oozie.log4j.file", log4jFile.getName());
        new Services().init();
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        String param = "start=14-03-20 02:06:25,499;end=4m;debug";
        paramMap.put("logfilter", new String[]{param});
        XLogFilter filter = new XLogFilter(new XLogUserFilterParam(paramMap));
        String out = this.doStreamLog(filter, dt.parse("14-01-20 02:06:25,499"), dt.parse("14-02-20 02:06:25,499"));
        TestXLogUserFilterParam.assertEquals((int)out.split(System.getProperty("line.separator")).length, (int)1);
        TestXLogUserFilterParam.assertTrue((boolean)out.split(System.getProperty("line.separator"))[0].contains("Log start time = Tue Mar 20 02:06:25"));
        TestXLogUserFilterParam.assertTrue((boolean)out.split(System.getProperty("line.separator"))[0].contains("Log end time = Tue Mar 20 02:12:25"));
    }

    private String doStreamLog(XLogFilter xf) throws Exception {
        return this.doStreamLog(xf, null, null);
    }

    private String doStreamLog(XLogFilter xf, Date startDate, Date endDate) throws Exception {
        StringWriter w = new StringWriter();
        ((XLogStreamingService)Services.get().get(XLogStreamingService.class)).streamLog(xf, startDate, endDate, (Writer)w, new HashMap());
        return w.toString();
    }
}

