/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.util.ArrayList;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XLogFilter;

public class TestXLogFilter
extends XTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testXLogFilter() throws ServiceException, CommandException {
        Services services = new Services();
        services.init();
        try {
            XLogFilter xf2 = new XLogFilter();
            xf2.constructPattern();
            ArrayList<String> a = new ArrayList<String>();
            a.add("2009-06-24 02:43:13,958");
            a.add(" DEBUG");
            a.add(" WorkflowRunnerCallable:323 - " + XLog.Info.get().createPrefix() + " test log");
            TestXLogFilter.assertEquals((boolean)true, (boolean)xf2.matches(a));
        }
        finally {
            services.destroy();
        }
        XLogFilter.reset();
        XLogFilter.defineParameter((String)"USER");
        XLogFilter.defineParameter((String)"GROUP");
        XLogFilter.defineParameter((String)"TOKEN");
        XLogFilter.defineParameter((String)"APP");
        XLogFilter.defineParameter((String)"JOB");
        XLogFilter.defineParameter((String)"ACTION");
        XLogFilter xf = new XLogFilter();
        TestXLogFilter.assertEquals((int)7, (int)this.matches(xf));
        xf.setLogLevel(XLog.Level.WARN.toString());
        TestXLogFilter.assertEquals((int)2, (int)this.matches(xf));
        xf.setLogLevel(XLog.Level.WARN.toString());
        xf.setParameter("APP", "example-forkjoinwf");
        TestXLogFilter.assertEquals((int)0, (int)this.matches(xf));
        xf.setLogLevel(XLog.Level.DEBUG.toString() + "|" + XLog.Level.INFO.toString());
        xf.setParameter("JOB", "14-200904160239--example-forkjoinwf");
        TestXLogFilter.assertEquals((int)2, (int)this.matches(xf));
        XLogFilter xf1 = new XLogFilter();
        xf1.setParameter("USER", "oozie");
        TestXLogFilter.assertEquals((int)3, (int)this.matches(xf1));
        xf1.setParameter("GROUP", "oozie");
        TestXLogFilter.assertEquals((int)2, (int)this.matches(xf1));
        xf1.setParameter("TOKEN", "MYtoken");
        TestXLogFilter.assertEquals((int)1, (int)this.matches(xf1));
    }

    private int matches(XLogFilter xf) {
        xf.constructPattern();
        ArrayList<String> a = new ArrayList<String>();
        a.add("2009-06-24 02:43:13,958 DEBUG WorkflowRunnerCallable:323 - USER[oozie] GROUP[-] TOKEN[-] APP[example-forkjoinwf] JOB[14-200904160239--example-forkjoinwf] ACTION[-] End workflow state change");
        a.add("2009-06-24 02:43:13,961  INFO WorkflowRunnerCallable:317 - USER[-] GROUP[-] TOKEN[-] APP[example-forkjoinwf] JOB[14-200904160239--example-forkjoinwf] ACTION[-] [org.apache.oozie.core.command.WorkflowRunnerCallable] released lock");
        a.add("2009-06-24 02:43:13,986  WARN JobClient:539 - Use GenericOptionsParser for parsing the arguments. Applications should implement Tool for the same.");
        a.add("2009-06-24 02:43:14,431  WARN JobClient:661 - No job jar file set.  User classes may not be found. See JobConf(Class) or JobConf#setJar(String).");
        a.add("2009-06-24 02:43:14,505  INFO ActionExecutorCallable:317 - USER[oozie] GROUP[oozie] TOKEN[-] APP[-] JOB[-] ACTION[-] Released Lock");
        a.add("2009-06-24 02:43:19,344 DEBUG PendingSignalsCallable:323 - USER[oozie] GROUP[oozie] TOKEN[MYtoken] APP[-] JOB[-] ACTION[-] Number of pending signals to check [0]");
        a.add("2009-06-24 02:43:29,151 DEBUG PendingActionsCallable:323 - USER[-] GROUP[-] TOKEN[-] APP[-] JOB[-] ACTION[-] Number of pending actions [0] ");
        int matchCnt = 0;
        for (int i = 0; i < a.size(); ++i) {
            if (!xf.matches(xf.splitLogMessage((String)a.get(i)))) continue;
            ++matchCnt;
        }
        return matchCnt;
    }
}

