/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;

public class TestXConfiguration
extends XTestCase {
    public void testFromStream() throws Exception {
        String configPath = "test-oozie-default.xml";
        InputStream is = IOUtils.getResourceAsStream((String)configPath, (int)-1);
        XConfiguration conf = new XConfiguration(is);
        TestXConfiguration.assertEquals((String)"DEFAULT", (String)conf.get("oozie.dummy"));
    }

    public void testFromReader() throws Exception {
        String configPath = "test-oozie-default.xml";
        Reader reader = IOUtils.getResourceAsReader((String)configPath, (int)-1);
        XConfiguration conf = new XConfiguration(reader);
        TestXConfiguration.assertEquals((String)"DEFAULT", (String)conf.get("oozie.dummy"));
    }

    public void testAddXIncludeFromStream() throws IOException {
        String parentXml = "parentXml";
        this.prepareXmlWithInclude(parentXml);
        try {
            XConfiguration conf = new XConfiguration((InputStream)new FileInputStream(new File(this.getTestCaseDir(), parentXml)));
            TestXConfiguration.assertEquals((String)"DEFAULT", (String)conf.get("oozie.dummy"));
            TestXConfiguration.assertEquals((String)"bar", (String)conf.get("foo"));
            TestXConfiguration.assertEquals((String)"def", (String)conf.get("abc"));
        }
        catch (IOException e) {
            e.printStackTrace();
            TestXConfiguration.fail((String)"XInclude failed");
        }
    }

    public void testAddXIncludeFromReader() throws IOException {
        String parentXml = "parentXml";
        this.prepareXmlWithInclude(parentXml);
        try {
            XConfiguration conf = new XConfiguration((Reader)new FileReader(new File(this.getTestCaseDir(), parentXml)));
            TestXConfiguration.assertEquals((String)"DEFAULT", (String)conf.get("oozie.dummy"));
            TestXConfiguration.assertEquals((String)"bar", (String)conf.get("foo"));
            TestXConfiguration.assertEquals((String)"def", (String)conf.get("abc"));
        }
        catch (IOException e) {
            e.printStackTrace();
            TestXConfiguration.fail((String)"XInclude failed");
        }
    }

    private void prepareXmlWithInclude(String parentXml) throws IOException {
        String targetPath = Thread.currentThread().getContextClassLoader().getResource("test-hadoop-config.xml").getFile();
        URL url = Thread.currentThread().getContextClassLoader().getResource("test-oozie-default.xml");
        BufferedReader br = new BufferedReader(new FileReader(url.getFile()));
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(this.getTestCaseDir(), parentXml)));
        while (br.ready()) {
            String s = br.readLine();
            bw.write(s);
            if (!s.contains("configuration xmlns")) continue;
            bw.write("<xi:include href=\"" + targetPath + "\"/>");
        }
        br.close();
        bw.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithNamespacePrefix() throws Exception {
        String configPath = "test-oozie-with-prefix.xml";
        try (InputStream is = null;){
            is = IOUtils.getResourceAsStream((String)configPath, (int)-1);
            XConfiguration conf = new XConfiguration(is);
            TestXConfiguration.assertEquals((String)"DEFAULT", (String)conf.get("oozie.dummy"));
        }
    }

    public void testInvalidParsing() throws Exception {
        try {
            new XConfiguration((Reader)new StringReader("<configurationx></configurationx>"));
            TestXConfiguration.fail();
        }
        catch (IOException iOException) {
        }
        catch (Throwable ex) {
            TestXConfiguration.fail();
        }
    }

    public void testCopy() throws Exception {
        Configuration srcConf = new Configuration(false);
        Configuration targetConf = new Configuration(false);
        srcConf.set("testParameter1", "valueFromSource");
        srcConf.set("testParameter2", "valueFromSource");
        targetConf.set("testParameter2", "valueFromTarget");
        targetConf.set("testParameter3", "valueFromTarget");
        XConfiguration.copy((Configuration)srcConf, (Configuration)targetConf);
        TestXConfiguration.assertEquals((String)targetConf.get("testParameter1"), (String)"valueFromSource");
        TestXConfiguration.assertEquals((String)targetConf.get("testParameter2"), (String)"valueFromSource");
        TestXConfiguration.assertEquals((String)targetConf.get("testParameter3"), (String)"valueFromTarget");
    }

    public void testInjectDefaults() throws Exception {
        Configuration srcConf = new Configuration(false);
        Configuration targetConf = new Configuration(false);
        srcConf.set("testParameter1", "valueFromSource");
        srcConf.set("testParameter2", "valueFromSource");
        targetConf.set("testParameter2", "originalValueFromTarget");
        targetConf.set("testParameter3", "originalValueFromTarget");
        XConfiguration.injectDefaults((Configuration)srcConf, (Configuration)targetConf);
        TestXConfiguration.assertEquals((String)targetConf.get("testParameter1"), (String)"valueFromSource");
        TestXConfiguration.assertEquals((String)targetConf.get("testParameter2"), (String)"originalValueFromTarget");
        TestXConfiguration.assertEquals((String)targetConf.get("testParameter3"), (String)"originalValueFromTarget");
        TestXConfiguration.assertEquals((String)srcConf.get("testParameter1"), (String)"valueFromSource");
        TestXConfiguration.assertEquals((String)srcConf.get("testParameter2"), (String)"valueFromSource");
        TestXConfiguration.assertNull((Object)srcConf.get("testParameter3"));
    }

    public void testTrim() {
        XConfiguration conf = new XConfiguration();
        conf.set("a", " A ");
        conf.set("b", "B");
        conf = conf.trim();
        TestXConfiguration.assertEquals((String)"A", (String)conf.get("a"));
        TestXConfiguration.assertEquals((String)"B", (String)conf.get("b"));
    }

    public void testResolve() {
        XConfiguration conf = new XConfiguration();
        conf.set("a", "A");
        conf.set("b", "${a}");
        TestXConfiguration.assertEquals((String)"A", (String)conf.getRaw("a"));
        TestXConfiguration.assertEquals((String)"${a}", (String)conf.getRaw("b"));
        conf = conf.resolve();
        TestXConfiguration.assertEquals((String)"A", (String)conf.getRaw("a"));
        TestXConfiguration.assertEquals((String)"A", (String)conf.getRaw("b"));
    }

    public void testVarResolutionAndSysProps() {
        this.setSystemProperty("aa", "foo");
        XConfiguration conf = new XConfiguration();
        conf.set("a", "A");
        conf.set("b", "${a}");
        conf.set("c", "${aa}");
        conf.set("d", "${aaa}");
        TestXConfiguration.assertEquals((String)"A", (String)conf.getRaw("a"));
        TestXConfiguration.assertEquals((String)"${a}", (String)conf.getRaw("b"));
        TestXConfiguration.assertEquals((String)"${aa}", (String)conf.getRaw("c"));
        TestXConfiguration.assertEquals((String)"A", (String)conf.get("a"));
        TestXConfiguration.assertEquals((String)"A", (String)conf.get("b"));
        TestXConfiguration.assertEquals((String)"foo", (String)conf.get("c"));
        TestXConfiguration.assertEquals((String)"${aaa}", (String)conf.get("d"));
        conf.set("un", "${user.name}");
        TestXConfiguration.assertEquals((String)System.getProperty("user.name"), (String)conf.get("un"));
        this.setSystemProperty("user.name", "foo");
        TestXConfiguration.assertEquals((String)"foo", (String)conf.get("un"));
    }

    public void testSubstituteVar() throws ServiceException {
        Services services = new Services();
        services.init();
        int depth = ConfigurationService.getInt((String)"oozie.configuration.substitute.depth");
        XConfiguration.initalized = false;
        XConfiguration conf = new XConfiguration();
        conf.set("key0", "hello");
        for (int i = 1; i < depth + 5; ++i) {
            conf.set(String.valueOf("key" + i), String.valueOf("${key" + (i - 1) + "}"));
        }
        TestXConfiguration.assertEquals((String)"hello", (String)conf.get("key0"));
        TestXConfiguration.assertEquals((String)"hello", (String)conf.get("key1"));
        TestXConfiguration.assertEquals((String)"hello", (String)conf.get("key" + (depth - 1)));
        try {
            conf.get(String.valueOf("key" + depth));
            TestXConfiguration.fail((String)"Fail to apply substitution depth");
        }
        catch (IllegalStateException e) {
            TestXConfiguration.assertTrue((boolean)e.getMessage().contains("Variable substitution depth too large: " + depth));
        }
        services.destroy();
    }

    public void testSubstituteVarUnlimited() throws ServiceException {
        Services services = new Services();
        ((ConfigurationService)services.get(ConfigurationService.class)).getConf().set("oozie.configuration.substitute.depth", "-1");
        services.init();
        int depth = ConfigurationService.getInt((String)"oozie.configuration.substitute.depth");
        TestXConfiguration.assertEquals((int)-1, (int)depth);
        XConfiguration.initalized = false;
        XConfiguration conf = new XConfiguration();
        conf.set("key0", "hello");
        int testMax = 100;
        for (int i = 1; i < testMax + 5; ++i) {
            conf.set(String.valueOf("key" + i), String.valueOf("${key" + (i - 1) + "}"));
        }
        TestXConfiguration.assertEquals((String)"hello", (String)conf.get("key0"));
        TestXConfiguration.assertEquals((String)"hello", (String)conf.get("key1"));
        TestXConfiguration.assertEquals((String)"hello", (String)conf.get("key" + (testMax - 1)));
        services.destroy();
    }
}

