/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.oozie.util.PasswordMasker;
import org.junit.Assert;
import org.junit.Test;

public class TestPasswordMasker {
    @Test
    public void testWhenJavaSystemPropertiesAreAskedPasswordsAppearMasked() throws Exception {
        Map masked = new PasswordMasker().mask(this.jsonToMap("/instrumentation-system-properties.json"));
        this.assertPasswordValueIsMasked(masked, "javax.net.ssl.trustStorePassword");
        this.assertPasswordValueIsMasked(masked, "oozie.https.keystore.pass");
    }

    @Test
    public void testWhenOSEnvIsAskedPasswordsAppearMasked() throws Exception {
        Map masked = new PasswordMasker().mask(this.jsonToMap("/instrumentation-os-env.json"));
        this.assertPasswordValueIsMasked(masked, "HADOOP_CREDSTORE_PASSWORD");
        this.assertPasswordValueIsMasked(masked, "OOZIE_HTTPS_KEYSTORE_PASSWORD");
        this.assertPasswordValueIsMasked(masked, "OOZIE_HTTPS_TRUSTSTORE_PASSWORD");
        this.assertPasswordValueFragmentIsMasked(masked, "CATALINA_OPTS", "-Doozie.https.keystore.pass=");
        this.assertPasswordValueFragmentIsMasked(masked, "CATALINA_OPTS", "-Djavax.net.ssl.trustStorePassword=");
        this.assertValueFragmentIsPresent(masked, "CATALINA_OPTS", "-Xmx1024m");
        this.assertValueFragmentIsPresent(masked, "CATALINA_OPTS", "-Doozie.https.keystore.file=/Users/forsage/.keystore");
        this.assertValueFragmentIsPresent(masked, "CATALINA_OPTS", "-Djava.library.path=");
    }

    private Map<String, String> jsonToMap(String jsonPath) throws IOException {
        return (Map)new ObjectMapper().readValue(this.getClass().getResourceAsStream(jsonPath), HashMap.class);
    }

    private void assertPasswordValueIsMasked(Map<String, String> mapContainingMaskedPassword, String passwordKey) {
        Assert.assertEquals((String)String.format("Value of key '%s' should be masked.", passwordKey), (Object)"*****", (Object)mapContainingMaskedPassword.get(passwordKey));
    }

    private void assertPasswordValueFragmentIsMasked(Map<String, String> mapContainingMaskedPassword, String passwordKey, String passwordFragmentKey) {
        Assert.assertEquals((String)String.format("Value fragment of password key '%s' and password fragment key '%s' should be masked.", passwordKey, passwordFragmentKey), (Object)"*****", (Object)this.getFragmentValue(mapContainingMaskedPassword.get(passwordKey), passwordFragmentKey));
    }

    private String getFragmentValue(String base, String fragmentKey) {
        for (String fragment : base.split(" ")) {
            if (!fragment.startsWith(fragmentKey)) continue;
            return fragment.substring(fragmentKey.length());
        }
        return null;
    }

    private void assertValueFragmentIsPresent(Map<String, String> masked, String key, String valueFragment) {
        Assert.assertTrue((String)String.format("For key '%s' value fragment '%s' should be present.", key, valueFragment), (boolean)masked.get(key).contains(valueFragment));
    }
}

