/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.MultiFileReader;
import org.apache.oozie.util.TestLogStreamer;

public class TestMultiFileReader
extends XTestCase {
    public void testOneFile() throws Exception {
        File dir = new File(this.getTestCaseDir());
        File f1 = new File(dir, "file1.txt");
        FileWriter fw = new FileWriter(f1);
        String str1 = "This is the first line of the only file\nThis is the second line\n";
        fw.write(str1);
        fw.close();
        ArrayList<File> files = new ArrayList<File>();
        files.add(f1);
        MultiFileReader reader = new MultiFileReader(files);
        char[] buf = new char[str1.length()];
        Arrays.fill(buf, '+');
        int numRead = reader.read(buf, 0, 10);
        TestMultiFileReader.assertEquals((int)10, (int)numRead);
        TestMultiFileReader.assertEquals((String)str1.substring(0, 10), (String)new String(buf, 0, 10));
        for (int i = 10; i < buf.length; ++i) {
            TestMultiFileReader.assertEquals((char)'+', (char)buf[i]);
        }
        numRead = reader.read(buf, 10, str1.length() - 10);
        TestMultiFileReader.assertEquals((int)(str1.length() - 10), (int)numRead);
        TestMultiFileReader.assertEquals((String)str1, (String)new String(buf));
        numRead = reader.read();
        TestMultiFileReader.assertEquals((int)-1, (int)numRead);
    }

    public void testMultipleFiles() throws Exception {
        int i;
        File dir = new File(this.getTestCaseDir());
        File f1 = new File(dir, "file1.txt");
        FileWriter fw = new FileWriter(f1);
        String str1 = "This is the first line of the first file\nThis is the second line\n";
        fw.write(str1);
        fw.close();
        File f2 = new File(dir, "file2.gz");
        String str2 = "This is a gz file with just one line\n";
        TestLogStreamer.writeToGZFile(f2, new StringBuilder(str2));
        File f3 = new File(dir, "file3.txt");
        fw = new FileWriter(f3);
        String str3 = "And this is the last file\nwith\n3 lines\n";
        fw.write(str3);
        fw.close();
        ArrayList<File> files = new ArrayList<File>();
        files.add(f1);
        files.add(f2);
        files.add(f3);
        MultiFileReader reader = new MultiFileReader(files);
        char[] buf = new char[str1.length() + str2.length() + str3.length()];
        Arrays.fill(buf, '+');
        int numRead = reader.read(buf, 0, str1.length() + 10);
        TestMultiFileReader.assertEquals((int)str1.length(), (int)numRead);
        TestMultiFileReader.assertEquals((String)str1, (String)new String(buf, 0, str1.length()));
        for (i = str1.length(); i < buf.length; ++i) {
            TestMultiFileReader.assertEquals((char)'+', (char)buf[i]);
        }
        numRead = reader.read(buf, str1.length(), str2.length());
        TestMultiFileReader.assertEquals((int)str2.length(), (int)numRead);
        TestMultiFileReader.assertEquals((String)(str1 + str2), (String)new String(buf, 0, str1.length() + str2.length()));
        for (i = str1.length() + str2.length(); i < buf.length; ++i) {
            TestMultiFileReader.assertEquals((char)'+', (char)buf[i]);
        }
        numRead = reader.read(buf, str1.length() + str2.length(), str3.length());
        TestMultiFileReader.assertEquals((int)str3.length(), (int)numRead);
        TestMultiFileReader.assertEquals((String)(str1 + str2 + str3), (String)new String(buf));
        numRead = reader.read();
        TestMultiFileReader.assertEquals((int)-1, (int)numRead);
    }
}

