/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;

public class TestIOUtils
extends XTestCase {
    public void testGetReaderAsString() throws Exception {
        try {
            IOUtils.getReaderAsString((Reader)new StringReader("1234"), (int)2);
            TestIOUtils.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TestIOUtils.assertEquals((String)"1234", (String)IOUtils.getReaderAsString((Reader)new StringReader("1234"), (int)4));
    }

    public void testGetResourceAsString() throws Exception {
        try {
            IOUtils.getResourceAsString((String)"invalid-resource.txt", (int)2);
            TestIOUtils.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String s = IOUtils.getResourceAsString((String)"test-ioutils.txt", (int)10);
        TestIOUtils.assertEquals((String)"abcde", (String)s);
        try {
            IOUtils.getResourceAsString((String)"test-ioutils.txt", (int)2);
            TestIOUtils.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetResourceAsReader() throws Exception {
        IOUtils.getResourceAsReader((String)"test-ioutils.txt", (int)10);
    }

    public void testCopyStream() throws IOException {
        byte[] original = new byte[]{0, 1, 2};
        ByteArrayInputStream is = new ByteArrayInputStream(original);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.copyStream((InputStream)is, (OutputStream)os);
        byte[] copy = os.toByteArray();
        TestIOUtils.assertEquals((int)3, (int)copy.length);
        TestIOUtils.assertEquals((int)original.length, (int)copy.length);
        for (int i = 0; i < original.length; ++i) {
            TestIOUtils.assertEquals((byte)original[i], (byte)copy[i]);
        }
    }
}

