/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import junit.framework.Assert;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.GraphGenerator;

public class TestGraphGenerator
extends XTestCase {
    public void testConstructor() {
        try {
            new GraphGenerator(null, null);
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((String)("Construction with illegal args failed as expected: " + iae.getMessage()), (boolean)true);
        }
        try {
            new GraphGenerator("<workflow></workflow>", null);
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((String)("Construction with illegal args failed as expected: " + iae.getMessage()), (boolean)true);
        }
        Assert.assertNotNull((Object)new GraphGenerator("<workflow></workflow>", new WorkflowJobBean()));
        Assert.assertNotNull((Object)new GraphGenerator(null, new WorkflowJobBean()));
        WorkflowJobBean jsonWFJob = new WorkflowJobBean();
        jsonWFJob.setAppName("My Test App");
        jsonWFJob.setId("My Test ID");
        Assert.assertNotNull((Object)new GraphGenerator("<workflow></workflow>", jsonWFJob));
        Assert.assertNotNull((Object)new GraphGenerator("<workflow></workflow>", jsonWFJob, false));
        Assert.assertNotNull((Object)new GraphGenerator("<workflow></workflow>", jsonWFJob, true));
    }

    public void testWrite() {
        WorkflowJobBean jsonWFJob = new WorkflowJobBean();
        jsonWFJob.setAppName("My Test App");
        jsonWFJob.setId("My Test ID");
        String png1 = "src/test/resources/tmp1.png";
        String png2 = "src/test/resources/tmp2.png";
        try {
            GraphGenerator g = new GraphGenerator(TestGraphGenerator.readFile("src/test/resources/graphWF.xml"), jsonWFJob);
            g.write((OutputStream)new FileOutputStream(new File(png1)));
        }
        catch (Exception e) {
            Assert.fail((String)("Write PNG failed for graphWF.xml: " + e.getMessage()));
        }
        File f1 = new File(png1);
        try {
            Assert.assertNotNull((Object)ImageIO.read(f1));
        }
        catch (IOException io) {
            Assert.fail((String)("Not a valid PNG: " + io.getMessage()));
        }
        try {
            GraphGenerator g = new GraphGenerator(TestGraphGenerator.readFile("src/test/resources/graphWF.xml"), jsonWFJob, true);
            g.write((OutputStream)new FileOutputStream(new File(png2)));
        }
        catch (Exception e) {
            Assert.fail((String)("Write PNG failed for graphWF.xml: " + e.getMessage()));
        }
        File f2 = new File(png2);
        try {
            Assert.assertNotNull((Object)ImageIO.read(f2));
        }
        catch (IOException io) {
            Assert.fail((String)("Not a valid PNG: " + io.getMessage()));
        }
        Assert.assertTrue((f1.length() < f2.length() ? 1 : 0) != 0);
        f1.delete();
        f2.delete();
        try {
            GraphGenerator g = new GraphGenerator(TestGraphGenerator.readFile("src/test/resources/invalidGraphWF.xml"), jsonWFJob, true);
            g.write((OutputStream)new FileOutputStream(new File("src/test/resources/invalid.png")));
        }
        catch (Exception e) {
            Assert.fail((String)("Write PNG failed for invalidGraphWF.xml: " + e.getMessage()));
        }
        new File("src/test/resources/invalid.png").delete();
    }

    public void testJobDAGLimit_more() throws IOException {
        WorkflowJobBean jsonWFJob = new WorkflowJobBean();
        jsonWFJob.setAppName("My Test App");
        jsonWFJob.setId("My Test ID");
        String txt = "src/test/resources/tmp1.txt";
        try {
            GraphGenerator g = new GraphGenerator(TestGraphGenerator.readFile("src/test/resources/graphWF_26_actions.xml"), jsonWFJob);
            g.write((OutputStream)new FileOutputStream(new File(txt)));
            Assert.fail((String)"This should not get executed");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Can't display the graph. Number of actions are more than display limit"));
        }
        File f1 = new File(txt);
        f1.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(String path) throws IOException {
        File f = new File(path);
        System.out.println("Reading input file " + f.getAbsolutePath());
        try (FileInputStream stream = new FileInputStream(f);){
            FileChannel fc = stream.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            String string = Charset.defaultCharset().decode(bb).toString();
            return string;
        }
    }
}

