/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.test;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Shell;
import org.apache.hive.hcatalog.api.HCatPartition;
import org.apache.oozie.test.MiniHCatServer;
import org.apache.oozie.test.XFsTestCase;

public abstract class XHCatTestCase
extends XFsTestCase {
    private MiniHCatServer hcatServer;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        super.setupHCatalogServer();
        this.hcatServer = super.getHCatalogServer();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected Configuration getMetaStoreConf() {
        return this.hcatServer.getMetaStoreConf();
    }

    public String getMetastoreAuthority() {
        return this.hcatServer.getMetastoreAuthority();
    }

    protected URI getHCatURI(String db, String table, String partitions) throws URISyntaxException {
        return this.hcatServer.getHCatURI(db, table, partitions);
    }

    protected void createDatabase(String db) throws Exception {
        if (db.equals("default")) {
            return;
        }
        this.hcatServer.createDatabase(db, this.getSanitizedTestCaseDir());
    }

    protected void createTable(String db, String table, String partitionCols) throws Exception {
        this.hcatServer.createTable(db, table, partitionCols);
    }

    protected void dropDatabase(String db, boolean ifExists) throws Exception {
        if (db.equals("default")) {
            return;
        }
        this.hcatServer.dropDatabase(db, ifExists);
    }

    protected void dropTable(String db, String table, boolean ifExists) throws Exception {
        this.hcatServer.dropTable(db, table, ifExists);
    }

    protected String getPartitionDir(String db, String table, String partitionSpec) throws Exception {
        return this.hcatServer.getPartitionDir(db, table, partitionSpec, this.getSanitizedTestCaseDir()).toString();
    }

    protected String addPartition(String db, String table, String partitionSpec) throws Exception {
        String location = this.hcatServer.createPartitionDir(db, table, partitionSpec, this.getSanitizedTestCaseDir());
        this.hcatServer.addPartition(db, table, partitionSpec, location);
        return location;
    }

    protected String getSanitizedTestCaseDir() {
        if (Shell.WINDOWS) {
            return "\\" + this.getTestCaseDir().replaceAll(":", "");
        }
        return this.getTestCaseDir();
    }

    protected void dropPartition(String db, String table, String partitionSpec) throws Exception {
        this.hcatServer.dropPartition(db, table, partitionSpec);
    }

    public List<HCatPartition> getPartitions(String db, String table, String partitionSpec) throws Exception {
        return this.hcatServer.getPartitions(db, table, partitionSpec);
    }

    protected Map<String, String> getPartitionMap(String partitionSpec) {
        String[] parts = partitionSpec.split(";");
        HashMap<String, String> partitions = new HashMap<String, String>();
        for (String part : parts) {
            String[] split = part.split("=");
            partitions.put(split[0], split[1]);
        }
        return partitions;
    }
}

