/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.test;

import junit.framework.TestCase;
import org.apache.oozie.test.XTestCase;

public class TestXTestCase
extends TestCase {
    static boolean TESTING = false;
    static String SYS_PROP = "oozie.test.testProp";
    static String testBaseDir;

    protected void setUp() throws Exception {
        super.setUp();
        testBaseDir = null;
        TESTING = true;
    }

    protected void tearDown() throws Exception {
        TESTING = false;
        super.tearDown();
    }

    public void testBaseDir() throws Exception {
        testBaseDir = System.getProperty("oozie.test.dir");
        try {
            MyXTestCase testcase = new MyXTestCase();
            testcase.setName(this.getName());
            testcase.setUp();
            testcase.testBaseDir();
            testcase.tearDown();
        }
        finally {
            if (testBaseDir != null) {
                System.getProperties().setProperty("oozie.test.dir", testBaseDir);
            }
        }
    }

    public void testSysPropSetting() throws Exception {
        try {
            System.getProperties().remove(SYS_PROP);
            MyXTestCase testcase = new MyXTestCase();
            testcase.setName(this.getName());
            testcase.setUp();
            testcase.testUnsetSysProperty();
            TestXTestCase.assertEquals((String)"A", (String)System.getProperty(SYS_PROP));
            testcase.tearDown();
            TestXTestCase.assertNull((Object)System.getProperty(SYS_PROP));
            testcase = new MyXTestCase();
            testcase.setName(this.getName() + "A");
            testcase.setUp();
            System.getProperties().setProperty(SYS_PROP, "B");
            testcase.testSetSysProperty();
            TestXTestCase.assertEquals((String)"C", (String)System.getProperty(SYS_PROP));
            testcase.tearDown();
            TestXTestCase.assertEquals((String)"B", (String)System.getProperty(SYS_PROP));
        }
        finally {
            System.getProperties().remove(SYS_PROP);
        }
    }

    public void testWaitFor() throws Exception {
        MyXTestCase testcase = new MyXTestCase();
        testcase.setName(this.getName());
        testcase.setUp();
        testcase.testWaitFor();
        testcase.tearDown();
        testcase.setName(this.getName() + "A");
        testcase.setUp();
        testcase.testWaitForTimeOut();
        testcase.tearDown();
    }

    public void testHadopSysProps() throws Exception {
        MyXTestCase testcase = new MyXTestCase();
        testcase.setName(this.getName());
        testcase.setUp();
        testcase.testHadoopSysProps();
        testcase.tearDown();
    }

    public static class MyXTestCase
    extends XTestCase {
        @Override
        protected void setUp() throws Exception {
            if (TESTING) {
                super.setUp();
            }
        }

        @Override
        protected void tearDown() throws Exception {
            if (TESTING) {
                super.tearDown();
            }
        }

        public void testDummy() {
        }

        public void testBaseDir() {
            if (TESTING) {
                MyXTestCase.assertTrue((testBaseDir == null || this.getTestCaseDir().startsWith(testBaseDir) ? 1 : 0) != 0);
            }
        }

        public void testUnsetSysProperty() {
            if (TESTING) {
                MyXTestCase.assertNull((Object)System.getProperty(SYS_PROP));
                this.setSystemProperty(SYS_PROP, "A");
                MyXTestCase.assertEquals((String)"A", (String)System.getProperty(SYS_PROP));
            }
        }

        public void testSetSysProperty() {
            if (TESTING) {
                MyXTestCase.assertEquals((String)"B", (String)System.getProperty(SYS_PROP));
                this.setSystemProperty(SYS_PROP, "C");
                MyXTestCase.assertEquals((String)"C", (String)System.getProperty(SYS_PROP));
            }
        }

        public void testWaitFor() {
            if (TESTING) {
                long start = System.currentTimeMillis();
                long waited = this.waitFor(60000, new XTestCase.Predicate(){

                    @Override
                    public boolean evaluate() throws Exception {
                        return true;
                    }
                });
                long end = System.currentTimeMillis();
                MyXTestCase.assertEquals((float)0.0f, (float)waited, (float)100.0f);
                MyXTestCase.assertEquals((float)0.0f, (float)(end - start), (float)300.0f);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void testWaitForTimeOut() {
            float originalRatio = XTestCase.WAITFOR_RATIO;
            try {
                XTestCase.WAITFOR_RATIO = 1.0f;
                if (TESTING) {
                    long start = System.currentTimeMillis();
                    long waited = this.waitFor(1000, new XTestCase.Predicate(){

                        @Override
                        public boolean evaluate() throws Exception {
                            return false;
                        }
                    });
                    long end = System.currentTimeMillis();
                    MyXTestCase.assertEquals((float)(1000.0f * XTestCase.WAITFOR_RATIO), (float)waited, (float)100.0f);
                    MyXTestCase.assertEquals((float)(1000.0f * XTestCase.WAITFOR_RATIO), (float)(end - start), (float)300.0f);
                }
            }
            finally {
                XTestCase.WAITFOR_RATIO = originalRatio;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void testWaitForTimeOutWithRatio() {
            float originalRatio = XTestCase.WAITFOR_RATIO;
            try {
                XTestCase.WAITFOR_RATIO = 2.0f;
                if (TESTING) {
                    long start = System.currentTimeMillis();
                    long waited = this.waitFor(1000, new XTestCase.Predicate(){

                        @Override
                        public boolean evaluate() throws Exception {
                            return false;
                        }
                    });
                    long end = System.currentTimeMillis();
                    MyXTestCase.assertEquals((float)(1000.0f * XTestCase.WAITFOR_RATIO), (float)(end - start), (float)300.0f);
                }
            }
            finally {
                XTestCase.WAITFOR_RATIO = originalRatio;
            }
        }

        public void testHadoopSysProps() {
            if (TESTING) {
                this.setSystemProperty("oozie.test.name.node", "hdfs://xyz:9000");
                this.setSystemProperty("oozie.test.job.tracker", "xyz:9001");
                MyXTestCase.assertEquals((String)"hdfs://xyz:9000", (String)this.getNameNodeUri());
                MyXTestCase.assertEquals((String)"xyz:9001", (String)this.getJobTrackerUri());
            }
        }
    }
}

