/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.sla;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.AppType;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.event.Event;
import org.apache.oozie.client.event.JobEvent;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionStartXCommand;
import org.apache.oozie.command.coord.CoordActionUpdateXCommand;
import org.apache.oozie.command.coord.CoordKillXCommand;
import org.apache.oozie.command.coord.CoordRerunXCommand;
import org.apache.oozie.command.coord.CoordSubmitXCommand;
import org.apache.oozie.command.wf.KillXCommand;
import org.apache.oozie.command.wf.ReRunXCommand;
import org.apache.oozie.command.wf.StartXCommand;
import org.apache.oozie.command.wf.SubmitXCommand;
import org.apache.oozie.event.CoordinatorActionEvent;
import org.apache.oozie.event.listener.JobEventListener;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.SLASummaryQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLACalcStatus;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.sla.TestSLAService;
import org.apache.oozie.sla.listener.SLAJobEventListener;
import org.apache.oozie.sla.service.SLAService;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestSLAEventGeneration
extends XDataTestCase {
    Services services;
    EventHandlerService ehs = null;
    JPAService jpa;
    Calendar cal;
    String alert_events = "START_MISS,END_MET,END_MISS";
    private String[] excludeServices = new String[]{"org.apache.oozie.service.StatusTransitService", "org.apache.oozie.service.ActionCheckerService"};
    private static final String SLA_XML_1 = "<workflow-app xmlns=\"uri:oozie:workflow:0.2\" xmlns:sla=\"uri:oozie:sla:0.1\" name=\"test-wf-job-sla\"><start to=\"myjava\"/><action name=\"myjava\"> <java><job-tracker>jt</job-tracker><name-node>nn</name-node><main-class>org.apache.oozie.example.DemoJavaMain</main-class></java> <ok to=\"end\"/><error to=\"fail\"/></action><kill name=\"fail\"><message>Workflow failed</message></kill><end name=\"end\"/> <sla:info><sla:app-name>test-wf-job-sla</sla:app-name><sla:nominal-time>${nominal_time}</sla:nominal-time><sla:should-start>${10 * MINUTES}</sla:should-start><sla:should-end>${30 * MINUTES}</sla:should-end><sla:notification-msg>My Notification Message</sla:notification-msg><sla:alert-contact>alert@example.com</sla:alert-contact><sla:dev-contact>dev@example.com</sla:dev-contact><sla:qa-contact>qa@example.com</sla:qa-contact><sla:se-contact>se@example.com</sla:se-contact><sla:alert-frequency>LAST_HOUR</sla:alert-frequency><sla:alert-percentage>10</sla:alert-percentage><sla:upstream-apps>upstream-job</sla:upstream-apps></sla:info></workflow-app>";

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        Configuration conf = this.services.getConf();
        this.setClassesToBeExcluded(conf, this.excludeServices);
        conf.set("oozie.services.ext", EventHandlerService.class.getName() + "," + SLAService.class.getName());
        conf.setClass("oozie.service.EventHandlerService.event.listeners", SLAJobEventListener.class, JobEventListener.class);
        conf.setInt("oozie.service.EventHandlerService.worker.interval", 10000);
        conf.setInt("oozie.service.EventHandlerService.worker.threads", 0);
        conf.setInt("oozie.service.EventHandlerService.batch.size", 1);
        conf.setInt("oozie.sla.disable.alerts.older.than", -1);
        this.services.init();
        this.jpa = (JPAService)this.services.get(JPAService.class);
        this.ehs = (EventHandlerService)this.services.get(EventHandlerService.class);
        this.cal = Calendar.getInstance();
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    @Test
    public void testWorkflowJobSLANewSubmitStart() throws Exception {
        TestSLAEventGeneration.assertNotNull((Object)this.ehs);
        SLAService slas = (SLAService)this.services.get(SLAService.class);
        TestSLAEventGeneration.assertNotNull((Object)slas);
        String wfXml = IOUtils.getResourceAsString((String)"wf-job-sla.xml", (int)-1);
        Path appPath = this.getFsTestCaseDir();
        this.writeToFile(wfXml, appPath, "workflow.xml");
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", appPath.toString());
        conf.set("user.name", TestSLAEventGeneration.getTestUser());
        this._testWorkflowJobSubmitStart((Configuration)conf, slas, true);
    }

    @Test
    public void testWorkflowJobSLANewKill() throws Exception {
        TestSLAEventGeneration.assertNotNull((Object)this.ehs);
        SLAService slas = (SLAService)this.services.get(SLAService.class);
        TestSLAEventGeneration.assertNotNull((Object)slas);
        String wfXml = IOUtils.getResourceAsString((String)"wf-job-sla.xml", (int)-1);
        Path appPath = this.getFsTestCaseDir();
        this.writeToFile(wfXml, appPath, "workflow.xml");
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", appPath.toString());
        conf.set("user.name", TestSLAEventGeneration.getTestUser());
        this._testWorkflowJobKillCommand((Configuration)conf, slas);
    }

    @Test
    public void testWorkflowJobSLARerun() throws Exception {
        SLAService slas = (SLAService)this.services.get(SLAService.class);
        String wfXml = IOUtils.getResourceAsString((String)"wf-job-sla.xml", (int)-1);
        Path appPath = this.getFsTestCaseDir();
        this.writeToFile(wfXml, appPath, "workflow.xml");
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", appPath.toString());
        conf.set("user.name", TestSLAEventGeneration.getTestUser());
        this.cal.setTime(new Date());
        this.cal.add(12, -40);
        Date nominal = this.cal.getTime();
        String nominalTime = DateUtils.formatDateOozieTZ((Date)nominal);
        conf.set("nominal_time", nominalTime);
        this.cal.setTime(nominal);
        this.cal.add(12, 10);
        String expectedStart = DateUtils.formatDateOozieTZ((Date)this.cal.getTime());
        this.cal.setTime(nominal);
        this.cal.add(12, 30);
        String expectedEnd = DateUtils.formatDateOozieTZ((Date)this.cal.getTime());
        SubmitXCommand sc = new SubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        SLACalcStatus slaEvent = slas.getSLACalculator().get(jobId);
        TestSLAEventGeneration.assertEquals((String)jobId, (String)slaEvent.getId());
        TestSLAEventGeneration.assertEquals((String)"test-wf-job-sla", (String)slaEvent.getAppName());
        TestSLAEventGeneration.assertEquals((Object)AppType.WORKFLOW_JOB, (Object)slaEvent.getAppType());
        TestSLAEventGeneration.assertEquals((String)nominalTime, (String)DateUtils.formatDateOozieTZ((Date)slaEvent.getNominalTime()));
        TestSLAEventGeneration.assertEquals((String)expectedStart, (String)DateUtils.formatDateOozieTZ((Date)slaEvent.getExpectedStart()));
        TestSLAEventGeneration.assertEquals((String)expectedEnd, (String)DateUtils.formatDateOozieTZ((Date)slaEvent.getExpectedEnd()));
        slas.runSLAWorker();
        slaEvent = (SLACalcStatus)this.ehs.getEventQueue().poll();
        TestSLAEventGeneration.assertEquals((Object)SLAEvent.SLAStatus.NOT_STARTED, (Object)slaEvent.getSLAStatus());
        TestSLAEventGeneration.assertEquals((Object)SLAEvent.EventStatus.START_MISS, (Object)slaEvent.getEventStatus());
        slas.getSLACalculator().clear();
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        WorkflowJobBean wfBean = (WorkflowJobBean)jpaService.execute((JPAExecutor)new WorkflowJobGetJPAExecutor(jobId));
        wfBean.setStatus(WorkflowJob.Status.SUCCEEDED);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_MODTIME, (Object)wfBean);
        this.cal.setTime(new Date());
        this.cal.add(12, -20);
        nominalTime = DateUtils.formatDateOozieTZ((Date)this.cal.getTime());
        conf.set("nominal_time", nominalTime);
        nominal = this.cal.getTime();
        this.cal.add(12, 10);
        expectedStart = DateUtils.formatDateOozieTZ((Date)this.cal.getTime());
        this.cal.setTime(nominal);
        this.cal.add(12, 30);
        expectedEnd = DateUtils.formatDateOozieTZ((Date)this.cal.getTime());
        ReRunXCommand rerun = new ReRunXCommand(jobId, (Configuration)conf);
        rerun.call();
        slaEvent = slas.getSLACalculator().get(jobId);
        TestSLAEventGeneration.assertNotNull((Object)slaEvent);
        TestSLAEventGeneration.assertEquals((String)jobId, (String)slaEvent.getId());
        TestSLAEventGeneration.assertEquals((String)"test-wf-job-sla", (String)slaEvent.getAppName());
        TestSLAEventGeneration.assertEquals((Object)AppType.WORKFLOW_JOB, (Object)slaEvent.getAppType());
        TestSLAEventGeneration.assertEquals((String)nominalTime, (String)DateUtils.formatDateOozieTZ((Date)slaEvent.getNominalTime()));
        TestSLAEventGeneration.assertEquals((String)expectedStart, (String)DateUtils.formatDateOozieTZ((Date)slaEvent.getExpectedStart()));
        TestSLAEventGeneration.assertEquals((String)expectedEnd, (String)DateUtils.formatDateOozieTZ((Date)slaEvent.getExpectedEnd()));
        SLASummaryBean slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId});
        TestSLAEventGeneration.assertEquals((int)0, (int)slaSummary.getEventProcessed());
        TestSLAEventGeneration.assertEquals((long)-1L, (long)slaSummary.getActualDuration());
        TestSLAEventGeneration.assertNull((Object)slaSummary.getActualStart());
        TestSLAEventGeneration.assertNull((Object)slaSummary.getActualEnd());
        TestSLAEventGeneration.assertEquals((String)"PREP", (String)slaSummary.getJobStatus());
        TestSLAEventGeneration.assertEquals((Object)SLAEvent.SLAStatus.NOT_STARTED, (Object)slaSummary.getSLAStatus());
        TestSLAEventGeneration.assertNull((Object)slaEvent.getEventStatus());
        this.ehs.getEventQueue().clear();
        slas.runSLAWorker();
        slaEvent = (SLACalcStatus)this.ehs.getEventQueue().poll();
        TestSLAEventGeneration.assertEquals((Object)SLAEvent.SLAStatus.IN_PROCESS, (Object)slaEvent.getSLAStatus());
        TestSLAEventGeneration.assertEquals((Object)SLAEvent.EventStatus.START_MISS, (Object)slaEvent.getEventStatus());
    }

    @Test
    public void testWorkflowActionSLARerun() throws Exception {
        SLAService slas = (SLAService)this.services.get(SLAService.class);
        String wfXml = IOUtils.getResourceAsString((String)"wf-action-sla.xml", (int)-1);
        Path appPath = this.getFsTestCaseDir();
        this.writeToFile(wfXml, appPath, "workflow.xml");
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", appPath.toString());
        conf.set("user.name", TestSLAEventGeneration.getTestUser());
        this.cal.setTime(new Date());
        this.cal.add(12, -20);
        Date nominal = this.cal.getTime();
        String nominalTime = DateUtils.formatDateOozieTZ((Date)nominal);
        conf.set("nominal_time", nominalTime);
        SubmitXCommand sc = new SubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        String actionId = jobId + "@grouper";
        slas.getSLACalculator().clear();
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        WorkflowJobBean wfBean = (WorkflowJobBean)jpaService.execute((JPAExecutor)new WorkflowJobGetJPAExecutor(jobId));
        wfBean.setStatus(WorkflowJob.Status.SUCCEEDED);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_MODTIME, (Object)wfBean);
        this.cal.setTime(new Date());
        nominalTime = DateUtils.formatDateOozieTZ((Date)this.cal.getTime());
        conf.set("nominal_time", nominalTime);
        nominal = this.cal.getTime();
        this.cal.add(12, 10);
        String expectedStart = DateUtils.formatDateOozieTZ((Date)this.cal.getTime());
        this.cal.setTime(nominal);
        this.cal.add(12, 30);
        String expectedEnd = DateUtils.formatDateOozieTZ((Date)this.cal.getTime());
        ReRunXCommand rerun = new ReRunXCommand(jobId, (Configuration)conf);
        rerun.call();
        SLACalcStatus slaEvent = slas.getSLACalculator().get(actionId);
        TestSLAEventGeneration.assertNotNull((Object)slaEvent);
        TestSLAEventGeneration.assertEquals((String)actionId, (String)slaEvent.getId());
        TestSLAEventGeneration.assertEquals((String)"test-wf-action-sla", (String)slaEvent.getAppName());
        TestSLAEventGeneration.assertEquals((Object)AppType.WORKFLOW_ACTION, (Object)slaEvent.getAppType());
        TestSLAEventGeneration.assertEquals((String)nominalTime, (String)DateUtils.formatDateOozieTZ((Date)slaEvent.getNominalTime()));
        TestSLAEventGeneration.assertEquals((String)expectedStart, (String)DateUtils.formatDateOozieTZ((Date)slaEvent.getExpectedStart()));
        TestSLAEventGeneration.assertEquals((String)expectedEnd, (String)DateUtils.formatDateOozieTZ((Date)slaEvent.getExpectedEnd()));
    }

    @Test
    public void testCoordRerunNoSLA() throws Exception {
        block2: {
            CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
            this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.FAILED, "coord-rerun-action1.xml", 0);
            try {
                new CoordRerunXCommand(job.getId(), "date", "2009-12-15T01:00Z", false, true, false, null).call();
            }
            catch (CommandException ce) {
                if (ce.getErrorCode() != ErrorCode.E0604) break block2;
                TestSLAEventGeneration.fail((String)("Coord Rerun with no SLA should not throw " + ce.getMessage() + " exception"));
            }
        }
    }

    @Test
    public void testSLASchema1BackwardCompatibilitySubmitStart() throws Exception {
        TestSLAEventGeneration.assertNotNull((Object)this.ehs);
        SLAService slas = (SLAService)this.services.get(SLAService.class);
        TestSLAEventGeneration.assertNotNull((Object)slas);
        Path appPath = this.getFsTestCaseDir();
        this.writeToFile(SLA_XML_1, appPath, "workflow.xml");
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", appPath.toString());
        conf.set("user.name", TestSLAEventGeneration.getTestUser());
        this.cal.setTime(new Date());
        this.cal.add(12, -20);
        Date nominal = this.cal.getTime();
        String nominalTime = DateUtils.formatDateOozieTZ((Date)nominal);
        conf.set("nominal_time", nominalTime);
        this._testWorkflowJobSubmitStart((Configuration)conf, slas, false);
    }

    @Test
    public void testSLASchema1BackwardCompatibilityKill() throws Exception {
        TestSLAEventGeneration.assertNotNull((Object)this.ehs);
        SLAService slas = (SLAService)this.services.get(SLAService.class);
        TestSLAEventGeneration.assertNotNull((Object)slas);
        Path appPath = this.getFsTestCaseDir();
        this.writeToFile(SLA_XML_1, appPath, "workflow.xml");
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", appPath.toString());
        conf.set("user.name", TestSLAEventGeneration.getTestUser());
        this.cal.setTime(new Date());
        this.cal.add(12, -20);
        Date nominal = this.cal.getTime();
        String nominalTime = DateUtils.formatDateOozieTZ((Date)nominal);
        conf.set("nominal_time", nominalTime);
        this._testWorkflowJobKillCommand((Configuration)conf, slas);
    }

    @Test
    public void testCoordinatorActionCommandsSubmitAndStart() throws Exception {
        this.ehs.setAppTypes(new HashSet<String>(Arrays.asList("coordinator_action")));
        this.ehs.getEventQueue().clear();
        SLAService slas = (SLAService)this.services.get(SLAService.class);
        String coordXml = IOUtils.getResourceAsString((String)"coord-action-sla.xml", (int)-1);
        Path appPath = this.getFsTestCaseDir();
        this.writeToFile(coordXml, appPath, "coordinator.xml");
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.coord.application.path", appPath.toString());
        String wfXml = IOUtils.getResourceAsString((String)"wf-credentials.xml", (int)-1);
        this.writeToFile(wfXml, appPath, "workflow.xml");
        conf.set("wfAppPath", appPath.toString());
        conf.set("user.name", TestSLAEventGeneration.getTestUser());
        this.cal.setTime(new Date());
        this.cal.add(12, -20);
        Date nominal = this.cal.getTime();
        String nominalTime = DateUtils.formatDateOozieTZ((Date)nominal);
        conf.set("nominal_time", nominalTime);
        conf.set("start", "2009-01-02T08:01Z");
        conf.set("frequency", "coord:days(1)");
        conf.set("end", "2009-01-03T08:00Z");
        this.cal.setTime(nominal);
        this.cal.add(12, 10);
        String expectedStart = DateUtils.formatDateOozieTZ((Date)this.cal.getTime());
        this.cal.setTime(nominal);
        this.cal.add(12, 30);
        String expectedEnd = DateUtils.formatDateOozieTZ((Date)this.cal.getTime());
        String appName = "test-coord-sla";
        String jobId = (String)new CoordSubmitXCommand((Configuration)conf).call();
        Thread.sleep(500L);
        CoordActionGetJPAExecutor getCmd = new CoordActionGetJPAExecutor(jobId + "@1");
        CoordinatorActionBean action = (CoordinatorActionBean)this.jpa.execute((JPAExecutor)getCmd);
        String actionId = action.getId();
        SLACalcStatus slaEvent = slas.getSLACalculator().get(actionId);
        TestSLAEventGeneration.assertEquals((String)actionId, (String)slaEvent.getId());
        TestSLAEventGeneration.assertEquals((String)appName, (String)slaEvent.getAppName());
        TestSLAEventGeneration.assertEquals((Object)AppType.COORDINATOR_ACTION, (Object)slaEvent.getAppType());
        TestSLAEventGeneration.assertEquals((String)nominalTime, (String)DateUtils.formatDateOozieTZ((Date)slaEvent.getNominalTime()));
        TestSLAEventGeneration.assertEquals((String)expectedStart, (String)DateUtils.formatDateOozieTZ((Date)slaEvent.getExpectedStart()));
        TestSLAEventGeneration.assertEquals((String)expectedEnd, (String)DateUtils.formatDateOozieTZ((Date)slaEvent.getExpectedEnd()));
        TestSLAEventGeneration.assertEquals((long)1800000L, (long)slaEvent.getExpectedDuration());
        TestSLAEventGeneration.assertEquals((String)this.alert_events, (String)slaEvent.getAlertEvents());
        slas.runSLAWorker();
        slaEvent = this.skipToSLAEvent();
        TestSLAEventGeneration.assertTrue((SLAEvent.SLAStatus.NOT_STARTED == slaEvent.getSLAStatus() ? 1 : 0) != 0);
        TestSLAEventGeneration.assertEquals((Object)SLAEvent.EventStatus.START_MISS, (Object)slaEvent.getEventStatus());
        this.ehs.getEventQueue().clear();
        action.setStatus(CoordinatorAction.Status.SUBMITTED);
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_STATUS_PENDING_TIME, (Object)action);
        new CoordActionStartXCommand(actionId, TestSLAEventGeneration.getTestUser(), appName, jobId).call();
        slaEvent = slas.getSLACalculator().get(actionId);
        slaEvent.setEventProcessed(0);
        SLASummaryBean suBean = new SLASummaryBean();
        suBean.setId(actionId);
        suBean.setEventProcessed(0);
        SLASummaryQueryExecutor.getInstance().executeUpdate((Enum)SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_EVENTPROCESSED, (Object)suBean);
        new EventHandlerService.EventWorker(this.ehs).run();
        slaEvent = this.skipToSLAEvent();
        TestSLAEventGeneration.assertEquals((String)actionId, (String)slaEvent.getId());
        TestSLAEventGeneration.assertNotNull((Object)slaEvent.getActualStart());
        TestSLAEventGeneration.assertEquals((Object)SLAEvent.SLAStatus.IN_PROCESS, (Object)slaEvent.getSLAStatus());
        TestSLAEventGeneration.assertEquals((String)CoordinatorAction.Status.RUNNING.name(), (String)slaEvent.getJobStatus());
    }

    public void testFailureAndMissEventsOnKill() throws Exception {
        TestSLAEventGeneration.assertEquals((int)0, (int)this.ehs.getEventQueue().size());
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        CoordinatorActionBean action = this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.WAITING, "coord-action-sla1.xml", 0);
        action.setExternalId(null);
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION, (Object)action);
        ((SLAService)this.services.get(SLAService.class)).addRegistrationEvent(TestSLAService._createSLARegistration(action.getId(), AppType.COORDINATOR_ACTION));
        new CoordKillXCommand(job.getId()).call();
        TestSLAEventGeneration.assertEquals((int)1, (int)this.ehs.getEventQueue().size());
        CoordinatorActionEvent jobEvent = (CoordinatorActionEvent)this.ehs.getEventQueue().peek();
        TestSLAEventGeneration.assertEquals((Object)AppType.COORDINATOR_ACTION, (Object)jobEvent.getAppType());
        TestSLAEventGeneration.assertEquals((Object)JobEvent.EventStatus.FAILURE, (Object)jobEvent.getEventStatus());
        TestSLAEventGeneration.assertEquals((String)action.getId(), (String)jobEvent.getId());
        new EventHandlerService.EventWorker(this.ehs).run();
        SLACalcStatus slaEvent = (SLACalcStatus)this.ehs.getEventQueue().poll();
        TestSLAEventGeneration.assertEquals((Object)SLAEvent.EventStatus.END_MISS, (Object)slaEvent.getEventStatus());
        TestSLAEventGeneration.assertEquals((Object)SLAEvent.SLAStatus.MISS, (Object)slaEvent.getSLAStatus());
        TestSLAEventGeneration.assertEquals((String)CoordinatorAction.Status.KILLED.name(), (String)slaEvent.getJobStatus());
        TestSLAEventGeneration.assertEquals((String)action.getId(), (String)slaEvent.getId());
        TestSLAEventGeneration.assertNotNull((Object)slaEvent.getActualEnd());
        TestSLAEventGeneration.assertEquals((int)0, (int)this.ehs.getEventQueue().size());
        job = this.addRecordToCoordJobTable(Job.Status.PAUSED, false, false);
        action = this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.RUNNING, "coord-action-sla1.xml", 0);
        ((SLAService)this.services.get(SLAService.class)).addRegistrationEvent(TestSLAService._createSLARegistration(action.getId(), AppType.COORDINATOR_ACTION));
        new CoordKillXCommand(job.getId()).call();
        TestSLAEventGeneration.assertEquals((int)0, (int)this.ehs.getEventQueue().size());
        WorkflowJobBean wf = new WorkflowJobBean();
        wf.setId(action.getExternalId());
        wf.setStatus(WorkflowJob.Status.KILLED);
        wf.setParentId(action.getId());
        wf.setEndTime(new Date());
        this.jpa.execute((JPAExecutor)new WorkflowJobInsertJPAExecutor(wf));
        new CoordActionUpdateXCommand(wf).call();
        TestSLAEventGeneration.assertEquals((int)1, (int)this.ehs.getEventQueue().size());
        jobEvent = (CoordinatorActionEvent)this.ehs.getEventQueue().peek();
        TestSLAEventGeneration.assertEquals((Object)AppType.COORDINATOR_ACTION, (Object)jobEvent.getAppType());
        TestSLAEventGeneration.assertEquals((Object)JobEvent.EventStatus.FAILURE, (Object)jobEvent.getEventStatus());
        TestSLAEventGeneration.assertEquals((String)action.getId(), (String)jobEvent.getId());
        new EventHandlerService.EventWorker(this.ehs).run();
        slaEvent = (SLACalcStatus)this.ehs.getEventQueue().poll();
        TestSLAEventGeneration.assertEquals((Object)SLAEvent.EventStatus.END_MISS, (Object)slaEvent.getEventStatus());
        TestSLAEventGeneration.assertEquals((Object)SLAEvent.SLAStatus.MISS, (Object)slaEvent.getSLAStatus());
        TestSLAEventGeneration.assertEquals((String)CoordinatorAction.Status.KILLED.name(), (String)slaEvent.getJobStatus());
        TestSLAEventGeneration.assertEquals((String)action.getId(), (String)slaEvent.getId());
        TestSLAEventGeneration.assertNotNull((Object)slaEvent.getActualEnd());
    }

    private void waitForEventGeneration(int wait) {
        this.waitFor(wait, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return TestSLAEventGeneration.this.ehs.getEventQueue().peek() != null;
            }
        });
    }

    private SLACalcStatus skipToSLAEvent() {
        Event someEvent;
        while (!((someEvent = this.ehs.getEventQueue().poll()) instanceof SLACalcStatus)) {
        }
        return (SLACalcStatus)someEvent;
    }

    private void _testWorkflowJobSubmitStart(Configuration conf, SLAService slas, boolean isNew) throws Exception {
        this.cal.setTime(new Date());
        this.cal.add(12, -20);
        Date nominal = this.cal.getTime();
        String nominalTime = DateUtils.formatDateOozieTZ((Date)nominal);
        conf.set("nominal_time", nominalTime);
        this.cal.setTime(nominal);
        this.cal.add(12, 10);
        String expectedStart = DateUtils.formatDateOozieTZ((Date)this.cal.getTime());
        this.cal.setTime(nominal);
        this.cal.add(12, 30);
        String expectedEnd = DateUtils.formatDateOozieTZ((Date)this.cal.getTime());
        SubmitXCommand sc = new SubmitXCommand(conf);
        String jobId = (String)sc.call();
        SLACalcStatus slaEvent = slas.getSLACalculator().get(jobId);
        TestSLAEventGeneration.assertEquals((String)jobId, (String)slaEvent.getId());
        TestSLAEventGeneration.assertEquals((String)"test-wf-job-sla", (String)slaEvent.getAppName());
        TestSLAEventGeneration.assertEquals((Object)AppType.WORKFLOW_JOB, (Object)slaEvent.getAppType());
        TestSLAEventGeneration.assertEquals((String)nominalTime, (String)DateUtils.formatDateOozieTZ((Date)slaEvent.getNominalTime()));
        TestSLAEventGeneration.assertEquals((String)expectedStart, (String)DateUtils.formatDateOozieTZ((Date)slaEvent.getExpectedStart()));
        TestSLAEventGeneration.assertEquals((String)expectedEnd, (String)DateUtils.formatDateOozieTZ((Date)slaEvent.getExpectedEnd()));
        if (isNew) {
            TestSLAEventGeneration.assertEquals((long)1800000L, (long)slaEvent.getExpectedDuration());
            TestSLAEventGeneration.assertEquals((String)this.alert_events, (String)slaEvent.getAlertEvents());
        }
        slas.runSLAWorker();
        slaEvent = this.skipToSLAEvent();
        TestSLAEventGeneration.assertEquals((Object)SLAEvent.SLAStatus.NOT_STARTED, (Object)slaEvent.getSLAStatus());
        TestSLAEventGeneration.assertEquals((Object)SLAEvent.EventStatus.START_MISS, (Object)slaEvent.getEventStatus());
        new StartXCommand(jobId).call();
        slaEvent = slas.getSLACalculator().get(jobId);
        slaEvent.setEventProcessed(0);
        SLASummaryBean suBean = new SLASummaryBean();
        suBean.setId(jobId);
        suBean.setEventProcessed(0);
        SLASummaryQueryExecutor.getInstance().executeUpdate((Enum)SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_EVENTPROCESSED, (Object)suBean);
        this.waitForEventGeneration(200);
        new EventHandlerService.EventWorker(this.ehs).run();
        this.waitForEventGeneration(300);
        slaEvent = this.skipToSLAEvent();
        TestSLAEventGeneration.assertEquals((String)jobId, (String)slaEvent.getId());
        TestSLAEventGeneration.assertNotNull((Object)slaEvent.getActualStart());
        TestSLAEventGeneration.assertEquals((Object)SLAEvent.SLAStatus.IN_PROCESS, (Object)slaEvent.getSLAStatus());
        TestSLAEventGeneration.assertEquals((String)WorkflowJob.Status.RUNNING.name(), (String)slaEvent.getJobStatus());
        this.ehs.getEventQueue().clear();
    }

    private void _testWorkflowJobKillCommand(Configuration conf, SLAService slas) throws Exception {
        this.cal.setTime(new Date());
        this.cal.add(12, -20);
        Date nominal = this.cal.getTime();
        String nominalTime = DateUtils.formatDateOozieTZ((Date)nominal);
        conf.set("nominal_time", nominalTime);
        String jobId = (String)new SubmitXCommand(conf).call();
        new KillXCommand(jobId).call();
        this.waitForEventGeneration(200);
        new EventHandlerService.EventWorker(this.ehs).run();
        this.waitForEventGeneration(300);
        SLACalcStatus slaEvent = this.skipToSLAEvent();
        TestSLAEventGeneration.assertEquals((String)jobId, (String)slaEvent.getId());
        TestSLAEventGeneration.assertNotNull((Object)slaEvent.getActualEnd());
        TestSLAEventGeneration.assertEquals((Object)SLAEvent.EventStatus.END_MISS, (Object)slaEvent.getEventStatus());
        TestSLAEventGeneration.assertEquals((Object)SLAEvent.SLAStatus.MISS, (Object)slaEvent.getSLAStatus());
        TestSLAEventGeneration.assertEquals((String)WorkflowJob.Status.KILLED.name(), (String)slaEvent.getJobStatus());
    }
}

