/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.sla;

import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;
import java.util.Date;
import javax.mail.Message;
import javax.mail.internet.MimeMessage;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.AppType;
import org.apache.oozie.client.event.JobEvent;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLACalcStatus;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.listener.SLAEmailEventListener;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.junit.After;
import org.junit.Before;

public class TestSLAEmailEventListener
extends XTestCase {
    private Services services;
    private static final int SMTP_TEST_PORT = 3025;
    private GreenMail greenMail;
    private SLAEmailEventListener slaEmailListener;
    private Configuration conf = null;

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.conf = this.services.getConf();
        this.conf.set("oozie.email.smtp.host", "localhost");
        this.conf.set("oozie.email.smtp.port", String.valueOf(3025));
        this.conf.set("oozie.email.smtp.auth", "false");
        this.conf.set("oozie.email.smtp.username", "");
        this.conf.set("oozie.email.smtp.password", "");
        this.conf.set("oozie.email.from.address", "oozie@localhost");
        this.conf.set("oozie.email.blacklist.cachetimeout", "1");
        this.conf.set("oozie.email.blacklist.failcount", "2");
        this.conf.set("oozie.sla.service.SLAService.alert.events", SLAEvent.EventStatus.START_MISS.name() + "," + SLAEvent.EventStatus.END_MISS + "," + SLAEvent.EventStatus.DURATION_MISS);
        this.greenMail = new GreenMail(new ServerSetup(3025, null, "smtp"));
        this.greenMail.start();
        this.services.init();
        this.slaEmailListener = new SLAEmailEventListener();
        this.slaEmailListener.init(this.conf);
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        if (null != this.greenMail) {
            this.greenMail.stop();
        }
        this.services.destroy();
        super.tearDown();
    }

    public void testOnStartMiss() throws Exception {
        String id = "0000000-000000000000001-oozie-wrkf-C@1";
        SLACalcStatus event = this._createSLACalcStatus(id);
        SLARegistrationBean eventBean = event.getSLARegistrationBean();
        Date startDate = DateUtils.parseDateUTC((String)"2013-01-01T00:00Z");
        Date actualstartDate = DateUtils.parseDateUTC((String)"2013-01-01T01:00Z");
        event.setEventStatus(SLAEvent.EventStatus.START_MISS);
        event.setJobStatus(JobEvent.EventStatus.STARTED.toString());
        event.setId(id);
        eventBean.setParentId("0000000-000000000000001-oozie-wrkf-C");
        eventBean.setAppName("Test-SLA-Start-Miss");
        eventBean.setUser("dummyuser");
        eventBean.setNominalTime(startDate);
        eventBean.setExpectedStart(startDate);
        eventBean.setNotificationMsg("Notification of Missing Expected Start Time");
        eventBean.setAlertContact("alert-receiver@oozie.com");
        event.setActualStart(actualstartDate);
        eventBean.setAppType(AppType.COORDINATOR_ACTION);
        this.slaEmailListener.onStartMiss((SLAEvent)event);
        MimeMessage[] msgs = this.greenMail.getReceivedMessages();
        MimeMessage msg = msgs[0];
        TestSLAEmailEventListener.assertEquals((String)msg.getFrom()[0].toString(), (String)"oozie@localhost");
        TestSLAEmailEventListener.assertEquals((String)msg.getRecipients(Message.RecipientType.TO)[0].toString(), (String)"alert-receiver@oozie.com");
        TestSLAEmailEventListener.assertEquals((String)msg.getSubject(), (String)("OOZIE - SLA " + SLAEvent.EventStatus.START_MISS + " (AppName=Test-SLA-Start-Miss, JobID=0000000-000000000000001-oozie-wrkf-C@1)"));
        String msgBody = msg.getContent().toString();
        String headerSep = SLAEmailEventListener.EMAIL_BODY_HEADER_SEPARATER;
        String sep = SLAEmailEventListener.EMAIL_BODY_FIELD_SEPARATER;
        String indent = SLAEmailEventListener.EMAIL_BODY_FIELD_INDENT;
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf("Status" + headerSep) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.EVENT_STATUS.toString() + sep + SLAEvent.EventStatus.START_MISS.toString()) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.JOB_STATUS.toString() + sep + JobEvent.EventStatus.STARTED.toString()) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.NOTIFICATION_MESSAGE.toString() + sep + "Notification of Missing Expected Start Time") > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf("Job Details" + headerSep) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.APP_TYPE.toString() + sep + AppType.COORDINATOR_ACTION) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.APP_NAME.toString() + sep + "Test-SLA-Start-Miss") > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.USER.toString() + sep + "dummyuser") > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.JOBID.toString() + sep + "0000000-000000000000001-oozie-wrkf-C@1") > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.PARENT_JOBID.toString() + sep + "0000000-000000000000001-oozie-wrkf-C") > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.JOB_URL.toString() + sep + this.conf.get("oozie.base.url") + "/?job=0000000-000000000000001-oozie-wrkf-C@1") > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.PARENT_JOB_URL.toString() + sep + this.conf.get("oozie.base.url") + "/?job=0000000-000000000000001-oozie-wrkf-C") > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf("SLA Details" + headerSep) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.NOMINAL_TIME.toString() + sep + startDate) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.EXPECTED_START_TIME.toString() + sep + startDate) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.ACTUAL_START_TIME.toString() + sep + actualstartDate) > -1 ? 1 : 0) != 0);
    }

    public void testOnEndMiss() throws Exception {
        String id = "0000000-000000000000001-oozie-wrkf-C@1";
        SLACalcStatus event = this._createSLACalcStatus(id);
        SLARegistrationBean eventBean = event.getSLARegistrationBean();
        Date expectedStartDate = DateUtils.parseDateUTC((String)"2013-01-01T00:00Z");
        Date actualStartDate = DateUtils.parseDateUTC((String)"2013-01-01T01:00Z");
        Date expectedEndDate = DateUtils.parseDateUTC((String)"2013-01-01T12:00Z");
        Date actualEndDate = DateUtils.parseDateUTC((String)"2013-01-01T13:00Z");
        event.setId(id);
        eventBean.setParentId("0000000-000000000000001-oozie-wrkf-C");
        event.setEventStatus(SLAEvent.EventStatus.END_MISS);
        event.setJobStatus(JobEvent.EventStatus.SUCCESS.toString());
        eventBean.setAppName("Test-SLA-End-Miss");
        eventBean.setUser("dummyuser");
        eventBean.setNominalTime(expectedStartDate);
        eventBean.setExpectedStart(expectedStartDate);
        eventBean.setExpectedEnd(expectedEndDate);
        eventBean.setNotificationMsg("notification of end miss");
        eventBean.setAlertContact("alert-receiver-endmiss@oozie.com");
        eventBean.setAppType(AppType.COORDINATOR_ACTION);
        eventBean.setExpectedStart(expectedStartDate);
        eventBean.setExpectedEnd(expectedEndDate);
        event.setActualStart(actualStartDate);
        event.setActualEnd(actualEndDate);
        this.slaEmailListener.onEndMiss((SLAEvent)event);
        MimeMessage[] msgs = this.greenMail.getReceivedMessages();
        MimeMessage msg = msgs[0];
        TestSLAEmailEventListener.assertEquals((String)msg.getFrom()[0].toString(), (String)"oozie@localhost");
        TestSLAEmailEventListener.assertEquals((String)msg.getRecipients(Message.RecipientType.TO)[0].toString(), (String)"alert-receiver-endmiss@oozie.com");
        TestSLAEmailEventListener.assertEquals((String)msg.getSubject(), (String)("OOZIE - SLA " + SLAEvent.EventStatus.END_MISS + " (AppName=Test-SLA-End-Miss, JobID=0000000-000000000000001-oozie-wrkf-C@1)"));
        String msgBody = msg.getContent().toString();
        String headerSep = SLAEmailEventListener.EMAIL_BODY_HEADER_SEPARATER;
        String sep = SLAEmailEventListener.EMAIL_BODY_FIELD_SEPARATER;
        String indent = SLAEmailEventListener.EMAIL_BODY_FIELD_INDENT;
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf("Status" + headerSep) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.EVENT_STATUS.toString() + sep + SLAEvent.EventStatus.END_MISS.toString()) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.JOB_STATUS.toString() + sep + JobEvent.EventStatus.SUCCESS.toString()) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.NOTIFICATION_MESSAGE.toString() + sep + "notification of end miss") > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf("Job Details" + headerSep) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.APP_TYPE.toString() + sep + AppType.COORDINATOR_ACTION) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.APP_NAME.toString() + sep + "Test-SLA-End-Miss") > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.USER.toString() + sep + "dummyuser") > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.JOBID.toString() + sep + "0000000-000000000000001-oozie-wrkf-C@1") > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.PARENT_JOBID.toString() + sep + "0000000-000000000000001-oozie-wrkf-C") > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.JOB_URL.toString() + sep + this.conf.get("oozie.base.url") + "/?job=0000000-000000000000001-oozie-wrkf-C@1") > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.PARENT_JOB_URL.toString() + sep + this.conf.get("oozie.base.url") + "/?job=0000000-000000000000001-oozie-wrkf-C") > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf("SLA Details" + headerSep) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.NOMINAL_TIME.toString() + sep + expectedStartDate) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.EXPECTED_START_TIME.toString() + sep + expectedStartDate) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.ACTUAL_START_TIME.toString() + sep + actualStartDate) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.EXPECTED_END_TIME.toString() + sep + expectedEndDate) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.ACTUAL_END_TIME.toString() + sep + actualEndDate) > -1 ? 1 : 0) != 0);
    }

    public void testOnDurationMiss() throws Exception {
        String id = "0000000-000000000000001-oozie-wrkf-C@1";
        SLACalcStatus event = this._createSLACalcStatus(id);
        SLARegistrationBean eventBean = event.getSLARegistrationBean();
        Date expectedStartDate = DateUtils.parseDateUTC((String)"2013-01-01T00:00Z");
        Date actualStartDate = DateUtils.parseDateUTC((String)"2013-01-01T00:10Z");
        Date expectedEndDate = DateUtils.parseDateUTC((String)"2013-01-01T00:20Z");
        Date actualEndDate = DateUtils.parseDateUTC((String)"2013-01-01T00:40Z");
        long expectedDuration = expectedEndDate.getTime() - expectedStartDate.getTime();
        long actualDuration = actualEndDate.getTime() - actualStartDate.getTime();
        long expectedDurationInMins = expectedDuration / 60000L;
        long actualDurationInMins = actualDuration / 60000L;
        event.setId(id);
        eventBean.setParentId("0000000-000000000000001-oozie-wrkf-C");
        event.setEventStatus(SLAEvent.EventStatus.DURATION_MISS);
        event.setJobStatus(JobEvent.EventStatus.SUCCESS.toString());
        eventBean.setAppName("Test-SLA-Duration-Miss");
        eventBean.setUser("dummyuser");
        eventBean.setNominalTime(expectedStartDate);
        eventBean.setExpectedStart(expectedStartDate);
        eventBean.setExpectedEnd(expectedEndDate);
        eventBean.setNotificationMsg("notification of duration miss");
        eventBean.setAlertContact("alert-receiver-durationmiss@oozie.com");
        eventBean.setAppType(AppType.COORDINATOR_ACTION);
        eventBean.setExpectedStart(expectedStartDate);
        eventBean.setExpectedEnd(expectedEndDate);
        event.setActualStart(actualStartDate);
        event.setActualEnd(actualEndDate);
        eventBean.setExpectedDuration(expectedDuration);
        event.setActualDuration(actualDuration);
        this.slaEmailListener.onEndMiss((SLAEvent)event);
        MimeMessage[] msgs = this.greenMail.getReceivedMessages();
        MimeMessage msg = msgs[0];
        TestSLAEmailEventListener.assertEquals((String)msg.getFrom()[0].toString(), (String)"oozie@localhost");
        TestSLAEmailEventListener.assertEquals((String)msg.getRecipients(Message.RecipientType.TO)[0].toString(), (String)"alert-receiver-durationmiss@oozie.com");
        TestSLAEmailEventListener.assertEquals((String)msg.getSubject(), (String)("OOZIE - SLA " + SLAEvent.EventStatus.DURATION_MISS + " (AppName=Test-SLA-Duration-Miss, JobID=0000000-000000000000001-oozie-wrkf-C@1)"));
        String msgBody = msg.getContent().toString();
        String headerSep = SLAEmailEventListener.EMAIL_BODY_HEADER_SEPARATER;
        String sep = SLAEmailEventListener.EMAIL_BODY_FIELD_SEPARATER;
        String indent = SLAEmailEventListener.EMAIL_BODY_FIELD_INDENT;
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf("Status" + headerSep) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.EVENT_STATUS.toString() + sep + SLAEvent.EventStatus.DURATION_MISS.toString()) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.JOB_STATUS.toString() + sep + JobEvent.EventStatus.SUCCESS.toString()) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.NOTIFICATION_MESSAGE.toString() + sep + "notification of duration miss") > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf("Job Details" + headerSep) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.APP_TYPE.toString() + sep + AppType.COORDINATOR_ACTION) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.APP_NAME.toString() + sep + "Test-SLA-Duration-Miss") > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.USER.toString() + sep + "dummyuser") > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.JOBID.toString() + sep + "0000000-000000000000001-oozie-wrkf-C@1") > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.PARENT_JOBID.toString() + sep + "0000000-000000000000001-oozie-wrkf-C") > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.JOB_URL.toString() + sep + this.conf.get("oozie.base.url") + "/?job=0000000-000000000000001-oozie-wrkf-C@1") > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.PARENT_JOB_URL.toString() + sep + this.conf.get("oozie.base.url") + "/?job=0000000-000000000000001-oozie-wrkf-C") > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf("SLA Details" + headerSep) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.NOMINAL_TIME.toString() + sep + expectedStartDate) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.EXPECTED_START_TIME.toString() + sep + expectedStartDate) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.ACTUAL_START_TIME.toString() + sep + actualStartDate) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.EXPECTED_END_TIME.toString() + sep + expectedEndDate) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.ACTUAL_END_TIME.toString() + sep + actualEndDate) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.EXPECTED_DURATION.toString() + sep + expectedDurationInMins) > -1 ? 1 : 0) != 0);
        TestSLAEmailEventListener.assertTrue((msgBody.indexOf(indent + SLAEmailEventListener.EmailField.ACTUAL_DURATION.toString() + sep + actualDurationInMins) > -1 ? 1 : 0) != 0);
    }

    public void testUserAlertEventSetting() throws Exception {
        String id = "0000000-000000000000001-oozie-wrkf-C@1";
        SLACalcStatus event = this._createSLACalcStatus(id);
        SLARegistrationBean eventBean = event.getSLARegistrationBean();
        eventBean.setAlertEvents(SLAEvent.EventStatus.END_MISS.name());
        Date startDate = DateUtils.parseDateUTC((String)"2013-01-01T00:00Z");
        Date actualstartDate = DateUtils.parseDateUTC((String)"2013-01-01T01:00Z");
        event.setEventStatus(SLAEvent.EventStatus.START_MISS);
        event.setId(id);
        eventBean.setAppName("Test-SLA-Start-Miss");
        eventBean.setUser("dummyuser");
        eventBean.setNominalTime(startDate);
        eventBean.setExpectedStart(startDate);
        eventBean.setAlertContact("alert-receiver@oozie.com");
        event.setActualStart(actualstartDate);
        eventBean.setAppType(AppType.COORDINATOR_ACTION);
        this.slaEmailListener.onStartMiss((SLAEvent)event);
        MimeMessage[] msgs = this.greenMail.getReceivedMessages();
        TestSLAEmailEventListener.assertEquals((int)msgs.length, (int)0);
        event.setEventStatus(SLAEvent.EventStatus.DURATION_MISS);
        this.slaEmailListener.onDurationMiss((SLAEvent)event);
        msgs = this.greenMail.getReceivedMessages();
        TestSLAEmailEventListener.assertEquals((int)msgs.length, (int)0);
        event.setEventStatus(SLAEvent.EventStatus.END_MISS);
        this.slaEmailListener.onEndMiss((SLAEvent)event);
        msgs = this.greenMail.getReceivedMessages();
        TestSLAEmailEventListener.assertNotNull((Object)msgs[0]);
    }

    public void testInvalidDestAddress() throws Exception {
        String id = "0000000-000000000000001-oozie-wrkf-C@1";
        SLACalcStatus event = this._createSLACalcStatus(id);
        SLARegistrationBean eventBean = event.getSLARegistrationBean();
        Date startDate = DateUtils.parseDateUTC((String)"2013-01-01T00:00Z");
        eventBean.setAlertContact("invalidAddress");
        event.setEventStatus(SLAEvent.EventStatus.START_MISS);
        event.setId(id);
        eventBean.setAppType(AppType.COORDINATOR_ACTION);
        eventBean.setAppName("Test-SLA-Start-Miss");
        eventBean.setUser("dummyuser");
        eventBean.setExpectedStart(startDate);
        eventBean.setNotificationMsg("notification of start miss");
        eventBean.setAppType(AppType.COORDINATOR_ACTION);
        event.setActualStart(DateUtils.parseDateUTC((String)"2013-01-01T01:00Z"));
        this.slaEmailListener.onStartMiss((SLAEvent)event);
        MimeMessage[] msgs = this.greenMail.getReceivedMessages();
        TestSLAEmailEventListener.assertEquals((int)msgs.length, (int)0);
    }

    public void testNoDestAddress() throws Exception {
        String id = "0000000-000000000000001-oozie-wrkf-C@1";
        SLACalcStatus event = this._createSLACalcStatus(id);
        SLARegistrationBean eventBean = event.getSLARegistrationBean();
        Date startDate = DateUtils.parseDateUTC((String)"2013-01-01T00:00Z");
        eventBean.setAlertContact("");
        event.setEventStatus(SLAEvent.EventStatus.START_MISS);
        event.setId(id);
        eventBean.setAppType(AppType.COORDINATOR_ACTION);
        eventBean.setAppName("Test-SLA-Start-Miss");
        eventBean.setUser("dummyuser");
        eventBean.setExpectedStart(startDate);
        eventBean.setNotificationMsg("notification of start miss");
        eventBean.setAppType(AppType.COORDINATOR_ACTION);
        event.setActualStart(DateUtils.parseDateUTC((String)"2013-01-01T01:00Z"));
        this.slaEmailListener.onStartMiss((SLAEvent)event);
        MimeMessage[] msgs = this.greenMail.getReceivedMessages();
        TestSLAEmailEventListener.assertEquals((int)msgs.length, (int)0);
    }

    public void testMultipleDestAddress() throws Exception {
        String id = "0000000-000000000000001-oozie-wrkf-C@1";
        SLACalcStatus event = this._createSLACalcStatus(id);
        SLARegistrationBean eventBean = event.getSLARegistrationBean();
        Date startDate = DateUtils.parseDateUTC((String)"2013-01-01T00:00Z");
        eventBean.setAlertContact("alert-receiver1@oozie.com, alert-receiver2@oozie.com");
        event.setEventStatus(SLAEvent.EventStatus.START_MISS);
        event.setId(id);
        eventBean.setAppType(AppType.COORDINATOR_ACTION);
        eventBean.setAppName("Test-SLA-Start-Miss");
        eventBean.setUser("dummyuser");
        eventBean.setExpectedStart(startDate);
        eventBean.setNotificationMsg("notification of start miss");
        eventBean.setAppType(AppType.COORDINATOR_ACTION);
        event.setActualStart(DateUtils.parseDateUTC((String)"2013-01-01T01:00Z"));
        this.slaEmailListener.onStartMiss((SLAEvent)event);
        MimeMessage[] msgs = this.greenMail.getReceivedMessages();
        MimeMessage msg = msgs[0];
        TestSLAEmailEventListener.assertEquals((String)msg.getFrom()[0].toString(), (String)"oozie@localhost");
        TestSLAEmailEventListener.assertEquals((String)msg.getRecipients(Message.RecipientType.TO)[0].toString(), (String)"alert-receiver1@oozie.com");
        TestSLAEmailEventListener.assertEquals((String)msg.getRecipients(Message.RecipientType.TO)[1].toString(), (String)"alert-receiver2@oozie.com");
    }

    public void testBlackList() throws Exception {
        String blackListedEmail = "alert-receiver@oozie.com";
        this.slaEmailListener.addBlackList(blackListedEmail);
        String id = "0000000-000000000000001-oozie-wrkf-C@1";
        SLACalcStatus event = this._createSLACalcStatus(id);
        SLARegistrationBean eventBean = event.getSLARegistrationBean();
        event.setEventStatus(SLAEvent.EventStatus.START_MISS);
        eventBean.setAlertContact(blackListedEmail);
        eventBean.setAppType(AppType.COORDINATOR_ACTION);
        eventBean.setAppName("Test-SLA-Start-Miss");
        eventBean.setUser("dummyuser");
        eventBean.setAlertContact("alert-receiver@oozie.com");
        event.setActualStart(DateUtils.parseDateUTC((String)"2013-01-01T01:00Z"));
        this.slaEmailListener.onStartMiss((SLAEvent)event);
        MimeMessage[] msgs = this.greenMail.getReceivedMessages();
        TestSLAEmailEventListener.assertEquals((int)msgs.length, (int)0);
        Thread.sleep(1500L);
        this.slaEmailListener.onStartMiss((SLAEvent)event);
        msgs = this.greenMail.getReceivedMessages();
        TestSLAEmailEventListener.assertEquals((int)msgs.length, (int)1);
    }

    private SLACalcStatus _createSLACalcStatus(String actionId) {
        SLARegistrationBean reg = new SLARegistrationBean();
        reg.setId(actionId);
        reg.setAppType(AppType.COORDINATOR_ACTION);
        return new SLACalcStatus(reg);
    }
}

