/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.Callable;
import junit.framework.Assert;
import org.apache.oozie.servlet.DagServletTestCase;
import org.apache.oozie.servlet.MockCoordinatorEngineService;
import org.apache.oozie.servlet.MockDagEngineService;
import org.apache.oozie.servlet.V1JobServlet;
import org.apache.oozie.servlet.V2JobServlet;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class TestV2JobServlet
extends DagServletTestCase {
    private static final boolean IS_SECURITY_ENABLED = false;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testJobInfo() throws Exception {
        this.runTest("/v2/job/*", V2JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockCoordinatorEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("show", "info");
                URL url = TestV2JobServlet.this.createURL("coord-job-C-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertEquals((Object)"coord-job-C-1", (Object)obj.get((Object)"coordJobId"));
                Assert.assertEquals((String)"info", (String)MockCoordinatorEngineService.did);
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("show", "info");
                params.put("offset", "2");
                params.put("len", "50");
                url = TestV2JobServlet.this.createURL("coord-job-C-1", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertEquals((Object)"coord-job-C-1", (Object)obj.get((Object)"coordJobId"));
                Assert.assertEquals((String)"info", (String)MockCoordinatorEngineService.did);
                Assert.assertEquals((Object)MockCoordinatorEngineService.offset, (Object)new Integer(2));
                Assert.assertEquals((Object)MockCoordinatorEngineService.length, (Object)new Integer(50));
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("show", "info");
                params.put("offset", "-1");
                params.put("len", "-1");
                url = TestV2JobServlet.this.createURL("coord-job-C-1", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertEquals((Object)"coord-job-C-1", (Object)obj.get((Object)"coordJobId"));
                Assert.assertEquals((String)"info", (String)MockCoordinatorEngineService.did);
                Assert.assertEquals((Object)MockCoordinatorEngineService.offset, (Object)new Integer(1));
                Assert.assertEquals((Object)MockCoordinatorEngineService.length, (Object)new Integer(1000));
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("show", "info");
                params.put("offset", "0");
                params.put("len", "0");
                url = TestV2JobServlet.this.createURL("coord-job-C-1", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertEquals((Object)"coord-job-C-1", (Object)obj.get((Object)"coordJobId"));
                Assert.assertEquals((String)"info", (String)MockCoordinatorEngineService.did);
                Assert.assertEquals((Object)MockCoordinatorEngineService.offset, (Object)new Integer(1));
                Assert.assertEquals((Object)MockCoordinatorEngineService.length, (Object)new Integer(0));
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("show", "info");
                url = TestV2JobServlet.this.createURL("coord-job-C-" + (MockCoordinatorEngineService.coordJobs.size() + 1), params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)400, (int)conn.getResponseCode());
                Assert.assertEquals((String)"info", (String)MockCoordinatorEngineService.did);
                return null;
            }
        });
    }

    public void testGetCoordActionReruns() throws Exception {
        this.runTest("/v2/job/*", V1JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("show", "allruns");
                URL url = TestV2JobServlet.this.createURL("coord-action-C@-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                MockDagEngineService.reset();
                params.put("type", "action");
                params.put("scope", "2");
                url = TestV2JobServlet.this.createURL("coord-job-C-2", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                return null;
            }
        });
    }

    public void testCoordJobIgnore() throws Exception {
        this.runTest("/v2/job/*", V2JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("action", "ignore");
                URL url = TestV2JobServlet.this.createURL("coord-job-C-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertEquals((String)"change", (String)MockCoordinatorEngineService.did);
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("action", "ignore");
                url = TestV2JobServlet.this.createURL("coord-job-C-" + (MockCoordinatorEngineService.coordJobs.size() + 1), params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                Assert.assertEquals((int)400, (int)conn.getResponseCode());
                Assert.assertEquals((String)"change", (String)MockCoordinatorEngineService.did);
                return null;
            }
        });
    }

    public void testCoordActionIgnore() throws Exception {
        this.runTest("/v2/job/*", V2JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("action", "ignore");
                params.put("type", "action");
                params.put("scope", "1");
                URL url = TestV2JobServlet.this.createURL("coord-job-C-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertEquals((String)"ignore", (String)MockCoordinatorEngineService.did);
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("action", "ignore");
                params.put("type", "action");
                params.put("scope", "1");
                url = TestV2JobServlet.this.createURL("coord-job-C-" + (MockCoordinatorEngineService.coordJobs.size() + 1), params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                Assert.assertEquals((int)400, (int)conn.getResponseCode());
                Assert.assertEquals((String)"ignore", (String)MockCoordinatorEngineService.did);
                return null;
            }
        });
    }

    public void testJobStatus() throws Exception {
        this.runTest("/v2/job/*", V2JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("show", "status");
                URL url = TestV2JobServlet.this.createURL("job-1-W", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertEquals((Object)"SUCCEEDED", (Object)obj.get((Object)"status"));
                Assert.assertEquals((String)"status", (String)MockDagEngineService.did);
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("show", "status");
                url = TestV2JobServlet.this.createURL("coord-job-C-1", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertEquals((Object)"RUNNING", (Object)obj.get((Object)"status"));
                Assert.assertEquals((String)"status", (String)MockCoordinatorEngineService.did);
                return null;
            }
        });
    }

    static {
        new V2JobServlet();
    }
}

