/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import junit.framework.Assert;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.DagEngine;
import org.apache.oozie.service.DagEngineService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.DagServletTestCase;
import org.apache.oozie.servlet.MockDagEngineService;
import org.apache.oozie.servlet.V0JobsServlet;
import org.apache.oozie.util.XConfiguration;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class TestJobsServlet
extends DagServletTestCase {
    private static final boolean IS_SECURITY_ENABLED = false;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testSubmit() throws Exception {
        this.runTest("/v0/jobs", V0JobsServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                String appPath = TestJobsServlet.this.getFsTestCaseDir().toString() + "/app";
                FileSystem fs = TestJobsServlet.this.getFileSystem();
                Path jobXmlPath = new Path(appPath, "workflow.xml");
                fs.create(jobXmlPath);
                int wfCount = MockDagEngineService.workflows.size();
                XConfiguration jobConf = new XConfiguration();
                jobConf.set("user.name", TestJobsServlet.getTestUser());
                jobConf.set("oozie.wf.application.path", appPath);
                HashMap<String, String> params = new HashMap<String, String>();
                URL url = TestJobsServlet.this.createURL("", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                jobConf.writeXml(conn.getOutputStream());
                Assert.assertEquals((int)201, (int)conn.getResponseCode());
                JSONObject obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertEquals((Object)("job-" + wfCount + "-W"), (Object)obj.get((Object)"id"));
                Assert.assertFalse((boolean)MockDagEngineService.started.get(wfCount));
                ++wfCount;
                jobConf = new XConfiguration();
                jobConf.set("user.name", TestJobsServlet.getTestUser());
                jobConf.set("oozie.wf.application.path", appPath);
                params = new HashMap();
                params.put("action", "start");
                url = TestJobsServlet.this.createURL("", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                jobConf.writeXml(conn.getOutputStream());
                Assert.assertEquals((int)201, (int)conn.getResponseCode());
                obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertEquals((Object)("job-" + wfCount + "-W"), (Object)obj.get((Object)"id"));
                Assert.assertTrue((boolean)MockDagEngineService.started.get(wfCount));
                Services services = Services.get();
                DagEngine de = ((DagEngineService)services.get(DagEngineService.class)).getDagEngine(TestJobsServlet.getTestUser());
                StringReader sr = new StringReader(de.getJob("job-" + wfCount).getConf());
                XConfiguration conf1 = new XConfiguration((Reader)sr);
                return null;
            }
        });
    }

    public void testJobs() throws Exception {
        this.runTest("/v0/jobs", V0JobsServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int i;
                MockDagEngineService.reset();
                int wfCount = MockDagEngineService.workflows.size();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("filter", "name=x");
                URL url = TestJobsServlet.this.createURL("", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                JSONArray array = (JSONArray)json.get((Object)"workflows");
                Assert.assertEquals((int)4, (int)array.size());
                for (i = 0; i < 4; ++i) {
                    Assert.assertEquals((Object)("job-" + i + "-W"), (Object)((JSONObject)array.get(i)).get((Object)"id"));
                    Assert.assertNotNull((Object)((JSONObject)array.get(i)).get((Object)"appPath"));
                }
                params = new HashMap();
                params.put("filter", "name=x");
                params.put("offset", "2");
                params.put("len", "100");
                url = TestJobsServlet.this.createURL("", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                array = (JSONArray)json.get((Object)"workflows");
                Assert.assertEquals((int)4, (int)array.size());
                for (i = 0; i < 4; ++i) {
                    Assert.assertEquals((Object)("job-" + i + "-W"), (Object)((JSONObject)array.get(i)).get((Object)"id"));
                    Assert.assertNotNull((Object)((JSONObject)array.get(i)).get((Object)"appPath"));
                }
                params = new HashMap();
                params.put("external-id", "external-valid");
                url = TestJobsServlet.this.createURL("", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertEquals((Object)"id-valid", (Object)obj.get((Object)"id"));
                params = new HashMap();
                params.put("external-id", "external-invalid");
                url = TestJobsServlet.this.createURL("", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertNull((Object)obj.get((Object)"id"));
                return null;
            }
        });
    }

    public void testDiffUser() throws Exception {
        this.runTest("/v0/jobs", V0JobsServletWithDefUser.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                String appPath = TestJobsServlet.this.getFsTestCaseDir().toString() + "/app";
                FileSystem fs = TestJobsServlet.this.getFileSystem();
                Path jobXmlPath = new Path(appPath, "workflow.xml");
                fs.create(jobXmlPath);
                XConfiguration jobConf = new XConfiguration();
                jobConf.set("user.name", TestJobsServlet.getTestUser());
                jobConf.set("oozie.wf.application.path", appPath);
                HashMap<String, String> params = new HashMap<String, String>();
                URL url = TestJobsServlet.this.createURL("", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                jobConf.writeXml(conn.getOutputStream());
                Assert.assertEquals((int)201, (int)conn.getResponseCode());
                Assert.assertEquals((String)TestJobsServlet.getTestUser2(), (String)MockDagEngineService.user);
                return null;
            }
        });
    }

    static {
        new V0JobsServlet();
    }

    public static class V0JobsServletWithDefUser
    extends V0JobsServlet {
        protected String getUser(HttpServletRequest request) {
            return TestJobsServlet.getTestUser2();
        }
    }
}

