/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.Callable;
import junit.framework.Assert;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.PseudoAuthenticator;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.oozie.cli.OozieCLI;
import org.apache.oozie.client.AuthOozieClient;
import org.apache.oozie.client.HeaderTestingVersionServlet;
import org.apache.oozie.service.ForTestAuthorizationService;
import org.apache.oozie.service.ForTestWorkflowStoreService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.AuthFilter;
import org.apache.oozie.servlet.HostnameFilter;
import org.apache.oozie.servlet.MockCoordinatorEngineService;
import org.apache.oozie.servlet.MockDagEngineService;
import org.apache.oozie.servlet.V1AdminServlet;
import org.apache.oozie.test.EmbeddedServletContainer;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;

public class TestAuthFilterAuthOozieClient
extends XTestCase {
    private static final String SECRET = "secret";
    private EmbeddedServletContainer container;

    protected String getContextURL() {
        return this.container.getContextURL();
    }

    protected URL createURL(String servletPath, String resource, Map<String, String> parameters) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.container.getServletURL(servletPath));
        if (resource != null && resource.length() > 0) {
            sb.append("/").append(resource);
        }
        if (parameters.size() > 0) {
            String separator = "?";
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                sb.append(separator).append(URLEncoder.encode(param.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(param.getValue(), "UTF-8"));
                separator = "&";
            }
        }
        return new URL(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest(Callable<Void> assertions, Configuration additionalConf) throws Exception {
        Services services = new Services();
        try {
            services.init();
            if (additionalConf != null) {
                for (Map.Entry prop : additionalConf) {
                    Services.get().getConf().set((String)prop.getKey(), (String)prop.getValue());
                }
            }
            Services.get().setService(ForTestAuthorizationService.class);
            Services.get().setService(ForTestWorkflowStoreService.class);
            Services.get().setService(MockDagEngineService.class);
            Services.get().setService(MockCoordinatorEngineService.class);
            this.container = new EmbeddedServletContainer("oozie");
            this.container.addServletEndpoint("/versions", HeaderTestingVersionServlet.class);
            String version = "/v2";
            this.container.addServletEndpoint(version + "/admin/*", V1AdminServlet.class);
            this.container.addFilter("*", HostnameFilter.class);
            this.container.addFilter("/*", AuthFilter.class);
            this.container.start();
            assertions.call();
        }
        finally {
            if (this.container != null) {
                this.container.stop();
            }
            services.destroy();
            this.container = null;
        }
    }

    public void testClientWithAnonymous() throws Exception {
        Configuration conf = new Configuration(false);
        conf.set("oozie.authentication.simple.anonymous.allowed", "true");
        this.runTest(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestAuthFilterAuthOozieClient.this.getContextURL();
                String[] args = new String[]{"admin", "-status", "-oozie", oozieUrl};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                return null;
            }
        }, conf);
    }

    public void testClientWithoutAnonymous() throws Exception {
        Configuration conf = new Configuration(false);
        conf.set("oozie.authentication.simple.anonymous.allowed", "false");
        this.runTest(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestAuthFilterAuthOozieClient.this.getContextURL();
                String[] args = new String[]{"admin", "-status", "-oozie", oozieUrl};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                return null;
            }
        }, conf);
    }

    public void testClientWithCustomAuthenticator() throws Exception {
        this.setSystemProperty("authenticator.class", Authenticator4Test.class.getName());
        Configuration conf = new Configuration(false);
        conf.set("oozie.authentication.simple.anonymous.allowed", "false");
        Authenticator4Test.USED = false;
        this.runTest(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestAuthFilterAuthOozieClient.this.getContextURL();
                String[] args = new String[]{"admin", "-status", "-oozie", oozieUrl};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                return null;
            }
        }, conf);
        TestAuthFilterAuthOozieClient.assertTrue((boolean)Authenticator4Test.USED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClientAuthTokenCache() throws Exception {
        Configuration conf;
        block6: {
            conf = new Configuration(false);
            try {
                if (Class.forName("org.apache.hadoop.security.authentication.util.FileSignerSecretProvider") == null) break block6;
                String secretFile = this.getTestCaseConfDir() + "/auth-secret";
                conf.set("oozie.authentication.signature.secret.file", secretFile);
                try (FileWriter fw = null;){
                    fw = new FileWriter(secretFile);
                    fw.write(SECRET);
                }
            }
            catch (ClassNotFoundException secretFile) {
                // empty catch block
            }
        }
        conf.set("oozie.authentication.signature.secret", SECRET);
        conf.set("oozie.authentication.simple.anonymous.allowed", "false");
        AuthOozieClient.AUTH_TOKEN_CACHE_FILE.delete();
        TestAuthFilterAuthOozieClient.assertFalse((boolean)AuthOozieClient.AUTH_TOKEN_CACHE_FILE.exists());
        this.runTest(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestAuthFilterAuthOozieClient.this.getContextURL();
                String[] args = new String[]{"admin", "-status", "-oozie", oozieUrl};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                return null;
            }
        }, conf);
        TestAuthFilterAuthOozieClient.assertFalse((boolean)AuthOozieClient.AUTH_TOKEN_CACHE_FILE.exists());
        this.setSystemProperty("oozie.auth.token.cache", "true");
        AuthOozieClient.AUTH_TOKEN_CACHE_FILE.delete();
        TestAuthFilterAuthOozieClient.assertFalse((boolean)AuthOozieClient.AUTH_TOKEN_CACHE_FILE.exists());
        this.runTest(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestAuthFilterAuthOozieClient.this.getContextURL();
                String[] args = new String[]{"admin", "-status", "-oozie", oozieUrl};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                return null;
            }
        }, conf);
        TestAuthFilterAuthOozieClient.assertTrue((boolean)AuthOozieClient.AUTH_TOKEN_CACHE_FILE.exists());
        String currentCache = IOUtils.getReaderAsString((Reader)new FileReader(AuthOozieClient.AUTH_TOKEN_CACHE_FILE), (int)-1);
        this.setSystemProperty("oozie.auth.token.cache", "true");
        this.runTest(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestAuthFilterAuthOozieClient.this.getContextURL();
                String[] args = new String[]{"admin", "-status", "-oozie", oozieUrl};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                return null;
            }
        }, conf);
        TestAuthFilterAuthOozieClient.assertTrue((boolean)AuthOozieClient.AUTH_TOKEN_CACHE_FILE.exists());
        String newCache = IOUtils.getReaderAsString((Reader)new FileReader(AuthOozieClient.AUTH_TOKEN_CACHE_FILE), (int)-1);
        TestAuthFilterAuthOozieClient.assertEquals((String)currentCache, (String)newCache);
        currentCache = TestAuthFilterAuthOozieClient.writeTokenCache(System.currentTimeMillis() + 300000L);
        this.setSystemProperty("oozie.auth.token.cache", "true");
        this.runTest(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestAuthFilterAuthOozieClient.this.getContextURL();
                String[] args = new String[]{"admin", "-status", "-oozie", oozieUrl};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                return null;
            }
        }, conf);
        TestAuthFilterAuthOozieClient.assertTrue((boolean)AuthOozieClient.AUTH_TOKEN_CACHE_FILE.exists());
        newCache = IOUtils.getReaderAsString((Reader)new FileReader(AuthOozieClient.AUTH_TOKEN_CACHE_FILE), (int)-1);
        TestAuthFilterAuthOozieClient.assertFalse((String)"Almost expired token should have been updated but was not", (boolean)currentCache.equals(newCache));
        currentCache = TestAuthFilterAuthOozieClient.writeTokenCache(System.currentTimeMillis() - 1000L);
        this.setSystemProperty("oozie.auth.token.cache", "true");
        this.runTest(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestAuthFilterAuthOozieClient.this.getContextURL();
                String[] args = new String[]{"admin", "-status", "-oozie", oozieUrl};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                return null;
            }
        }, conf);
        TestAuthFilterAuthOozieClient.assertTrue((boolean)AuthOozieClient.AUTH_TOKEN_CACHE_FILE.exists());
        newCache = IOUtils.getReaderAsString((Reader)new FileReader(AuthOozieClient.AUTH_TOKEN_CACHE_FILE), (int)-1);
        TestAuthFilterAuthOozieClient.assertFalse((String)"Expired token should have been updated but was not", (boolean)currentCache.equals(newCache));
    }

    private static String writeTokenCache(long expirationTime) throws Exception {
        AuthenticationToken authToken = new AuthenticationToken(TestAuthFilterAuthOozieClient.getOozieUser(), TestAuthFilterAuthOozieClient.getOozieUser(), "simple");
        authToken.setExpires(expirationTime);
        String signedTokenStr = TestAuthFilterAuthOozieClient.computeSignature(SECRET.getBytes(Charset.forName("UTF-8")), authToken.toString());
        signedTokenStr = authToken.toString() + "&s=" + signedTokenStr;
        PrintWriter pw = new PrintWriter(AuthOozieClient.AUTH_TOKEN_CACHE_FILE);
        pw.write(signedTokenStr);
        pw.close();
        return signedTokenStr;
    }

    private static String computeSignature(byte[] secret, String str) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA");
        md.update(str.getBytes());
        md.update(secret);
        byte[] digest = md.digest();
        return new Base64(0).encodeToString(digest);
    }

    public void testClientAuthMethod() throws Exception {
        this.runTest(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestAuthFilterAuthOozieClient.this.getContextURL();
                String[] args = new String[]{"admin", "-status", "-oozie", oozieUrl, "-auth", "SIMPLE"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                return null;
            }
        }, null);
        this.runTest(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestAuthFilterAuthOozieClient.this.getContextURL();
                String[] args = new String[]{"admin", "-status", "-oozie", oozieUrl, "-auth", "fake"};
                Assert.assertEquals((int)-1, (int)new OozieCLI().run(args));
                return null;
            }
        }, null);
    }

    public static class Authenticator4Test
    extends PseudoAuthenticator {
        private static boolean USED = false;

        public void authenticate(URL url, AuthenticatedURL.Token token) throws IOException, AuthenticationException {
            USED = true;
            super.authenticate(url, token);
        }
    }
}

