/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oozie.servlet.JsonRestServlet;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class MyJsonRestServlet
extends JsonRestServlet {
    static JsonRestServlet.ResourceInfo[] EMPTY = new JsonRestServlet.ResourceInfo[0];
    static JsonRestServlet.ResourceInfo[] NO_RESOURCE_NO_PARAMS = new JsonRestServlet.ResourceInfo[]{new JsonRestServlet.ResourceInfo("", Arrays.asList("GET"), Collections.EMPTY_LIST)};
    static JsonRestServlet.ResourceInfo[] PARAMS_REQUIRED = new JsonRestServlet.ResourceInfo[]{new JsonRestServlet.ResourceInfo("", Arrays.asList("GET"), Arrays.asList(new JsonRestServlet.ParameterInfo("required", Boolean.class, true, Arrays.asList("GET")), new JsonRestServlet.ParameterInfo("optional", Boolean.class, false, Arrays.asList("GET"))))};
    static JsonRestServlet.ResourceInfo[] PARAM_TYPES = new JsonRestServlet.ResourceInfo[]{new JsonRestServlet.ResourceInfo("", Arrays.asList("GET"), Arrays.asList(new JsonRestServlet.ParameterInfo("boolean", Boolean.class, false, Arrays.asList("GET")), new JsonRestServlet.ParameterInfo("integer", Integer.class, false, Arrays.asList("GET")), new JsonRestServlet.ParameterInfo("string", String.class, false, Arrays.asList("GET"))))};
    static JsonRestServlet.ResourceInfo[] RESOURCE_GET_POST_PARAM_GET = new JsonRestServlet.ResourceInfo[]{new JsonRestServlet.ResourceInfo("", Arrays.asList("GET", "POST"), Arrays.asList(new JsonRestServlet.ParameterInfo("param", Boolean.class, true, Arrays.asList("GET"))))};
    static JsonRestServlet.ResourceInfo[] FIXED_RESOURCE = new JsonRestServlet.ResourceInfo[]{new JsonRestServlet.ResourceInfo("resource", Arrays.asList("GET"), Collections.EMPTY_LIST)};
    static JsonRestServlet.ResourceInfo[] WILDCARD_RESOURCE = new JsonRestServlet.ResourceInfo[]{new JsonRestServlet.ResourceInfo("*", Arrays.asList("GET", "PUT"), Arrays.asList(new JsonRestServlet.ParameterInfo("action", String.class, false, Arrays.asList("PUT"))))};
    static JsonRestServlet.ResourceInfo[] MULTIPLE_RESOURCES = new JsonRestServlet.ResourceInfo[]{new JsonRestServlet.ResourceInfo("resource1", Arrays.asList("GET"), Collections.EMPTY_LIST), new JsonRestServlet.ResourceInfo("resource2", Arrays.asList("POST"), Collections.EMPTY_LIST)};
    static JsonRestServlet.ResourceInfo[] MULTIPLE_RESOURCES_NO_RESOURCE = new JsonRestServlet.ResourceInfo[]{new JsonRestServlet.ResourceInfo("resource1", Arrays.asList("GET"), Collections.EMPTY_LIST), new JsonRestServlet.ResourceInfo("resource2", Arrays.asList("GET"), Collections.EMPTY_LIST), new JsonRestServlet.ResourceInfo("", Arrays.asList("POST"), Collections.EMPTY_LIST)};
    static JsonRestServlet.ResourceInfo[] MULTIPLE_RESOURCES_WILDCARD = new JsonRestServlet.ResourceInfo[]{new JsonRestServlet.ResourceInfo("resource1", Arrays.asList("GET"), Collections.EMPTY_LIST), new JsonRestServlet.ResourceInfo("resource2", Arrays.asList("GET"), Collections.EMPTY_LIST), new JsonRestServlet.ResourceInfo("*", Arrays.asList("POST"), Collections.EMPTY_LIST)};
    static JsonRestServlet.ResourceInfo[] CONTENT_TYPE_JSON_CRON_TEST = new JsonRestServlet.ResourceInfo[]{new JsonRestServlet.ResourceInfo("", Arrays.asList("GET"), Arrays.asList(new JsonRestServlet.ParameterInfo("json", String.class, true, Arrays.asList("GET"))))};
    static JsonRestServlet.ResourceInfo[] ACTIVE = NO_RESOURCE_NO_PARAMS;

    public MyJsonRestServlet() {
        super("my", ACTIVE);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (ACTIVE != CONTENT_TYPE_JSON_CRON_TEST) {
            response.setStatus(200);
        } else {
            try {
                this.stopCron();
                this.validateContentType(request, "application/xml");
            }
            finally {
                this.startCron();
            }
            if (request.getParameter("json").equals("object")) {
                JSONObject json = new JSONObject();
                json.put((Object)"a", (Object)"object");
                this.sendJsonResponse(response, 200, (JSONStreamAware)json);
            } else if (request.getParameter("json").equals("array")) {
                JSONArray json = new JSONArray();
                json.add((Object)"array");
                this.sendJsonResponse(response, 200, (JSONStreamAware)json);
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(200);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String jobId = this.getResourceName(request);
        String action = request.getParameter("action");
        if (action == null || action.isEmpty()) {
            response.setStatus(400);
        }
        if (jobId.isEmpty()) {
            throw new IllegalArgumentException("Job Id cannot be empty " + jobId);
        }
    }
}

