/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.oozie.service.ForTestAuthorizationService;
import org.apache.oozie.service.ForTestWorkflowStoreService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.AuthFilter;
import org.apache.oozie.servlet.HostnameFilter;
import org.apache.oozie.servlet.MockCoordinatorEngineService;
import org.apache.oozie.servlet.MockDagEngineService;
import org.apache.oozie.test.EmbeddedServletContainer;
import org.apache.oozie.test.XDataTestCase;

public abstract class DagServletTestCase
extends XDataTestCase {
    private EmbeddedServletContainer container;
    private String servletPath;

    protected String getContextURL() {
        return this.container.getContextURL();
    }

    protected URL createURL(String servletPath, String resource, Map<String, String> parameters) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.container.getServletURL(servletPath));
        if (resource != null && resource.length() > 0) {
            sb.append("/").append(resource);
        }
        if (parameters.size() > 0) {
            String separator = "?";
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                sb.append(separator).append(URLEncoder.encode(param.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(param.getValue(), "UTF-8"));
                separator = "&";
            }
        }
        return new URL(sb.toString());
    }

    protected URL createURL(String resource, Map<String, String> parameters) throws Exception {
        return this.createURL(this.servletPath, resource, parameters);
    }

    protected void runTest(String servletPath, Class servletClass, boolean securityEnabled, Callable<Void> assertions) throws Exception {
        this.runTest(new String[]{servletPath}, new Class[]{servletClass}, securityEnabled, assertions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest(String[] servletPath, Class[] servletClass, boolean securityEnabled, Callable<Void> assertions) throws Exception {
        Services services = new Services();
        this.servletPath = servletPath[0];
        try {
            String proxyUser = DagServletTestCase.getTestUser();
            services.getConf().set("oozie.service.ProxyUserService.proxyuser." + proxyUser + ".hosts", "*");
            services.getConf().set("oozie.service.ProxyUserService.proxyuser." + proxyUser + ".groups", "*");
            services.init();
            services.getConf().setBoolean("oozie.service.AuthorizationService.security.enabled", securityEnabled);
            Services.get().setService(ForTestAuthorizationService.class);
            Services.get().setService(ForTestWorkflowStoreService.class);
            Services.get().setService(MockDagEngineService.class);
            Services.get().setService(MockCoordinatorEngineService.class);
            this.container = new EmbeddedServletContainer("oozie");
            for (int i = 0; i < servletPath.length; ++i) {
                this.container.addServletEndpoint(servletPath[i], servletClass[i]);
            }
            this.container.addFilter("*", HostnameFilter.class);
            this.container.addFilter("*", AuthFilter.class);
            this.setSystemProperty("user.name", DagServletTestCase.getTestUser());
            this.container.start();
            assertions.call();
        }
        finally {
            this.servletPath = null;
            if (this.container != null) {
                this.container.stop();
            }
            services.destroy();
            this.container = null;
        }
    }
}

