/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.oozie.BulkResponseInfo;
import org.apache.oozie.BundleEngine;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.rest.BulkResponseImpl;
import org.apache.oozie.executor.jpa.BulkJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.service.ZKLocksService;
import org.apache.oozie.service.ZKUUIDService;
import org.apache.oozie.service.ZKUUIDServiceWithException;
import org.apache.oozie.test.ZKXTestCase;
import org.apache.oozie.util.ZKUtils;

public class TestZKUUIDService
extends ZKXTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ZKUUIDService.setMaxSequence((long)9999990L);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRegisterUnregister() throws Exception {
        TestZKUUIDService.assertEquals((int)0, (int)ZKUtils.getUsers().size());
        ZKUUIDService zkUUUIDService = new ZKUUIDService();
        try {
            zkUUUIDService.init(Services.get());
            TestZKUUIDService.assertEquals((int)1, (int)ZKUtils.getUsers().size());
            TestZKUUIDService.assertEquals((Object)zkUUUIDService, ZKUtils.getUsers().iterator().next());
            zkUUUIDService.destroy();
            TestZKUUIDService.assertEquals((int)0, (int)ZKUtils.getUsers().size());
        }
        finally {
            zkUUUIDService.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIDGeneration() throws Exception {
        ZKUUIDService uuid = new ZKUUIDService();
        try {
            this.setSystemProperty("oozie.service.UUIDService.generator", "counter");
            uuid.init(Services.get());
            String id = uuid.generateId(UUIDService.ApplicationType.WORKFLOW);
            TestZKUUIDService.assertTrue((boolean)id.startsWith("0000000-"));
            for (int i = 0; i < 1000; ++i) {
                id = uuid.generateId(UUIDService.ApplicationType.WORKFLOW);
            }
            TestZKUUIDService.assertTrue((boolean)id.startsWith("0001000-"));
        }
        finally {
            uuid.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipleIDGeneration() throws Exception {
        ZKUUIDService uuid1 = new ZKUUIDService();
        ZKUUIDService uuid2 = new ZKUUIDService();
        try {
            this.setSystemProperty("oozie.service.UUIDService.generator", "counter");
            uuid1.init(Services.get());
            uuid2.init(Services.get());
            for (int i = 0; i < 1000; i += 2) {
                String id1 = uuid1.generateId(UUIDService.ApplicationType.WORKFLOW);
                String id2 = uuid2.generateId(UUIDService.ApplicationType.WORKFLOW);
                TestZKUUIDService.assertEquals((int)Integer.parseInt(id1.substring(0, 7)), (int)i);
                TestZKUUIDService.assertEquals((int)Integer.parseInt(id2.substring(0, 7)), (int)(i + 1));
            }
        }
        finally {
            uuid1.destroy();
            uuid2.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipleIDGeneration_withMultiThread() throws Exception {
        int size = 10000;
        final boolean[] result = new boolean[10000];
        Arrays.fill(result, false);
        final ZKUUIDService uuid1 = new ZKUUIDService();
        final ZKUUIDService uuid2 = new ZKUUIDService();
        this.setSystemProperty("oozie.service.UUIDService.generator", "counter");
        uuid1.init(Services.get());
        uuid2.init(Services.get());
        try {
            Thread t1 = new Thread(){

                @Override
                public void run() {
                    for (int i = 0; i < 5000; ++i) {
                        String id = uuid1.generateId(UUIDService.ApplicationType.WORKFLOW);
                        TestZKUUIDService.this.log.info("[Thread-1] Generated id: {0}", new Object[]{id});
                        int index = Integer.parseInt(id.substring(0, 7));
                        result[index] = true;
                    }
                }
            };
            Thread t2 = new Thread(){

                @Override
                public void run() {
                    for (int i = 0; i < 5000; ++i) {
                        String id = uuid2.generateId(UUIDService.ApplicationType.WORKFLOW);
                        TestZKUUIDService.this.log.info("[Thread-2] Generated id: {0}", new Object[]{id});
                        int index = Integer.parseInt(id.substring(0, 7));
                        result[index] = true;
                    }
                }
            };
            t1.start();
            t2.start();
            t1.join();
            t2.join();
            for (int i = 0; i < 10000; ++i) {
                TestZKUUIDService.assertTrue((String)("Array index " + i + " is not set to true"), (boolean)result[i]);
            }
        }
        finally {
            uuid1.destroy();
            uuid2.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResetSequence() throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmssSSS");
        Services service = Services.get();
        service.setService(ZKLocksService.class);
        ZKUUIDService uuid = new ZKUUIDService();
        try {
            this.setSystemProperty("oozie.service.UUIDService.generator", "counter");
            ZKUUIDService.setMaxSequence((long)900L);
            uuid.init(service);
            String id = uuid.generateId(UUIDService.ApplicationType.WORKFLOW);
            Date d = dateFormat.parse(id.split("-")[1]);
            TestZKUUIDService.assertTrue((boolean)id.startsWith("0000000-"));
            for (int i = 0; i < 1000; ++i) {
                id = uuid.generateId(UUIDService.ApplicationType.WORKFLOW);
            }
            TestZKUUIDService.assertTrue((boolean)id.startsWith("0000100-"));
            Date newDate = dateFormat.parse(id.split("-")[1]);
            TestZKUUIDService.assertTrue((boolean)newDate.after(d));
        }
        finally {
            uuid.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResetSequence_withMultiThread() throws Exception {
        Services service = Services.get();
        service.setService(ZKLocksService.class);
        final AtomicInteger[] result = new AtomicInteger[5000];
        final ZKUUIDService uuid1 = new ZKUUIDService();
        final ZKUUIDService uuid2 = new ZKUUIDService();
        this.setSystemProperty("oozie.service.UUIDService.generator", "counter");
        uuid1.init(service);
        uuid2.init(service);
        ZKUUIDService.setMaxSequence((long)5000L);
        for (int i = 0; i < 5000; ++i) {
            result[i] = new AtomicInteger(0);
        }
        try {
            Thread t1 = new Thread(){

                @Override
                public void run() {
                    for (int i = 0; i < 5000; ++i) {
                        String id = uuid1.generateId(UUIDService.ApplicationType.WORKFLOW);
                        int index = Integer.parseInt(id.substring(0, 7));
                        result[index].incrementAndGet();
                    }
                }
            };
            Thread t2 = new Thread(){

                @Override
                public void run() {
                    for (int i = 0; i < 5000; ++i) {
                        String id = uuid2.generateId(UUIDService.ApplicationType.WORKFLOW);
                        int index = Integer.parseInt(id.substring(0, 7));
                        result[index].incrementAndGet();
                    }
                }
            };
            t1.start();
            t2.start();
            t1.join();
            t2.join();
            for (int i = 0; i < 5000; ++i) {
                TestZKUUIDService.assertEquals((int)result[i].get(), (int)2);
            }
        }
        finally {
            uuid1.destroy();
            uuid2.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBulkJobForZKUUIDService() throws Exception {
        Services service = Services.get();
        ZKUUIDService uuid = new ZKUUIDService();
        try {
            this.setSystemProperty("oozie.service.UUIDService.generator", "counter");
            uuid.init(service);
            String bundleId = uuid.generateId(UUIDService.ApplicationType.BUNDLE);
            BundleJobBean bundle = this.createBundleJob(bundleId, Job.Status.SUCCEEDED, false);
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            BundleJobInsertJPAExecutor bundleInsertjpa = new BundleJobInsertJPAExecutor(bundle);
            jpaService.execute((JPAExecutor)bundleInsertjpa);
            this.addCoordForBulkMonitor(bundleId);
            String request = "bundle=" + bundleId;
            BulkJPAExecutor bulkjpa = new BulkJPAExecutor(BundleEngine.parseBulkFilter((String)request), 1, 1);
            try {
                BulkResponseInfo response = (BulkResponseInfo)jpaService.execute((JPAExecutor)bulkjpa);
                TestZKUUIDService.assertEquals((String)((BulkResponseImpl)response.getResponses().get(0)).getBundle().getId(), (String)bundleId);
            }
            catch (JPAExecutorException jex) {
                TestZKUUIDService.fail();
            }
        }
        finally {
            uuid.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFallback() throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmssSSS");
        Services service = Services.get();
        ZKUUIDServiceWithException uuid = new ZKUUIDServiceWithException();
        try {
            this.setSystemProperty("oozie.service.UUIDService.generator", "counter");
            uuid.init(service);
            String id = uuid.generateId(UUIDService.ApplicationType.BUNDLE);
            TestZKUUIDService.assertTrue((boolean)id.startsWith("0000000-"));
            id = uuid.generateId(UUIDService.ApplicationType.BUNDLE);
            TestZKUUIDService.assertTrue((boolean)id.startsWith("0000001-"));
            id = uuid.generateId(UUIDService.ApplicationType.BUNDLE);
            TestZKUUIDService.assertTrue((boolean)id.startsWith("0000002-"));
            id = uuid.generateId(UUIDService.ApplicationType.BUNDLE);
            TestZKUUIDService.assertTrue((boolean)id.startsWith("0000003-"));
            id = uuid.generateId(UUIDService.ApplicationType.BUNDLE);
            TestZKUUIDService.assertTrue((boolean)id.startsWith("0000004-"));
            uuid.setThrowException();
            Date beforeDate = new Date();
            Thread.sleep(2000L);
            id = uuid.generateId(UUIDService.ApplicationType.BUNDLE);
            TestZKUUIDService.assertTrue((boolean)id.startsWith("0000000-"));
            TestZKUUIDService.assertTrue((boolean)dateFormat.parse(id.split("-")[1]).after(beforeDate));
            beforeDate = new Date();
            Thread.sleep(2000L);
            id = uuid.generateId(UUIDService.ApplicationType.BUNDLE);
            TestZKUUIDService.assertTrue((boolean)id.startsWith("0000001-"));
            TestZKUUIDService.assertTrue((boolean)dateFormat.parse(id.split("-")[1]).after(beforeDate));
            uuid.resetThrowException();
            beforeDate = new Date();
            Thread.sleep(2000L);
            id = uuid.generateId(UUIDService.ApplicationType.BUNDLE);
            TestZKUUIDService.assertTrue((boolean)id.startsWith("0000005-"));
            TestZKUUIDService.assertTrue((boolean)dateFormat.parse(id.split("-")[1]).before(beforeDate));
        }
        finally {
            uuid.destroy();
        }
    }
}

