/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.bundle.BundleJobResumeXCommand;
import org.apache.oozie.command.bundle.BundleJobSuspendXCommand;
import org.apache.oozie.command.bundle.BundleKillXCommand;
import org.apache.oozie.command.coord.CoordKillXCommand;
import org.apache.oozie.command.coord.CoordResumeXCommand;
import org.apache.oozie.command.coord.CoordSuspendXCommand;
import org.apache.oozie.executor.jpa.BundleActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleActionQueryExecutor;
import org.apache.oozie.executor.jpa.BundleJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobQueryExecutor;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobInsertJPAExecutor;
import org.apache.oozie.lock.LockToken;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.LiteWorkflowStoreService;
import org.apache.oozie.service.MemoryLocksService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.StatusTransitService;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.StartNodeDef;

public class TestStatusTransitService
extends XDataTestCase {
    private Services services;
    private String[] excludedServices = new String[]{"org.apache.oozie.service.StatusTransitService", "org.apache.oozie.service.PauseTransitService", "org.apache.oozie.service.CoordMaterializeTriggerService", "org.apache.oozie.service.RecoveryService"};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordStatusTransitServiceSucceeded() throws Exception {
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, true, true, 3);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.sleep(1000);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestStatusTransitService.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
    }

    public void testCoordStatusTransitServiceDoneWithError() throws Exception {
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, true, true, 3);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.KILLED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.sleep(1000);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestStatusTransitService.assertEquals((Object)Job.Status.DONEWITHERROR, (Object)coordJob.getStatus());
    }

    public void testCoordStatusTransitServiceNoDoneWithErrorForBackwardSupport() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.coord.status", "true");
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, true, true, 3);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestStatusTransitService.assertNotNull((Object)jpaService);
        coordJob.setAppNamespace("uri:oozie:coordinator:0.1");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_APPNAMESPACE, coordJob);
        this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.KILLED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(coordJob.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(coordJob.getId(), 3, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.sleep(1000);
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestStatusTransitService.assertEquals((Object)Job.Status.RUNNING, (Object)coordJob.getStatus());
    }

    public void testCoordStatusTransitServiceKilledByUser1() throws Exception {
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, false, 1);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        final String wfJobId = wfJob.getId();
        CoordinatorActionBean coordAction = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", wfJobId, "RUNNING", 0);
        new CoordKillXCommand(coordJob.getId()).call();
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                WorkflowJobGetJPAExecutor wfGetCmd = new WorkflowJobGetJPAExecutor(wfJobId);
                WorkflowJobBean wfBean = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfGetCmd);
                return wfBean.getStatusStr().equals("KILLED");
            }
        });
        TestStatusTransitService.assertNotNull((Object)jpaService);
        final CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        CoordActionGetJPAExecutor coordActionGetCmd = new CoordActionGetJPAExecutor(coordAction.getId());
        WorkflowJobGetJPAExecutor wfGetCmd = new WorkflowJobGetJPAExecutor(wfJobId);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        coordAction = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfGetCmd);
        TestStatusTransitService.assertEquals((Object)Job.Status.KILLED, (Object)coordJob.getStatus());
        TestStatusTransitService.assertEquals((Object)CoordinatorAction.Status.KILLED, (Object)coordAction.getStatus());
        TestStatusTransitService.assertEquals((Object)WorkflowJob.Status.KILLED, (Object)wfJob.getStatus());
        TestStatusTransitService.assertEquals((boolean)false, (boolean)coordAction.isPending());
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean coordJobBean = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
                return !coordJobBean.isPending();
            }
        });
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestStatusTransitService.assertEquals((boolean)false, (boolean)coordJob.isPending());
    }

    public void testCoordStatusTransitServiceKilledByUser2() throws Exception {
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.KILLED, start, end, true, false, 3);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.KILLED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.KILLED, "coord-action-get.xml", 0);
        final String jobId = job.getId();
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestStatusTransitService.assertNotNull((Object)jpaService);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(jobId));
                return !coordJob.isPending();
            }
        });
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestStatusTransitService.assertFalse((boolean)job.isPending());
    }

    public void testCoordStatusTransitServiceSuspendedByUser() throws Exception {
        String currentDateplusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDateplusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDateplusMonth);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.SUSPENDED, start, end, true, true, 3);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        final String jobId = job.getId();
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestStatusTransitService.assertNotNull((Object)jpaService);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(jobId));
                return !coordJob.isPending();
            }
        });
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestStatusTransitService.assertFalse((boolean)job.isPending());
        TestStatusTransitService.assertEquals((Object)Job.Status.SUCCEEDED, (Object)job.getStatus());
    }

    public void testCoordStatusTransitServiceSuspendedBottomUp() throws Exception {
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, true, true, 4);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUSPENDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.SUSPENDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.SUSPENDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 4, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        final String jobId = job.getId();
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestStatusTransitService.assertNotNull((Object)jpaService);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.waitFor(20000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(jobId));
                return coordJob.getStatus() == Job.Status.SUSPENDED;
            }
        });
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestStatusTransitService.assertEquals((Object)Job.Status.SUSPENDED, (Object)job.getStatus());
        TestStatusTransitService.assertFalse((boolean)job.isPending());
    }

    public void testCoordStatusTransitServiceSuspendedWithError() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.states.without.error", "false");
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, true, true, 4);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.KILLED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.SUSPENDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.SUSPENDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 4, CoordinatorAction.Status.SUSPENDED, "coord-action-get.xml", 0);
        final String jobId = job.getId();
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestStatusTransitService.assertNotNull((Object)jpaService);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.waitFor(20000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(jobId));
                return coordJob.getStatus() == Job.Status.SUSPENDEDWITHERROR;
            }
        });
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestStatusTransitService.assertEquals((Object)Job.Status.SUSPENDEDWITHERROR, (Object)job.getStatus());
        TestStatusTransitService.assertFalse((boolean)job.isPending());
    }

    public void testCoordStatusTransitServiceSuspendAndResume() throws Exception {
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestStatusTransitService.assertNotNull((Object)jpaService);
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, true, 2);
        final String coordJobId = coordJob.getId();
        CoordinatorActionBean coordAction1_1 = this.addRecordToCoordActionTable(coordJobId, 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        CoordinatorActionBean coordAction1_2 = this.addRecordToCoordActionTable(coordJobId, 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToWfJobTable(coordAction1_1.getExternalId(), WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        this.addRecordToWfJobTable(coordAction1_2.getExternalId(), WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        new CoordSuspendXCommand(coordJobId).call();
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(coordJobId);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestStatusTransitService.assertEquals((Object)Job.Status.SUSPENDED, (Object)coordJob.getStatus());
        this.sleep(3000);
        new CoordResumeXCommand(coordJobId).call();
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.waitFor(20000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(coordJobId));
                return job.getStatus().equals((Object)Job.Status.SUCCEEDED);
            }
        });
        CoordinatorJobBean coordJob1 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(coordJobId));
        TestStatusTransitService.assertFalse((boolean)coordJob1.isPending());
        TestStatusTransitService.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob1.getStatus());
    }

    public void testFoo() throws Exception {
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestStatusTransitService.assertNotNull((Object)jpaService);
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.PREP, start, end, true, false, 0);
        final String coordJobId = coordJob.getId();
        new CoordSuspendXCommand(coordJobId).call();
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(coordJobId);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestStatusTransitService.assertEquals((Object)Job.Status.PREPSUSPENDED, (Object)coordJob.getStatus());
        new StatusTransitService.StatusTransitRunnable().run();
        CoordinatorJobBean coordJob1 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(coordJobId));
        TestStatusTransitService.assertEquals((Object)Job.Status.PREPSUSPENDED, (Object)coordJob1.getStatus());
        new CoordResumeXCommand(coordJobId).call();
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestStatusTransitService.assertEquals((Object)Job.Status.PREP, (Object)coordJob.getStatus());
        new StatusTransitService.StatusTransitRunnable().run();
        this.waitFor(20000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(coordJobId));
                return job.getStatus().equals((Object)Job.Status.PREP);
            }
        });
        coordJob1 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(coordJobId));
        TestStatusTransitService.assertEquals((Object)Job.Status.PREP, (Object)coordJob1.getStatus());
    }

    public void testCoordStatusTransitServiceRunning1() throws Exception {
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, true, false, 3);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        final String jobId = job.getId();
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestStatusTransitService.assertNotNull((Object)jpaService);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(jobId));
                return !coordJob.isPending();
            }
        });
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestStatusTransitService.assertFalse((boolean)job.isPending());
        TestStatusTransitService.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNING);
    }

    public void testCoordStatusTransitServiceRunning2() throws Exception {
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNINGWITHERROR, start, end, true, false, 4);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 4, CoordinatorAction.Status.SUSPENDED, "coord-action-get.xml", 0);
        final String jobId = job.getId();
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestStatusTransitService.assertNotNull((Object)jpaService);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(jobId));
                return coordJob.getStatus() == Job.Status.RUNNING;
            }
        });
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestStatusTransitService.assertFalse((boolean)job.isPending());
        TestStatusTransitService.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNING);
    }

    public void testCoordStatusTransitServiceBackwardSupport() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.states.without.error", "true");
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, true, false, 3);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.KILLED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        final String jobId = job.getId();
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestStatusTransitService.assertNotNull((Object)jpaService);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(jobId));
                return !coordJob.isPending();
            }
        });
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestStatusTransitService.assertFalse((boolean)job.isPending());
        TestStatusTransitService.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNING);
    }

    public void testCoordStatusTransitServiceRunning3() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.states.without.error", "false");
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, true, false, 3);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.KILLED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        final String jobId = job.getId();
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestStatusTransitService.assertNotNull((Object)jpaService);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(jobId));
                return !coordJob.isPending();
            }
        });
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestStatusTransitService.assertFalse((boolean)job.isPending());
        TestStatusTransitService.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNINGWITHERROR);
    }

    public void testCoordStatusTransitServiceUpdateLastModifiedTime() throws Exception {
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, true, false, 3);
        Date lastModifiedDate = job.getLastModifiedTime();
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 1);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.sleep(1000);
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestStatusTransitService.assertEquals((long)lastModifiedDate.getTime(), (long)job.getLastModifiedTime().getTime());
        TestStatusTransitService.assertEquals((Object)Job.Status.RUNNING, (Object)job.getStatus());
    }

    public void testCoordStatusTransitServicePaused() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.states.without.error", "false");
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean coordJob = this.createCoordJob(Job.Status.PAUSED, start, end, true, false, 3);
        coordJob.setPauseTime(DateUtils.parseDateOozieTZ((String)"2009-02-01T01:00Z"));
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordJobInsertJPAExecutor coordInsertCmd = new CoordJobInsertJPAExecutor(coordJob);
        jpaService.execute((JPAExecutor)coordInsertCmd);
        this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.KILLED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(coordJob.getId(), 2, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(coordJob.getId(), 3, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        final String jobId = coordJob.getId();
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(jobId));
                return !coordJob.isPending();
            }
        });
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestStatusTransitService.assertFalse((boolean)coordJob.isPending());
        TestStatusTransitService.assertEquals((Object)Job.Status.PAUSEDWITHERROR, (Object)coordJob.getStatus());
    }

    public void testCoordStatusTransitServicePausedWithError() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.states.without.error", "false");
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job = this.createCoordJob(Job.Status.PAUSEDWITHERROR, start, end, true, false, 3);
        job.setPauseTime(DateUtils.parseDateOozieTZ((String)"2009-02-01T01:00Z"));
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordJobInsertJPAExecutor coordInsertCmd = new CoordJobInsertJPAExecutor(job);
        jpaService.execute((JPAExecutor)coordInsertCmd);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        final String jobId = job.getId();
        TestStatusTransitService.assertNotNull((Object)jpaService);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(jobId));
                return !coordJob.isPending();
            }
        });
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestStatusTransitService.assertFalse((boolean)job.isPending());
        TestStatusTransitService.assertEquals((Object)Job.Status.PAUSED, (Object)job.getStatus());
    }

    public void testCoordStatusTransitServiceForTimeout() throws Exception {
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, true, true, 3);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.TIMEDOUT, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.TIMEDOUT, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.TIMEDOUT, "coord-action-get.xml", 0);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.sleep(1000);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestStatusTransitService.assertEquals((Object)Job.Status.DONEWITHERROR, (Object)coordJob.getStatus());
    }

    public void testCoordNotTransitionfromKilled() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.KILLED, true, false);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.sleep(1000);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestStatusTransitService.assertEquals((Object)Job.Status.KILLED, (Object)coordJob.getStatus());
    }

    public void testBundleStatusTransitServiceSucceeded1() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestStatusTransitService.assertNotNull((Object)jpaService);
        final String jobId = job.getId();
        BundleActionBean ba1 = this.addRecordToBundleActionTable(jobId, "action1", 0, Job.Status.SUCCEEDED);
        this.addRecordToBundleActionTable(jobId, "action2", 0, Job.Status.SUCCEEDED);
        this.addRecordToBundleActionTable(jobId, "action3", 0, Job.Status.SUCCEEDED);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                BundleJobBean bundle = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobId));
                return bundle.getStatus().equals((Object)Job.Status.SUCCEEDED);
            }
        });
        job = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobId));
        TestStatusTransitService.assertEquals((Object)Job.Status.SUCCEEDED, (Object)job.getStatus());
    }

    public void testBundleStatusTransitServiceSucceeded2() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestStatusTransitService.assertNotNull((Object)jpaService);
        final String bundleId = job.getId();
        this.addRecordToBundleActionTable(bundleId, "action1", 0, Job.Status.RUNNING);
        this.addRecordToBundleActionTable(bundleId, "action2", 0, Job.Status.RUNNING);
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        this.addRecordToCoordJobTableWithBundle(bundleId, "action1", Job.Status.RUNNING, start, end, true, true, 2);
        this.addRecordToCoordJobTableWithBundle(bundleId, "action2", Job.Status.RUNNING, start, end, true, true, 2);
        this.addRecordToCoordActionTable("action1", 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable("action1", 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable("action2", 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable("action2", 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                BundleJobBean bundle = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
                return bundle.getStatus().equals((Object)Job.Status.SUCCEEDED);
            }
        });
        job = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
        TestStatusTransitService.assertEquals((Object)Job.Status.SUCCEEDED, (Object)job.getStatus());
    }

    public void testBundleStatusTransitServiceForTerminalStates() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestStatusTransitService.assertNotNull((Object)jpaService);
        String bundleId = job.getId();
        CoordinatorJobBean coord1 = this.addRecordToCoordJobTable(Job.Status.KILLED, false, false);
        this.addRecordToBundleActionTable(bundleId, coord1.getId(), "action1", 0, Job.Status.KILLED);
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        this.addRecordToCoordJobTableWithBundle(bundleId, "action1", Job.Status.KILLED, start, end, true, true, 2);
        this.addRecordToCoordActionTable("action1", 1, CoordinatorAction.Status.KILLED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable("action1", 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor("action1"));
                return coordJob.getStatus().equals((Object)Job.Status.DONEWITHERROR);
            }
        });
        CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor("action1"));
        TestStatusTransitService.assertEquals((Object)Job.Status.KILLED, (Object)coordJob.getStatus());
        BundleActionBean bab = (BundleActionBean)jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(bundleId, "action1"));
        TestStatusTransitService.assertEquals((Object)Job.Status.KILLED, (Object)bab.getStatus());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
        TestStatusTransitService.assertEquals((Object)Job.Status.KILLED, (Object)job.getStatus());
    }

    public void testBundleStatusTransitServiceSucceeded3() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestStatusTransitService.assertNotNull((Object)jpaService);
        String bundleId = job.getId();
        this.addRecordToBundleActionTable(bundleId, "action1", 1, Job.Status.RUNNING);
        this.addRecordToBundleActionTable(bundleId, "action2", 0, Job.Status.RUNNING);
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        this.addRecordToCoordJobTableWithBundle(bundleId, "action1", Job.Status.RUNNING, start, end, true, true, 2);
        this.addRecordToCoordJobTableWithBundle(bundleId, "action2", Job.Status.RUNNING, start, end, true, true, 2);
        this.addRecordToCoordActionTable("action1", 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable("action1", 2, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable("action2", 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable("action2", 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        new BundleJobSuspendXCommand(bundleId).call();
        BundleJobGetJPAExecutor bundleJobGetCmd = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestStatusTransitService.assertEquals((Object)Job.Status.SUSPENDED, (Object)job.getStatus());
        this.sleep(3000);
        new BundleJobResumeXCommand(bundleId).call();
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        TestStatusTransitService.assertEquals((Object)Job.Status.RUNNING, (Object)job.getStatus());
    }

    public void testBundleStatusTransitServiceKilled() throws Exception {
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.KILLED, true);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestStatusTransitService.assertNotNull((Object)jpaService);
        final String bundleId = bundleJob.getId();
        this.addRecordToBundleActionTable(bundleId, "action1-C", 1, Job.Status.KILLED);
        this.addRecordToBundleActionTable(bundleId, "action2-C", 1, Job.Status.KILLED);
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        this.addRecordToCoordJobTableWithBundle(bundleId, "action1-C", Job.Status.RUNNING, start, end, false, true, 2);
        this.addRecordToCoordJobTableWithBundle(bundleId, "action2-C", Job.Status.RUNNING, start, end, false, true, 2);
        WorkflowJobBean wfJob1_1 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowJobBean wfJob1_2 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowJobBean wfJob1_3 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowJobBean wfJob1_4 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        CoordinatorActionBean coordAction1_1 = this.addRecordToCoordActionTable("action1-C", 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", wfJob1_1.getId(), wfJob1_1.getStatusStr(), 0);
        CoordinatorActionBean coordAction1_2 = this.addRecordToCoordActionTable("action1-C", 2, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", wfJob1_2.getId(), wfJob1_2.getStatusStr(), 0);
        CoordinatorActionBean coordAction1_3 = this.addRecordToCoordActionTable("action2-C", 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", wfJob1_3.getId(), wfJob1_3.getStatusStr(), 0);
        final CoordinatorActionBean coordAction1_4 = this.addRecordToCoordActionTable("action2-C", 2, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", wfJob1_4.getId(), wfJob1_4.getStatusStr(), 0);
        new CoordKillXCommand("action1-C").call();
        new CoordKillXCommand("action2-C").call();
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                WorkflowJobBean wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)new WorkflowJobGetJPAExecutor(coordAction1_4.getExternalId()));
                return wfJob.getStatus().equals((Object)Job.Status.KILLED);
            }
        });
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                BundleJobBean bundle = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
                return !bundle.isPending();
            }
        });
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
        TestStatusTransitService.assertFalse((boolean)bundleJob.isPending());
        TestStatusTransitService.assertEquals((Object)Job.Status.KILLED, (Object)bundleJob.getStatus());
        BundleActionBean bundleAction1 = (BundleActionBean)jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(bundleId, "action1-C"));
        TestStatusTransitService.assertFalse((boolean)bundleAction1.isPending());
        TestStatusTransitService.assertEquals((Object)Job.Status.KILLED, (Object)bundleAction1.getStatus());
        CoordinatorJobBean coordJob1 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor("action1-C"));
        TestStatusTransitService.assertFalse((boolean)coordJob1.isPending());
        TestStatusTransitService.assertEquals((Object)Job.Status.KILLED, (Object)coordJob1.getStatus());
        BundleActionBean bundleAction2 = (BundleActionBean)jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(bundleId, "action2-C"));
        TestStatusTransitService.assertFalse((boolean)bundleAction2.isPending());
        TestStatusTransitService.assertEquals((Object)Job.Status.KILLED, (Object)bundleAction2.getStatus());
        CoordinatorJobBean coordJob2 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor("action2-C"));
        TestStatusTransitService.assertFalse((boolean)coordJob2.isPending());
        TestStatusTransitService.assertEquals((Object)Job.Status.KILLED, (Object)coordJob2.getStatus());
    }

    public void testBundleStatusNotTransitionFromKilled() throws Exception {
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.RUNNING, true);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestStatusTransitService.assertNotNull((Object)jpaService);
        final String bundleId = bundleJob.getId();
        this.addRecordToBundleActionTable(bundleId, "action1", 0, Job.Status.DONEWITHERROR);
        this.addRecordToBundleActionTable(bundleId, "action2", 0, Job.Status.DONEWITHERROR);
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        this.addRecordToCoordJobTableWithBundle(bundleId, "action1", Job.Status.DONEWITHERROR, start, end, false, true, 2);
        this.addRecordToCoordJobTableWithBundle(bundleId, "action2", Job.Status.DONEWITHERROR, start, end, false, true, 2);
        new BundleKillXCommand(bundleId).call();
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                BundleJobBean bundle = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
                return bundle.getStatus() == Job.Status.KILLED;
            }
        });
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
        TestStatusTransitService.assertEquals((Object)Job.Status.KILLED, (Object)bundleJob.getStatus());
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                BundleJobBean bundle = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
                return bundle.getStatus() == Job.Status.KILLED;
            }
        });
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
        TestStatusTransitService.assertEquals((Object)Job.Status.KILLED, (Object)bundleJob.getStatus());
    }

    public void testBundleStatusTransitServiceKilled2() throws Exception {
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.RUNNING, true);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestStatusTransitService.assertNotNull((Object)jpaService);
        final String bundleId = bundleJob.getId();
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean coord = this.addRecordToCoordJobTableWithBundle(bundleId, "action2", Job.Status.RUNNING, start, end, true, true, 2);
        this.addRecordToCoordActionTable("action2", 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        this.addRecordToBundleActionTable(bundleId, null, 0, Job.Status.KILLED);
        this.addRecordToBundleActionTable(bundleId, coord.getId(), "action2", 0, Job.Status.RUNNING);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.sleep(10000);
        runnable.run();
        this.waitFor(25000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                BundleJobBean bundle = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
                return bundle.getStatus() == Job.Status.KILLED;
            }
        });
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
        TestStatusTransitService.assertEquals((Object)Job.Status.KILLED, (Object)bundleJob.getStatus());
    }

    public void testBundleStatusTransitServiceRunningWithError() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.states.without.error", "false");
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.RUNNING, true);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestStatusTransitService.assertNotNull((Object)jpaService);
        final String bundleId = bundleJob.getId();
        this.addRecordToBundleActionTable(bundleId, "action1-C", 1, Job.Status.RUNNING);
        this.addRecordToBundleActionTable(bundleId, "action2-C", 1, Job.Status.RUNNING);
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        this.addRecordToCoordJobTableWithBundle(bundleId, "action1-C", Job.Status.RUNNING, start, end, false, true, 2);
        this.addRecordToCoordJobTableWithBundle(bundleId, "action2-C", Job.Status.RUNNING, start, end, true, false, 2);
        WorkflowJobBean wfJob1_1 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowJobBean wfJob1_2 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowJobBean wfJob1_3 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowJobBean wfJob1_4 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        final CoordinatorActionBean coordAction1_1 = this.addRecordToCoordActionTable("action1-C", 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", wfJob1_1.getId(), wfJob1_1.getStatusStr(), 0);
        CoordinatorActionBean coordAction1_2 = this.addRecordToCoordActionTable("action1-C", 2, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", wfJob1_2.getId(), wfJob1_2.getStatusStr(), 0);
        CoordinatorActionBean coordAction1_3 = this.addRecordToCoordActionTable("action2-C", 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", wfJob1_3.getId(), wfJob1_3.getStatusStr(), 1);
        CoordinatorActionBean coordAction1_4 = this.addRecordToCoordActionTable("action2-C", 2, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", wfJob1_4.getId(), wfJob1_4.getStatusStr(), 1);
        new CoordKillXCommand("action1-C").call();
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                WorkflowJobBean wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)new WorkflowJobGetJPAExecutor(coordAction1_1.getExternalId()));
                return wfJob.getStatus().equals((Object)Job.Status.KILLED);
            }
        });
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                BundleJobBean bundle = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
                return !bundle.isPending();
            }
        });
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
        TestStatusTransitService.assertTrue((boolean)bundleJob.isPending());
        TestStatusTransitService.assertEquals((Object)Job.Status.RUNNINGWITHERROR, (Object)bundleJob.getStatus());
        BundleActionBean bundleAction1 = (BundleActionBean)jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(bundleId, "action1-C"));
        TestStatusTransitService.assertFalse((boolean)bundleAction1.isPending());
        TestStatusTransitService.assertEquals((Object)Job.Status.KILLED, (Object)bundleAction1.getStatus());
        CoordinatorJobBean coordJob1 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor("action1-C"));
        TestStatusTransitService.assertFalse((boolean)coordJob1.isPending());
        TestStatusTransitService.assertEquals((Object)Job.Status.KILLED, (Object)coordJob1.getStatus());
        BundleActionBean bundleAction2 = (BundleActionBean)jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(bundleId, "action2-C"));
        TestStatusTransitService.assertTrue((boolean)bundleAction2.isPending());
        TestStatusTransitService.assertEquals((Object)Job.Status.RUNNING, (Object)bundleAction2.getStatus());
        CoordinatorJobBean coordJob2 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor("action2-C"));
        TestStatusTransitService.assertTrue((boolean)coordJob2.isPending());
        TestStatusTransitService.assertEquals((Object)Job.Status.RUNNING, (Object)coordJob2.getStatus());
    }

    public void testBundleStatusTransitServiceSuspended() throws Exception {
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.SUSPENDED, true);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestStatusTransitService.assertNotNull((Object)jpaService);
        final String bundleId = bundleJob.getId();
        this.addRecordToBundleActionTable(bundleId, "action1-C", 1, Job.Status.SUSPENDED);
        this.addRecordToBundleActionTable(bundleId, "action2-C", 1, Job.Status.SUSPENDED);
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        this.addRecordToCoordJobTableWithBundle(bundleId, "action1-C", Job.Status.RUNNING, start, end, false, false, 2);
        this.addRecordToCoordJobTableWithBundle(bundleId, "action2-C", Job.Status.RUNNING, start, end, false, false, 2);
        WorkflowJobBean wfJob1_1 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowJobBean wfJob1_2 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowJobBean wfJob1_3 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowJobBean wfJob1_4 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        CoordinatorActionBean coordAction1_1 = this.addRecordToCoordActionTable("action1-C", 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", wfJob1_1.getId(), wfJob1_1.getStatusStr(), 0);
        CoordinatorActionBean coordAction1_2 = this.addRecordToCoordActionTable("action1-C", 2, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", wfJob1_2.getId(), wfJob1_2.getStatusStr(), 0);
        CoordinatorActionBean coordAction1_3 = this.addRecordToCoordActionTable("action2-C", 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", wfJob1_3.getId(), wfJob1_3.getStatusStr(), 0);
        final CoordinatorActionBean coordAction1_4 = this.addRecordToCoordActionTable("action2-C", 2, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", wfJob1_4.getId(), wfJob1_4.getStatusStr(), 0);
        new CoordSuspendXCommand("action1-C").call();
        new CoordSuspendXCommand("action2-C").call();
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                WorkflowJobBean wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)new WorkflowJobGetJPAExecutor(coordAction1_4.getExternalId()));
                return wfJob.getStatus().equals((Object)Job.Status.SUSPENDED);
            }
        });
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                BundleJobBean bundle = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
                return !bundle.isPending();
            }
        });
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
        TestStatusTransitService.assertFalse((boolean)bundleJob.isPending());
        TestStatusTransitService.assertEquals((Object)Job.Status.SUSPENDED, (Object)bundleJob.getStatus());
        BundleActionBean bundleAction1 = (BundleActionBean)jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(bundleId, "action1-C"));
        TestStatusTransitService.assertFalse((boolean)bundleAction1.isPending());
        TestStatusTransitService.assertEquals((Object)Job.Status.SUSPENDED, (Object)bundleAction1.getStatus());
        CoordinatorJobBean coordJob1 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor("action1-C"));
        TestStatusTransitService.assertFalse((boolean)coordJob1.isPending());
        TestStatusTransitService.assertEquals((Object)Job.Status.SUSPENDED, (Object)coordJob1.getStatus());
        BundleActionBean bundleAction2 = (BundleActionBean)jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(bundleId, "action2-C"));
        TestStatusTransitService.assertFalse((boolean)bundleAction2.isPending());
        TestStatusTransitService.assertEquals((Object)Job.Status.SUSPENDED, (Object)bundleAction2.getStatus());
        CoordinatorJobBean coordJob2 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor("action2-C"));
        TestStatusTransitService.assertFalse((boolean)coordJob2.isPending());
        TestStatusTransitService.assertEquals((Object)Job.Status.SUSPENDED, (Object)coordJob2.getStatus());
    }

    public void testBundleStatusTransitServiceSuspendedWithError() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.states.without.error", "false");
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.RUNNING, true);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestStatusTransitService.assertNotNull((Object)jpaService);
        final String bundleId = bundleJob.getId();
        this.addRecordToBundleActionTable(bundleId, "action1", 0, Job.Status.SUSPENDED);
        this.addRecordToBundleActionTable(bundleId, "action2", 0, Job.Status.SUSPENDEDWITHERROR);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                BundleJobBean bundle = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
                return !bundle.isPending();
            }
        });
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
        TestStatusTransitService.assertFalse((boolean)bundleJob.isPending());
        TestStatusTransitService.assertEquals((Object)Job.Status.SUSPENDEDWITHERROR, (Object)bundleJob.getStatus());
    }

    public void testBundleStatusTransitServicePausedWithError() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.states.without.error", "false");
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
        BundleJobBean bundleJob = this.createBundleJob(Job.Status.PAUSED, true);
        bundleJob.setPauseTime(DateUtils.parseDateOozieTZ((String)"2009-02-01T01:00Z"));
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        BundleJobInsertJPAExecutor bundleInsertjpa = new BundleJobInsertJPAExecutor(bundleJob);
        jpaService.execute((JPAExecutor)bundleInsertjpa);
        final String bundleId = bundleJob.getId();
        this.addRecordToBundleActionTable(bundleId, "action1", 1, Job.Status.PAUSED);
        this.addRecordToBundleActionTable(bundleId, "action2", 1, Job.Status.PAUSED);
        BundleActionBean bundleAction = this.addRecordToBundleActionTable(bundleId, "action3", 0, Job.Status.FAILED);
        bundleAction.setCoordId("test");
        BundleActionQueryExecutor.getInstance().executeUpdate((Enum)BundleActionQueryExecutor.BundleActionQuery.UPDATE_BUNDLE_ACTION_STATUS_PENDING_MODTIME_COORDID, (Object)bundleAction);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                BundleJobBean bundle = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
                return bundle.getStatus() == Job.Status.PAUSEDWITHERROR;
            }
        });
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
        TestStatusTransitService.assertEquals((Object)Job.Status.PAUSEDWITHERROR, (Object)bundleJob.getStatus());
    }

    public void testBundleStatusTransitServicePaused() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.states.without.error", "false");
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
        BundleJobBean bundleJob = this.createBundleJob(Job.Status.PAUSEDWITHERROR, true);
        bundleJob.setPauseTime(DateUtils.parseDateOozieTZ((String)"2009-02-01T01:00Z"));
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        BundleJobInsertJPAExecutor bundleInsertjpa = new BundleJobInsertJPAExecutor(bundleJob);
        jpaService.execute((JPAExecutor)bundleInsertjpa);
        final String bundleId = bundleJob.getId();
        this.addRecordToBundleActionTable(bundleId, "action1", 1, Job.Status.PAUSED);
        this.addRecordToBundleActionTable(bundleId, "action2", 1, Job.Status.PAUSED);
        this.addRecordToBundleActionTable(bundleId, "action3", 0, Job.Status.SUCCEEDED);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                BundleJobBean bundle = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
                return bundle.getStatus() == Job.Status.PAUSED;
            }
        });
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
        TestStatusTransitService.assertEquals((Object)Job.Status.PAUSED, (Object)bundleJob.getStatus());
    }

    protected WorkflowJobBean addRecordToWfJobTable(String wfId, WorkflowJob.Status jobStatus, WorkflowInstance.Status instanceStatus) throws Exception {
        LiteWorkflowApp app = new LiteWorkflowApp("testApp", "<workflow-app/>", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        Configuration conf = new Configuration();
        Path appUri = new Path(this.getAppPath(), "workflow.xml");
        conf.set("oozie.wf.application.path", appUri.toString());
        conf.set("oozie.wf.log.token", "testToken");
        conf.set("user.name", TestStatusTransitService.getTestUser());
        WorkflowJobBean wfBean = this.createWorkflow((WorkflowApp)app, conf, jobStatus, instanceStatus);
        wfBean.setId(wfId);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestStatusTransitService.assertNotNull((Object)jpaService);
            WorkflowJobInsertJPAExecutor wfInsertCmd = new WorkflowJobInsertJPAExecutor(wfBean);
            jpaService.execute((JPAExecutor)wfInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            TestStatusTransitService.fail((String)"Unable to insert the test wf job record to table");
            throw je;
        }
        return wfBean;
    }

    public void testCoordStatusTransitServiceStaleCoordActions() throws Exception {
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, true, true, 3);
        this.addRecordToCoordActionTable("ABCD", 3, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.sleep(1000);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestStatusTransitService.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
    }

    public void testCoordStatusTransitRunningFromKilled() throws Exception {
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, false, 1);
        CoordinatorActionBean coordAction = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", null, "RUNNING", 0);
        new CoordKillXCommand(coordJob.getId()).call();
        final CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
                return coordJob.getStatusStr().equals("KILLED");
            }
        });
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.sleep(1000);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestStatusTransitService.assertEquals((Object)Job.Status.KILLED, (Object)coordJob.getStatus());
        coordAction.setStatus(CoordinatorAction.Status.RUNNING);
        coordJob.setPending();
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_STATUS_PENDING, coordJob);
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION, (Object)coordAction);
        runnable.run();
        this.sleep(1000);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestStatusTransitService.assertEquals((Object)Job.Status.RUNNING, (Object)coordJob.getStatus());
    }

    public void testBundleStatusTransitRunningFromKilled() throws Exception {
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.RUNNING, true);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        String bundleId = bundleJob.getId();
        CoordinatorJobBean coord1 = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        BundleActionBean bundleAction1 = this.addRecordToBundleActionTable(bundleId, coord1.getId(), "action1-C", 1, Job.Status.RUNNING);
        bundleJob.setPending();
        bundleAction1.setStatus(Job.Status.KILLED);
        bundleAction1.setPending(0);
        BundleActionQueryExecutor.getInstance().executeUpdate((Enum)BundleActionQueryExecutor.BundleActionQuery.UPDATE_BUNDLE_ACTION_STATUS_PENDING_MODTIME_COORDID, (Object)bundleAction1);
        BundleJobQueryExecutor.getInstance().executeUpdate((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_STATUS_PENDING, (Object)bundleJob);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.sleep(1000);
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
        TestStatusTransitService.assertEquals((Object)Job.Status.KILLED, (Object)bundleJob.getStatus());
        bundleAction1 = (BundleActionBean)jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(bundleId, "action1-C"));
        TestStatusTransitService.assertEquals((Object)Job.Status.KILLED, (Object)bundleAction1.getStatus());
        bundleAction1.setPending(1);
        bundleAction1.setStatus(Job.Status.RUNNING);
        bundleAction1.setLastModifiedTime(new Date());
        bundleJob.setPending();
        bundleJob.setLastModifiedTime(new Date());
        BundleActionQueryExecutor.getInstance().executeUpdate((Enum)BundleActionQueryExecutor.BundleActionQuery.UPDATE_BUNDLE_ACTION_STATUS_PENDING_MODTIME_COORDID, (Object)bundleAction1);
        BundleJobQueryExecutor.getInstance().executeUpdate((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_STATUS_PENDING, (Object)bundleJob);
        runnable.run();
        this.sleep(1000);
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(bundleId));
        TestStatusTransitService.assertEquals((Object)Job.Status.RUNNING, (Object)bundleJob.getStatus());
    }

    public void testBundleStatusTransitRunningWithError() throws Exception {
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.states.without.error", "false");
        this.services = new Services();
        this.services.init();
        CoordinatorJobBean coord1 = this.addRecordToCoordJobTable(Job.Status.PREP, false, false);
        CoordinatorJobBean coord2 = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        CoordinatorJobBean coord3 = this.addRecordToCoordJobTable(Job.Status.DONEWITHERROR, false, false);
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.RUNNING, true);
        String bundleId = bundleJob.getId();
        this.addRecordToBundleActionTable(bundleId, coord1.getId(), "action1-C", 0, Job.Status.PREP);
        this.addRecordToBundleActionTable(bundleId, coord2.getId(), "action2-C", 0, Job.Status.RUNNING);
        BundleActionBean action3 = this.addRecordToBundleActionTable(bundleId, coord3.getId(), "action3-C", 0, Job.Status.DONEWITHERROR);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        bundleJob = (BundleJobBean)BundleJobQueryExecutor.getInstance().get((Enum)BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB_STATUS, new Object[]{bundleId});
        TestStatusTransitService.assertEquals((Object)Job.Status.RUNNINGWITHERROR, (Object)bundleJob.getStatus());
        action3.setStatus(Job.Status.SUSPENDED);
        action3.setPending(1);
        action3.setLastModifiedTime(new Date());
        BundleActionQueryExecutor.getInstance().executeUpdate((Enum)BundleActionQueryExecutor.BundleActionQuery.UPDATE_BUNDLE_ACTION_STATUS_PENDING_MODTIME_COORDID, (Object)action3);
        runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        bundleJob = (BundleJobBean)BundleJobQueryExecutor.getInstance().get((Enum)BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB_STATUS, new Object[]{bundleId});
        TestStatusTransitService.assertEquals((Object)Job.Status.RUNNING, (Object)bundleJob.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBundleStatusTransitWithLock() throws Exception {
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.states.without.error", "false");
        this.services = new Services();
        this.services.init();
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.RUNNING, true);
        String jobId = bundleJob.getId();
        String bundleId = bundleJob.getId();
        this.addRecordToBundleActionTable(bundleId, "action1-C", 0, Job.Status.PREP);
        this.addRecordToBundleActionTable(bundleId, "action2-C", 0, Job.Status.RUNNING);
        this.addRecordToBundleActionTable(bundleId, "action3-C", 0, Job.Status.DONEWITHERROR);
        JobLock lockThread = new JobLock(jobId);
        new Thread(lockThread).start();
        this.sleep(1000);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        bundleJob = (BundleJobBean)BundleJobQueryExecutor.getInstance().get((Enum)BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB_STATUS, new Object[]{bundleId});
        TestStatusTransitService.assertEquals((Object)Job.Status.RUNNING, (Object)bundleJob.getStatus());
        JobLock jobLock = lockThread;
        synchronized (jobLock) {
            lockThread.notifyAll();
        }
        this.sleep(1000);
        runnable.run();
        bundleJob = (BundleJobBean)BundleJobQueryExecutor.getInstance().get((Enum)BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB_STATUS, new Object[]{bundleId});
        TestStatusTransitService.assertEquals((Object)Job.Status.RUNNINGWITHERROR, (Object)bundleJob.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCoordStatusTransitWithLock() throws Exception {
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.states.without.error", "false");
        this.services = new Services();
        this.services.init();
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, true, false, 1);
        this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.KILLED, "coord-action-get.xml", null, "KILLED", 0);
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        JobLock lockThread = new JobLock(coordJob.getId());
        new Thread(lockThread).start();
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.sleep(1000);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestStatusTransitService.assertEquals((Object)Job.Status.RUNNING, (Object)coordJob.getStatus());
        JobLock jobLock = lockThread;
        synchronized (jobLock) {
            lockThread.notifyAll();
        }
        runnable.run();
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestStatusTransitService.assertEquals((Object)Job.Status.RUNNINGWITHERROR, (Object)coordJob.getStatus());
    }

    public void testBundleStatusCoordSubmitFails() throws Exception {
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.states.without.error", "false");
        this.services = new Services();
        this.services.init();
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        String bundleId = bundleJob.getId();
        this.addRecordToBundleActionTable(bundleId, null, 0, Job.Status.FAILED);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        bundleJob = (BundleJobBean)BundleJobQueryExecutor.getInstance().get((Enum)BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB_STATUS, new Object[]{bundleId});
        TestStatusTransitService.assertEquals((Object)Job.Status.FAILED, (Object)bundleJob.getStatus());
        this.sleep(1000);
        bundleJob.setStatus(Job.Status.RUNNING);
        BundleJobQueryExecutor.getInstance().executeUpdate((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_STATUS_PENDING, (Object)bundleJob);
        runnable.run();
        bundleJob = (BundleJobBean)BundleJobQueryExecutor.getInstance().get((Enum)BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB_STATUS, new Object[]{bundleId});
        TestStatusTransitService.assertEquals((Object)Job.Status.FAILED, (Object)bundleJob.getStatus());
    }

    public void testBundleRunningAfterCoordResume() throws Exception {
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.states.without.error", "false");
        this.services = new Services();
        this.services.init();
        CoordinatorJobBean coord = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.RUNNING, true);
        String bundleId = bundleJob.getId();
        this.addRecordToBundleActionTable(bundleId, coord.getId(), "COORD-TEST", 0, Job.Status.RUNNING);
        new CoordSuspendXCommand(coord.getId()).call();
        coord = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{coord.getId()});
        TestStatusTransitService.assertEquals((Object)Job.Status.SUSPENDED, (Object)coord.getStatus());
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        bundleJob = (BundleJobBean)BundleJobQueryExecutor.getInstance().get((Enum)BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB_STATUS, new Object[]{bundleId});
        TestStatusTransitService.assertEquals((Object)Job.Status.SUSPENDED, (Object)bundleJob.getStatus());
        new CoordResumeXCommand(coord.getId()).call();
        coord = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{coord.getId()});
        TestStatusTransitService.assertEquals((Object)Job.Status.RUNNING, (Object)coord.getStatus());
        runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        bundleJob = (BundleJobBean)BundleJobQueryExecutor.getInstance().get((Enum)BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB_STATUS, new Object[]{bundleId});
        TestStatusTransitService.assertEquals((Object)Job.Status.RUNNING, (Object)bundleJob.getStatus());
    }

    static class JobLock
    implements Runnable {
        String jobId;
        LockToken lock = null;

        public JobLock(String jobId) {
            this.jobId = jobId;
        }

        public void acquireLock() throws InterruptedException {
            this.lock = ((MemoryLocksService)Services.get().get(MemoryLocksService.class)).getWriteLock(this.jobId, 0L);
        }

        public void release() {
            this.lock.release();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.acquireLock();
                JobLock jobLock = this;
                synchronized (jobLock) {
                    this.wait();
                }
                this.release();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

