/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.DagEngine;
import org.apache.oozie.ForTestingActionExecutor;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.hadoop.LauncherMapperHelper;
import org.apache.oozie.action.hadoop.MapReduceActionExecutor;
import org.apache.oozie.action.hadoop.MapperReducerForTest;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.wf.ActionXCommand;
import org.apache.oozie.dependency.FSURIHandler;
import org.apache.oozie.dependency.HCatURIHandler;
import org.apache.oozie.executor.jpa.BundleActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionInsertJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionInsertJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.HCatAccessorService;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.JMSAccessorService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.PartitionDependencyManagerService;
import org.apache.oozie.service.RecoveryService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.HCatURI;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestRecoveryService
extends XDataTestCase {
    private Services services;
    private String server;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.server = this.getMetastoreAuthority();
        this.setSystemProperty("oozie.service.SchemaService.wf.ext.schemas", "wf-ext-schema.xsd");
        this.services = new Services();
        this.services.init();
        ((ActionService)this.services.get(ActionService.class)).registerAndInitExecutor(ForTestingActionExecutor.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testWorkflowActionRecoveryService() throws Exception {
        Reader reader = IOUtils.getResourceAsReader((String)"wf-ext-schema-valid.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
        this.createTestCaseSubDir("lib");
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        final DagEngine engine = new DagEngine(TestRecoveryService.getTestUser());
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", this.getTestCaseFileUri("workflow.xml"));
        conf.set("user.name", TestRecoveryService.getTestUser());
        conf.set("oozie.wf.log.token", "t");
        conf.set("external-status", "ok");
        conf.set("signal-value", "based_on_action_status");
        conf.set("running-mode", "async");
        this.sleep(1000);
        final String jobId = engine.submitJob((Configuration)conf, true);
        this.sleep(1000);
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return engine.getJob(jobId).getStatus() == WorkflowJob.Status.RUNNING;
            }
        });
        this.sleep(1000);
        WorkflowStore store = ((WorkflowStoreService)Services.get().get(WorkflowStoreService.class)).create();
        store.beginTrx();
        List actions = store.getActionsForWorkflow(jobId, false);
        WorkflowActionBean action = null;
        for (WorkflowActionBean bean : actions) {
            if (!bean.getType().equals("test")) continue;
            action = bean;
            break;
        }
        TestRecoveryService.assertNotNull(action);
        final String actionId = action.getId();
        TestRecoveryService.assertEquals((Object)WorkflowAction.Status.RUNNING, (Object)action.getStatus());
        String actionConf = action.getConf();
        String fixedActionConf = actionConf.replaceAll("async", "sync");
        action.setConf(fixedActionConf);
        action.setPending();
        store.updateAction(action);
        store.commitTrx();
        store.closeTrx();
        RecoveryService.RecoveryRunnable recoveryRunnable = new RecoveryService.RecoveryRunnable(0L, 60L, 60L);
        recoveryRunnable.run();
        this.sleep(3000);
        WorkflowStore store2 = ((WorkflowStoreService)Services.get().get(WorkflowStoreService.class)).create();
        TestRecoveryService.assertEquals((Object)WorkflowJob.Status.RUNNING, (Object)engine.getJob(jobId).getStatus());
        store2.beginTrx();
        WorkflowActionBean action2 = store2.getAction(actionId, false);
        TestRecoveryService.assertEquals((Object)WorkflowAction.Status.RUNNING, (Object)action2.getStatus());
        action2.setStatus(WorkflowAction.Status.PREP);
        action2.setPending();
        store2.updateAction(action2);
        store2.commitTrx();
        store2.closeTrx();
        this.sleep(1000);
        recoveryRunnable.run();
        this.sleep(3000);
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return engine.getWorkflowAction(actionId).getStatus() == WorkflowAction.Status.OK;
            }
        });
        WorkflowStore store3 = ((WorkflowStoreService)Services.get().get(WorkflowStoreService.class)).create();
        store3.beginTrx();
        WorkflowActionBean action3 = store3.getAction(actionId, false);
        TestRecoveryService.assertEquals((Object)WorkflowAction.Status.OK, (Object)action3.getStatus());
        store3.commitTrx();
        store3.closeTrx();
    }

    public void testWorkflowActionRecoveryUserRetry() throws Exception {
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        WorkflowJobBean job1 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action1 = this.addRecordToWfActionTable(job1.getId(), "1", WorkflowAction.Status.USER_RETRY);
        WorkflowJobBean job2 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action2 = this.createWorkflowActionSetPending(job2.getId(), WorkflowAction.Status.USER_RETRY);
        action2.setCreatedTime(new Date(new Date().getTime() - 720000000L));
        WorkflowActionInsertJPAExecutor actionInsertCmd = new WorkflowActionInsertJPAExecutor(action2);
        jpaService.execute((JPAExecutor)actionInsertCmd);
        RecoveryService.RecoveryRunnable recoveryRunnable = new RecoveryService.RecoveryRunnable(0L, 60L, 60L);
        recoveryRunnable.run();
        this.sleep(3000);
        final WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(action1.getId());
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                WorkflowActionBean a = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
                return a.getExternalId() != null;
            }
        });
        action1 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestRecoveryService.assertNotNull((Object)action1.getExternalId());
        TestRecoveryService.assertEquals((Object)WorkflowAction.Status.RUNNING, (Object)action1.getStatus());
        action2 = (WorkflowActionBean)WorkflowActionQueryExecutor.getInstance().get((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION, new Object[]{action2.getId()});
        TestRecoveryService.assertNull((Object)action2.getExternalId());
        TestRecoveryService.assertEquals((Object)WorkflowAction.Status.USER_RETRY, (Object)action2.getStatus());
        ActionXCommand.ActionExecutorContext context = new ActionXCommand.ActionExecutorContext(job1, action1, false, false);
        MapReduceActionExecutor actionExecutor = new MapReduceActionExecutor();
        JobConf conf = actionExecutor.createBaseHadoopConf((ActionExecutor.Context)context, XmlUtils.parseXml((String)action1.getConf()));
        String user = conf.get("user.name");
        String group = conf.get("group.name");
        JobClient jobClient = ((HadoopAccessorService)Services.get().get(HadoopAccessorService.class)).createJobClient(user, conf);
        String launcherId = action1.getExternalId();
        final RunningJob launcherJob = jobClient.getJob(JobID.forName((String)launcherId));
        this.waitFor(240000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return launcherJob.isComplete();
            }
        });
        TestRecoveryService.assertTrue((boolean)launcherJob.isSuccessful());
        Map actionData = LauncherMapperHelper.getActionData((FileSystem)this.getFileSystem(), (Path)context.getActionDir(), (Configuration)conf);
        TestRecoveryService.assertTrue((boolean)LauncherMapperHelper.hasIdSwap((Map)actionData));
    }

    public void testBundleRecoveryCoordCreate() throws Exception {
        final BundleJobBean bundle = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        BundleActionBean bundleAction = this.addRecordToBundleActionTable(bundle.getId(), "coord1", 1, Job.Status.PREP);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        this.sleep(3000);
        RecoveryService.RecoveryRunnable recoveryRunnable = new RecoveryService.RecoveryRunnable(0L, 1L, 1L);
        recoveryRunnable.run();
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                BundleActionBean mybundleAction = (BundleActionBean)jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(bundle.getId(), "coord1"));
                try {
                    if (mybundleAction.getCoordId() != null) {
                        CoordinatorJobBean coord = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(mybundleAction.getCoordId()));
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        });
        BundleActionBean mybundleAction = (BundleActionBean)jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(bundle.getId(), "coord1"));
        TestRecoveryService.assertNotNull((Object)mybundleAction.getCoordId());
        try {
            jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(mybundleAction.getCoordId()));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestRecoveryService.fail((String)("Expected coord " + mybundleAction.getCoordId() + " to be created"));
        }
    }

    public void testCoordCreateNotifyParentFailed() throws Exception {
        final BundleJobBean bundle = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        BundleActionBean bundleAction = this.addRecordToBundleActionTable(bundle.getId(), "coord1", 1, Job.Status.PREP);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.PREP, new Date(), new Date(), false, false, 1);
        coordJob.setBundleId(bundle.getId());
        coordJob.setAppName("coord1");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob);
        TestRecoveryService.assertNull((Object)bundleAction.getCoordId());
        this.sleep(3000);
        RecoveryService.RecoveryRunnable recoveryRunnable = new RecoveryService.RecoveryRunnable(0L, 1L, 1L);
        recoveryRunnable.run();
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                BundleActionBean mybundleAction = (BundleActionBean)BundleActionQueryExecutor.getInstance().get((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTION, new Object[]{bundle.getId() + "_coord1"});
                return mybundleAction.getCoordId() != null;
            }
        });
        BundleActionBean mybundleAction = (BundleActionBean)BundleActionQueryExecutor.getInstance().get((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTION, new Object[]{bundle.getId() + "_coord1"});
        TestRecoveryService.assertNotNull((Object)mybundleAction.getCoordId());
    }

    public void testBundleRecoveryCoordExists() throws Exception {
        final BundleJobBean bundle = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        CoordinatorJobBean coord = this.addRecordToCoordJobTable(Job.Status.PREP, false, false);
        BundleActionBean bundleAction = this.addRecordToBundleActionTable(bundle.getId(), coord.getId(), "coord1", 1, Job.Status.PREP);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        this.sleep(3000);
        RecoveryService.RecoveryRunnable recoveryRunnable = new RecoveryService.RecoveryRunnable(0L, 1L, 1L);
        recoveryRunnable.run();
        this.waitFor(3000, new XTestCase.Predicate((CoordinatorJob)coord){
            final /* synthetic */ CoordinatorJob val$coord;
            {
                this.val$coord = coordinatorJob;
            }

            @Override
            public boolean evaluate() throws Exception {
                BundleActionBean mybundleAction = (BundleActionBean)jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(bundle.getId(), "coord1"));
                return !mybundleAction.getCoordId().equals(this.val$coord.getId());
            }
        });
        BundleActionBean mybundleAction = (BundleActionBean)jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(bundle.getId(), "coord1"));
        TestRecoveryService.assertEquals((String)coord.getId(), (String)mybundleAction.getCoordId());
    }

    public void testCoordActionRecoveryServiceForSubmitted() throws Exception {
        String jobId = "0000000-" + new Date().getTime() + "-testCoordRecoveryService-C";
        boolean actionNum = true;
        final String actionId = jobId + "@" + 1;
        final CoordinatorEngine ce = new CoordinatorEngine(TestRecoveryService.getTestUser());
        this.createTestCaseSubDir("one-op");
        this.createTestCaseSubDir("one-op", "lib");
        this.createTestCaseSubDir("workflows");
        this.createTestCaseSubDir("in");
        this.addRecordToJobTable(jobId, this.getTestCaseDir());
        this.addRecordToActionTable(jobId, 1, actionId, this.getTestCaseDir());
        this.sleep(3000);
        RecoveryService.RecoveryRunnable recoveryRunnable = new RecoveryService.RecoveryRunnable(0L, 1L, 1L);
        recoveryRunnable.run();
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorActionBean bean = ce.getCoordAction(actionId);
                return bean.getStatus() == CoordinatorAction.Status.RUNNING || bean.getStatus() == CoordinatorAction.Status.SUCCEEDED;
            }
        });
        CoordinatorActionBean action = this.getCoordinatorAction(actionId);
        if (action.getStatus() != CoordinatorAction.Status.RUNNING && action.getStatus() != CoordinatorAction.Status.SUCCEEDED) {
            TestRecoveryService.fail();
        }
    }

    public void testCoordActionRecoveryServiceForWaiting() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTableForWaiting("coord-job-for-action-input-check.xml", Job.Status.RUNNING, false, true);
        CoordinatorJobBean jobWithError = this.addRecordToCoordJobTableForWaiting("coord-job-for-action-input-check.xml", Job.Status.RUNNINGWITHERROR, false, true);
        CoordinatorJobBean suspendedJob = this.addRecordToCoordJobTableForWaiting("coord-job-for-action-input-check.xml", Job.Status.SUSPENDED, false, true);
        CoordinatorActionBean action = this.addRecordToCoordActionTableForWaiting(job.getId(), 1, CoordinatorAction.Status.WAITING, "coord-action-for-action-input-check.xml");
        CoordinatorActionBean actionReady = this.addRecordToCoordActionTableForWaiting(job.getId(), 2, CoordinatorAction.Status.READY, "coord-action-for-action-input-check.xml");
        CoordinatorActionBean suspendedAction = this.addRecordToCoordActionTableForWaiting(suspendedJob.getId(), 1, CoordinatorAction.Status.WAITING, "coord-action-for-action-input-check.xml");
        CoordinatorActionBean runningWithErrorAction = this.addRecordToCoordActionTableForWaiting(jobWithError.getId(), 1, CoordinatorAction.Status.WAITING, "coord-action-for-action-input-check.xml");
        CoordinatorActionBean submittedAction = this.addRecordToCoordActionTableForWaiting(suspendedJob.getId(), 2, CoordinatorAction.Status.SUBMITTED, "coord-action-for-action-input-check.xml");
        this.createDir(new File(this.getTestCaseDir(), "/2009/29/"));
        this.createDir(new File(this.getTestCaseDir(), "/2009/22/"));
        this.createDir(new File(this.getTestCaseDir(), "/2009/15/"));
        this.createDir(new File(this.getTestCaseDir(), "/2009/08/"));
        this.sleep(3000);
        RecoveryService.RecoveryRunnable recoveryRunnable = new RecoveryService.RecoveryRunnable(0L, 1L, 1L);
        recoveryRunnable.run();
        final String actionId = action.getId();
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorActionBean newAction = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{actionId});
                return newAction.getStatus() != CoordinatorAction.Status.WAITING;
            }
        });
        action = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{actionId});
        TestRecoveryService.assertFalse((boolean)action.getStatus().equals((Object)CoordinatorAction.Status.WAITING));
        TestRecoveryService.assertFalse((boolean)((CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{runningWithErrorAction.getId()})).getStatus().equals((Object)CoordinatorAction.Status.WAITING));
        TestRecoveryService.assertFalse((boolean)((CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{actionReady.getId()})).getStatus().equals((Object)CoordinatorAction.Status.READY));
        TestRecoveryService.assertTrue((boolean)((CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{suspendedAction.getId()})).getStatus().equals((Object)CoordinatorAction.Status.WAITING));
        TestRecoveryService.assertEquals((Object)((CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{submittedAction.getId()})).getStatus(), (Object)CoordinatorAction.Status.SUBMITTED);
    }

    public void testCoordActionRecoveryServiceForWaitingRegisterPartition() throws Exception {
        this.services.destroy();
        this.services = super.setupServicesForHCatalog();
        this.services.getConf().set("oozie.service.URIHandlerService.uri.handlers", FSURIHandler.class.getName() + "," + HCatURIHandler.class.getName());
        this.services.getConf().setLong("oozie.service.RecoveryService.push.dependency.interval", 1L);
        this.services.init();
        String db = "default";
        String table = "tablename";
        String newHCatDependency1 = "hcat://" + this.server + "/" + db + "/" + table + "/dt=20120430;country=brazil";
        String newHCatDependency2 = "hcat://" + this.server + "/" + db + "/" + table + "/dt=20120430;country=usa";
        String newHCatDependency = newHCatDependency1 + "#" + newHCatDependency2;
        HCatAccessorService hcatService = (HCatAccessorService)this.services.get(HCatAccessorService.class);
        JMSAccessorService jmsService = (JMSAccessorService)this.services.get(JMSAccessorService.class);
        PartitionDependencyManagerService pdms = (PartitionDependencyManagerService)this.services.get(PartitionDependencyManagerService.class);
        TestRecoveryService.assertFalse((boolean)jmsService.isListeningToTopic(hcatService.getJMSConnectionInfo(new URI(newHCatDependency1)), db + "." + table));
        this.populateTable(db, table);
        String actionId = this.addInitRecords(newHCatDependency);
        CoordinatorActionBean ca = this.checkCoordActionDependencies(actionId, newHCatDependency);
        TestRecoveryService.assertEquals((Object)CoordinatorAction.Status.WAITING, (Object)ca.getStatus());
        pdms.addMissingDependency(new HCatURI(newHCatDependency1), actionId);
        pdms.addMissingDependency(new HCatURI(newHCatDependency2), actionId);
        this.sleep(2000);
        RecoveryService.RecoveryRunnable recoveryRunnable = new RecoveryService.RecoveryRunnable(0L, 1L, 1L);
        recoveryRunnable.run();
        this.sleep(2000);
        TestRecoveryService.assertTrue((boolean)jmsService.isListeningToTopic(hcatService.getJMSConnectionInfo(new URI(newHCatDependency2)), "hcat." + db + "." + table));
        this.checkCoordActionDependencies(actionId, newHCatDependency1);
        TestRecoveryService.assertNull((Object)pdms.getWaitingActions(new HCatURI(newHCatDependency2)));
        Collection waitingActions = pdms.getWaitingActions(new HCatURI(newHCatDependency1));
        TestRecoveryService.assertEquals((int)1, (int)waitingActions.size());
        TestRecoveryService.assertTrue((boolean)waitingActions.contains(actionId));
    }

    private void populateTable(String db, String table) throws Exception {
        this.dropTable(db, table, true);
        this.dropDatabase(db, true);
        this.createDatabase(db);
        this.createTable(db, table, "dt,country");
        this.addPartition(db, table, "dt=20120430;country=usa");
        this.addPartition(db, table, "dt=20120412;country=brazil");
        this.addPartition(db, table, "dt=20120413;country=brazil");
    }

    private CoordinatorActionBean checkCoordActionDependencies(String actionId, String expDeps) throws Exception {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionId));
            TestRecoveryService.assertEquals((String)expDeps, (String)action.getPushMissingDependencies());
            return action;
        }
        catch (JPAExecutorException se) {
            throw new Exception("Action ID " + actionId + " was not stored properly in db");
        }
    }

    public void testCoordActionRecoveryServiceForSuspended() throws Exception {
        Date start = DateUtils.parseDateOozieTZ((String)"2009-02-01T01:00Z");
        Date end = DateUtils.parseDateOozieTZ((String)"2009-02-02T23:59Z");
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.SUSPENDED, start, end, false, false, 1);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        final String wfJobId = wfJob.getId();
        this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUSPENDED, "coord-action-get.xml", wfJobId, "RUNNING", 2);
        this.sleep(3000);
        RecoveryService.RecoveryRunnable recoveryRunnable = new RecoveryService.RecoveryRunnable(0L, 1L, 1L);
        recoveryRunnable.run();
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestRecoveryService.assertNotNull((Object)jpaService);
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                WorkflowJobGetJPAExecutor wfGetCmd = new WorkflowJobGetJPAExecutor(wfJobId);
                WorkflowJobBean ret = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfGetCmd);
                return ret.getStatus() == WorkflowJob.Status.SUSPENDED;
            }
        });
        WorkflowJobGetJPAExecutor wfGetCmd = new WorkflowJobGetJPAExecutor(wfJobId);
        WorkflowJobBean ret = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfGetCmd);
        TestRecoveryService.assertEquals((Object)WorkflowJob.Status.SUSPENDED, (Object)ret.getStatus());
    }

    public void testCoordActionRecoveryServiceForKilled() throws Exception {
        Date start = DateUtils.parseDateOozieTZ((String)"2009-02-01T01:00Z");
        Date end = DateUtils.parseDateOozieTZ((String)"2009-02-02T23:59Z");
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.KILLED, start, end, false, false, 1);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        final String wfJobId = wfJob.getId();
        this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.KILLED, "coord-action-get.xml", wfJobId, "RUNNING", 1);
        this.sleep(3000);
        RecoveryService.RecoveryRunnable recoveryRunnable = new RecoveryService.RecoveryRunnable(0L, 1L, 1L);
        recoveryRunnable.run();
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestRecoveryService.assertNotNull((Object)jpaService);
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                WorkflowJobGetJPAExecutor wfGetCmd = new WorkflowJobGetJPAExecutor(wfJobId);
                WorkflowJobBean ret = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfGetCmd);
                return ret.getStatus() == WorkflowJob.Status.KILLED;
            }
        });
        WorkflowJobGetJPAExecutor wfGetCmd = new WorkflowJobGetJPAExecutor(wfJobId);
        WorkflowJobBean ret = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfGetCmd);
        TestRecoveryService.assertEquals((Object)WorkflowJob.Status.KILLED, (Object)ret.getStatus());
    }

    public void testCoordActionRecoveryServiceForResume() throws Exception {
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUSPENDED, WorkflowInstance.Status.SUSPENDED);
        final String wfJobId = wfJob.getId();
        this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", wfJobId, "SUSPENDED", 1);
        this.sleep(3000);
        RecoveryService.RecoveryRunnable recoveryRunnable = new RecoveryService.RecoveryRunnable(0L, 1L, 1L);
        recoveryRunnable.run();
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestRecoveryService.assertNotNull((Object)jpaService);
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                WorkflowJobGetJPAExecutor wfGetCmd = new WorkflowJobGetJPAExecutor(wfJobId);
                WorkflowJobBean ret = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfGetCmd);
                return ret.getStatus() == WorkflowJob.Status.RUNNING;
            }
        });
        WorkflowJobGetJPAExecutor wfGetCmd = new WorkflowJobGetJPAExecutor(wfJobId);
        WorkflowJobBean ret = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfGetCmd);
        TestRecoveryService.assertEquals((Object)WorkflowJob.Status.RUNNING, (Object)ret.getStatus());
    }

    protected CoordinatorActionBean addRecordToCoordActionTableForWaiting(String jobId, int actionNum, CoordinatorAction.Status status, String resourceXmlName) throws Exception {
        CoordinatorActionBean action = this.createCoordAction(jobId, actionNum, status, resourceXmlName, 0);
        String testDir = this.getTestCaseDir();
        String missDeps = this.getTestCaseFileUri("2009/29/_SUCCESS") + "#" + this.getTestCaseFileUri("2009/22/_SUCCESS") + "#" + this.getTestCaseFileUri("2009/15/_SUCCESS") + "#" + this.getTestCaseFileUri("2009/08/_SUCCESS");
        missDeps = missDeps.replaceAll("#testDir", testDir);
        action.setMissingDependencies(missDeps);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestRecoveryService.assertNotNull((Object)jpaService);
            CoordActionInsertJPAExecutor coordActionInsertCmd = new CoordActionInsertJPAExecutor(action);
            jpaService.execute((JPAExecutor)coordActionInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            TestRecoveryService.fail((String)"Unable to insert the test coord action record to table");
            throw je;
        }
        return action;
    }

    @Override
    protected String getCoordActionXml(Path appPath, String resourceXmlName) {
        try {
            Reader reader = IOUtils.getResourceAsReader((String)resourceXmlName, (int)-1);
            String appXml = IOUtils.getReaderAsString((Reader)reader, (int)-1);
            String testDir = this.getTestCaseDir();
            appXml = appXml.replaceAll("#testDir", testDir);
            return appXml;
        }
        catch (IOException ioe) {
            throw new RuntimeException(XLog.format((String)("Could not get " + resourceXmlName), (Object[])new Object[]{ioe}));
        }
    }

    private void addRecordToActionTable(String jobId, int actionNum, String actionId, String baseDir) throws Exception {
        CoordinatorActionBean action = new CoordinatorActionBean();
        action.setJobId(jobId);
        action.setId(actionId);
        action.setActionNumber(actionNum);
        action.setNominalTime(new Date());
        action.setLastModifiedTime(new Date());
        action.setStatus(CoordinatorAction.Status.SUBMITTED);
        String appPath = this.getTestCaseFileUri("one-op/workflow.xml");
        String actionXml = "<coordinator-app xmlns='uri:oozie:coordinator:0.2' xmlns:sla='uri:oozie:sla:0.1' name='NAME' frequency=\"1\" start='2009-02-01T01:00Z' end='2009-02-03T23:59Z' timezone='UTC' freq_timeunit='DAY' end_of_duration='NONE'  instance-number=\"1\" action-nominal-time=\"2009-02-01T01:00Z\">";
        actionXml = actionXml + "<controls>";
        actionXml = actionXml + "<timeout>10</timeout>";
        actionXml = actionXml + "<concurrency>2</concurrency>";
        actionXml = actionXml + "<execution>LIFO</execution>";
        actionXml = actionXml + "</controls>";
        actionXml = actionXml + "<input-events>";
        actionXml = actionXml + "<data-in name='A' dataset='a'>";
        actionXml = actionXml + "<dataset name='a' frequency='7' initial-instance='2009-02-01T01:00Z' timezone='UTC' freq_timeunit='DAY' end_of_duration='NONE'>";
        actionXml = actionXml + "<uri-template>" + this.getTestCaseFileUri("workflows/workflows/${YEAR}/${DAY}") + "</uri-template>";
        actionXml = actionXml + "</dataset>";
        actionXml = actionXml + "<instance>${coord:latest(0)}</instance>";
        actionXml = actionXml + "</data-in>";
        actionXml = actionXml + "</input-events>";
        actionXml = actionXml + "<output-events>";
        actionXml = actionXml + "<data-out name='LOCAL_A' dataset='local_a'>";
        actionXml = actionXml + "<dataset name='local_a' frequency='7' initial-instance='2009-02-01T01:00Z' timezone='UTC' freq_timeunit='DAY' end_of_duration='NONE'>";
        actionXml = actionXml + "<uri-template>" + this.getTestCaseFileUri("workflows/${YEAR}/${DAY}") + "</uri-template>";
        actionXml = actionXml + "</dataset>";
        actionXml = actionXml + "<instance>${coord:current(-1)}</instance>";
        actionXml = actionXml + "</data-out>";
        actionXml = actionXml + "</output-events>";
        actionXml = actionXml + "<action>";
        actionXml = actionXml + "<workflow>";
        actionXml = actionXml + "<app-path>" + appPath + "</app-path>";
        actionXml = actionXml + "<configuration>";
        actionXml = actionXml + "<property>";
        actionXml = actionXml + "<name>inputA</name>";
        actionXml = actionXml + "<value>" + this.getTestCaseFileUri("workflows/US/2009/02/") + "</value>";
        actionXml = actionXml + "</property>";
        actionXml = actionXml + "<property>";
        actionXml = actionXml + "<name>inputB</name>";
        actionXml = actionXml + "<value>" + this.getTestCaseFileUri("workflows/US/2009/01/") + "</value>";
        actionXml = actionXml + "</property>";
        actionXml = actionXml + "</configuration>";
        actionXml = actionXml + "</workflow>";
        actionXml = actionXml + "</action>";
        actionXml = actionXml + "</coordinator-app>";
        action.setActionXml(actionXml);
        String createdConf = "<configuration> ";
        createdConf = createdConf + "<property> <name>execution_order</name> <value>LIFO</value> </property>";
        createdConf = createdConf + "<property> <name>user.name</name> <value>" + TestRecoveryService.getTestUser() + "</value> </property>";
        createdConf = createdConf + "<property> <name>group.name</name> <value>other</value> </property>";
        createdConf = createdConf + "<property> <name>app-path</name> <value>" + appPath + "</value> </property>";
        createdConf = createdConf + "<property> <name>jobTracker</name> ";
        createdConf = createdConf + "<value>localhost:9001</value></property>";
        createdConf = createdConf + "<property> <name>nameNode</name> <value>hdfs://localhost:9000</value></property>";
        createdConf = createdConf + "<property> <name>queueName</name> <value>default</value></property>";
        createdConf = createdConf + "</configuration> ";
        XConfiguration conf = new XConfiguration((Reader)new StringReader(createdConf));
        createdConf = conf.toXmlString(false);
        action.setCreatedConf(createdConf);
        this.addRecordToCoordActionTable(action, null);
        String content = "<workflow-app xmlns='uri:oozie:workflow:0.1'  xmlns:sla='uri:oozie:sla:0.1' name='one-op-wf'>";
        content = content + "<start to='fs1'/><action name='fs1'><fs><mkdir path='/tmp'/></fs><ok to='end'/><error to='end'/></action>";
        content = content + "<end name='end' /></workflow-app>";
        this.writeToFile(content, baseDir + "/one-op/");
    }

    private void writeToFile(String content, String appPath) throws IOException {
        this.createDir(new File(appPath));
        File wf = new File(appPath, "workflow.xml");
        try (PrintWriter out = null;){
            out = new PrintWriter(new FileWriter(wf));
            out.println(content);
        }
    }

    private void createDir(File dir) {
        new File(dir, "_SUCCESS").mkdirs();
    }

    private void addRecordToJobTable(String jobId, String baseDir) throws Exception {
        CoordinatorJobBean coordJob = new CoordinatorJobBean();
        coordJob.setId(jobId);
        coordJob.setAppName("testApp");
        coordJob.setAppPath("testAppPath");
        coordJob.setStatus(Job.Status.RUNNING);
        coordJob.setCreatedTime(new Date());
        coordJob.setLastModifiedTime(new Date());
        coordJob.setUser(TestRecoveryService.getTestUser());
        coordJob.setGroup(TestRecoveryService.getTestGroup());
        coordJob.setTimeZone("UTC");
        String confStr = "<configuration></configuration>";
        coordJob.setConf(confStr);
        String appXml = "<coordinator-app xmlns='uri:oozie:coordinator:0.2' name='NAME' frequency=\"1\" start='2009-02-01T01:00Z' end='2009-02-03T23:59Z'";
        appXml = appXml + " timezone='UTC' freq_timeunit='DAY' end_of_duration='NONE'>";
        appXml = appXml + "<controls>";
        appXml = appXml + "<timeout>10</timeout>";
        appXml = appXml + "<concurrency>2</concurrency>";
        appXml = appXml + "<execution>LIFO</execution>";
        appXml = appXml + "</controls>";
        appXml = appXml + "<input-events>";
        appXml = appXml + "<data-in name='A' dataset='a'>";
        appXml = appXml + "<dataset name='a' frequency='7' initial-instance='2009-02-01T01:00Z' timezone='UTC' freq_timeunit='DAY' end_of_duration='NONE'>";
        appXml = appXml + "<uri-template>" + this.getTestCaseFileUri("workflows/${YEAR}/${DAY}") + "</uri-template>";
        appXml = appXml + "</dataset>";
        appXml = appXml + "<instance>${coord:latest(0)}</instance>";
        appXml = appXml + "</data-in>";
        appXml = appXml + "</input-events>";
        appXml = appXml + "<output-events>";
        appXml = appXml + "<data-out name='LOCAL_A' dataset='local_a'>";
        appXml = appXml + "<dataset name='local_a' frequency='7' initial-instance='2009-02-01T01:00Z' timezone='UTC' freq_timeunit='DAY' end_of_duration='NONE'>";
        appXml = appXml + "<uri-template>" + this.getTestCaseFileUri("workflows/${YEAR}/${DAY}") + "</uri-template>";
        appXml = appXml + "</dataset>";
        appXml = appXml + "<instance>${coord:current(-1)}</instance>";
        appXml = appXml + "</data-out>";
        appXml = appXml + "</output-events>";
        appXml = appXml + "<action>";
        appXml = appXml + "<workflow>";
        appXml = appXml + "<app-path>" + this.getTestCaseFileUri("workflows") + "</app-path>";
        appXml = appXml + "<configuration>";
        appXml = appXml + "<property>";
        appXml = appXml + "<name>inputA</name>";
        appXml = appXml + "<value>${coord:dataIn('A')}</value>";
        appXml = appXml + "</property>";
        appXml = appXml + "<property>";
        appXml = appXml + "<name>inputB</name>";
        appXml = appXml + "<value>${coord:dataOut('LOCAL_A')}</value>";
        appXml = appXml + "</property>";
        appXml = appXml + "</configuration>";
        appXml = appXml + "</workflow>";
        appXml = appXml + "</action>";
        appXml = appXml + "</coordinator-app>";
        coordJob.setJobXml(appXml);
        coordJob.setLastActionNumber(0);
        coordJob.setFrequency("1");
        coordJob.setExecutionOrder(CoordinatorJob.Execution.FIFO);
        coordJob.setConcurrency(1);
        try {
            coordJob.setEndTime(DateUtils.parseDateOozieTZ((String)"2009-02-03T23:59Z"));
            coordJob.setStartTime(DateUtils.parseDateOozieTZ((String)"2009-02-01T23:59Z"));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestRecoveryService.fail((String)"Could not set Date/time");
        }
        try {
            this.addRecordToCoordJobTable(coordJob);
        }
        catch (Exception se) {
            se.printStackTrace();
            TestRecoveryService.fail((String)"Unable to insert the test job record to table");
            throw se;
        }
    }

    @Override
    protected WorkflowActionBean addRecordToWfActionTable(String wfId, String actionName, WorkflowAction.Status status) throws Exception {
        WorkflowActionBean action = this.createWorkflowActionSetPending(wfId, status);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestRecoveryService.assertNotNull((Object)jpaService);
            WorkflowActionInsertJPAExecutor actionInsertCmd = new WorkflowActionInsertJPAExecutor(action);
            jpaService.execute((JPAExecutor)actionInsertCmd);
        }
        catch (JPAExecutorException ce) {
            ce.printStackTrace();
            TestRecoveryService.fail((String)"Unable to insert the test wf action record to table");
            throw ce;
        }
        return action;
    }

    protected WorkflowActionBean createWorkflowActionSetPending(String wfId, WorkflowAction.Status status) throws Exception {
        WorkflowActionBean action = new WorkflowActionBean();
        String actionname = "testAction";
        action.setName(actionname);
        action.setId(((UUIDService)Services.get().get(UUIDService.class)).generateChildId(wfId, actionname));
        action.setJobId(wfId);
        action.setType("map-reduce");
        action.setTransition("transition");
        action.setStatus(status);
        action.setCreatedTime(new Date());
        action.setStartTime(new Date());
        action.setEndTime(new Date());
        action.setLastCheckTime(new Date());
        action.setPending();
        action.setUserRetryCount(1);
        action.setUserRetryMax(2);
        action.setUserRetryInterval(1);
        Path inputDir = new Path(this.getFsTestCaseDir(), "input");
        Path outputDir = new Path(this.getFsTestCaseDir(), "output");
        FileSystem fs = this.getFileSystem();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fs.create(new Path(inputDir, "data.txt")));
        w.write("dummy\n");
        w.write("dummy\n");
        ((Writer)w).close();
        String actionXml = "<map-reduce><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration><property><name>mapred.mapper.class</name><value>" + MapperReducerForTest.class.getName() + "</value></property><property><name>mapred.reducer.class</name><value>" + MapperReducerForTest.class.getName() + "</value></property><property><name>mapred.input.dir</name><value>" + inputDir.toString() + "</value></property><property><name>mapred.output.dir</name><value>" + outputDir.toString() + "</value></property></configuration></map-reduce>";
        action.setConf(actionXml);
        return action;
    }
}

