/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.security.AccessControlException;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.oozie.service.GroupsService;
import org.apache.oozie.service.ProxyUserService;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;

public class TestProxyUserService
extends XTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testService() throws Exception {
        Services services = new Services();
        Configuration conf = services.getConf();
        conf.set("oozie.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        services.init();
        try {
            ProxyUserService proxyUser = (ProxyUserService)services.get(ProxyUserService.class);
            Assert.assertNotNull((Object)proxyUser);
        }
        finally {
            services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWrongConfigGroups() throws Exception {
        Services services = new Services();
        Configuration conf = services.getConf();
        conf.set("oozie.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        conf.set("oozie.service.ProxyUserService.proxyuser.foo.hosts", "*");
        try {
            services.init();
            TestProxyUserService.fail();
        }
        catch (ServiceException serviceException) {
        }
        catch (Exception ex) {
            TestProxyUserService.fail();
        }
        finally {
            services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWrongHost() throws Exception {
        Services services = new Services();
        Configuration conf = services.getConf();
        conf.set("oozie.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        conf.set("oozie.service.ProxyUserService.proxyuser.foo.hosts", "otherhost");
        conf.set("oozie.service.ProxyUserService.proxyuser.foo.groups", "*");
        try {
            services.init();
            TestProxyUserService.fail();
        }
        catch (ServiceException serviceException) {
        }
        catch (Exception ex) {
            TestProxyUserService.fail();
        }
        finally {
            services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWrongConfigHosts() throws Exception {
        Services services = new Services();
        Configuration conf = services.getConf();
        conf.set("oozie.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        conf.set("oozie.service.ProxyUserService.proxyuser.foo.groups", "*");
        try {
            services.init();
            TestProxyUserService.fail();
        }
        catch (ServiceException serviceException) {
        }
        catch (Exception ex) {
            TestProxyUserService.fail();
        }
        finally {
            services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValidateAnyHostAnyUser() throws Exception {
        Services services = new Services();
        Configuration conf = services.getConf();
        conf.set("oozie.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        conf.set("oozie.service.ProxyUserService.proxyuser.foo.hosts", "*");
        conf.set("oozie.service.ProxyUserService.proxyuser.foo.groups", "*");
        services.init();
        try {
            ProxyUserService proxyUser = (ProxyUserService)services.get(ProxyUserService.class);
            Assert.assertNotNull((Object)proxyUser);
            proxyUser.validate("foo", "localhost", "bar");
        }
        finally {
            services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidProxyUser() throws Exception {
        Services services = new Services();
        Configuration conf = services.getConf();
        conf.set("oozie.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        conf.set("oozie.service.ProxyUserService.proxyuser.foo.hosts", "*");
        conf.set("oozie.service.ProxyUserService.proxyuser.foo.groups", "*");
        services.init();
        try {
            ProxyUserService proxyUser = (ProxyUserService)services.get(ProxyUserService.class);
            Assert.assertNotNull((Object)proxyUser);
            proxyUser.validate("bar", "localhost", "foo");
            TestProxyUserService.fail();
        }
        catch (AccessControlException proxyUser) {
        }
        catch (Exception ex) {
            TestProxyUserService.fail((String)ex.toString());
        }
        finally {
            services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValidateHost() throws Exception {
        Services services = new Services();
        Configuration conf = services.getConf();
        conf.set("oozie.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        conf.set("oozie.service.ProxyUserService.proxyuser.foo.hosts", "localhost");
        conf.set("oozie.service.ProxyUserService.proxyuser.foo.groups", "*");
        services.init();
        try {
            ProxyUserService proxyUser = (ProxyUserService)services.get(ProxyUserService.class);
            Assert.assertNotNull((Object)proxyUser);
            proxyUser.validate("foo", "localhost", "bar");
        }
        finally {
            services.destroy();
        }
    }

    private String getGroup() throws Exception {
        Services services = new Services();
        Configuration conf = services.getConf();
        conf.set("oozie.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName())));
        conf.set("server.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName())));
        services.init();
        GroupsService groups = (GroupsService)services.get(GroupsService.class);
        List g = groups.getGroups(System.getProperty("user.name"));
        services.destroy();
        return (String)g.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValidateGroup() throws Exception {
        Services services = new Services();
        Configuration conf = services.getConf();
        conf.set("oozie.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        conf.set("oozie.service.ProxyUserService.proxyuser.foo.hosts", "*");
        conf.set("oozie.service.ProxyUserService.proxyuser.foo.groups", this.getGroup());
        services.init();
        try {
            ProxyUserService proxyUser = (ProxyUserService)services.get(ProxyUserService.class);
            Assert.assertNotNull((Object)proxyUser);
            proxyUser.validate("foo", "localhost", System.getProperty("user.name"));
        }
        finally {
            services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnknownHost() throws Exception {
        Services services = new Services();
        Configuration conf = services.getConf();
        conf.set("oozie.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        conf.set("oozie.service.ProxyUserService.proxyuser.foo.hosts", "localhost");
        conf.set("oozie.service.ProxyUserService.proxyuser.foo.groups", "*");
        services.init();
        try {
            ProxyUserService proxyUser = (ProxyUserService)services.get(ProxyUserService.class);
            Assert.assertNotNull((Object)proxyUser);
            proxyUser.validate("foo", "unknownhost.bar.foo", "bar");
            TestProxyUserService.fail();
        }
        catch (AccessControlException proxyUser) {
        }
        catch (Exception ex) {
            TestProxyUserService.fail((String)ex.toString());
        }
        finally {
            services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidHost() throws Exception {
        Services services = new Services();
        Configuration conf = services.getConf();
        conf.set("oozie.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        conf.set("oozie.service.ProxyUserService.proxyuser.foo.hosts", "localhost");
        conf.set("oozie.service.ProxyUserService.proxyuser.foo.groups", "*");
        services.init();
        try {
            ProxyUserService proxyUser = (ProxyUserService)services.get(ProxyUserService.class);
            Assert.assertNotNull((Object)proxyUser);
            proxyUser.validate("foo", "www.example.com", "bar");
            TestProxyUserService.fail();
        }
        catch (AccessControlException proxyUser) {
        }
        catch (Exception ex) {
            TestProxyUserService.fail((String)ex.toString());
        }
        finally {
            services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidGroup() throws Exception {
        Services services = new Services();
        Configuration conf = services.getConf();
        conf.set("oozie.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        conf.set("oozie.service.ProxyUserService.proxyuser.foo.hosts", "localhost");
        conf.set("oozie.service.ProxyUserService.proxyuser.foo.groups", "nobody");
        services.init();
        try {
            ProxyUserService proxyUser = (ProxyUserService)services.get(ProxyUserService.class);
            Assert.assertNotNull((Object)proxyUser);
            proxyUser.validate("foo", "localhost", System.getProperty("user.name"));
            TestProxyUserService.fail();
        }
        catch (AccessControlException proxyUser) {
        }
        catch (Exception ex) {
            TestProxyUserService.fail((String)ex.toString());
        }
        finally {
            services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNullProxyUser() throws Exception {
        Services services = new Services();
        Configuration conf = services.getConf();
        conf.set("oozie.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        services.init();
        try {
            ProxyUserService proxyUser = (ProxyUserService)services.get(ProxyUserService.class);
            Assert.assertNotNull((Object)proxyUser);
            proxyUser.validate(null, "localhost", "bar");
            TestProxyUserService.fail();
        }
        catch (IllegalArgumentException ex) {
            TestProxyUserService.assertTrue((boolean)ex.getMessage().contains("oozie.service.ProxyUserService.proxyuser.#USER#.hosts"));
            TestProxyUserService.assertTrue((boolean)ex.getMessage().contains("oozie.service.ProxyUserService.proxyuser.#USER#.groups"));
        }
        catch (Exception ex) {
            TestProxyUserService.fail((String)ex.toString());
        }
        finally {
            services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNullHost() throws Exception {
        Services services = new Services();
        Configuration conf = services.getConf();
        conf.set("oozie.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName(), ProxyUserService.class.getName())));
        services.init();
        try {
            ProxyUserService proxyUser = (ProxyUserService)services.get(ProxyUserService.class);
            Assert.assertNotNull((Object)proxyUser);
            proxyUser.validate("foo", null, "bar");
            TestProxyUserService.fail();
        }
        catch (IllegalArgumentException ex) {
            TestProxyUserService.assertTrue((boolean)ex.getMessage().contains("oozie.service.ProxyUserService.proxyuser.foo.hosts"));
            TestProxyUserService.assertTrue((boolean)ex.getMessage().contains("oozie.service.ProxyUserService.proxyuser.foo.groups"));
        }
        catch (Exception ex) {
            TestProxyUserService.fail((String)ex.toString());
        }
        finally {
            services.destroy();
        }
    }
}

