/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.JobsConcurrencyService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.ConfigUtils;
import org.apache.oozie.util.Instrumentation;

public class TestJobsConcurrencyService
extends XTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        new Services().init();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testIsLeader() throws Exception {
        JobsConcurrencyService jcs = new JobsConcurrencyService();
        try {
            jcs.init(Services.get());
            TestJobsConcurrencyService.assertTrue((boolean)jcs.isLeader());
        }
        finally {
            jcs.destroy();
        }
    }

    public void testIsJobIdForThisServer() throws Exception {
        JobsConcurrencyService jcs = new JobsConcurrencyService();
        try {
            jcs.init(Services.get());
            TestJobsConcurrencyService.assertTrue((boolean)jcs.isJobIdForThisServer("blah"));
        }
        finally {
            jcs.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetJobIdsForThisServer() throws Exception {
        JobsConcurrencyService jcs = new JobsConcurrencyService();
        try {
            jcs.init(Services.get());
            ArrayList<String> ids = new ArrayList<String>();
            ids.add("blah");
            ids.add("0000002-130521183438837-oozie-rkan-W");
            ids.add("0000001-130521155209569-oozie-rkan-W");
            List ids2 = jcs.getJobIdsForThisServer(ids);
            TestJobsConcurrencyService.assertEquals((int)ids.size(), (int)ids2.size());
            TestJobsConcurrencyService.assertTrue((boolean)ids2.containsAll(ids));
        }
        finally {
            jcs.destroy();
        }
    }

    public void testGetServerUrls() throws Exception {
        JobsConcurrencyService jcs = new JobsConcurrencyService();
        try {
            jcs.init(Services.get());
            Map map = jcs.getServerUrls();
            TestJobsConcurrencyService.assertEquals((int)1, (int)map.size());
            TestJobsConcurrencyService.assertEquals((String)Services.get().getConf().get("oozie.instance.id"), (String)((String)map.keySet().iterator().next()));
            TestJobsConcurrencyService.assertEquals((String)ConfigUtils.getOozieURL((boolean)false), (String)((String)map.get(Services.get().getConf().get("oozie.instance.id"))));
        }
        finally {
            jcs.destroy();
        }
    }

    public void testsAllServerRequest() throws Exception {
        JobsConcurrencyService jcs = new JobsConcurrencyService();
        try {
            jcs.init(Services.get());
            TestJobsConcurrencyService.assertFalse((boolean)jcs.isAllServerRequest(null));
            HashMap<String, String[]> param = new HashMap<String, String[]>();
            TestJobsConcurrencyService.assertFalse((boolean)jcs.isAllServerRequest(param));
            param.put("allservers", new String[]{"test"});
            TestJobsConcurrencyService.assertFalse((boolean)jcs.isAllServerRequest(param));
            param.put("allservers", new String[]{"true"});
            TestJobsConcurrencyService.assertFalse((boolean)jcs.isAllServerRequest(param));
            param.put("allservers", new String[]{"false"});
            TestJobsConcurrencyService.assertFalse((boolean)jcs.isAllServerRequest(param));
        }
        finally {
            jcs.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstrumentation() throws Exception {
        JobsConcurrencyService jcs = new JobsConcurrencyService();
        Instrumentation instr = new Instrumentation();
        try {
            jcs.init(Services.get());
            jcs.instrument(instr);
            String servers = ConfigurationService.get((String)"oozie.instance.id") + "=" + ConfigUtils.getOozieEffectiveUrl();
            TestJobsConcurrencyService.assertEquals((Object)servers, (Object)((Instrumentation.Element)((Map)instr.getVariables().get("oozie")).get("servers")).getValue());
        }
        finally {
            jcs.destroy();
        }
    }
}

