/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.util.Shell;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.dependency.hcat.HCatMessageHandler;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.CoordActionsDeleteJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.HCatAccessorService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.PartitionDependencyManagerService;
import org.apache.oozie.service.RecoveryService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.ZKJobsConcurrencyService;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.test.ZKXTestCase;
import org.apache.oozie.util.HCatURI;

public class TestHAPartitionDependencyManagerService
extends ZKXTestCase {
    protected Services services;
    protected String server;
    protected String db;
    protected String table1;
    protected String table2;
    protected String part1;
    protected String part2;
    protected String part3;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = super.setupServicesForHCatalog(Services.get());
        super.setupHCatalogServer();
        this.services.getConf().setInt("oozie.service.RecoveryService.interval", 1000000);
        this.services.getConf().setInt("oozie.service.PartitionDependencyManagerService.cache.purge.interval", 1000000);
        this.server = super.getHCatalogServer().getMetastoreAuthority();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void populateTable() throws Exception {
        this.dropTable(this.db, this.table1, true);
        this.dropTable(this.db, this.table2, true);
        this.dropDatabase(this.db, true);
        this.createDatabase(this.db);
        this.createTable(this.db, this.table1, "dt,country");
        this.createTable(this.db, this.table2, "dt,country");
    }

    @Override
    protected String getSanitizedTestCaseDir() {
        if (Shell.WINDOWS) {
            return "\\" + this.getTestCaseDir().replaceAll(":", "");
        }
        return this.getTestCaseDir();
    }

    public void testDependencyCacheWithHA() throws Exception {
        this.db = "default";
        this.table1 = "mytbl";
        this.table2 = "mytb2";
        this.part1 = "dt=20120101;country=us";
        this.part2 = "dt=20120102;country=us";
        this.part3 = "dt=20120103;country=us";
        String newHCatDependency1 = "hcat://" + this.server + "/" + this.db + "/" + this.table1 + "/" + this.part1;
        String newHCatDependency2 = "hcat://" + this.server + "/" + this.db + "/" + this.table1 + "/" + this.part2;
        String newHCatDependency3 = "hcat://" + this.server + "/" + this.db + "/" + this.table2 + "/" + this.part3;
        HCatURI dep1 = new HCatURI(newHCatDependency1);
        HCatURI dep2 = new HCatURI(newHCatDependency2);
        HCatURI dep3 = new HCatURI(newHCatDependency3);
        this.populateTable();
        String actionId1 = this.addInitRecords(newHCatDependency1);
        String actionId2 = this.addInitRecords(newHCatDependency2);
        String actionId3 = this.addInitRecords(newHCatDependency3);
        PartitionDependencyManagerService dummyPdms = new PartitionDependencyManagerService();
        PartitionDependencyManagerService pdms = (PartitionDependencyManagerService)Services.get().get(PartitionDependencyManagerService.class);
        dummyPdms.init(Services.get());
        dummyPdms.addMissingDependency(dep1, actionId1);
        dummyPdms.addMissingDependency(dep2, actionId2);
        dummyPdms.addMissingDependency(dep3, actionId3);
        Collection waitingActions = dummyPdms.getWaitingActions(dep1);
        TestHAPartitionDependencyManagerService.assertEquals((int)1, (int)waitingActions.size());
        waitingActions = dummyPdms.getWaitingActions(dep2);
        TestHAPartitionDependencyManagerService.assertEquals((int)1, (int)waitingActions.size());
        waitingActions = dummyPdms.getWaitingActions(dep3);
        TestHAPartitionDependencyManagerService.assertEquals((int)1, (int)waitingActions.size());
        waitingActions = pdms.getWaitingActions(dep1);
        TestHAPartitionDependencyManagerService.assertNull((Object)waitingActions);
        waitingActions = pdms.getWaitingActions(dep2);
        TestHAPartitionDependencyManagerService.assertNull((Object)waitingActions);
        waitingActions = pdms.getWaitingActions(dep3);
        TestHAPartitionDependencyManagerService.assertNull((Object)waitingActions);
        dummyPdms.destroy();
        RecoveryService.RecoveryRunnable recoveryRunnable = new RecoveryService.RecoveryRunnable(60L, 0L, 60L);
        recoveryRunnable.run();
        this.waitFor(30000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                PartitionDependencyManagerService pdms = (PartitionDependencyManagerService)Services.get().get(PartitionDependencyManagerService.class);
                HCatURI dep1 = new HCatURI("hcat://" + TestHAPartitionDependencyManagerService.this.server + "/" + TestHAPartitionDependencyManagerService.this.db + "/" + TestHAPartitionDependencyManagerService.this.table1 + "/" + TestHAPartitionDependencyManagerService.this.part1);
                HCatURI dep2 = new HCatURI("hcat://" + TestHAPartitionDependencyManagerService.this.server + "/" + TestHAPartitionDependencyManagerService.this.db + "/" + TestHAPartitionDependencyManagerService.this.table1 + "/" + TestHAPartitionDependencyManagerService.this.part2);
                HCatURI dep3 = new HCatURI("hcat://" + TestHAPartitionDependencyManagerService.this.server + "/" + TestHAPartitionDependencyManagerService.this.db + "/" + TestHAPartitionDependencyManagerService.this.table2 + "/" + TestHAPartitionDependencyManagerService.this.part3);
                Collection waitingActions = pdms.getWaitingActions(dep1);
                if (waitingActions == null) {
                    return false;
                }
                waitingActions = pdms.getWaitingActions(dep2);
                if (waitingActions == null) {
                    return false;
                }
                waitingActions = pdms.getWaitingActions(dep3);
                return waitingActions != null;
            }
        });
        waitingActions = pdms.getWaitingActions(dep1);
        TestHAPartitionDependencyManagerService.assertEquals((int)1, (int)waitingActions.size());
        TestHAPartitionDependencyManagerService.assertTrue((boolean)waitingActions.contains(actionId1));
        waitingActions = pdms.getWaitingActions(dep2);
        TestHAPartitionDependencyManagerService.assertEquals((int)1, (int)waitingActions.size());
        TestHAPartitionDependencyManagerService.assertTrue((boolean)waitingActions.contains(actionId2));
        waitingActions = pdms.getWaitingActions(dep3);
        TestHAPartitionDependencyManagerService.assertEquals((int)1, (int)waitingActions.size());
        TestHAPartitionDependencyManagerService.assertTrue((boolean)waitingActions.contains(actionId3));
        HCatAccessorService hcatService = (HCatAccessorService)Services.get().get(HCatAccessorService.class);
        TestHAPartitionDependencyManagerService.assertTrue((boolean)hcatService.isRegisteredForNotification(dep1));
        TestHAPartitionDependencyManagerService.assertTrue((boolean)hcatService.isRegisteredForNotification(dep2));
        TestHAPartitionDependencyManagerService.assertTrue((boolean)hcatService.isRegisteredForNotification(dep3));
    }

    protected void addMissingDependencyAndRegister(HCatURI hcatURI, String actionId, PartitionDependencyManagerService pdms) {
        pdms.addMissingDependency(hcatURI, actionId);
        HCatAccessorService hcatService = (HCatAccessorService)Services.get().get(HCatAccessorService.class);
        if (!hcatService.isRegisteredForNotification(hcatURI)) {
            hcatService.registerForNotification(hcatURI, hcatURI.getDb() + "." + hcatURI.getTable(), new HCatMessageHandler(hcatURI.getServer()));
        }
    }

    public void testPurgeMissingDependencies() throws Exception {
        this.services.setService(ZKJobsConcurrencyService.class);
        PartitionDependencyManagerService pdms = (PartitionDependencyManagerService)this.services.get(PartitionDependencyManagerService.class);
        pdms.init(this.services);
        this.testPurgeMissingDependenciesForCache(pdms);
    }

    protected void testPurgeMissingDependenciesForCache(PartitionDependencyManagerService pdms) throws Exception {
        String actionId1 = "1234465451";
        String actionId2 = "1234465452";
        String actionId3 = "1234465453";
        HCatURI dep1 = new HCatURI("hcat://hcat-server1.domain.com:5080/mydb/mytbl1/dt=20120101;country=us");
        HCatURI dep2 = new HCatURI("hcat://hcat-server1.domain.com:5080/mydb/mytbl1/country=us;dt=20120101");
        HCatURI dep3 = new HCatURI("hcat://hcat-server2.domain.com:5080/mydb/mytbl2/dt=20120102;country=us");
        this.addMissingDependencyAndRegister(dep1, actionId1, pdms);
        this.addMissingDependencyAndRegister(dep2, actionId1, pdms);
        this.addMissingDependencyAndRegister(dep2, actionId2, pdms);
        this.addMissingDependencyAndRegister(dep2, actionId3, pdms);
        this.addMissingDependencyAndRegister(dep3, actionId3, pdms);
        ArrayList waitingDep1 = (ArrayList)pdms.getWaitingActions(dep1);
        TestHAPartitionDependencyManagerService.assertEquals((int)waitingDep1.size(), (int)1);
        TestHAPartitionDependencyManagerService.assertEquals((String)((String)waitingDep1.get(0)), (String)actionId1);
        ArrayList waitingDep2 = (ArrayList)pdms.getWaitingActions(dep2);
        TestHAPartitionDependencyManagerService.assertEquals((int)waitingDep2.size(), (int)3);
        for (String id : waitingDep2) {
            TestHAPartitionDependencyManagerService.assertTrue((id.equals(actionId1) || id.equals(actionId2) || id.equals(actionId3) ? 1 : 0) != 0);
        }
        ArrayList waitingDep3 = (ArrayList)pdms.getWaitingActions(dep3);
        TestHAPartitionDependencyManagerService.assertEquals((int)waitingDep3.size(), (int)1);
        TestHAPartitionDependencyManagerService.assertTrue((boolean)((String)waitingDep3.get(0)).equals(actionId3));
        ArrayList<CoordinatorActionBean> insertList = new ArrayList<CoordinatorActionBean>();
        CoordinatorActionBean coordAction1 = new CoordinatorActionBean();
        coordAction1.setId(actionId1);
        coordAction1.setStatus(CoordinatorAction.Status.WAITING);
        insertList.add(coordAction1);
        CoordinatorActionBean coordAction2 = new CoordinatorActionBean();
        coordAction2.setId(actionId2);
        coordAction2.setStatus(CoordinatorAction.Status.RUNNING);
        insertList.add(coordAction2);
        CoordinatorActionBean coordAction3 = new CoordinatorActionBean();
        coordAction3.setId(actionId3);
        coordAction3.setStatus(CoordinatorAction.Status.RUNNING);
        insertList.add(coordAction3);
        BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(insertList, null, null);
        Services.get().getConf().setInt("oozie.service.PartitionDependencyManagerService.cache.purge.ttl", 0);
        pdms.runCachePurgeWorker();
        waitingDep1 = (ArrayList)pdms.getWaitingActions(dep1);
        TestHAPartitionDependencyManagerService.assertEquals((int)waitingDep1.size(), (int)1);
        TestHAPartitionDependencyManagerService.assertTrue((boolean)((String)waitingDep1.get(0)).equals(actionId1));
        waitingDep2 = (ArrayList)pdms.getWaitingActions(dep2);
        TestHAPartitionDependencyManagerService.assertEquals((int)waitingDep2.size(), (int)1);
        TestHAPartitionDependencyManagerService.assertTrue((boolean)((String)waitingDep2.get(0)).equals(actionId1));
        waitingDep3 = (ArrayList)pdms.getWaitingActions(dep3);
        TestHAPartitionDependencyManagerService.assertNull((Object)waitingDep3);
        HCatAccessorService hcatService = (HCatAccessorService)Services.get().get(HCatAccessorService.class);
        TestHAPartitionDependencyManagerService.assertTrue((boolean)hcatService.isRegisteredForNotification(dep1));
        TestHAPartitionDependencyManagerService.assertTrue((boolean)hcatService.isRegisteredForNotification(dep2));
        TestHAPartitionDependencyManagerService.assertFalse((boolean)hcatService.isRegisteredForNotification(dep3));
    }

    public void testCheckAfterActionDelete() throws Exception {
        Services.get().setService(ZKJobsConcurrencyService.class);
        ((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf().setInt("oozie.service.PartitionDependencyManagerService.cache.purge.ttl", 0);
        this.db = "default";
        this.table1 = "mytbl";
        this.table2 = "mytb2";
        this.part1 = "dt=20120101;country=us";
        this.part2 = "dt=20120102;country=us";
        this.part3 = "dt=20120103;country=us";
        String newHCatDependency1 = "hcat://" + this.server + "/" + this.db + "/" + this.table1 + "/" + this.part1;
        String newHCatDependency2 = "hcat://" + this.server + "/" + this.db + "/" + this.table1 + "/" + this.part2;
        String newHCatDependency3 = "hcat://" + this.server + "/" + this.db + "/" + this.table2 + "/" + this.part3;
        HCatURI dep1 = new HCatURI(newHCatDependency1);
        HCatURI dep2 = new HCatURI(newHCatDependency2);
        HCatURI dep3 = new HCatURI(newHCatDependency3);
        this.populateTable();
        String actionId1 = this.addInitRecords(newHCatDependency1);
        String actionId2 = this.addInitRecords(newHCatDependency2);
        String actionId3 = this.addInitRecords(newHCatDependency3);
        PartitionDependencyManagerService pdms = (PartitionDependencyManagerService)Services.get().get(PartitionDependencyManagerService.class);
        pdms.init(Services.get());
        pdms.addMissingDependency(dep1, actionId1);
        pdms.addMissingDependency(dep2, actionId2);
        pdms.addMissingDependency(dep3, actionId3);
        pdms.runCachePurgeWorker();
        TestHAPartitionDependencyManagerService.assertNotNull((Object)pdms.getWaitingActions(dep1));
        TestHAPartitionDependencyManagerService.assertNotNull((Object)pdms.getWaitingActions(dep2));
        TestHAPartitionDependencyManagerService.assertNotNull((Object)pdms.getWaitingActions(dep3));
        ArrayList<String> deleteList = new ArrayList<String>();
        deleteList.add(actionId1);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        jpaService.execute((JPAExecutor)new CoordActionsDeleteJPAExecutor(deleteList));
        pdms.runCachePurgeWorker();
        TestHAPartitionDependencyManagerService.assertNull((Object)pdms.getWaitingActions(dep1));
        TestHAPartitionDependencyManagerService.assertNotNull((Object)pdms.getWaitingActions(dep2));
        TestHAPartitionDependencyManagerService.assertNotNull((Object)pdms.getWaitingActions(dep3));
        deleteList.clear();
        deleteList.add(actionId2);
        jpaService.execute((JPAExecutor)new CoordActionsDeleteJPAExecutor(deleteList));
        pdms.runCachePurgeWorker();
        TestHAPartitionDependencyManagerService.assertNull((Object)pdms.getWaitingActions(dep1));
        TestHAPartitionDependencyManagerService.assertNull((Object)pdms.getWaitingActions(dep2));
        TestHAPartitionDependencyManagerService.assertNotNull((Object)pdms.getWaitingActions(dep3));
    }
}

