/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.service.CallableQueueService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.XCallable;

public class TestCallableQueueService
extends XTestCase {
    static AtomicLong EXEC_ORDER = new AtomicLong();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        new Services().init();
    }

    @Override
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    public void testQueuing() throws Exception {
        CallableQueueService queueservice = (CallableQueueService)Services.get().get(CallableQueueService.class);
        final MyCallable callable = new MyCallable();
        queueservice.queue((XCallable)callable);
        this.waitFor(1000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return callable.executed != 0L;
            }
        });
        TestCallableQueueService.assertTrue((callable.executed != 0L ? 1 : 0) != 0);
    }

    public void testDelayedQueuing() throws Exception {
        CallableQueueService queueservice = (CallableQueueService)Services.get().get(CallableQueueService.class);
        final MyCallable callable = new MyCallable();
        long scheduled = System.currentTimeMillis();
        queueservice.queue((XCallable)callable, 1000L);
        this.waitFor(3000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return callable.executed != 0L;
            }
        });
        TestCallableQueueService.assertTrue((callable.executed >= scheduled + 1000L ? 1 : 0) != 0);
    }

    public void testPriorityExecution() throws Exception {
        EXEC_ORDER = new AtomicLong();
        Services.get().destroy();
        this.setSystemProperty("oozie.service.CallableQueueService.threads", "1");
        new Services().init();
        CallableQueueService queueservice = (CallableQueueService)Services.get().get(CallableQueueService.class);
        final MyCallable callable1 = new MyCallable(0, 200);
        final MyCallable callable2 = new MyCallable(0, 200);
        final MyCallable callable3 = new MyCallable(0, 200);
        final MyCallable callableLow = new MyCallable();
        final MyCallable callableHigh = new MyCallable(1, 10);
        queueservice.queue((XCallable)callable1);
        queueservice.queue((XCallable)callable2);
        queueservice.queue((XCallable)callable3);
        queueservice.queue((XCallable)callableLow);
        queueservice.queue((XCallable)callableHigh);
        this.waitFor(3000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return callable1.executed != 0L && callable2.executed != 0L && callable3.executed != 0L && callableLow.executed != 0L && callableHigh.executed != 0L;
            }
        });
        TestCallableQueueService.assertTrue((callable1.executed >= 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((callable2.executed >= 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((callable3.executed >= 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((callableLow.executed >= 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((callableHigh.executed >= 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((callableHigh.order < callableLow.order ? 1 : 0) != 0);
    }

    public void testQueueSerial() throws Exception {
        EXEC_ORDER = new AtomicLong();
        final MyCallable callable1 = new MyCallable(0, 10);
        final MyCallable callable2 = new MyCallable(0, 10);
        final MyCallable callable3 = new MyCallable(0, 10);
        CallableQueueService queueservice = (CallableQueueService)Services.get().get(CallableQueueService.class);
        queueservice.queueSerial(Arrays.asList(callable1, callable2, callable3));
        this.waitFor(100, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return callable1.executed != 0L && callable2.executed != 0L && callable3.executed != 0L;
            }
        });
        TestCallableQueueService.assertEquals((long)0L, (long)callable1.order);
        TestCallableQueueService.assertEquals((long)1L, (long)callable2.order);
        TestCallableQueueService.assertEquals((long)2L, (long)callable3.order);
    }

    public void testConcurrencyLimit() throws Exception {
        CLCallable.resetConcurrency();
        final CallableQueueService queueservice = (CallableQueueService)Services.get().get(CallableQueueService.class);
        for (int i = 0; i < 10; ++i) {
            queueservice.queue((XCallable)new CLCallable(), 10L);
        }
        float originalRatio = XTestCase.WAITFOR_RATIO;
        try {
            XTestCase.WAITFOR_RATIO = 1.0f;
            this.waitFor(2000, new XTestCase.Predicate(){

                @Override
                public boolean evaluate() throws Exception {
                    return queueservice.queueSize() == 0;
                }
            });
        }
        finally {
            XTestCase.WAITFOR_RATIO = originalRatio;
        }
        System.out.println("Callable Queue Size :" + queueservice.queueSize());
        System.out.println("CLCallable Concurrency :" + CLCallable.getConcurrency());
        TestCallableQueueService.assertTrue((CLCallable.getConcurrency() <= 3 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrencyReachedAndChooseNextEligible() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.CallableQueueService.callable.next.eligible", "true");
        new Services().init();
        CLCallable.resetConcurrency();
        final CallableQueueService queueservice = (CallableQueueService)Services.get().get(CallableQueueService.class);
        MyCallable callable1 = new MyCallable(0, 100);
        MyCallable callable2 = new MyCallable(0, 100);
        MyCallable callable3 = new MyCallable(0, 100);
        MyCallable callable4 = new MyCallable(0, 100);
        MyCallable callable5 = new MyCallable(0, 100);
        MyCallable callable6 = new MyCallable(0, 100);
        List<MyCallable> callables = Arrays.asList(callable1, callable2, callable3, callable4, callable5, callable6);
        MyCallable callableOther = new MyCallable("other", 0, 100);
        long now = System.currentTimeMillis();
        queueservice.queue((XCallable)callableOther, 15L);
        for (MyCallable c : callables) {
            queueservice.queue((XCallable)c, 10L);
        }
        float originalRatio = XTestCase.WAITFOR_RATIO;
        try {
            XTestCase.WAITFOR_RATIO = 1.0f;
            this.waitFor(2000, new XTestCase.Predicate(){

                @Override
                public boolean evaluate() throws Exception {
                    return queueservice.queueSize() == 0;
                }
            });
        }
        finally {
            XTestCase.WAITFOR_RATIO = originalRatio;
        }
        System.out.println("Callable Queue Size :" + queueservice.queueSize());
        long last = Long.MIN_VALUE;
        for (MyCallable c : callables) {
            System.out.println("Callable C executed :" + c.executed);
            TestCallableQueueService.assertTrue((c.executed != 0L ? 1 : 0) != 0);
            last = Math.max(last, c.executed);
        }
        System.out.println("Callable callableOther executed :" + callableOther.executed);
        TestCallableQueueService.assertTrue((callableOther.executed < last ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((callableOther.executed > now + 115L ? 1 : 0) != 0);
    }

    public void testSerialConcurrencyLimit() throws Exception {
        EXEC_ORDER = new AtomicLong();
        final MyCallable callable1 = new MyCallable("TestSerialConcurrencyLimit", 0, 100);
        final MyCallable callable2 = new MyCallable("TestSerialConcurrencyLimit", 0, 100);
        final MyCallable callable3 = new MyCallable("TestSerialConcurrencyLimit", 0, 100);
        final MyCallable callable4 = new MyCallable("TestSerialConcurrencyLimit", 0, 100);
        final MyCallable callable5 = new MyCallable("TestSerialConcurrencyLimit", 0, 100);
        List<MyCallable> callables = Arrays.asList(callable1, callable2, callable3, callable4, callable5);
        CallableQueueService queueservice = (CallableQueueService)Services.get().get(CallableQueueService.class);
        String type = "SerialConcurrencyLimit";
        for (MyCallable c : callables) {
            MyCallable[] myCallableArray = new MyCallable[2];
            myCallableArray[0] = c;
            type = type + "x";
            myCallableArray[1] = new MyCallable(type, 0, 0);
            queueservice.queueSerial(Arrays.asList(myCallableArray));
        }
        this.waitFor(3000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return callable1.executed != 0L && callable2.executed != 0L && callable3.executed != 0L && callable4.executed != 0L && callable5.executed != 0L;
            }
        });
        long first = Long.MAX_VALUE;
        for (MyCallable c : callables) {
            TestCallableQueueService.assertTrue((c.executed != 0L ? 1 : 0) != 0);
            first = Math.min(first, c.executed);
        }
        int secondBatch = 0;
        for (MyCallable c : callables) {
            if (c.executed - first <= 0L) continue;
            ++secondBatch;
        }
        TestCallableQueueService.assertTrue((secondBatch >= 2 ? 1 : 0) != 0);
    }

    public void testConcurrency() throws Exception {
        EXEC_ORDER = new AtomicLong();
        final MyCallable callable1 = new MyCallable("TestConcurrency", 0, 100);
        final MyCallable callable2 = new MyCallable("TestConcurrency", 0, 100);
        final MyCallable callable3 = new MyCallable("TestConcurrency", 0, 100);
        final MyCallable callable4 = new MyCallable("TestConcurrency", 0, 100);
        final MyCallable callable5 = new MyCallable("TestConcurrency", 0, 100);
        List<MyCallable> callables = Arrays.asList(callable1, callable2, callable3, callable4, callable5);
        CallableQueueService queueservice = (CallableQueueService)Services.get().get(CallableQueueService.class);
        for (MyCallable c : callables) {
            queueservice.queue((XCallable)c);
        }
        this.waitFor(3000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return callable1.executed != 0L && callable2.executed != 0L && callable3.executed != 0L && callable4.executed != 0L && callable5.executed != 0L;
            }
        });
        long first = Long.MAX_VALUE;
        for (MyCallable c : callables) {
            TestCallableQueueService.assertTrue((c.executed != 0L ? 1 : 0) != 0);
            first = Math.min(first, c.executed);
        }
        int secondBatch = 0;
        for (MyCallable c : callables) {
            if (c.executed - first <= 0L) continue;
            ++secondBatch;
        }
        TestCallableQueueService.assertTrue((secondBatch >= 2 ? 1 : 0) != 0);
    }

    public void testQueueUniquenessWithSameKey() throws Exception {
        EXEC_ORDER = new AtomicLong();
        final MyCallable callable1 = new MyCallable("QueueUniquenessWithSameKey", "QueueUniquenessWithSameKey", 0, 100);
        final MyCallable callable2 = new MyCallable("QueueUniquenessWithSameKey", "QueueUniquenessWithSameKey", 0, 100);
        final MyCallable callable3 = new MyCallable("QueueUniquenessWithSameKey", "QueueUniquenessWithSameKey", 0, 100);
        List<MyCallable> callables = Arrays.asList(callable1, callable2, callable3);
        CallableQueueService queueservice = (CallableQueueService)Services.get().get(CallableQueueService.class);
        for (MyCallable c : callables) {
            queueservice.queue((XCallable)c);
        }
        this.waitFor(200, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return callable1.executed != 0L && callable2.executed == 0L && callable3.executed == 0L;
            }
        });
        TestCallableQueueService.assertTrue((callable1.executed != 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((callable2.executed == 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((callable3.executed == 0L ? 1 : 0) != 0);
    }

    public void testQueueUniquenessWithSameKeyInComposite() throws Exception {
        EXEC_ORDER = new AtomicLong();
        final MyCallable callable1 = new MyCallable("QueueUniquenessWithSameKeyInComposite", "QueueUniquenessWithSameKeyInComposite", 0, 200);
        final MyCallable callable2 = new MyCallable("QueueUniquenessWithSameKeyInComposite", "QueueUniquenessWithSameKeyInComposite", 0, 200);
        final MyCallable callable3 = new MyCallable("QueueUniquenessWithSameKeyInComposite", "QueueUniquenessWithSameKeyInComposite", 0, 200);
        List<MyCallable> callables = Arrays.asList(callable1, callable2, callable3);
        CallableQueueService queueservice = (CallableQueueService)Services.get().get(CallableQueueService.class);
        String type = "QueueUniquenessWithSameKeyInComposite";
        for (MyCallable c : callables) {
            MyCallable[] myCallableArray = new MyCallable[2];
            myCallableArray[0] = c;
            type = type + "x";
            myCallableArray[1] = new MyCallable(type, 0, 0);
            queueservice.queueSerial(Arrays.asList(myCallableArray), 200L);
        }
        this.waitFor(2000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return callable1.executed != 0L && callable2.executed == 0L && callable3.executed == 0L;
            }
        });
        TestCallableQueueService.assertTrue((callable1.executed != 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((callable2.executed == 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((callable3.executed == 0L ? 1 : 0) != 0);
    }

    public void testQueueUniquenessWithSameKeyInOneComposite() throws Exception {
        EXEC_ORDER = new AtomicLong();
        final MyCallable callable1 = new MyCallable("QueueUniquenessWithSameKeyInOneComposite", "QueueUniquenessWithSameKeyInOneComposite", 0, 100);
        final MyCallable callable2 = new MyCallable("QueueUniquenessWithSameKeyInOneComposite", "QueueUniquenessWithSameKeyInOneComposite", 0, 100);
        final MyCallable callable3 = new MyCallable("QueueUniquenessWithSameKeyInOneComposite", "QueueUniquenessWithSameKeyInOneComposite", 0, 100);
        CallableQueueService queueservice = (CallableQueueService)Services.get().get(CallableQueueService.class);
        queueservice.queueSerial(Arrays.asList(callable1, callable2, callable3));
        this.waitFor(200, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return callable1.executed != 0L && callable2.executed == 0L && callable3.executed == 0L;
            }
        });
        TestCallableQueueService.assertTrue((callable1.executed != 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((callable2.executed == 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((callable3.executed == 0L ? 1 : 0) != 0);
    }

    public void testQueueUniquenessWithDiffKey() throws Exception {
        EXEC_ORDER = new AtomicLong();
        final MyCallable callable1 = new MyCallable("QueueUniquenessWithDiffKey1", "QueueUniquenessWithDiffKey", 0, 100);
        final MyCallable callable2 = new MyCallable("QueueUniquenessWithDiffKey2", "QueueUniquenessWithDiffKey", 0, 100);
        final MyCallable callable3 = new MyCallable("QueueUniquenessWithDiffKey3", "QueueUniquenessWithDiffKey", 0, 100);
        List<MyCallable> callables = Arrays.asList(callable1, callable2, callable3);
        CallableQueueService queueservice = (CallableQueueService)Services.get().get(CallableQueueService.class);
        for (MyCallable c : callables) {
            queueservice.queue((XCallable)c);
        }
        this.waitFor(200, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return callable1.executed != 0L && callable2.executed != 0L && callable3.executed != 0L;
            }
        });
        TestCallableQueueService.assertTrue((callable1.executed != 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((callable2.executed != 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((callable3.executed != 0L ? 1 : 0) != 0);
    }

    public void testQueueUniquenessWithDiffKeyInComposite() throws Exception {
        EXEC_ORDER = new AtomicLong();
        final MyCallable callable1 = new MyCallable("QueueUniquenessWithDiffKeyInComposite1", "QueueUniquenessWithDiffKeyInComposite", 0, 100);
        final MyCallable callable2 = new MyCallable("QueueUniquenessWithDiffKeyInComposite2", "QueueUniquenessWithDiffKeyInComposite", 0, 100);
        final MyCallable callable3 = new MyCallable("QueueUniquenessWithDiffKeyInComposite3", "QueueUniquenessWithDiffKeyInComposite", 0, 100);
        List<MyCallable> callables = Arrays.asList(callable1, callable2, callable3);
        CallableQueueService queueservice = (CallableQueueService)Services.get().get(CallableQueueService.class);
        String type = "QueueUniquenessWithDiffKeyInComposite";
        for (MyCallable c : callables) {
            MyCallable[] myCallableArray = new MyCallable[2];
            myCallableArray[0] = c;
            type = type + "x";
            myCallableArray[1] = new MyCallable(type, 0, 0);
            queueservice.queueSerial(Arrays.asList(myCallableArray));
        }
        this.waitFor(200, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return callable1.executed != 0L && callable2.executed != 0L && callable3.executed != 0L;
            }
        });
        TestCallableQueueService.assertTrue((callable1.executed != 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((callable2.executed != 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((callable3.executed != 0L ? 1 : 0) != 0);
    }

    public void testQueueUniquenessWithDiffKeyInOneComposite() throws Exception {
        EXEC_ORDER = new AtomicLong();
        final MyCallable callable1 = new MyCallable("QueueUniquenessWithDiffKeyInOneComposite1", "QueueUniquenessWithDiffKeyInOneComposite", 0, 100);
        final MyCallable callable2 = new MyCallable("QueueUniquenessWithDiffKeyInOneComposite2", "QueueUniquenessWithDiffKeyInOneComposite", 0, 100);
        final MyCallable callable3 = new MyCallable("QueueUniquenessWithDiffKeyInOneComposite3", "QueueUniquenessWithDiffKeyInOneComposite", 0, 100);
        CallableQueueService queueservice = (CallableQueueService)Services.get().get(CallableQueueService.class);
        queueservice.queueSerial(Arrays.asList(callable1, callable2, callable3));
        this.waitFor(200, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return callable1.executed != 0L && callable2.executed != 0L && callable3.executed != 0L;
            }
        });
        TestCallableQueueService.assertTrue((callable1.executed != 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((callable2.executed != 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((callable3.executed != 0L ? 1 : 0) != 0);
    }

    public void testInterrupt() throws Exception {
        EXEC_ORDER = new AtomicLong();
        Services.get().destroy();
        this.setSystemProperty("oozie.service.CallableQueueService.threads", "1");
        this.setSystemProperty("oozie.service.CallableQueueService.InterruptTypes", "testKill");
        new Services().init();
        CallableQueueService queueservice = (CallableQueueService)Services.get().get(CallableQueueService.class);
        final ExtendedXCommand initialCallable = new ExtendedXCommand("initialKey", "initialType", 2, 200, "initialLockKey");
        final ArrayList<ExtendedXCommand> callables = new ArrayList<ExtendedXCommand>();
        for (int i = 0; i < 10; ++i) {
            callables.add(new ExtendedXCommand("key" + i, "type" + i, 1, 100, "lockKey"));
        }
        final ExtendedXCommand intCallable = new ExtendedXCommand("keyInt", "testKill", 0, 200, "lockKey");
        queueservice.queue((XCallable)initialCallable);
        for (int i = 0; i < 10; ++i) {
            queueservice.queue((XCallable)callables.get(i));
        }
        queueservice.queue((XCallable)intCallable);
        this.waitFor(3000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                boolean retValue = initialCallable.executed != 0L && intCallable.executed != 0L;
                for (ExtendedXCommand c : callables) {
                    retValue = retValue && c.executed != 0L;
                }
                return retValue;
            }
        });
        TestCallableQueueService.assertTrue((initialCallable.executed > 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((intCallable.executed > 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((intCallable.executed < ((ExtendedXCommand)((Object)callables.get((int)5))).executed ? 1 : 0) != 0);
    }

    public void testInterruptsWithDistinguishedLockKeys() throws Exception {
        EXEC_ORDER = new AtomicLong();
        Services.get().destroy();
        this.setSystemProperty("oozie.service.CallableQueueService.threads", "1");
        this.setSystemProperty("oozie.service.CallableQueueService.InterruptTypes", "testKill");
        new Services().init();
        CallableQueueService queueservice = (CallableQueueService)Services.get().get(CallableQueueService.class);
        final ExtendedXCommand initialCallable = new ExtendedXCommand("initialKey", "initialType", 2, 200, "initialLockKey");
        final ArrayList<ExtendedXCommand> callables = new ArrayList<ExtendedXCommand>();
        for (int i = 0; i < 10; ++i) {
            callables.add(new ExtendedXCommand("key" + i, "type" + i, 1, 100, "lockKey" + i));
        }
        final ExtendedXCommand intCallable = new ExtendedXCommand("keyInt", "testKill", 0, 100, "lockKey");
        queueservice.queue((XCallable)initialCallable);
        for (int i = 0; i < 10; ++i) {
            queueservice.queue((XCallable)callables.get(i));
        }
        queueservice.queue((XCallable)intCallable);
        this.waitFor(6000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                boolean retValue = initialCallable.executed != 0L && intCallable.executed != 0L;
                for (ExtendedXCommand c : callables) {
                    retValue = retValue && c.executed != 0L;
                }
                return retValue;
            }
        });
        TestCallableQueueService.assertTrue((initialCallable.executed > 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((intCallable.executed > 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((intCallable.executed > ((ExtendedXCommand)((Object)callables.get((int)5))).executed ? 1 : 0) != 0);
    }

    public void testInterruptsWithCompositeCallable() throws Exception {
        EXEC_ORDER = new AtomicLong();
        Services.get().destroy();
        this.setSystemProperty("oozie.service.CallableQueueService.threads", "1");
        this.setSystemProperty("oozie.service.CallableQueueService.InterruptTypes", "testKill");
        new Services().init();
        CallableQueueService queueservice = (CallableQueueService)Services.get().get(CallableQueueService.class);
        final ExtendedXCommand initialCallable = new ExtendedXCommand("initialKey", "initialType", 2, 200, "initialLockKey");
        final ArrayList<ExtendedXCommand> callables = new ArrayList<ExtendedXCommand>();
        for (int i = 0; i < 10; ++i) {
            callables.add(new ExtendedXCommand("key" + i, "type" + i, 1, 100, "lockKey"));
        }
        final ExtendedXCommand intCallable = new ExtendedXCommand("key5", "testKill", 0, 200, "lockKey");
        queueservice.queue((XCallable)initialCallable);
        queueservice.queueSerial(callables, 0L);
        queueservice.queue((XCallable)intCallable);
        this.waitFor(3000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                boolean retValue = initialCallable.executed != 0L && intCallable.executed != 0L;
                for (ExtendedXCommand c : callables) {
                    retValue = retValue && c.executed != 0L;
                }
                return retValue;
            }
        });
        TestCallableQueueService.assertTrue((initialCallable.executed > 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((intCallable.executed > 0L ? 1 : 0) != 0);
        for (ExtendedXCommand c : callables) {
            TestCallableQueueService.assertTrue((intCallable.executed < c.executed ? 1 : 0) != 0);
        }
    }

    public void testInterruptsInCompositeCallable() throws Exception {
        int i;
        EXEC_ORDER = new AtomicLong();
        Services.get().destroy();
        this.setSystemProperty("oozie.service.CallableQueueService.threads", "1");
        this.setSystemProperty("oozie.service.CallableQueueService.InterruptTypes", "testKill");
        new Services().init();
        CallableQueueService queueservice = (CallableQueueService)Services.get().get(CallableQueueService.class);
        final ExtendedXCommand initialCallable = new ExtendedXCommand("initialKey", "initialType", 2, 200, "initialLockKey");
        final ArrayList<ExtendedXCommand> callables = new ArrayList<ExtendedXCommand>();
        for (i = 0; i < 5; ++i) {
            callables.add(new ExtendedXCommand("key" + i, "type" + i, 1, 100, "lockKey"));
        }
        callables.add(new ExtendedXCommand("key5", "testKill", 1, 100, "lockKey"));
        for (i = 6; i < 10; ++i) {
            callables.add(new ExtendedXCommand("key" + i, "type" + i, 1, 100, "lockKey"));
        }
        queueservice.queue((XCallable)initialCallable);
        queueservice.queueSerial(callables, 0L);
        this.waitFor(3000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                boolean retValue = initialCallable.executed != 0L;
                for (ExtendedXCommand c : callables) {
                    retValue = retValue && c.executed != 0L;
                }
                return retValue;
            }
        });
        TestCallableQueueService.assertTrue((initialCallable.executed > 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((((ExtendedXCommand)((Object)callables.get((int)1))).executed > ((ExtendedXCommand)((Object)callables.get((int)5))).executed ? 1 : 0) != 0);
    }

    public void testMaxInterruptMapSize() throws Exception {
        EXEC_ORDER = new AtomicLong();
        Services.get().destroy();
        this.setSystemProperty("oozie.service.CallableQueueService.threads", "1");
        this.setSystemProperty("oozie.service.CallableQueueService.InterruptTypes", "testKill");
        this.setSystemProperty("oozie.service.CallableQueueService.InterruptMapMaxSize", "0");
        new Services().init();
        CallableQueueService queueservice = (CallableQueueService)Services.get().get(CallableQueueService.class);
        final ExtendedXCommand initialCallable = new ExtendedXCommand("initialKey", "initialType", 2, 100, "initialLockKey");
        final ArrayList<ExtendedXCommand> callables = new ArrayList<ExtendedXCommand>();
        for (int i = 0; i < 10; ++i) {
            callables.add(new ExtendedXCommand("key" + i, "type" + i, 1, 100, "lockKey"));
        }
        final ExtendedXCommand intCallable = new ExtendedXCommand("keyInt", "testKill", 0, 100, "lockKey");
        queueservice.queue((XCallable)initialCallable);
        for (int i = 0; i < 10; ++i) {
            queueservice.queue((XCallable)callables.get(i));
        }
        queueservice.queue((XCallable)intCallable);
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                boolean retValue = initialCallable.executed != 0L && intCallable.executed != 0L;
                for (ExtendedXCommand c : callables) {
                    retValue = retValue && c.executed != 0L;
                }
                return retValue;
            }
        });
        TestCallableQueueService.assertTrue((initialCallable.executed > 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((intCallable.executed > 0L ? 1 : 0) != 0);
        TestCallableQueueService.assertTrue((intCallable.executed > ((ExtendedXCommand)((Object)callables.get((int)5))).executed ? 1 : 0) != 0);
    }

    public void testRemoveUniqueCallables() throws Exception {
        XCommand command = new XCommand("Test", "type", 100){

            protected boolean isLockRequired() {
                return false;
            }

            public String getEntityKey() {
                return "TEST";
            }

            protected void loadState() throws CommandException {
            }

            protected void verifyPrecondition() throws CommandException, PreconditionException {
            }

            protected Object execute() throws CommandException {
                return null;
            }
        };
        Services.get().destroy();
        this.setSystemProperty("oozie.service.CallableQueueService.threads", "1");
        new Services().init();
        CallableQueueService queueservice = (CallableQueueService)Services.get().get(CallableQueueService.class);
        List uniquesBefore = queueservice.getUniqueDump();
        try {
            queueservice.queue((XCallable)command);
            TestCallableQueueService.fail((String)"Expected illegal argument exception: priority = 100");
        }
        catch (Exception e) {
            TestCallableQueueService.assertTrue((e.getCause() != null && e.getCause() instanceof IllegalArgumentException ? 1 : 0) != 0);
        }
        List uniquesAfter = queueservice.getUniqueDump();
        uniquesAfter.removeAll(uniquesBefore);
        TestCallableQueueService.assertTrue((String)uniquesAfter.toString(), (boolean)uniquesAfter.isEmpty());
    }

    public static class CLCallable
    implements XCallable<Void> {
        private static AtomicInteger counter = new AtomicInteger();
        private static int max = 0;

        public String getName() {
            return "name";
        }

        public int getPriority() {
            return 0;
        }

        public String getType() {
            return "type";
        }

        public String getKey() {
            return "name_" + UUID.randomUUID();
        }

        public String getEntityKey() {
            return null;
        }

        public long getCreatedTime() {
            return 0L;
        }

        public void setInterruptMode(boolean mode) {
        }

        public boolean inInterruptMode() {
            return false;
        }

        public Void call() throws Exception {
            this.incr();
            Thread.sleep(100L);
            this.decr();
            return null;
        }

        private void incr() {
            counter.incrementAndGet();
            max = Math.max(max, counter.intValue());
        }

        private void decr() {
            counter.decrementAndGet();
        }

        public static int getConcurrency() {
            return max;
        }

        public static void resetConcurrency() {
            max = 0;
        }
    }

    public static class ExtendedXCommand
    extends XCommand<Void> {
        private boolean lockRequired = true;
        public String lockKey;
        public long wait;
        long executed;

        public ExtendedXCommand(String key, String type, int priority, int wait, String lockKey, boolean lockRequired) {
            super(key, type, priority, false);
            this.lockRequired = lockRequired;
            this.lockKey = lockKey;
            this.wait = wait;
        }

        public ExtendedXCommand(String key, String type, int priority, int wait, String lockKey) {
            super(key, type, priority, false);
            this.lockKey = lockKey;
            this.wait = wait;
        }

        protected boolean isLockRequired() {
            return this.lockRequired;
        }

        protected boolean isReQueueRequired() {
            return false;
        }

        public String getEntityKey() {
            return this.lockKey;
        }

        protected void eagerLoadState() {
        }

        protected void eagerVerifyPrecondition() throws CommandException {
        }

        protected void loadState() {
        }

        protected void verifyPrecondition() throws CommandException {
        }

        protected Void execute() throws CommandException {
            if (this.executed == 0L) {
                try {
                    Thread.sleep(this.wait);
                }
                catch (InterruptedException exp) {
                    throw new CommandException(ErrorCode.ETEST, new Object[]{"invalid_id"});
                }
                this.executed = System.currentTimeMillis();
            }
            return null;
        }
    }

    public static class MyCallable
    implements XCallable<Void> {
        String type;
        int priority;
        long executed = 0L;
        int wait;
        long order;
        long created = System.currentTimeMillis();
        private String name = "myCallable";
        private String key = null;

        public MyCallable() {
            this(0, 0);
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public MyCallable(String type, int priority, int wait) {
            this.type = type;
            this.priority = priority;
            this.wait = wait;
            this.key = this.name + "_" + UUID.randomUUID();
        }

        public MyCallable(String key, String type, int priority, int wait) {
            this.type = type;
            this.priority = priority;
            this.wait = wait;
            this.key = key;
        }

        public MyCallable(int priority, int wait) {
            this("type", priority, wait);
        }

        public int getPriority() {
            return this.priority;
        }

        public long getCreatedTime() {
            return this.created;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Type:").append(this.getType());
            sb.append(",Priority:").append(this.getPriority());
            return sb.toString();
        }

        public Void call() throws Exception {
            this.order = EXEC_ORDER.getAndIncrement();
            Thread.sleep(this.wait);
            this.executed = System.currentTimeMillis();
            return null;
        }

        public String getKey() {
            return this.key;
        }

        public String getEntityKey() {
            return null;
        }

        public void setInterruptMode(boolean mode) {
        }

        public boolean inInterruptMode() {
            return false;
        }
    }
}

