/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.DagEngine;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.ForTestingActionExecutor;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.AuthorizationException;
import org.apache.oozie.service.AuthorizationService;
import org.apache.oozie.service.ForTestAuthorizationService;
import org.apache.oozie.service.GroupsService;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestAuthorizationService
extends XDataTestCase {
    private Services services;

    private void init(boolean useDefaultGroup, boolean useAdminUsersFile) throws Exception {
        this.setSystemProperty("oozie.service.SchemaService.wf.ext.schemas", "wf-ext-schema.xsd");
        this.services = new Services();
        Configuration conf = this.services.getConf();
        if (useAdminUsersFile) {
            Reader adminListReader = IOUtils.getResourceAsReader((String)"adminusers.txt", (int)-1);
            FileWriter adminListWriter = new FileWriter(new File(this.getTestCaseConfDir(), "adminusers.txt"));
            IOUtils.copyCharStream((Reader)adminListReader, (Writer)adminListWriter);
        } else {
            conf.set("oozie.service.AuthorizationService.admin.groups", TestAuthorizationService.getTestGroup());
        }
        conf.set("oozie.services", conf.get("oozie.services") + "," + AuthorizationService.class.getName() + "," + DummyGroupsService.class.getName());
        conf.set("oozie.service.AuthorizationService.default.group.as.acl", Boolean.toString(useDefaultGroup));
        this.services.init();
        this.services.getConf().setBoolean("oozie.service.AuthorizationService.security.enabled", true);
        ((AuthorizationService)this.services.get(AuthorizationService.class)).init(this.services);
        ((ActionService)this.services.get(ActionService.class)).registerAndInitExecutor(ForTestingActionExecutor.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testAuthorizationServiceUseDefaultGroup() throws Exception {
        this._testAuthorizationService(true);
    }

    public void testAuthorizationServiceUseACLs() throws Exception {
        this._testAuthorizationService(false);
    }

    private void _testAuthorizationService(boolean useDefaultGroup) throws Exception {
        this.init(useDefaultGroup, true);
        Reader reader = IOUtils.getResourceAsReader((String)"wf-ext-schema-valid.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        DagEngine engine = new DagEngine(TestAuthorizationService.getTestUser());
        XConfiguration jobConf = new XConfiguration();
        jobConf.set("oozie.wf.application.path", this.getTestCaseFileUri("workflow.xml"));
        jobConf.set("user.name", TestAuthorizationService.getTestUser());
        if (useDefaultGroup) {
            jobConf.set("group.name", TestAuthorizationService.getTestGroup());
        } else {
            jobConf.set("group.name", TestAuthorizationService.getTestGroup() + ",foogrp");
        }
        jobConf.set("oozie.wf.log.token", "t");
        jobConf.set("external-status", "ok");
        jobConf.set("signal-value", "based_on_action_status");
        String jobId = engine.submitJob((Configuration)jobConf, true);
        HadoopAccessorService has = (HadoopAccessorService)Services.get().get(HadoopAccessorService.class);
        URI uri = this.getFileSystem().getUri();
        JobConf fsConf = has.createJobConf(uri.getAuthority());
        FileSystem fileSystem = has.createFileSystem(TestAuthorizationService.getTestUser(), uri, (Configuration)fsConf);
        Path path = new Path(fileSystem.getWorkingDirectory(), UUID.randomUUID().toString());
        Path fsTestDir = fileSystem.makeQualified(path);
        System.out.println(XLog.format((String)"Setting FS testcase work dir[{0}]", (Object[])new Object[]{fsTestDir}));
        fileSystem.delete(fsTestDir, true);
        if (!fileSystem.mkdirs(path)) {
            throw new IOException(XLog.format((String)"Could not create FS testcase dir [{0}]", (Object[])new Object[]{fsTestDir}));
        }
        String appPath = fsTestDir.toString() + "/app";
        Path jobXmlPath = new Path(appPath, "workflow.xml");
        fileSystem.create(jobXmlPath).close();
        fileSystem.setOwner(jobXmlPath, TestAuthorizationService.getTestUser(), TestAuthorizationService.getTestGroup());
        FsPermission permissions = new FsPermission(FsAction.READ_WRITE, FsAction.READ, FsAction.NONE);
        fileSystem.setPermission(jobXmlPath, permissions);
        AuthorizationService as = (AuthorizationService)this.services.get(AuthorizationService.class);
        TestAuthorizationService.assertNotNull((Object)as);
        as.authorizeForGroup(TestAuthorizationService.getTestUser(), TestAuthorizationService.getTestGroup());
        TestAuthorizationService.assertNotNull((Object)as.getDefaultGroup(TestAuthorizationService.getTestUser()));
        as.authorizeForApp(TestAuthorizationService.getTestUser2(), TestAuthorizationService.getTestGroup(), appPath, (Configuration)jobConf);
        try {
            as.authorizeForApp(TestAuthorizationService.getTestUser3(), TestAuthorizationService.getTestGroup(), appPath, (Configuration)jobConf);
            TestAuthorizationService.fail();
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
        as.authorizeForJob(TestAuthorizationService.getTestUser(), jobId, false);
        as.authorizeForJob(TestAuthorizationService.getTestUser(), jobId, true);
        if (!useDefaultGroup) {
            as.authorizeForJob("foo", jobId, true);
        }
        try {
            as.authorizeForJob("bar", jobId, true);
            TestAuthorizationService.fail();
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    public void testAuthorizationServiceForCoord() throws Exception {
        this.init(false, true);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.PREP, false, false);
        TestAuthorizationService.assertNotNull((Object)job);
        AuthorizationService as = (AuthorizationService)this.services.get(AuthorizationService.class);
        TestAuthorizationService.assertNotNull((Object)as);
        as.authorizeForJob(TestAuthorizationService.getTestUser(), job.getId(), false);
        as.authorizeForJob(TestAuthorizationService.getTestUser(), job.getId(), true);
    }

    public void testAuthorizationServiceForBundle() throws Exception {
        this.init(false, true);
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        TestAuthorizationService.assertNotNull((Object)job);
        AuthorizationService as = (AuthorizationService)this.services.get(AuthorizationService.class);
        TestAuthorizationService.assertNotNull((Object)as);
        as.authorizeForJob(TestAuthorizationService.getTestUser(), job.getId(), false);
        as.authorizeForJob(TestAuthorizationService.getTestUser(), job.getId(), true);
    }

    public void testDefaultGroup() throws Exception {
        this.init(false, true);
        AuthorizationService as = (AuthorizationService)this.services.get(AuthorizationService.class);
        TestAuthorizationService.assertNotNull((Object)as);
        TestAuthorizationService.assertNotNull((Object)as.getDefaultGroup(TestAuthorizationService.getTestUser()));
    }

    public void testErrors() throws Exception {
        Path wf;
        Path app;
        this.init(false, true);
        this.services.setService(ForTestAuthorizationService.class);
        AuthorizationService as = (AuthorizationService)this.services.get(AuthorizationService.class);
        Configuration conf = new Configuration();
        HadoopAccessorService has = (HadoopAccessorService)Services.get().get(HadoopAccessorService.class);
        URI uri = this.getFileSystem().getUri();
        JobConf fsConf = has.createJobConf(uri.getAuthority());
        FileSystem fileSystem = has.createFileSystem(TestAuthorizationService.getTestUser(), uri, (Configuration)fsConf);
        try {
            as.authorizeForGroup(TestAuthorizationService.getTestUser3(), TestAuthorizationService.getTestGroup());
            TestAuthorizationService.fail();
        }
        catch (AuthorizationException ex) {
            TestAuthorizationService.assertEquals((Object)ErrorCode.E0502, (Object)ex.getErrorCode());
        }
        try {
            as.authorizeForAdmin(TestAuthorizationService.getTestUser(), true);
            TestAuthorizationService.fail();
        }
        catch (AuthorizationException ex) {
            TestAuthorizationService.assertEquals((Object)ErrorCode.E0503, (Object)ex.getErrorCode());
        }
        try {
            app = new Path(this.getFsTestCaseDir(), "w");
            as.authorizeForApp(TestAuthorizationService.getTestUser(), TestAuthorizationService.getTestGroup(), app.toString(), conf);
            TestAuthorizationService.fail();
        }
        catch (AuthorizationException ex) {
            TestAuthorizationService.assertEquals((Object)ErrorCode.E0504, (Object)ex.getErrorCode());
        }
        try {
            app = new Path(this.getFsTestCaseDir(), "w");
            fileSystem.mkdirs(app);
            as.authorizeForApp(TestAuthorizationService.getTestUser(), TestAuthorizationService.getTestGroup(), app.toString(), conf);
            TestAuthorizationService.fail();
        }
        catch (AuthorizationException ex) {
            TestAuthorizationService.assertEquals((Object)ErrorCode.E0505, (Object)ex.getErrorCode());
        }
        try {
            app = new Path(this.getFsTestCaseDir(), "w");
            wf = new Path(app, "workflow.xml");
            fileSystem.mkdirs(wf);
            as.authorizeForApp(TestAuthorizationService.getTestUser(), TestAuthorizationService.getTestGroup(), app.toString(), conf);
            TestAuthorizationService.fail();
        }
        catch (AuthorizationException ex) {
            TestAuthorizationService.assertEquals((Object)ErrorCode.E0506, (Object)ex.getErrorCode());
        }
        try {
            app = new Path(this.getFsTestCaseDir(), "ww");
            fileSystem.mkdirs(app);
            wf = new Path(app, "workflow.xml");
            fileSystem.create(wf).close();
            FsPermission fsPermission = new FsPermission(FsAction.READ, FsAction.NONE, FsAction.NONE);
            fileSystem.setPermission(app, fsPermission);
            as.authorizeForApp(TestAuthorizationService.getTestUser2(), TestAuthorizationService.getTestGroup() + "-invalid", app.toString(), conf);
            TestAuthorizationService.fail();
        }
        catch (AuthorizationException ex) {
            TestAuthorizationService.assertEquals((Object)ErrorCode.E0507, (Object)ex.getErrorCode());
        }
        try {
            as.authorizeForJob(TestAuthorizationService.getTestUser(), "1", true);
            TestAuthorizationService.fail();
        }
        catch (AuthorizationException ex) {
            TestAuthorizationService.assertEquals((Object)ErrorCode.E0604, (Object)ex.getErrorCode());
        }
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        try {
            as.authorizeForJob(TestAuthorizationService.getTestUser3(), job.getId(), true);
            TestAuthorizationService.fail();
        }
        catch (AuthorizationException ex) {
            TestAuthorizationService.assertEquals((Object)ErrorCode.E0508, (Object)ex.getErrorCode());
        }
    }

    private void _testAdminUsers(boolean useAdminFile, String adminUser, String regularUser) throws Exception {
        this.init(true, useAdminFile);
        AuthorizationService as = (AuthorizationService)this.services.get(AuthorizationService.class);
        as.authorizeForAdmin(adminUser, false);
        as.authorizeForAdmin(adminUser, true);
        try {
            as.authorizeForAdmin(regularUser, true);
            TestAuthorizationService.fail();
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
        try {
            as.authorizeForAdmin(regularUser, true);
            TestAuthorizationService.fail();
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    public void testAdminUsersWithAdminFile() throws Exception {
        this._testAdminUsers(true, "admin", TestAuthorizationService.getTestUser());
    }

    public void testAdminUsersWithAdminGroup() throws Exception {
        this._testAdminUsers(false, TestAuthorizationService.getTestUser(), TestAuthorizationService.getTestUser2());
    }

    public static class DummyGroupsService
    extends GroupsService {
        public void init(Services services) {
        }

        public List<String> getGroups(String user) throws IOException {
            if (TestAuthorizationService.getTestUser().equals(user)) {
                return Arrays.asList("users", TestAuthorizationService.getTestGroup());
            }
            if ("foo".equals(user)) {
                return Arrays.asList("users", "foogrp");
            }
            return Arrays.asList("users");
        }

        public void destroy() {
        }
    }
}

