/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.jms;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.hive.hcatalog.messaging.HCatEventMessage;
import org.apache.hive.hcatalog.messaging.json.JSONAddPartitionMessage;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;
import org.apache.oozie.dependency.hcat.HCatMessageHandler;
import org.apache.oozie.service.HCatAccessorService;
import org.apache.oozie.service.PartitionDependencyManagerService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.HCatURI;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestHCatMessageHandler
extends XDataTestCase {
    private ConnectionFactory connFac;
    private Connection conn;
    private Session session;
    private Services services;

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.services = super.setupServicesForHCatalog();
        this.services.init();
        this.connFac = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        this.conn = this.connFac.createConnection();
        this.conn.start();
        this.session = this.conn.createSession(false, 1);
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        this.services.destroy();
        this.session.close();
        this.conn.close();
        super.tearDown();
    }

    @Test
    public void testCacheUpdateByMessage() {
        try {
            String actionId1 = "1234465451";
            String actionId2 = "1234465452";
            String actionId3 = "1234465453";
            String actionId4 = "1234465454";
            HCatURI dep1 = new HCatURI("hcat://hcat.server.com:5080/mydb/mytbl/dt=20120101;country=us");
            HCatURI dep2 = new HCatURI("hcat://hcat.server.com:5080/mydb/mytbl/country=us;dt=20120101");
            HCatURI dep3 = new HCatURI("hcat://hcat.server.com:5080/mydb/mytbl/dt=20120102;country=us");
            HCatURI dep4 = new HCatURI("hcat://hcat.server.com:5080/mydb/mytbl/dt=20120102;country=us;state=CA");
            PartitionDependencyManagerService pdms = (PartitionDependencyManagerService)Services.get().get(PartitionDependencyManagerService.class);
            pdms.addMissingDependency(dep1, actionId1);
            pdms.addMissingDependency(dep2, actionId2);
            pdms.addMissingDependency(dep3, actionId3);
            pdms.addMissingDependency(dep4, actionId4);
            TestHCatMessageHandler.assertTrue((boolean)pdms.getWaitingActions(dep1).contains(actionId1));
            TestHCatMessageHandler.assertTrue((boolean)pdms.getWaitingActions(dep2).contains(actionId2));
            TestHCatMessageHandler.assertTrue((boolean)pdms.getWaitingActions(dep3).contains(actionId3));
            TestHCatMessageHandler.assertTrue((boolean)pdms.getWaitingActions(dep4).contains(actionId4));
            ArrayList<Map<String, String>> partitionsList = new ArrayList<Map<String, String>>();
            partitionsList.add(this.getPartitionMap("dt=20120101;country=us;state=CA"));
            partitionsList.add(this.getPartitionMap("dt=20120101;country=us;state=NY"));
            JSONAddPartitionMessage jsonMsg = new JSONAddPartitionMessage("thrift://" + dep1.getServer(), "", dep1.getDb(), dep1.getTable(), partitionsList, Long.valueOf(System.currentTimeMillis()));
            TextMessage msg = this.session.createTextMessage(jsonMsg.toString());
            msg.setStringProperty("HCAT_EVENT", HCatEventMessage.EventType.ADD_PARTITION.toString());
            HCatMessageHandler hcatHandler = new HCatMessageHandler("hcat.server.com:5080");
            hcatHandler.process((Message)msg);
            TestHCatMessageHandler.assertNull((Object)pdms.getWaitingActions(dep1));
            TestHCatMessageHandler.assertNull((Object)pdms.getWaitingActions(dep2));
            TestHCatMessageHandler.assertTrue((boolean)pdms.getWaitingActions(dep3).contains(actionId3));
            TestHCatMessageHandler.assertTrue((boolean)pdms.getWaitingActions(dep4).contains(actionId4));
            partitionsList.clear();
            partitionsList.add(this.getPartitionMap("dt=20120102;country=us;state=CA"));
            partitionsList.add(this.getPartitionMap("dt=20120102;country=us;state=NY"));
            jsonMsg = new JSONAddPartitionMessage("thrift://" + dep1.getServer(), "", dep1.getDb(), dep1.getTable(), partitionsList, Long.valueOf(System.currentTimeMillis()));
            msg = this.session.createTextMessage(jsonMsg.toString());
            msg.setStringProperty("HCAT_EVENT", HCatEventMessage.EventType.ADD_PARTITION.toString());
            HCatAccessorService hcatService = (HCatAccessorService)Services.get().get(HCatAccessorService.class);
            hcatService.registerForNotification(dep1, "hcat.topic1", hcatHandler);
            Topic topic = this.session.createTopic("hcat.topic1");
            MessageProducer producer = this.session.createProducer((Destination)topic);
            producer.send((Message)msg);
            Thread.sleep(500L);
            TestHCatMessageHandler.assertNull((Object)pdms.getWaitingActions(dep3));
            TestHCatMessageHandler.assertNull((Object)pdms.getWaitingActions(dep4));
            TestHCatMessageHandler.assertTrue((boolean)pdms.getAvailableDependencyURIs(actionId1).contains(dep1.getURI().toString()));
            TestHCatMessageHandler.assertTrue((boolean)pdms.getAvailableDependencyURIs(actionId2).contains(dep2.getURI().toString()));
            TestHCatMessageHandler.assertTrue((boolean)pdms.getAvailableDependencyURIs(actionId3).contains(dep3.getURI().toString()));
            TestHCatMessageHandler.assertTrue((boolean)pdms.getAvailableDependencyURIs(actionId4).contains(dep4.getURI().toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestHCatMessageHandler.fail((String)("Exception: " + e.getMessage()));
        }
    }

    public void testDropEventTypeMessage() {
        try {
            Logger logger = Logger.getLogger(HCatMessageHandler.class);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            SimpleLayout layout = new SimpleLayout();
            WriterAppender appender = new WriterAppender((Layout)layout, (OutputStream)out);
            logger.addAppender((Appender)appender);
            TextMessage msg = this.session.createTextMessage("{\"server\" : \"thrift://localhost:1234\",\"db\" : \"default\",\"table\" : \"newTable\",\"timestamp\" : \"123456\",\"partitions\" : [{ \"dt\" : \"2012_01_01\", \"grid\" : \"AB\" }]}");
            msg.setStringProperty("HCAT_EVENT", HCatEventMessage.EventType.DROP_PARTITION.toString());
            HCatMessageHandler hcatHandler = new HCatMessageHandler("localhost");
            hcatHandler.process((Message)msg);
            String logMsg = out.toString();
            TestHCatMessageHandler.assertTrue((boolean)logMsg.contains(HCatEventMessage.EventType.DROP_PARTITION.toString()));
            msg.setStringProperty("HCAT_EVENT", HCatEventMessage.EventType.DROP_TABLE.toString());
            hcatHandler.process((Message)msg);
            logMsg = out.toString();
            TestHCatMessageHandler.assertTrue((boolean)logMsg.contains(HCatEventMessage.EventType.DROP_TABLE.toString()));
        }
        catch (Exception e) {
            TestHCatMessageHandler.fail((String)("Exception caused " + e.getMessage()));
        }
    }
}

