/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobsGetFromWorkflowParentIdJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestWorkflowJobsGetFromWorkflowParentIdJPAExecutor
extends XDataTestCase {
    Services services;
    private String[] excludedServices = new String[]{"org.apache.oozie.service.StatusTransitService", "org.apache.oozie.service.PauseTransitService", "org.apache.oozie.service.PurgeService", "org.apache.oozie.service.CoordMaterializeTriggerService", "org.apache.oozie.service.RecoveryService"};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testGetWorkflowParent() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowJobsGetFromWorkflowParentIdJPAExecutor.assertNotNull((Object)jpaService);
        WorkflowJobBean wfJobA = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean wfJobB = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean subwfJobA1 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJobA.getId());
        WorkflowJobBean subwfJobA2 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJobA.getId());
        WorkflowJobBean subwfJobB = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJobB.getId());
        WorkflowActionBean wfActionA = this.addRecordToWfActionTable(wfJobA.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfActionB = this.addRecordToWfActionTable(wfJobB.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean subwfActionA1 = this.addRecordToWfActionTable(subwfJobA1.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean subwfActionA2 = this.addRecordToWfActionTable(subwfJobA2.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean subwfActionB = this.addRecordToWfActionTable(subwfJobB.getId(), "1", WorkflowAction.Status.OK);
        ArrayList<String> children = new ArrayList<String>();
        children.addAll((Collection)jpaService.execute((JPAExecutor)new WorkflowJobsGetFromWorkflowParentIdJPAExecutor(wfJobA.getId(), 10)));
        this.checkChildren(children, subwfJobA1.getId(), subwfJobA2.getId());
        children = new ArrayList();
        children.addAll((Collection)jpaService.execute((JPAExecutor)new WorkflowJobsGetFromWorkflowParentIdJPAExecutor(wfJobB.getId(), 10)));
        this.checkChildren(children, subwfJobB.getId());
    }

    public void testGetCoordinatorParentTooMany() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowJobsGetFromWorkflowParentIdJPAExecutor.assertNotNull((Object)jpaService);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean subwfJob1 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        WorkflowJobBean subwfJob2 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        WorkflowJobBean subwfJob3 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        WorkflowJobBean subwfJob4 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        WorkflowJobBean subwfJob5 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        WorkflowActionBean wfAction1 = this.addRecordToWfActionTable(wfJob.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction2 = this.addRecordToWfActionTable(wfJob.getId(), "2", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction3 = this.addRecordToWfActionTable(wfJob.getId(), "3", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction4 = this.addRecordToWfActionTable(wfJob.getId(), "4", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction5 = this.addRecordToWfActionTable(wfJob.getId(), "5", WorkflowAction.Status.OK);
        WorkflowActionBean subwfAction1 = this.addRecordToWfActionTable(subwfJob1.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean subwfAction2 = this.addRecordToWfActionTable(subwfJob2.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean subwfAction3 = this.addRecordToWfActionTable(subwfJob3.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean subwfAction4 = this.addRecordToWfActionTable(subwfJob4.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean subwfAction5 = this.addRecordToWfActionTable(subwfJob5.getId(), "1", WorkflowAction.Status.OK);
        ArrayList<String> children = new ArrayList<String>();
        children.addAll((Collection)jpaService.execute((JPAExecutor)new WorkflowJobsGetFromWorkflowParentIdJPAExecutor(wfJob.getId(), 3)));
        TestWorkflowJobsGetFromWorkflowParentIdJPAExecutor.assertEquals((int)3, (int)children.size());
        children.addAll((Collection)jpaService.execute((JPAExecutor)new WorkflowJobsGetFromWorkflowParentIdJPAExecutor(wfJob.getId(), 3, 3)));
        TestWorkflowJobsGetFromWorkflowParentIdJPAExecutor.assertEquals((int)5, (int)children.size());
        this.checkChildren(children, subwfJob1.getId(), subwfJob2.getId(), subwfJob3.getId(), subwfJob4.getId(), subwfJob5.getId());
    }

    private void checkChildren(List<String> children, String ... wfJobIDs) {
        TestWorkflowJobsGetFromWorkflowParentIdJPAExecutor.assertEquals((int)wfJobIDs.length, (int)children.size());
        Arrays.sort(wfJobIDs);
        Collections.sort(children);
        for (int i = 0; i < wfJobIDs.length; ++i) {
            TestWorkflowJobsGetFromWorkflowParentIdJPAExecutor.assertEquals((String)wfJobIDs[i], (String)children.get(i));
        }
    }
}

