/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionSubsetGetJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestWorkflowActionSubsetGetJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testWfActionSubsetGet() throws Exception {
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.RUNNING);
        this.addRecordToWfActionTable(job.getId(), "2", WorkflowAction.Status.RUNNING);
        this._testWfActionSubsetGet(job.getId());
        System.out.println("testWfActionSubsetGet Successful");
    }

    private void _testWfActionSubsetGet(String wfId) throws JPAExecutorException {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowActionSubsetGetJPAExecutor.assertNotNull((Object)jpaService);
        WorkflowActionSubsetGetJPAExecutor wfActionCmd = new WorkflowActionSubsetGetJPAExecutor(wfId, 1, 1);
        List actions = (List)jpaService.execute((JPAExecutor)wfActionCmd);
        TestWorkflowActionSubsetGetJPAExecutor.assertEquals((int)1, (int)actions.size());
        wfActionCmd = new WorkflowActionSubsetGetJPAExecutor(wfId, 1, 2);
        actions = (List)jpaService.execute((JPAExecutor)wfActionCmd);
        TestWorkflowActionSubsetGetJPAExecutor.assertEquals((int)2, (int)actions.size());
    }
}

