/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionGetJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestWorkflowActionGetJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testWfActionGet() throws Exception {
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.PREP);
        this._testGetAction(action.getId());
    }

    private void _testGetAction(String actionId) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowActionGetJPAExecutor.assertNotNull((Object)jpaService);
        WorkflowActionGetJPAExecutor actionGetCmd = new WorkflowActionGetJPAExecutor(actionId);
        WorkflowActionBean ret = (WorkflowActionBean)jpaService.execute((JPAExecutor)actionGetCmd);
        TestWorkflowActionGetJPAExecutor.assertNotNull((Object)ret);
        TestWorkflowActionGetJPAExecutor.assertEquals((String)ret.getId(), (String)actionId);
    }

    public void testWfActionGetWithExecPath() throws Exception {
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        StringBuilder execPath = new StringBuilder("");
        for (int i = 0; i < 20; ++i) {
            execPath.append("/fork" + i);
        }
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.PREP, execPath.toString(), false);
        this._testGetActionWithExecPath(action.getId(), execPath.toString());
    }

    private void _testGetActionWithExecPath(String actionId, String execPath) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowActionGetJPAExecutor.assertNotNull((Object)jpaService);
        WorkflowActionGetJPAExecutor actionGetCmd = new WorkflowActionGetJPAExecutor(actionId);
        WorkflowActionBean ret = (WorkflowActionBean)jpaService.execute((JPAExecutor)actionGetCmd);
        TestWorkflowActionGetJPAExecutor.assertNotNull((Object)ret);
        TestWorkflowActionGetJPAExecutor.assertEquals((String)ret.getId(), (String)actionId);
        TestWorkflowActionGetJPAExecutor.assertEquals((String)ret.getExecutionPath(), (String)execPath);
    }
}

