/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.executor.jpa.SLARegistrationQueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.test.XDataTestCase;

public class TestSLARegistrationQueryExecutor
extends XDataTestCase {
    Services services;
    JPAService jpaService;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        this.jpaService = (JPAService)Services.get().get(JPAService.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testGetUpdateQuery() throws Exception {
        EntityManager em = this.jpaService.getEntityManager();
        SLARegistrationBean bean = this.addRecordToSLARegistrationTable("test-application", SLAEvent.SLAStatus.MET);
        Query query = SLARegistrationQueryExecutor.getInstance().getUpdateQuery((Enum)SLARegistrationQueryExecutor.SLARegQuery.UPDATE_SLA_REG_ALL, (Object)bean, em);
        TestSLARegistrationQueryExecutor.assertEquals((Object)query.getParameterValue("jobId"), (Object)bean.getId());
        TestSLARegistrationQueryExecutor.assertEquals((Object)query.getParameterValue("nominalTime"), (Object)bean.getNominalTimestamp());
        TestSLARegistrationQueryExecutor.assertEquals((Object)query.getParameterValue("expectedStartTime"), (Object)bean.getExpectedStartTimestamp());
        TestSLARegistrationQueryExecutor.assertEquals((Object)query.getParameterValue("expectedEndTime"), (Object)bean.getExpectedEndTimestamp());
        TestSLARegistrationQueryExecutor.assertEquals((Object)query.getParameterValue("expectedDuration"), (Object)bean.getExpectedDuration());
        TestSLARegistrationQueryExecutor.assertEquals((Object)query.getParameterValue("slaConfig"), (Object)bean.getSlaConfig());
        TestSLARegistrationQueryExecutor.assertEquals((Object)query.getParameterValue("notificationMsg"), (Object)bean.getNotificationMsg());
        TestSLARegistrationQueryExecutor.assertEquals((Object)query.getParameterValue("upstreamApps"), (Object)bean.getUpstreamApps());
        TestSLARegistrationQueryExecutor.assertEquals((Object)query.getParameterValue("appType"), (Object)bean.getAppType().toString());
        TestSLARegistrationQueryExecutor.assertEquals((Object)query.getParameterValue("appName"), (Object)bean.getAppName());
        TestSLARegistrationQueryExecutor.assertEquals((Object)query.getParameterValue("user"), (Object)bean.getUser());
        TestSLARegistrationQueryExecutor.assertEquals((Object)query.getParameterValue("parentId"), (Object)bean.getParentId());
        TestSLARegistrationQueryExecutor.assertEquals((Object)query.getParameterValue("jobData"), (Object)bean.getJobData());
        em.close();
    }

    public void testGetSelectQuery() throws Exception {
        EntityManager em = this.jpaService.getEntityManager();
        SLARegistrationBean bean = this.addRecordToSLARegistrationTable("test-application", SLAEvent.SLAStatus.MET);
        Query query = SLARegistrationQueryExecutor.getInstance().getSelectQuery((Enum)SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ALL, em, new Object[]{bean.getId()});
        TestSLARegistrationQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = SLARegistrationQueryExecutor.getInstance().getSelectQuery((Enum)SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ON_RESTART, em, new Object[]{bean.getId()});
        TestSLARegistrationQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
    }

    public void testGet() throws Exception {
        SLARegistrationBean bean = this.addRecordToSLARegistrationTable("test-application", SLAEvent.SLAStatus.MET);
        SLARegistrationBean retBean = (SLARegistrationBean)SLARegistrationQueryExecutor.getInstance().get((Enum)SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ON_RESTART, new Object[]{bean.getId()});
        TestSLARegistrationQueryExecutor.assertEquals((String)bean.getJobData(), (String)retBean.getJobData());
        TestSLARegistrationQueryExecutor.assertEquals((String)bean.getSlaConfig(), (String)retBean.getSlaConfig());
        TestSLARegistrationQueryExecutor.assertEquals((String)bean.getUpstreamApps(), (String)retBean.getUpstreamApps());
        TestSLARegistrationQueryExecutor.assertEquals((String)bean.getNotificationMsg(), (String)retBean.getNotificationMsg());
        TestSLARegistrationQueryExecutor.assertNull((Object)retBean.getAppName());
        TestSLARegistrationQueryExecutor.assertNull((Object)retBean.getExpectedEnd());
        TestSLARegistrationQueryExecutor.assertNull((Object)retBean.getExpectedStart());
        TestSLARegistrationQueryExecutor.assertNull((Object)retBean.getCreatedTime());
        TestSLARegistrationQueryExecutor.assertNull((Object)retBean.getNominalTime());
        TestSLARegistrationQueryExecutor.assertNull((Object)retBean.getUser());
        TestSLARegistrationQueryExecutor.assertNull((Object)retBean.getParentId());
        retBean = (SLARegistrationBean)SLARegistrationQueryExecutor.getInstance().get((Enum)SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ALL, new Object[]{bean.getId()});
        TestSLARegistrationQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestSLARegistrationQueryExecutor.assertEquals((String)bean.getAppName(), (String)retBean.getAppName());
        TestSLARegistrationQueryExecutor.assertEquals((Object)bean.getAppType(), (Object)retBean.getAppType());
        TestSLARegistrationQueryExecutor.assertEquals((long)bean.getExpectedDuration(), (long)retBean.getExpectedDuration());
        TestSLARegistrationQueryExecutor.assertEquals((long)bean.getExpectedStart().getTime(), (long)retBean.getExpectedStart().getTime());
        TestSLARegistrationQueryExecutor.assertEquals((long)bean.getExpectedEnd().getTime(), (long)retBean.getExpectedEnd().getTime());
        TestSLARegistrationQueryExecutor.assertEquals((long)bean.getCreatedTime().getTime(), (long)retBean.getCreatedTime().getTime());
        TestSLARegistrationQueryExecutor.assertEquals((long)bean.getNominalTime().getTime(), (long)retBean.getNominalTime().getTime());
        TestSLARegistrationQueryExecutor.assertEquals((String)bean.getNotificationMsg(), (String)retBean.getNotificationMsg());
        TestSLARegistrationQueryExecutor.assertEquals((String)bean.getJobData(), (String)retBean.getJobData());
        TestSLARegistrationQueryExecutor.assertEquals((String)bean.getParentId(), (String)retBean.getParentId());
        TestSLARegistrationQueryExecutor.assertEquals((String)bean.getSlaConfig(), (String)retBean.getSlaConfig());
        TestSLARegistrationQueryExecutor.assertEquals((String)bean.getUpstreamApps(), (String)retBean.getUpstreamApps());
        TestSLARegistrationQueryExecutor.assertEquals((String)bean.getUser(), (String)retBean.getUser());
    }

    public void testExecuteUpdate() throws Exception {
    }

    public void testGetList() throws Exception {
    }

    public void testInsert() throws Exception {
    }
}

