/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobsGetFromParentIdJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestCoordJobsGetFromParentIdJPAExecutor
extends XDataTestCase {
    Services services;
    private String[] excludedServices = new String[]{"org.apache.oozie.service.StatusTransitService", "org.apache.oozie.service.PauseTransitService", "org.apache.oozie.service.PurgeService", "org.apache.oozie.service.CoordMaterializeTriggerService", "org.apache.oozie.service.RecoveryService"};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testGetBundleParent() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobsGetFromParentIdJPAExecutor.assertNotNull((Object)jpaService);
        BundleJobBean bundleJobA = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, false);
        BundleJobBean bundleJobB = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, false);
        CoordinatorJobBean coordJobA1 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        CoordinatorJobBean coordJobA2 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        coordJobA2.setAppName("something_different");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJobA2);
        CoordinatorJobBean coordJobB = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        CoordinatorActionBean coordActionA1 = this.addRecordToCoordActionTable(coordJobA1.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        CoordinatorActionBean coordActionA2 = this.addRecordToCoordActionTable(coordJobA2.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        CoordinatorActionBean coordActionB = this.addRecordToCoordActionTable(coordJobB.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        BundleActionBean bundleActionA1 = this.addRecordToBundleActionTable(bundleJobA.getId(), coordJobA1.getId(), coordJobA1.getAppName(), 0, Job.Status.SUCCEEDED);
        BundleActionBean bundleActionA2 = this.addRecordToBundleActionTable(bundleJobA.getId(), coordJobA2.getId(), coordJobA2.getAppName(), 0, Job.Status.SUCCEEDED);
        BundleActionBean bundleActionB = this.addRecordToBundleActionTable(bundleJobB.getId(), coordJobB.getId(), coordJobB.getAppName(), 0, Job.Status.SUCCEEDED);
        ArrayList<String> children = new ArrayList<String>();
        children.addAll((Collection)jpaService.execute((JPAExecutor)new CoordJobsGetFromParentIdJPAExecutor(bundleJobA.getId(), 10)));
        this.checkChildren(children, coordJobA1.getId(), coordJobA2.getId());
        children = new ArrayList();
        children.addAll((Collection)jpaService.execute((JPAExecutor)new CoordJobsGetFromParentIdJPAExecutor(bundleJobB.getId(), 10)));
        this.checkChildren(children, coordJobB.getId());
    }

    public void testGetBundleParentTooMany() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobsGetFromParentIdJPAExecutor.assertNotNull((Object)jpaService);
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, false);
        CoordinatorJobBean coordJob1 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        coordJob1.setAppName("coordJob1");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob1);
        CoordinatorJobBean coordJob2 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        coordJob2.setAppName("coordJob2");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob2);
        CoordinatorJobBean coordJob3 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        coordJob3.setAppName("coordJob3");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob3);
        CoordinatorJobBean coordJob4 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        coordJob4.setAppName("coordJob4");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob4);
        CoordinatorJobBean coordJob5 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        coordJob5.setAppName("coordJob5");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob5);
        CoordinatorActionBean coordAction1 = this.addRecordToCoordActionTable(coordJob1.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        CoordinatorActionBean coordAction2 = this.addRecordToCoordActionTable(coordJob2.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        CoordinatorActionBean coordAction3 = this.addRecordToCoordActionTable(coordJob3.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        CoordinatorActionBean coordAction4 = this.addRecordToCoordActionTable(coordJob4.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        CoordinatorActionBean coordAction5 = this.addRecordToCoordActionTable(coordJob5.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        BundleActionBean bundleAction1 = this.addRecordToBundleActionTable(bundleJob.getId(), coordJob1.getId(), coordJob1.getAppName(), 0, Job.Status.SUCCEEDED);
        BundleActionBean bundleAction2 = this.addRecordToBundleActionTable(bundleJob.getId(), coordJob2.getId(), coordJob2.getAppName(), 0, Job.Status.SUCCEEDED);
        BundleActionBean bundleAction3 = this.addRecordToBundleActionTable(bundleJob.getId(), coordJob3.getId(), coordJob3.getAppName(), 0, Job.Status.SUCCEEDED);
        BundleActionBean bundleAction4 = this.addRecordToBundleActionTable(bundleJob.getId(), coordJob4.getId(), coordJob4.getAppName(), 0, Job.Status.SUCCEEDED);
        BundleActionBean bundleAction5 = this.addRecordToBundleActionTable(bundleJob.getId(), coordJob5.getId(), coordJob5.getAppName(), 0, Job.Status.SUCCEEDED);
        ArrayList<String> children = new ArrayList<String>();
        children.addAll((Collection)jpaService.execute((JPAExecutor)new CoordJobsGetFromParentIdJPAExecutor(bundleJob.getId(), 3)));
        TestCoordJobsGetFromParentIdJPAExecutor.assertEquals((int)3, (int)children.size());
        children.addAll((Collection)jpaService.execute((JPAExecutor)new CoordJobsGetFromParentIdJPAExecutor(bundleJob.getId(), 3, 3)));
        TestCoordJobsGetFromParentIdJPAExecutor.assertEquals((int)5, (int)children.size());
        this.checkChildren(children, coordJob1.getId(), coordJob2.getId(), coordJob3.getId(), coordJob4.getId(), coordJob5.getId());
    }

    private void checkChildren(List<String> children, String ... coordJobIDs) {
        TestCoordJobsGetFromParentIdJPAExecutor.assertEquals((int)coordJobIDs.length, (int)children.size());
        Arrays.sort(coordJobIDs);
        Collections.sort(children);
        for (int i = 0; i < coordJobIDs.length; ++i) {
            TestCoordJobsGetFromParentIdJPAExecutor.assertEquals((String)coordJobIDs[i], (String)children.get(i));
        }
    }
}

