/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.executor.jpa.CoordJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobsGetForPurgeJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XFsTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;

public class TestCoordJobsGetForPurgeJPAExecutor
extends XFsTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LocalOozie.start();
    }

    @Override
    protected void tearDown() throws Exception {
        LocalOozie.stop();
        super.tearDown();
    }

    public void testCoordJobsGetForPurgeJPAExecutorWithParent() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobsGetForPurgeJPAExecutor.assertNotNull((Object)jpaService);
        String jobId1 = "00001-" + new Date().getTime() + "-TestCoordJobsGetForPurgeJPAExecutor-C";
        this.insertJob(jobId1, Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        String jobId2 = "00002-" + new Date().getTime() + "-TestCoordJobsGetForPurgeJPAExecutor-C";
        CoordinatorJobBean job2 = this.insertJob(jobId2, Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        job2.setBundleId("some_bundle_parent_id");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_BUNDLEID, job2);
        CoordJobsGetForPurgeJPAExecutor executor = new CoordJobsGetForPurgeJPAExecutor(10L, 50);
        List jobList = (List)jpaService.execute((JPAExecutor)executor);
        TestCoordJobsGetForPurgeJPAExecutor.assertEquals((int)1, (int)jobList.size());
        TestCoordJobsGetForPurgeJPAExecutor.assertEquals((String)jobId1, (String)((String)jobList.get(0)));
    }

    public void testCoordJobsGetForPurgeJPAExecutorTooMany() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobsGetForPurgeJPAExecutor.assertNotNull((Object)jpaService);
        String jobId1 = "00001-" + new Date().getTime() + "-TestCoordJobsGetForPurgeJPAExecutor-C";
        this.insertJob(jobId1, Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        String jobId2 = "00002-" + new Date().getTime() + "-TestCoordJobsGetForPurgeJPAExecutor-C";
        this.insertJob(jobId2, Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        String jobId3 = "00003-" + new Date().getTime() + "-TestCoordJobsGetForPurgeJPAExecutor-C";
        this.insertJob(jobId3, Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        String jobId4 = "00004-" + new Date().getTime() + "-TestCoordJobsGetForPurgeJPAExecutor-C";
        this.insertJob(jobId4, Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        String jobId5 = "00005-" + new Date().getTime() + "-TestCoordJobsGetForPurgeJPAExecutor-C";
        this.insertJob(jobId5, Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        ArrayList<String> list = new ArrayList<String>();
        list.addAll((Collection)jpaService.execute((JPAExecutor)new CoordJobsGetForPurgeJPAExecutor(1L, 3)));
        TestCoordJobsGetForPurgeJPAExecutor.assertEquals((int)3, (int)list.size());
        list.addAll((Collection)jpaService.execute((JPAExecutor)new CoordJobsGetForPurgeJPAExecutor(1L, 3, 3)));
        TestCoordJobsGetForPurgeJPAExecutor.assertEquals((int)5, (int)list.size());
        this.checkCoordinators(list, jobId1, jobId2, jobId3, jobId4, jobId5);
    }

    private CoordinatorJobBean insertJob(String jobId, Job.Status status, Date d) throws Exception {
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String appXml = this.getCoordJobXml(appPath);
        CoordinatorJobBean coordJob = new CoordinatorJobBean();
        coordJob.setId(jobId);
        coordJob.setAppName("COORD-TEST");
        coordJob.setAppPath(appPath.toString());
        coordJob.setStatus(status);
        coordJob.setCreatedTime(d);
        coordJob.setLastModifiedTime(d);
        coordJob.setUser(TestCoordJobsGetForPurgeJPAExecutor.getTestUser());
        coordJob.setGroup(TestCoordJobsGetForPurgeJPAExecutor.getTestGroup());
        Properties conf = this.getCoordConf(appPath);
        String confStr = XmlUtils.writePropToString((Properties)conf);
        coordJob.setConf(confStr);
        coordJob.setJobXml(appXml);
        coordJob.setLastActionNumber(0);
        coordJob.setFrequency("1");
        coordJob.setExecutionOrder(CoordinatorJob.Execution.FIFO);
        coordJob.setConcurrency(1);
        try {
            coordJob.setStartTime(DateUtils.parseDateOozieTZ((String)"2009-12-15T01:00Z"));
            coordJob.setEndTime(DateUtils.parseDateOozieTZ((String)"2009-12-17T01:00Z"));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordJobsGetForPurgeJPAExecutor.fail((String)"Could not set Date/time");
        }
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestCoordJobsGetForPurgeJPAExecutor.assertNotNull((Object)jpaService);
            CoordJobInsertJPAExecutor coordInsertCmd = new CoordJobInsertJPAExecutor(coordJob);
            jpaService.execute((JPAExecutor)coordInsertCmd);
        }
        catch (JPAExecutorException ce) {
            ce.printStackTrace();
            TestCoordJobsGetForPurgeJPAExecutor.fail((String)"Unable to insert the test job record to table");
            throw ce;
        }
        return coordJob;
    }

    private String getCoordJobXml(Path appPath) {
        String inputTemplate = appPath + "/coord-input/${YEAR}/${MONTH}/${DAY}/${HOUR}/${MINUTE}";
        inputTemplate = Matcher.quoteReplacement(inputTemplate);
        String outputTemplate = appPath + "/coord-input/${YEAR}/${MONTH}/${DAY}/${HOUR}/${MINUTE}";
        outputTemplate = Matcher.quoteReplacement(outputTemplate);
        try {
            Reader reader = IOUtils.getResourceAsReader((String)"coord-job-get.xml", (int)-1);
            String appXml = IOUtils.getReaderAsString((Reader)reader, (int)-1);
            appXml = appXml.replaceAll("#inputTemplate", inputTemplate);
            appXml = appXml.replaceAll("#outputTemplate", outputTemplate);
            return appXml;
        }
        catch (IOException ioe) {
            throw new RuntimeException(XLog.format((String)"Could not get coord-rerun-job.xml", (Object[])new Object[]{ioe}));
        }
    }

    private Properties getCoordConf(Path appPath) {
        Path wfAppPath = new Path(this.getFsTestCaseDir(), "workflow");
        OozieClient coordClient = LocalOozie.getCoordClient();
        Properties conf = coordClient.createConfiguration();
        conf.setProperty("oozie.coord.application.path", appPath.toString());
        conf.setProperty("jobTracker", this.getJobTrackerUri());
        conf.setProperty("nameNode", this.getNameNodeUri());
        conf.setProperty("wfAppPath", wfAppPath.toString());
        conf.remove("user.name");
        conf.setProperty("user.name", TestCoordJobsGetForPurgeJPAExecutor.getTestUser());
        return conf;
    }

    private void checkCoordinators(List<String> coords, String ... coordJobIDs) {
        TestCoordJobsGetForPurgeJPAExecutor.assertEquals((int)coordJobIDs.length, (int)coords.size());
        Arrays.sort(coordJobIDs);
        Collections.sort(coords);
        for (int i = 0; i < coordJobIDs.length; ++i) {
            TestCoordJobsGetForPurgeJPAExecutor.assertEquals((String)coordJobIDs[i], (String)coords.get(i));
        }
    }
}

