/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.ArrayList;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.FaultInjection;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionsDeleteJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobsDeleteJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestCoordJobsDeleteJPAExecutor
extends XDataTestCase {
    Services services;
    private String[] excludedServices = new String[]{"org.apache.oozie.service.StatusTransitService", "org.apache.oozie.service.PauseTransitService", "org.apache.oozie.service.PurgeService", "org.apache.oozie.service.CoordMaterializeTriggerService", "org.apache.oozie.service.RecoveryService"};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testDeleteCoords() throws Exception {
        CoordinatorJobBean jobA = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        CoordinatorActionBean actionA1 = this.addRecordToCoordActionTable(jobA.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        CoordinatorActionBean actionA2 = this.addRecordToCoordActionTable(jobA.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        CoordinatorJobBean jobB = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        CoordinatorActionBean actionB1 = this.addRecordToCoordActionTable(jobB.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        CoordinatorActionBean actionB2 = this.addRecordToCoordActionTable(jobB.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        CoordinatorJobBean jobC = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        CoordinatorActionBean actionC1 = this.addRecordToCoordActionTable(jobC.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        CoordinatorActionBean actionC2 = this.addRecordToCoordActionTable(jobC.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobsDeleteJPAExecutor.assertNotNull((Object)jpaService);
        ArrayList<String> deleteCoordlist = new ArrayList<String>();
        deleteCoordlist.add(jobA.getId());
        deleteCoordlist.add(jobB.getId());
        deleteCoordlist.add(jobC.getId());
        jpaService.execute((JPAExecutor)new CoordJobsDeleteJPAExecutor(deleteCoordlist));
        ArrayList<String> deleteActionList = new ArrayList<String>();
        deleteActionList.add(actionA1.getId());
        deleteActionList.add(actionB1.getId());
        deleteActionList.add(actionC1.getId());
        deleteActionList.add(actionA2.getId());
        deleteActionList.add(actionB2.getId());
        deleteActionList.add(actionC2.getId());
        jpaService.execute((JPAExecutor)new CoordActionsDeleteJPAExecutor(deleteActionList));
        try {
            jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(jobA.getId()));
            TestCoordJobsDeleteJPAExecutor.fail((String)"Coordinator Job A should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestCoordJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionA1.getId()));
            TestCoordJobsDeleteJPAExecutor.fail((String)"Coordinator Action A1 should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestCoordJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionA2.getId()));
            TestCoordJobsDeleteJPAExecutor.fail((String)"Coordinator Action A2 should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestCoordJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(jobB.getId()));
            TestCoordJobsDeleteJPAExecutor.fail((String)"Coordinator Job B should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestCoordJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionB1.getId()));
            TestCoordJobsDeleteJPAExecutor.fail((String)"Coordinator Action B1 should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestCoordJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionB2.getId()));
            TestCoordJobsDeleteJPAExecutor.fail((String)"Coordinator Action B2 should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestCoordJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(jobC.getId()));
            TestCoordJobsDeleteJPAExecutor.fail((String)"Coordinator Job C should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestCoordJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionC1.getId()));
            TestCoordJobsDeleteJPAExecutor.fail((String)"Coordinator Action C1 should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestCoordJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionC2.getId()));
            TestCoordJobsDeleteJPAExecutor.fail((String)"Coordinator Action C2 should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestCoordJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteCoordsRollback() throws Exception {
        CoordinatorJobBean jobA = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        CoordinatorActionBean actionA1 = this.addRecordToCoordActionTable(jobA.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        CoordinatorActionBean actionA2 = this.addRecordToCoordActionTable(jobA.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        CoordinatorJobBean jobB = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        CoordinatorActionBean actionB1 = this.addRecordToCoordActionTable(jobB.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        CoordinatorActionBean actionB2 = this.addRecordToCoordActionTable(jobB.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        CoordinatorJobBean jobC = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        CoordinatorActionBean actionC1 = this.addRecordToCoordActionTable(jobC.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        CoordinatorActionBean actionC2 = this.addRecordToCoordActionTable(jobC.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobsDeleteJPAExecutor.assertNotNull((Object)jpaService);
        try {
            this.setSystemProperty("oozie.fault.injection", "true");
            this.setSystemProperty("oozie.fault.injection.action.failover", "true");
            ArrayList<String> deleteCoordlist = new ArrayList<String>();
            deleteCoordlist.add(jobA.getId());
            deleteCoordlist.add(jobB.getId());
            deleteCoordlist.add(jobC.getId());
            ArrayList<String> deleteActionList = new ArrayList<String>();
            deleteActionList.add(actionA1.getId());
            deleteActionList.add(actionB1.getId());
            deleteActionList.add(actionC1.getId());
            deleteActionList.add(actionA2.getId());
            deleteActionList.add(actionB2.getId());
            deleteActionList.add(actionC2.getId());
            try {
                jpaService.execute((JPAExecutor)new CoordJobsDeleteJPAExecutor(deleteCoordlist));
                jpaService.execute((JPAExecutor)new CoordActionsDeleteJPAExecutor(deleteActionList));
                TestCoordJobsDeleteJPAExecutor.fail((String)"Should have skipped commit for failover testing");
            }
            catch (RuntimeException re) {
                TestCoordJobsDeleteJPAExecutor.assertEquals((String)"Skipping Commit for Failover Testing", (String)re.getMessage());
            }
        }
        finally {
            FaultInjection.deactivate((String)"org.apache.oozie.command.SkipCommitFaultInjection");
        }
        try {
            jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(jobA.getId()));
        }
        catch (JPAExecutorException je) {
            TestCoordJobsDeleteJPAExecutor.fail((String)"Coordinator Job A should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionA1.getId()));
        }
        catch (JPAExecutorException je) {
            TestCoordJobsDeleteJPAExecutor.fail((String)"Coordinator Action A1 should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionA2.getId()));
        }
        catch (JPAExecutorException je) {
            TestCoordJobsDeleteJPAExecutor.fail((String)"Coordinator Action A2 should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(jobB.getId()));
        }
        catch (JPAExecutorException je) {
            TestCoordJobsDeleteJPAExecutor.fail((String)"Coordinator Job B should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionB1.getId()));
        }
        catch (JPAExecutorException je) {
            TestCoordJobsDeleteJPAExecutor.fail((String)"Coordinator Action B1 should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionB2.getId()));
        }
        catch (JPAExecutorException je) {
            TestCoordJobsDeleteJPAExecutor.fail((String)"Coordinator Action B2 should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(jobC.getId()));
        }
        catch (JPAExecutorException je) {
            TestCoordJobsDeleteJPAExecutor.fail((String)"Coordinator Job C should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionC1.getId()));
        }
        catch (JPAExecutorException je) {
            TestCoordJobsDeleteJPAExecutor.fail((String)"Coordinator Action C1 should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionC2.getId()));
        }
        catch (JPAExecutorException je) {
            TestCoordJobsDeleteJPAExecutor.fail((String)"Coordinator Action C2 should not have been deleted");
        }
    }
}

