/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.TestPurgeXCommand;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobsCountNotForPurgeFromParentIdJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor
extends XDataTestCase {
    Services services;
    private String[] excludedServices = new String[]{"org.apache.oozie.service.StatusTransitService", "org.apache.oozie.service.PauseTransitService", "org.apache.oozie.service.PurgeService", "org.apache.oozie.service.CoordMaterializeTriggerService", "org.apache.oozie.service.RecoveryService"};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCount() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertNotNull((Object)jpaService);
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, false);
        String bundleJobId = bundleJob.getId();
        int days = 1;
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)0L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        CoordinatorJobBean coordJob1 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        coordJob1 = TestPurgeXCommand.setLastModifiedTime(coordJob1, "2009-12-01T01:00Z");
        coordJob1.setAppName("coord1");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob1);
        this.addRecordToBundleActionTable(bundleJobId, coordJob1.getId(), coordJob1.getAppName(), 0, Job.Status.SUCCEEDED);
        days = 1;
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)0L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob1.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)1L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        CoordinatorJobBean coordJob2 = this.addRecordToCoordJobTable(Job.Status.DONEWITHERROR, false, false);
        coordJob2 = TestPurgeXCommand.setLastModifiedTime(coordJob2, "2009-11-01T01:00Z");
        coordJob2.setAppName("coord2");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob2);
        this.addRecordToBundleActionTable(bundleJobId, coordJob2.getId(), coordJob2.getAppName(), 0, Job.Status.DONEWITHERROR);
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob1.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)1L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob2.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)2L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        CoordinatorJobBean coordJob3 = this.addRecordToCoordJobTable(Job.Status.FAILED, false, false);
        coordJob3 = TestPurgeXCommand.setLastModifiedTime(coordJob3, "2009-10-01T01:00Z");
        coordJob3.setAppName("coord3");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob3);
        this.addRecordToBundleActionTable(bundleJobId, coordJob3.getId(), coordJob3.getAppName(), 0, Job.Status.FAILED);
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob2.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)2L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob3.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)3L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        CoordinatorJobBean coordJob4 = this.addRecordToCoordJobTable(Job.Status.KILLED, false, false);
        coordJob4 = TestPurgeXCommand.setLastModifiedTime(coordJob4, "2009-09-01T01:00Z");
        coordJob4.setAppName("coord4");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob4);
        this.addRecordToBundleActionTable(bundleJobId, coordJob4.getId(), coordJob4.getAppName(), 0, Job.Status.KILLED);
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob3.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)3L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob4.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)4L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        CoordinatorJobBean coordJob5 = this.addRecordToCoordJobTable(Job.Status.PAUSED, false, false);
        coordJob5 = TestPurgeXCommand.setLastModifiedTime(coordJob5, "2009-08-01T01:00Z");
        coordJob5.setAppName("coord5");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob5);
        this.addRecordToBundleActionTable(bundleJobId, coordJob5.getId(), coordJob5.getAppName(), 0, Job.Status.PAUSED);
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob4.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)5L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob5.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)5L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        CoordinatorJobBean coordJob6 = this.addRecordToCoordJobTable(Job.Status.PAUSEDWITHERROR, false, false);
        coordJob5 = TestPurgeXCommand.setLastModifiedTime(coordJob6, "2009-07-01T01:00Z");
        coordJob5.setAppName("coord6");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob6);
        this.addRecordToBundleActionTable(bundleJobId, coordJob6.getId(), coordJob6.getAppName(), 0, Job.Status.PAUSEDWITHERROR);
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob5.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)6L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob6.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)6L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        CoordinatorJobBean coordJob7 = this.addRecordToCoordJobTable(Job.Status.PREMATER, false, false);
        coordJob5 = TestPurgeXCommand.setLastModifiedTime(coordJob7, "2009-06-01T01:00Z");
        coordJob5.setAppName("coord7");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob7);
        this.addRecordToBundleActionTable(bundleJobId, coordJob7.getId(), coordJob7.getAppName(), 0, Job.Status.PREMATER);
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob6.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)7L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob7.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)7L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        CoordinatorJobBean coordJob8 = this.addRecordToCoordJobTable(Job.Status.PREP, false, false);
        coordJob8 = TestPurgeXCommand.setLastModifiedTime(coordJob8, "2009-05-01T01:00Z");
        coordJob8.setAppName("coord8");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob8);
        this.addRecordToBundleActionTable(bundleJobId, coordJob8.getId(), coordJob8.getAppName(), 0, Job.Status.PREP);
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob7.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)8L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob8.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)8L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        CoordinatorJobBean coordJob9 = this.addRecordToCoordJobTable(Job.Status.PREPPAUSED, false, false);
        coordJob9 = TestPurgeXCommand.setLastModifiedTime(coordJob9, "2009-04-01T01:00Z");
        coordJob9.setAppName("coord9");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob9);
        this.addRecordToBundleActionTable(bundleJobId, coordJob9.getId(), coordJob9.getAppName(), 0, Job.Status.PREPPAUSED);
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob8.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)9L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob9.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)9L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        CoordinatorJobBean coordJob10 = this.addRecordToCoordJobTable(Job.Status.PREPSUSPENDED, false, false);
        coordJob10 = TestPurgeXCommand.setLastModifiedTime(coordJob10, "2009-03-01T01:00Z");
        coordJob10.setAppName("coord10");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob10);
        this.addRecordToBundleActionTable(bundleJobId, coordJob10.getId(), coordJob10.getAppName(), 0, Job.Status.PREPSUSPENDED);
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob9.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)10L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob10.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)10L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        CoordinatorJobBean coordJob11 = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        coordJob11 = TestPurgeXCommand.setLastModifiedTime(coordJob11, "2009-02-01T01:00Z");
        coordJob11.setAppName("coord11");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob11);
        this.addRecordToBundleActionTable(bundleJobId, coordJob11.getId(), coordJob11.getAppName(), 0, Job.Status.RUNNING);
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob10.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)11L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob11.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)11L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        CoordinatorJobBean coordJob12 = this.addRecordToCoordJobTable(Job.Status.RUNNINGWITHERROR, false, false);
        coordJob12 = TestPurgeXCommand.setLastModifiedTime(coordJob12, "2009-01-01T01:00Z");
        coordJob12.setAppName("coord12");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob12);
        this.addRecordToBundleActionTable(bundleJobId, coordJob12.getId(), coordJob12.getAppName(), 0, Job.Status.RUNNINGWITHERROR);
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob11.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)12L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob12.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)12L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        CoordinatorJobBean coordJob13 = this.addRecordToCoordJobTable(Job.Status.SUSPENDED, false, false);
        coordJob13 = TestPurgeXCommand.setLastModifiedTime(coordJob13, "2008-12-01T01:00Z");
        coordJob13.setAppName("coord13");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob13);
        this.addRecordToBundleActionTable(bundleJobId, coordJob13.getId(), coordJob13.getAppName(), 0, Job.Status.SUSPENDED);
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob12.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)13L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob13.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)13L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        CoordinatorJobBean coordJob14 = this.addRecordToCoordJobTable(Job.Status.SUSPENDEDWITHERROR, false, false);
        coordJob14 = TestPurgeXCommand.setLastModifiedTime(coordJob14, "2008-11-01T01:00Z");
        coordJob14.setAppName("coord14");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob14);
        this.addRecordToBundleActionTable(bundleJobId, coordJob14.getId(), coordJob14.getAppName(), 0, Job.Status.SUSPENDEDWITHERROR);
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob13.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)14L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
        days = TestPurgeXCommand.getNumDaysToNotBePurged(coordJob14.getLastModifiedTime());
        TestCoordJobsCountNotForPurgeFromParentIdJPAExecutor.assertEquals((long)14L, (long)((Long)jpaService.execute((JPAExecutor)new CoordJobsCountNotForPurgeFromParentIdJPAExecutor((long)days, bundleJobId))));
    }
}

