/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordJobGetActionsRunningJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestCoordJobGetActionsRunningJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordActionsRunningForColumnValues() throws Exception {
        int actionNum = 1;
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        String jobId = job.getId();
        CoordinatorActionBean action = this.addRecordToCoordActionTable(jobId, actionNum++, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        this._testCoordActionForCorrectColumnValues(jobId, action.getId(), action.getStatus(), action.getPending());
    }

    public void testCoordActionsRunningForSize() throws Exception {
        int actionNum = 1;
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        String jobId = job.getId();
        this.addRecordToCoordActionTable(jobId, actionNum++, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(jobId, actionNum++, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(jobId, actionNum++, CoordinatorAction.Status.FAILED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(jobId, actionNum++, CoordinatorAction.Status.KILLED, "coord-action-get.xml", 0);
        this._testCoordActionsRunningSize(jobId, 2);
    }

    private void _testCoordActionForCorrectColumnValues(String jobId, String actionId, CoordinatorAction.Status status, int pending) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobGetActionsRunningJPAExecutor.assertNotNull((Object)jpaService);
        CoordJobGetActionsRunningJPAExecutor actionGetCmd = new CoordJobGetActionsRunningJPAExecutor(jobId);
        List actionList = (List)jpaService.execute((JPAExecutor)actionGetCmd);
        CoordinatorActionBean action = (CoordinatorActionBean)actionList.get(0);
        TestCoordJobGetActionsRunningJPAExecutor.assertEquals((String)action.getId(), (String)actionId);
        TestCoordJobGetActionsRunningJPAExecutor.assertEquals((Object)action.getStatus(), (Object)status);
        TestCoordJobGetActionsRunningJPAExecutor.assertEquals((int)action.getPending(), (int)pending);
    }

    private void _testCoordActionsRunningSize(String jobId, int expectedSize) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobGetActionsRunningJPAExecutor.assertNotNull((Object)jpaService);
        CoordJobGetActionsRunningJPAExecutor actionGetCmd = new CoordJobGetActionsRunningJPAExecutor(jobId);
        List actionList = (List)jpaService.execute((JPAExecutor)actionGetCmd);
        TestCoordJobGetActionsRunningJPAExecutor.assertEquals((int)actionList.size(), (int)expectedSize);
    }
}

