/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.Date;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordJobGetActionForNominalTimeJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;

public class TestCoordJobGetActionForNominalTimeJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordActionGet() throws Exception {
        int actionNum = 1;
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        CoordinatorActionBean action = this.addRecordToCoordActionTable(job.getId(), actionNum, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String actionXml = this.getCoordActionXml(appPath, "coord-action-get.xml");
        String actionNomialTime = this.getActionNominalTime(actionXml);
        this._testGetActionForNominalTime(job.getId(), action.getId(), DateUtils.parseDateOozieTZ((String)actionNomialTime));
    }

    private void _testGetActionForNominalTime(String jobId, String actionId, Date d) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobGetActionForNominalTimeJPAExecutor.assertNotNull((Object)jpaService);
        CoordJobGetActionForNominalTimeJPAExecutor actionGetCmd = new CoordJobGetActionForNominalTimeJPAExecutor(jobId, d);
        CoordinatorActionBean ret = (CoordinatorActionBean)jpaService.execute((JPAExecutor)actionGetCmd);
        TestCoordJobGetActionForNominalTimeJPAExecutor.assertNotNull((Object)ret);
        TestCoordJobGetActionForNominalTimeJPAExecutor.assertEquals((String)ret.getId(), (String)actionId);
        TestCoordJobGetActionForNominalTimeJPAExecutor.assertEquals((String)ret.getJobId(), (String)jobId);
        TestCoordJobGetActionForNominalTimeJPAExecutor.assertEquals((String)ret.getNominalTime().toString(), (String)d.toString());
    }
}

