/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.ArrayList;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.FaultInjection;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionsDeleteJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestCoordActionsDeleteJPAExecutor
extends XDataTestCase {
    Services services;
    private String[] excludedServices = new String[]{"org.apache.oozie.service.StatusTransitService", "org.apache.oozie.service.PauseTransitService", "org.apache.oozie.service.PurgeService", "org.apache.oozie.service.CoordMaterializeTriggerService", "org.apache.oozie.service.RecoveryService"};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testDeleteCoordActions() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        CoordinatorActionBean action1 = this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        CoordinatorActionBean action2 = this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        CoordinatorActionBean action3 = this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordActionsDeleteJPAExecutor.assertNotNull((Object)jpaService);
        ArrayList<String> deleteList = new ArrayList<String>();
        deleteList.add(action1.getId());
        deleteList.add(action2.getId());
        deleteList.add(action3.getId());
        jpaService.execute((JPAExecutor)new CoordActionsDeleteJPAExecutor(deleteList));
        try {
            jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(action1.getId()));
            TestCoordActionsDeleteJPAExecutor.fail((String)"CoordinatorAction action1 should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestCoordActionsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(action2.getId()));
            TestCoordActionsDeleteJPAExecutor.fail((String)"CoordinatorAction action1 should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestCoordActionsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(action3.getId()));
            TestCoordActionsDeleteJPAExecutor.fail((String)"CoordinatorAction action1 should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestCoordActionsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteCoordActionsRollback() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        CoordinatorActionBean action1 = this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        CoordinatorActionBean action2 = this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        CoordinatorActionBean action3 = this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordActionsDeleteJPAExecutor.assertNotNull((Object)jpaService);
        ArrayList<String> deleteList = new ArrayList<String>();
        deleteList.add(action1.getId());
        deleteList.add(action2.getId());
        deleteList.add(action3.getId());
        try {
            this.setSystemProperty("oozie.fault.injection", "true");
            this.setSystemProperty("oozie.fault.injection.action.failover", "true");
            try {
                jpaService.execute((JPAExecutor)new CoordActionsDeleteJPAExecutor(deleteList));
                TestCoordActionsDeleteJPAExecutor.fail((String)"Should have skipped commit for failover testing");
            }
            catch (RuntimeException re) {
                TestCoordActionsDeleteJPAExecutor.assertEquals((String)"Skipping Commit for Failover Testing", (String)re.getMessage());
            }
        }
        finally {
            FaultInjection.deactivate((String)"org.apache.oozie.command.SkipCommitFaultInjection");
        }
        try {
            jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(action1.getId()));
        }
        catch (JPAExecutorException je) {
            TestCoordActionsDeleteJPAExecutor.fail((String)"Coordinator Action1 should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(action2.getId()));
        }
        catch (JPAExecutorException je) {
            TestCoordActionsDeleteJPAExecutor.fail((String)"Coordinator Action2 should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(action3.getId()));
        }
        catch (JPAExecutorException je) {
            TestCoordActionsDeleteJPAExecutor.fail((String)"Coordinator Action3 should not have been deleted");
        }
    }
}

