/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordActionGetForStartJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.XmlUtils;

public class TestCoordActionGetForStartJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordActionGet() throws Exception {
        int actionNum = 1;
        String errorCode = "000";
        String errorMessage = "Dummy";
        String resourceXmlName = "coord-action-get.xml";
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        CoordinatorActionBean action = this.createCoordAction(job.getId(), actionNum, CoordinatorAction.Status.WAITING, resourceXmlName, 0);
        action.setSlaXml(XDataTestCase.slaXml);
        action.setErrorCode(errorCode);
        action.setErrorMessage(errorMessage);
        this.insertRecordCoordAction(action);
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String actionXml = this.getCoordActionXml(appPath, resourceXmlName);
        Configuration conf = this.getCoordConf(appPath);
        this._testGetForStartX(action.getId(), job.getId(), CoordinatorAction.Status.WAITING, 0, action.getId() + "_E", XDataTestCase.slaXml, resourceXmlName, XmlUtils.prettyPrint((Configuration)conf).toString(), actionXml, errorCode, errorMessage);
    }

    private void _testGetForStartX(String actionId, String jobId, CoordinatorAction.Status status, int pending, String extId, String slaXml, String resourceXmlName, String createdConf, String actionXml, String errorCode, String errorMessage) throws Exception {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestCoordActionGetForStartJPAExecutor.assertNotNull((Object)jpaService);
            CoordActionGetForStartJPAExecutor actionGetCmd = new CoordActionGetForStartJPAExecutor(actionId);
            CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)actionGetCmd);
            TestCoordActionGetForStartJPAExecutor.assertNotNull((Object)action);
            TestCoordActionGetForStartJPAExecutor.assertEquals((String)actionId, (String)action.getId());
            TestCoordActionGetForStartJPAExecutor.assertEquals((String)jobId, (String)action.getJobId());
            TestCoordActionGetForStartJPAExecutor.assertEquals((Object)status, (Object)action.getStatus());
            TestCoordActionGetForStartJPAExecutor.assertEquals((int)pending, (int)action.getPending());
            TestCoordActionGetForStartJPAExecutor.assertEquals((String)createdConf, (String)action.getCreatedConf());
            TestCoordActionGetForStartJPAExecutor.assertEquals((String)slaXml, (String)action.getSlaXml());
            TestCoordActionGetForStartJPAExecutor.assertEquals((String)actionXml, (String)action.getActionXml());
            TestCoordActionGetForStartJPAExecutor.assertEquals((String)extId, (String)action.getExternalId());
            TestCoordActionGetForStartJPAExecutor.assertEquals((String)errorMessage, (String)action.getErrorMessage());
            TestCoordActionGetForStartJPAExecutor.assertEquals((String)errorCode, (String)action.getErrorCode());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TestCoordActionGetForStartJPAExecutor.fail((String)("Unable to GET a record for COORD Action By actionId =" + actionId));
        }
    }
}

