/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordActionGetForInputCheckJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.XmlUtils;

public class TestCoordActionGetForInputCheckJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordActionGet() throws Exception {
        int actionNum = 1;
        String resourceXmlName = "coord-action-get.xml";
        Date dummyCreationTime = new Date();
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        CoordinatorActionBean action = this.createCoordAction(job.getId(), actionNum, CoordinatorAction.Status.WAITING, resourceXmlName, 0);
        String testDir = this.getTestCaseDir();
        String missDeps = this.getTestCaseFileUri("2009/29/_SUCCESS") + "#" + this.getTestCaseFileUri("2009/22/_SUCCESS") + "#" + this.getTestCaseFileUri("2009/15/_SUCCESS") + "#" + this.getTestCaseFileUri("2009/08/_SUCCESS");
        missDeps = missDeps.replaceAll("#testDir", testDir);
        action.setMissingDependencies(missDeps);
        action.setCreatedTime(dummyCreationTime);
        this.insertRecordCoordAction(action);
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String actionXml = this.getCoordActionXml(appPath, resourceXmlName);
        Configuration conf = this.getCoordConf(appPath);
        String actionNominalTime = this.getActionNominalTime(actionXml);
        this._testGetForInputCheckX(action.getId(), action.getActionNumber(), job.getId(), CoordinatorAction.Status.WAITING, 0, actionXml, XmlUtils.prettyPrint((Configuration)conf).toString(), DateUtils.parseDateOozieTZ((String)actionNominalTime), dummyCreationTime, missDeps);
    }

    private void _testGetForInputCheckX(String actionId, int actionNum, String jobId, CoordinatorAction.Status status, int pending, String actionXml, String runConf, Date nominalTime, Date createdTime, String missDeps) throws Exception {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestCoordActionGetForInputCheckJPAExecutor.assertNotNull((Object)jpaService);
            CoordActionGetForInputCheckJPAExecutor actionGetCmd = new CoordActionGetForInputCheckJPAExecutor(actionId);
            CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)actionGetCmd);
            TestCoordActionGetForInputCheckJPAExecutor.assertNotNull((Object)action);
            TestCoordActionGetForInputCheckJPAExecutor.assertEquals((String)actionId, (String)action.getId());
            TestCoordActionGetForInputCheckJPAExecutor.assertEquals((int)actionNum, (int)action.getActionNumber());
            TestCoordActionGetForInputCheckJPAExecutor.assertEquals((String)jobId, (String)action.getJobId());
            TestCoordActionGetForInputCheckJPAExecutor.assertEquals((Object)status, (Object)action.getStatus());
            TestCoordActionGetForInputCheckJPAExecutor.assertEquals((int)pending, (int)action.getPending());
            TestCoordActionGetForInputCheckJPAExecutor.assertEquals((String)runConf, (String)action.getRunConf());
            TestCoordActionGetForInputCheckJPAExecutor.assertEquals((String)actionXml, (String)action.getActionXml());
            TestCoordActionGetForInputCheckJPAExecutor.assertEquals((Object)nominalTime, (Object)action.getNominalTime());
            TestCoordActionGetForInputCheckJPAExecutor.assertEquals((Object)createdTime, (Object)action.getCreatedTime());
            TestCoordActionGetForInputCheckJPAExecutor.assertEquals((String)missDeps, (String)action.getMissingDependencies());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TestCoordActionGetForInputCheckJPAExecutor.fail((String)("Unable to GET a record for COORD Action By actionId =" + actionId));
        }
    }
}

