/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.Date;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordActionGetForInfoJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;

public class TestCoordActionGetForInfoJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordActionGet() throws Exception {
        int actionNum = 1;
        String errorCode = "000";
        String errorMessage = "Dummy";
        String resourceXmlName = "coord-action-get.xml";
        String consoleUrl = "consoleUrl";
        String externalStatus = "externalStatus";
        String trackerUri = "trackerUri";
        String missingDeps = "missingDeps";
        String slaXml = "slaXml";
        Date createdTime = new Date();
        Date lastModifiedTime = new Date();
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        CoordinatorActionBean action = this.createCoordAction(job.getId(), actionNum, CoordinatorAction.Status.WAITING, resourceXmlName, 0);
        action.setErrorCode(errorCode);
        action.setErrorMessage(errorMessage);
        action.setConsoleUrl(consoleUrl);
        action.setExternalStatus(externalStatus);
        action.setTrackerUri(trackerUri);
        action.setCreatedTime(createdTime);
        action.setMissingDependencies(missingDeps);
        action.setLastModifiedTime(lastModifiedTime);
        action.setSlaXml(slaXml);
        this.insertRecordCoordAction(action);
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String actionXml = this.getCoordActionXml(appPath, resourceXmlName);
        String actionNominalTime = this.getActionNominalTime(actionXml);
        this._testGetForInfo(action.getId(), job.getId(), CoordinatorAction.Status.WAITING, action.getId() + "_E", errorCode, errorMessage, consoleUrl, externalStatus, trackerUri, createdTime, missingDeps, DateUtils.parseDateOozieTZ((String)actionNominalTime), actionNum, lastModifiedTime);
    }

    private void _testGetForInfo(String actionId, String jobId, CoordinatorAction.Status status, String extId, String errorCode, String errorMessage, String consoleUrl, String externalStatus, String trackerUri, Date createdTime, String missingDeps, Date nominalTime, int actionNumber, Date lastModifiedTime) throws Exception {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestCoordActionGetForInfoJPAExecutor.assertNotNull((Object)jpaService);
            CoordActionGetForInfoJPAExecutor actionGetCmd = new CoordActionGetForInfoJPAExecutor(actionId);
            CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)actionGetCmd);
            TestCoordActionGetForInfoJPAExecutor.assertNotNull((Object)action);
            TestCoordActionGetForInfoJPAExecutor.assertEquals((String)actionId, (String)action.getId());
            TestCoordActionGetForInfoJPAExecutor.assertEquals((String)jobId, (String)action.getJobId());
            TestCoordActionGetForInfoJPAExecutor.assertEquals((Object)status, (Object)action.getStatus());
            TestCoordActionGetForInfoJPAExecutor.assertEquals((String)extId, (String)action.getExternalId());
            TestCoordActionGetForInfoJPAExecutor.assertEquals((String)errorMessage, (String)action.getErrorMessage());
            TestCoordActionGetForInfoJPAExecutor.assertEquals((String)errorCode, (String)action.getErrorCode());
            TestCoordActionGetForInfoJPAExecutor.assertEquals((String)consoleUrl, (String)action.getConsoleUrl());
            TestCoordActionGetForInfoJPAExecutor.assertEquals((String)externalStatus, (String)action.getExternalStatus());
            TestCoordActionGetForInfoJPAExecutor.assertEquals((String)trackerUri, (String)action.getTrackerUri());
            TestCoordActionGetForInfoJPAExecutor.assertEquals((Object)createdTime, (Object)action.getCreatedTime());
            TestCoordActionGetForInfoJPAExecutor.assertEquals((String)missingDeps, (String)action.getMissingDependencies());
            TestCoordActionGetForInfoJPAExecutor.assertEquals((Object)nominalTime, (Object)action.getNominalTime());
            TestCoordActionGetForInfoJPAExecutor.assertEquals((int)actionNumber, (int)action.getActionNumber());
            TestCoordActionGetForInfoJPAExecutor.assertEquals((Object)lastModifiedTime, (Object)action.getLastModifiedTime());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TestCoordActionGetForInfoJPAExecutor.fail((String)("Unable to GET a record for COORD Action By actionId =" + actionId));
        }
    }

    public void testCoordActionGetAllColumns() throws Exception {
        this.services.destroy();
        this.setSystemProperty("oozie.coord.action.get.all.attributes", "true");
        this.services = new Services();
        this.services.init();
        String resourceXmlName = "coord-action-get.xml";
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        CoordinatorActionBean action = this.createCoordAction(job.getId(), 1, CoordinatorAction.Status.WAITING, resourceXmlName, 0);
        String slaXml = "slaXml";
        action.setSlaXml(slaXml);
        this.insertRecordCoordAction(action);
        this._testGetForInfoAllActions(action.getId(), slaXml);
    }

    private void _testGetForInfoAllActions(String actionId, String slaXml) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordActionGetForInfoJPAExecutor.assertNotNull((Object)jpaService);
        CoordActionGetForInfoJPAExecutor actionGetCmd = new CoordActionGetForInfoJPAExecutor(actionId);
        CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)actionGetCmd);
        TestCoordActionGetForInfoJPAExecutor.assertEquals((Object)CoordinatorAction.Status.WAITING, (Object)action.getStatus());
        TestCoordActionGetForInfoJPAExecutor.assertEquals((String)slaXml, (String)action.getSlaXml());
        TestCoordActionGetForInfoJPAExecutor.assertEquals((int)0, (int)action.getPending());
    }
}

