/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordActionGetForCheckJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestCoordActionGetForCheckJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordActionGet() throws Exception {
        int actionNum = 1;
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        CoordinatorActionBean action = this.createCoordAction(job.getId(), actionNum, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        action.setSlaXml(XDataTestCase.slaXml);
        this.insertRecordCoordAction(action);
        this._testGetActionForCheck(action.getId(), job.getId(), CoordinatorAction.Status.WAITING, 0, action.getId() + "_E", XDataTestCase.slaXml);
    }

    private void _testGetActionForCheck(String actionId, String jobId, CoordinatorAction.Status status, int pending, String extId, String slaXml) throws Exception {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestCoordActionGetForCheckJPAExecutor.assertNotNull((Object)jpaService);
            CoordActionGetForCheckJPAExecutor actionGetCmd = new CoordActionGetForCheckJPAExecutor(actionId);
            CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)actionGetCmd);
            TestCoordActionGetForCheckJPAExecutor.assertNotNull((Object)action);
            TestCoordActionGetForCheckJPAExecutor.assertEquals((String)actionId, (String)action.getId());
            TestCoordActionGetForCheckJPAExecutor.assertEquals((Object)status, (Object)action.getStatus());
            TestCoordActionGetForCheckJPAExecutor.assertEquals((int)pending, (int)action.getPending());
            TestCoordActionGetForCheckJPAExecutor.assertEquals((String)extId, (String)action.getExternalId());
            TestCoordActionGetForCheckJPAExecutor.assertEquals((String)slaXml, (String)action.getSlaXml());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TestCoordActionGetForCheckJPAExecutor.fail((String)("Unable to GET a record for COORD Action By actionId =" + actionId));
        }
    }
}

