/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.BundleJobInfo;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.BundleJobInfoGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;

public class TestBundleJobInfoGetJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testBundleJobInfoGet() throws Exception {
        BundleJobBean bundleJob1 = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        this._testGetJobInfoForStatus();
        this._testGetJobInfoForGroup();
        this.addRecordToBundleJobTable(Job.Status.KILLED, false);
        this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, false);
        this._testGetJobInfoForAppName();
        this._testGetJobInfoForUser();
        this._testGetJobInfoForUserAndStatus();
        this._testGetJobInfoForId(bundleJob1.getId());
    }

    public void testGetJobInfoForStartCreatedTime() throws Exception {
        BundleJobBean bundleJob1 = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        BundleJobBean bundleJob2 = this.addRecordToBundleJobTable(Job.Status.KILLED, false);
        Date createTime1 = DateUtils.parseDateUTC((String)"2012-01-01T10:00Z");
        Date createTime2 = DateUtils.parseDateUTC((String)"2012-01-05T10:00Z");
        bundleJob1.setCreatedTime(createTime1);
        bundleJob2.setCreatedTime(createTime2);
        BundleJobQueryExecutor.getInstance().executeUpdate((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB, (Object)bundleJob1);
        BundleJobQueryExecutor.getInstance().executeUpdate((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB, (Object)bundleJob2);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleJobInfoGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap<String, List<String>> filter = new HashMap<String, List<String>>();
        BundleJobInfoGetJPAExecutor BundleInfoGetCmd = new BundleJobInfoGetJPAExecutor(filter, 1, 20);
        BundleJobInfo ret = (BundleJobInfo)jpaService.execute((JPAExecutor)BundleInfoGetCmd);
        TestBundleJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestBundleJobInfoGetJPAExecutor.assertEquals((int)2, (int)ret.getBundleJobs().size());
        filter.clear();
        filter.put("startcreatedtime", Arrays.asList("2012-01-02T10:00Z"));
        BundleInfoGetCmd = new BundleJobInfoGetJPAExecutor(filter, 1, 20);
        ret = (BundleJobInfo)jpaService.execute((JPAExecutor)BundleInfoGetCmd);
        TestBundleJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestBundleJobInfoGetJPAExecutor.assertEquals((int)1, (int)ret.getBundleJobs().size());
        BundleJobBean jobBean = (BundleJobBean)ret.getBundleJobs().get(0);
        TestBundleJobInfoGetJPAExecutor.assertEquals((Object)bundleJob2.getStatus(), (Object)jobBean.getStatus());
        TestBundleJobInfoGetJPAExecutor.assertEquals((Object)bundleJob2.getCreatedTime(), (Object)jobBean.getCreatedTime());
    }

    public void testGetJobInfoForEndCreatedTime() throws Exception {
        BundleJobBean bundleJob1 = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        BundleJobBean bundleJob2 = this.addRecordToBundleJobTable(Job.Status.KILLED, false);
        BundleJobBean bundleJob3 = this.addRecordToBundleJobTable(Job.Status.FAILED, false);
        Date createTime1 = DateUtils.parseDateUTC((String)"2012-01-03T10:00Z");
        Date createTime2 = DateUtils.parseDateUTC((String)"2012-01-05T10:00Z");
        Date createTime3 = DateUtils.parseDateUTC((String)"2012-01-010T10:00Z");
        bundleJob1.setCreatedTime(createTime1);
        bundleJob2.setCreatedTime(createTime2);
        bundleJob3.setCreatedTime(createTime3);
        BundleJobQueryExecutor.getInstance().executeUpdate((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB, (Object)bundleJob1);
        BundleJobQueryExecutor.getInstance().executeUpdate((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB, (Object)bundleJob2);
        BundleJobQueryExecutor.getInstance().executeUpdate((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB, (Object)bundleJob3);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleJobInfoGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap<String, List<String>> filter = new HashMap<String, List<String>>();
        BundleJobInfoGetJPAExecutor bundleInfoGetCmd = new BundleJobInfoGetJPAExecutor(filter, 1, 20);
        BundleJobInfo ret = (BundleJobInfo)jpaService.execute((JPAExecutor)bundleInfoGetCmd);
        TestBundleJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestBundleJobInfoGetJPAExecutor.assertEquals((int)3, (int)ret.getBundleJobs().size());
        filter.clear();
        filter.put("startcreatedtime", Arrays.asList("2012-01-02T10:00Z"));
        filter.put("endcreatedtime", Arrays.asList("2012-01-07T10:00Z"));
        bundleInfoGetCmd = new BundleJobInfoGetJPAExecutor(filter, 1, 20);
        ret = (BundleJobInfo)jpaService.execute((JPAExecutor)bundleInfoGetCmd);
        TestBundleJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestBundleJobInfoGetJPAExecutor.assertEquals((int)2, (int)ret.getBundleJobs().size());
        BundleJobBean jobBean = (BundleJobBean)ret.getBundleJobs().get(0);
        TestBundleJobInfoGetJPAExecutor.assertEquals((Object)bundleJob2.getStatus(), (Object)jobBean.getStatus());
        TestBundleJobInfoGetJPAExecutor.assertEquals((Object)bundleJob2.getCreatedTime(), (Object)jobBean.getCreatedTime());
        BundleJobBean jobBean1 = (BundleJobBean)ret.getBundleJobs().get(1);
        TestBundleJobInfoGetJPAExecutor.assertEquals((Object)bundleJob1.getStatus(), (Object)jobBean1.getStatus());
        TestBundleJobInfoGetJPAExecutor.assertEquals((Object)bundleJob1.getCreatedTime(), (Object)jobBean1.getCreatedTime());
    }

    private void _testGetJobInfoForStatus() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleJobInfoGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap filter = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add("RUNNING");
        list.add("PREP");
        filter.put("status", list);
        BundleJobInfoGetJPAExecutor bundleInfoGetCmd = new BundleJobInfoGetJPAExecutor(filter, 1, 20);
        BundleJobInfo ret = (BundleJobInfo)jpaService.execute((JPAExecutor)bundleInfoGetCmd);
        TestBundleJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestBundleJobInfoGetJPAExecutor.assertEquals((int)2, (int)ret.getBundleJobs().size());
    }

    private void _testGetJobInfoForGroup() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleJobInfoGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap filter = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add(TestBundleJobInfoGetJPAExecutor.getTestGroup());
        filter.put("group", list);
        BundleJobInfoGetJPAExecutor bundleInfoGetCmd = new BundleJobInfoGetJPAExecutor(filter, 1, 20);
        BundleJobInfo ret = (BundleJobInfo)jpaService.execute((JPAExecutor)bundleInfoGetCmd);
        TestBundleJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestBundleJobInfoGetJPAExecutor.assertEquals((int)2, (int)ret.getBundleJobs().size());
    }

    private void _testGetJobInfoForAppName() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleJobInfoGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap filter = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add("BUNDLE-TEST");
        filter.put("name", list);
        BundleJobInfoGetJPAExecutor bundleInfoGetCmd = new BundleJobInfoGetJPAExecutor(filter, 1, 20);
        BundleJobInfo ret = (BundleJobInfo)jpaService.execute((JPAExecutor)bundleInfoGetCmd);
        TestBundleJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestBundleJobInfoGetJPAExecutor.assertEquals((int)4, (int)ret.getBundleJobs().size());
    }

    private void _testGetJobInfoForUser() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleJobInfoGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap filter = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add(TestBundleJobInfoGetJPAExecutor.getTestUser());
        filter.put("user", list);
        BundleJobInfoGetJPAExecutor bundleInfoGetCmd = new BundleJobInfoGetJPAExecutor(filter, 1, 20);
        BundleJobInfo ret = (BundleJobInfo)jpaService.execute((JPAExecutor)bundleInfoGetCmd);
        TestBundleJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestBundleJobInfoGetJPAExecutor.assertEquals((int)4, (int)ret.getBundleJobs().size());
    }

    private void _testGetJobInfoForUserAndStatus() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleJobInfoGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap filter = new HashMap();
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add(TestBundleJobInfoGetJPAExecutor.getTestUser());
        filter.put("user", list1);
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("KILLED");
        filter.put("status", list2);
        BundleJobInfoGetJPAExecutor bundleInfoGetCmd = new BundleJobInfoGetJPAExecutor(filter, 1, 20);
        BundleJobInfo ret = (BundleJobInfo)jpaService.execute((JPAExecutor)bundleInfoGetCmd);
        TestBundleJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestBundleJobInfoGetJPAExecutor.assertEquals((int)1, (int)ret.getBundleJobs().size());
    }

    private void _testGetJobInfoForId(String jobId) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleJobInfoGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap filter = new HashMap();
        ArrayList<String> jobIdList = new ArrayList<String>();
        jobIdList.add(jobId);
        filter.put("id", jobIdList);
        BundleJobInfoGetJPAExecutor bundleInfoGetCmd = new BundleJobInfoGetJPAExecutor(filter, 1, 20);
        BundleJobInfo ret = (BundleJobInfo)jpaService.execute((JPAExecutor)bundleInfoGetCmd);
        TestBundleJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestBundleJobInfoGetJPAExecutor.assertEquals((int)ret.getBundleJobs().size(), (int)1);
    }

    public void testBundleJobsSortBy() throws Exception {
        BundleJobBean bundleJob1 = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        BundleJobBean bundleJob2 = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        bundleJob1.setLastModifiedTime(DateUtils.parseDateUTC((String)"2012-01-04T10:00Z"));
        bundleJob1.setCreatedTime(DateUtils.parseDateUTC((String)"2012-01-03T10:00Z"));
        BundleJobQueryExecutor.getInstance().executeUpdate((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB, (Object)bundleJob1);
        bundleJob2.setLastModifiedTime(DateUtils.parseDateUTC((String)"2012-01-05T10:00Z"));
        bundleJob2.setCreatedTime(DateUtils.parseDateUTC((String)"2012-01-02T10:00Z"));
        BundleJobQueryExecutor.getInstance().executeUpdate((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB, (Object)bundleJob2);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleJobInfoGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap filter = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add("lastmodifiedTime");
        filter.put("sortby", list);
        BundleJobInfoGetJPAExecutor bundleInfoGetCmd = new BundleJobInfoGetJPAExecutor(filter, 1, 20);
        BundleJobInfo ret = (BundleJobInfo)jpaService.execute((JPAExecutor)bundleInfoGetCmd);
        TestBundleJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestBundleJobInfoGetJPAExecutor.assertEquals((int)2, (int)ret.getBundleJobs().size());
        this.compareBundleJobs(bundleJob2, (BundleJobBean)ret.getBundleJobs().get(0));
        filter.clear();
        list.clear();
        bundleInfoGetCmd = new BundleJobInfoGetJPAExecutor(filter, 1, 20);
        ret = (BundleJobInfo)jpaService.execute((JPAExecutor)bundleInfoGetCmd);
        TestBundleJobInfoGetJPAExecutor.assertNotNull((Object)ret);
        TestBundleJobInfoGetJPAExecutor.assertEquals((int)2, (int)ret.getBundleJobs().size());
        this.compareBundleJobs(bundleJob1, (BundleJobBean)ret.getBundleJobs().get(0));
    }

    private void compareBundleJobs(BundleJobBean bundleJobBean, BundleJobBean retBundleJobBean) {
        TestBundleJobInfoGetJPAExecutor.assertEquals((String)bundleJobBean.getId(), (String)retBundleJobBean.getId());
        TestBundleJobInfoGetJPAExecutor.assertEquals((Object)bundleJobBean.getCreatedTime(), (Object)retBundleJobBean.getCreatedTime());
        TestBundleJobInfoGetJPAExecutor.assertEquals((String)bundleJobBean.getStatusStr(), (String)retBundleJobBean.getStatusStr());
    }
}

