/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import org.apache.oozie.BundleJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.BundleActionsCountForJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestBundleActionsCountForJobGetJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testBundleActionsForJobCountGet() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        this.addRecordToBundleActionTable(job.getId(), "action1", 1, Job.Status.RUNNING);
        this._testGetForJobCount(job.getId(), 1);
        this.addRecordToBundleActionTable(job.getId(), "action2", 0, Job.Status.RUNNING);
        this.addRecordToBundleActionTable(job.getId(), "action3", 1, Job.Status.RUNNING);
        this._testGetForJobCount(job.getId(), 3);
    }

    private void _testGetForJobCount(String jobId, int expected) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleActionsCountForJobGetJPAExecutor.assertNotNull((Object)jpaService);
        BundleActionsCountForJobGetJPAExecutor actionsForJobCmd = new BundleActionsCountForJobGetJPAExecutor(jobId);
        int cnt = (Integer)jpaService.execute((JPAExecutor)actionsForJobCmd);
        TestBundleActionsCountForJobGetJPAExecutor.assertEquals((int)cnt, (int)expected);
    }
}

