/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.executor.jpa.BundleActionQueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;

public class TestBundleActionQueryExecutor
extends XDataTestCase {
    Services services;
    JPAService jpaService;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        this.jpaService = (JPAService)Services.get().get(JPAService.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testGetUpdateQuery() throws Exception {
        EntityManager em = this.jpaService.getEntityManager();
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        BundleActionBean bundleAction = this.addRecordToBundleActionTable(job.getId(), "action1", 1, Job.Status.PREP);
        Query query = BundleActionQueryExecutor.getInstance().getUpdateQuery((Enum)BundleActionQueryExecutor.BundleActionQuery.UPDATE_BUNDLE_ACTION_PENDING_MODTIME, (Object)bundleAction, em);
        TestBundleActionQueryExecutor.assertEquals((Object)query.getParameterValue("lastModifiedTime"), (Object)bundleAction.getLastModifiedTimestamp());
        TestBundleActionQueryExecutor.assertEquals((Object)query.getParameterValue("pending"), (Object)bundleAction.getPending());
        TestBundleActionQueryExecutor.assertEquals((Object)query.getParameterValue("bundleActionId"), (Object)bundleAction.getBundleActionId());
        query = BundleActionQueryExecutor.getInstance().getUpdateQuery((Enum)BundleActionQueryExecutor.BundleActionQuery.UPDATE_BUNDLE_ACTION_STATUS_PENDING_MODTIME_COORDID, (Object)bundleAction, em);
        TestBundleActionQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)bundleAction.getStatus().toString());
        TestBundleActionQueryExecutor.assertEquals((Object)query.getParameterValue("lastModifiedTime"), (Object)bundleAction.getLastModifiedTimestamp());
        TestBundleActionQueryExecutor.assertEquals((Object)query.getParameterValue("pending"), (Object)bundleAction.getPending());
        TestBundleActionQueryExecutor.assertEquals((Object)query.getParameterValue("coordId"), (Object)bundleAction.getCoordId());
        TestBundleActionQueryExecutor.assertEquals((Object)query.getParameterValue("bundleActionId"), (Object)bundleAction.getBundleActionId());
        query = BundleActionQueryExecutor.getInstance().getUpdateQuery((Enum)BundleActionQueryExecutor.BundleActionQuery.UPDATE_BUNDLE_ACTION_STATUS_PENDING_MODTIME_COORDID, (Object)bundleAction, em);
        TestBundleActionQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)bundleAction.getStatus().toString());
        TestBundleActionQueryExecutor.assertEquals((Object)query.getParameterValue("lastModifiedTime"), (Object)bundleAction.getLastModifiedTimestamp());
        TestBundleActionQueryExecutor.assertEquals((Object)query.getParameterValue("pending"), (Object)(bundleAction.isPending() ? 1 : 0));
        TestBundleActionQueryExecutor.assertEquals((Object)query.getParameterValue("coordId"), (Object)bundleAction.getCoordId());
        TestBundleActionQueryExecutor.assertEquals((Object)query.getParameterValue("bundleActionId"), (Object)bundleAction.getBundleActionId());
        em.close();
    }

    public void testGetSelectQuery() throws Exception {
        EntityManager em = this.jpaService.getEntityManager();
        BundleActionBean bean = this.addRecordToBundleActionTable("test-bundle-id", "test-coord", 0, Job.Status.RUNNING);
        Query query = null;
        query = BundleActionQueryExecutor.getInstance().getSelectQuery((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTION, em, new Object[]{bean.getBundleId()});
        TestBundleActionQueryExecutor.assertEquals((Object)query.getParameterValue("bundleActionId"), (Object)bean.getBundleId());
        query = BundleActionQueryExecutor.getInstance().getSelectQuery((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_WAITING_ACTIONS_OLDER_THAN, em, new Object[]{100L});
        Date date = DateUtils.toDate((Timestamp)((Timestamp)query.getParameterValue("lastModifiedTime")));
        TestBundleActionQueryExecutor.assertTrue((boolean)date.before(Calendar.getInstance().getTime()));
        query = BundleActionQueryExecutor.getInstance().getSelectQuery((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_UNIGNORED_ACTION_STATUS_PENDING_FOR_BUNDLE, em, new Object[]{bean.getBundleId()});
        TestBundleActionQueryExecutor.assertEquals((Object)query.getParameterValue("bundleId"), (Object)bean.getBundleId());
    }

    public void testExecuteUpdate() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        BundleActionBean bean = this.addRecordToBundleActionTable(job.getId(), "action1", 1, Job.Status.PREP);
        bean.setStatus(Job.Status.RUNNING);
        BundleActionQueryExecutor.getInstance().executeUpdate((Enum)BundleActionQueryExecutor.BundleActionQuery.UPDATE_BUNDLE_ACTION_STATUS_PENDING_MODTIME, (Object)bean);
        BundleActionBean retBean = (BundleActionBean)BundleActionQueryExecutor.getInstance().get((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTION, new Object[]{bean.getBundleActionId()});
        TestBundleActionQueryExecutor.assertEquals((Object)retBean.getStatus(), (Object)Job.Status.RUNNING);
    }

    public void testGet() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        BundleActionBean bundleAction = this.addRecordToBundleActionTable(job.getId(), "action1", 1, Job.Status.PREP);
        BundleActionBean retBean = (BundleActionBean)BundleActionQueryExecutor.getInstance().get((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_UNIGNORED_ACTION_STATUS_PENDING_FOR_BUNDLE, new Object[]{bundleAction.getBundleId()});
        TestBundleActionQueryExecutor.assertEquals((String)bundleAction.getCoordId(), (String)retBean.getCoordId());
        TestBundleActionQueryExecutor.assertEquals((String)bundleAction.getStatusStr(), (String)retBean.getStatusStr());
        TestBundleActionQueryExecutor.assertEquals((int)bundleAction.getPending(), (int)retBean.getPending());
        retBean = (BundleActionBean)BundleActionQueryExecutor.getInstance().get((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTION, new Object[]{bundleAction.getBundleActionId()});
        TestBundleActionQueryExecutor.assertEquals((Object)bundleAction.getStatus(), (Object)retBean.getStatus());
    }

    public void testGetList() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        this.addRecordToBundleActionTable(job.getId(), "coord1", 0, Job.Status.PREP);
        this.addRecordToBundleActionTable(job.getId(), "coord2", 1, Job.Status.RUNNING);
        this.addRecordToBundleActionTable(job.getId(), "coord3", 1, Job.Status.RUNNING);
        List bActions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_WAITING_ACTIONS_OLDER_THAN, new Object[]{60000L});
        TestBundleActionQueryExecutor.assertEquals((int)0, (int)bActions.size());
        bActions = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_WAITING_ACTIONS_OLDER_THAN, new Object[]{-60000L});
        TestBundleActionQueryExecutor.assertEquals((int)2, (int)bActions.size());
        List retList = BundleActionQueryExecutor.getInstance().getList((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, new Object[]{job.getId()});
        TestBundleActionQueryExecutor.assertEquals((int)3, (int)retList.size());
        for (BundleActionBean bean : retList) {
            TestBundleActionQueryExecutor.assertTrue((bean.getCoordName().equals("coord1") || bean.getCoordName().equals("coord2") || bean.getCoordName().equals("coord3") ? 1 : 0) != 0);
        }
    }

    public void testInsert() throws Exception {
        BundleActionBean bean = new BundleActionBean();
        bean.setBundleActionId("test-oozie");
        bean.setCoordName("testApp");
        bean.setStatus(Job.Status.RUNNING);
        BundleActionQueryExecutor.getInstance().insert((JsonBean)bean);
        BundleActionBean retBean = (BundleActionBean)BundleActionQueryExecutor.getInstance().get((Enum)BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTION, new Object[]{"test-oozie"});
        TestBundleActionQueryExecutor.assertEquals((String)retBean.getCoordName(), (String)"testApp");
        TestBundleActionQueryExecutor.assertEquals((Object)retBean.getStatus(), (Object)Job.Status.RUNNING);
    }
}

