/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.event;

import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.AppType;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.DagEngine;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.control.ControlNodeActionExecutor;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.event.JobEvent;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionCheckXCommand;
import org.apache.oozie.command.coord.CoordActionInputCheckXCommand;
import org.apache.oozie.command.coord.CoordMaterializeTransitionXCommand;
import org.apache.oozie.command.coord.CoordRerunXCommand;
import org.apache.oozie.command.coord.CoordResumeXCommand;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.command.wf.ActionCheckXCommand;
import org.apache.oozie.command.wf.ActionKillXCommand;
import org.apache.oozie.command.wf.ActionStartXCommand;
import org.apache.oozie.command.wf.ActionXCommand;
import org.apache.oozie.command.wf.KillXCommand;
import org.apache.oozie.command.wf.ResumeXCommand;
import org.apache.oozie.command.wf.SignalXCommand;
import org.apache.oozie.command.wf.StartXCommand;
import org.apache.oozie.command.wf.SuspendXCommand;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.event.CoordinatorActionEvent;
import org.apache.oozie.event.EventQueue;
import org.apache.oozie.event.WorkflowActionEvent;
import org.apache.oozie.event.WorkflowJobEvent;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionInsertJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.LiteWorkflowStoreService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.ActionNodeDef;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.StartNodeDef;
import org.apache.oozie.workflow.lite.TestLiteWorkflowLib;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestEventGeneration
extends XDataTestCase {
    EventQueue queue;
    Services services;
    EventHandlerService ehs;
    JPAService jpaService;

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        Configuration conf = this.services.getConf();
        conf.setInt("oozie.service.EventHandlerService.worker.threads", 0);
        conf.set("oozie.services.ext", "org.apache.oozie.service.EventHandlerService");
        this.services.init();
        this.ehs = (EventHandlerService)this.services.get(EventHandlerService.class);
        this.queue = this.ehs.getEventQueue();
        this.jpaService = (JPAService)this.services.get(JPAService.class);
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    @Test
    public void testWorkflowJobEvent() throws Exception {
        TestEventGeneration.assertEquals((int)0, (int)this.queue.size());
        LiteWorkflowApp app = new LiteWorkflowApp("testApp", "<workflow-app/>", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "fs-node")).addNode((NodeDef)new ActionNodeDef("fs-node", "", TestLiteWorkflowLib.TestActionNodeHandler.class, "end", "end")).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        WorkflowJobBean job = this.addRecordToWfJobTable((WorkflowApp)app, WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        new StartXCommand(job.getId()).call();
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(job.getId());
        job = (WorkflowJobBean)this.jpaService.execute((JPAExecutor)wfJobGetCmd);
        TestEventGeneration.assertEquals((Object)WorkflowJob.Status.RUNNING, (Object)job.getStatus());
        TestEventGeneration.assertEquals((int)1, (int)this.queue.size());
        JobEvent event = (JobEvent)this.queue.poll();
        TestEventGeneration.assertNotNull((Object)event);
        TestEventGeneration.assertEquals((Object)JobEvent.EventStatus.STARTED, (Object)event.getEventStatus());
        TestEventGeneration.assertEquals((Object)AppType.WORKFLOW_JOB, (Object)event.getAppType());
        TestEventGeneration.assertEquals((String)job.getId(), (String)event.getId());
        TestEventGeneration.assertEquals((String)job.getUser(), (String)event.getUser());
        TestEventGeneration.assertEquals((String)job.getAppName(), (String)event.getAppName());
        TestEventGeneration.assertEquals((Object)job.getStartTime(), (Object)event.getStartTime());
        TestEventGeneration.assertEquals((int)0, (int)this.queue.size());
        new SuspendXCommand(job.getId()).call();
        job = (WorkflowJobBean)this.jpaService.execute((JPAExecutor)wfJobGetCmd);
        TestEventGeneration.assertEquals((Object)WorkflowJob.Status.SUSPENDED, (Object)job.getStatus());
        TestEventGeneration.assertEquals((int)1, (int)this.queue.size());
        event = (JobEvent)this.queue.poll();
        TestEventGeneration.assertNotNull((Object)event);
        TestEventGeneration.assertEquals((Object)JobEvent.EventStatus.SUSPEND, (Object)event.getEventStatus());
        TestEventGeneration.assertEquals((Object)AppType.WORKFLOW_JOB, (Object)event.getAppType());
        TestEventGeneration.assertEquals((String)job.getId(), (String)event.getId());
        TestEventGeneration.assertEquals((String)job.getUser(), (String)event.getUser());
        TestEventGeneration.assertEquals((String)job.getAppName(), (String)event.getAppName());
        TestEventGeneration.assertEquals((int)0, (int)this.queue.size());
        new ResumeXCommand(job.getId()).call();
        job = (WorkflowJobBean)this.jpaService.execute((JPAExecutor)wfJobGetCmd);
        TestEventGeneration.assertEquals((Object)WorkflowJob.Status.RUNNING, (Object)job.getStatus());
        TestEventGeneration.assertEquals((int)1, (int)this.queue.size());
        event = (JobEvent)this.queue.poll();
        TestEventGeneration.assertNotNull((Object)event);
        TestEventGeneration.assertEquals((Object)AppType.WORKFLOW_JOB, (Object)event.getAppType());
        TestEventGeneration.assertEquals((String)job.getId(), (String)event.getId());
        TestEventGeneration.assertEquals((String)job.getUser(), (String)event.getUser());
        TestEventGeneration.assertEquals((String)job.getAppName(), (String)event.getAppName());
        TestEventGeneration.assertEquals((Object)job.getStartTime(), (Object)event.getStartTime());
        TestEventGeneration.assertEquals((int)0, (int)this.queue.size());
        new KillXCommand(job.getId()).call();
        job = (WorkflowJobBean)this.jpaService.execute((JPAExecutor)wfJobGetCmd);
        TestEventGeneration.assertEquals((Object)WorkflowJob.Status.KILLED, (Object)job.getStatus());
        TestEventGeneration.assertEquals((int)1, (int)this.queue.size());
        event = (JobEvent)this.queue.poll();
        TestEventGeneration.assertNotNull((Object)event);
        TestEventGeneration.assertEquals((Object)JobEvent.EventStatus.FAILURE, (Object)event.getEventStatus());
        TestEventGeneration.assertEquals((Object)AppType.WORKFLOW_JOB, (Object)event.getAppType());
        TestEventGeneration.assertEquals((String)job.getId(), (String)event.getId());
        TestEventGeneration.assertEquals((String)job.getUser(), (String)event.getUser());
        TestEventGeneration.assertEquals((String)job.getAppName(), (String)event.getAppName());
        TestEventGeneration.assertEquals((Object)job.getStartTime(), (Object)event.getStartTime());
        TestEventGeneration.assertEquals((Object)job.getEndTime(), (Object)event.getEndTime());
        TestEventGeneration.assertEquals((int)0, (int)this.queue.size());
        job = this._createWorkflowJob();
        LiteWorkflowInstance wfInstance = (LiteWorkflowInstance)job.getWorkflowInstance();
        wfInstance.start();
        job.setWorkflowInstance((WorkflowInstance)wfInstance);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MODIFIED, (Object)job);
        WorkflowActionBean wfAction = (WorkflowActionBean)this.jpaService.execute((JPAExecutor)new WorkflowActionGetJPAExecutor(job.getId() + "@one"));
        new SignalXCommand(job.getId(), wfAction.getId()).call();
        job = (WorkflowJobBean)this.jpaService.execute((JPAExecutor)new WorkflowJobGetJPAExecutor(job.getId()));
        TestEventGeneration.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)job.getStatus());
        TestEventGeneration.assertEquals((int)1, (int)this.queue.size());
        event = (JobEvent)this.queue.poll();
        TestEventGeneration.assertNotNull((Object)event);
        TestEventGeneration.assertEquals((Object)AppType.WORKFLOW_JOB, (Object)event.getAppType());
        TestEventGeneration.assertEquals((String)job.getId(), (String)event.getId());
        TestEventGeneration.assertEquals((String)job.getUser(), (String)event.getUser());
        TestEventGeneration.assertEquals((String)job.getAppName(), (String)event.getAppName());
        TestEventGeneration.assertEquals((Object)job.getStartTime(), (Object)event.getStartTime());
        TestEventGeneration.assertEquals((Object)job.getEndTime(), (Object)event.getEndTime());
    }

    @Test
    public void testCoordinatorActionEvent() throws Exception {
        this.ehs.setAppTypes(new HashSet<String>(Arrays.asList("coordinator_action")));
        TestEventGeneration.assertEquals((int)this.queue.size(), (int)0);
        Date startTime = DateUtils.parseDateOozieTZ((String)"2013-01-01T10:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2013-01-01T10:01Z");
        CoordinatorJobBean coord = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, false, false, 0);
        this.modifyCoordForRunning(coord);
        new CoordMaterializeTransitionXCommand(coord.getId(), 3600).call();
        final CoordActionGetJPAExecutor coordGetCmd = new CoordActionGetJPAExecutor(coord.getId() + "@1");
        CoordinatorActionBean action = (CoordinatorActionBean)this.jpaService.execute((JPAExecutor)coordGetCmd);
        TestEventGeneration.assertEquals((Object)CoordinatorAction.Status.WAITING, (Object)action.getStatus());
        TestEventGeneration.assertEquals((int)1, (int)this.queue.size());
        JobEvent event = (JobEvent)this.queue.poll();
        TestEventGeneration.assertNotNull((Object)event);
        TestEventGeneration.assertEquals((Object)JobEvent.EventStatus.WAITING, (Object)event.getEventStatus());
        TestEventGeneration.assertEquals((Object)AppType.COORDINATOR_ACTION, (Object)event.getAppType());
        TestEventGeneration.assertEquals((String)action.getId(), (String)event.getId());
        TestEventGeneration.assertEquals((String)action.getJobId(), (String)event.getParentId());
        TestEventGeneration.assertEquals((Object)action.getNominalTime(), (Object)((CoordinatorActionEvent)event).getNominalTime());
        TestEventGeneration.assertNull((Object)event.getStartTime());
        TestEventGeneration.assertEquals((String)coord.getUser(), (String)event.getUser());
        TestEventGeneration.assertEquals((String)coord.getAppName(), (String)event.getAppName());
        TestEventGeneration.assertEquals((int)0, (int)this.queue.size());
        new CoordActionInputCheckXCommand(action.getId(), coord.getId()).call();
        action = (CoordinatorActionBean)this.jpaService.execute((JPAExecutor)coordGetCmd);
        TestEventGeneration.assertEquals((Object)CoordinatorAction.Status.RUNNING, (Object)action.getStatus());
        event = (JobEvent)this.queue.poll();
        TestEventGeneration.assertEquals((Object)JobEvent.EventStatus.STARTED, (Object)event.getEventStatus());
        TestEventGeneration.assertEquals((Object)AppType.COORDINATOR_ACTION, (Object)event.getAppType());
        TestEventGeneration.assertEquals((String)action.getId(), (String)event.getId());
        TestEventGeneration.assertEquals((String)action.getJobId(), (String)event.getParentId());
        TestEventGeneration.assertEquals((Object)action.getNominalTime(), (Object)((CoordinatorActionEvent)event).getNominalTime());
        WorkflowJobBean wfJob = (WorkflowJobBean)this.jpaService.execute((JPAExecutor)new WorkflowJobGetJPAExecutor(action.getExternalId()));
        TestEventGeneration.assertEquals((Object)wfJob.getStartTime(), (Object)event.getStartTime());
        TestEventGeneration.assertEquals((String)coord.getUser(), (String)event.getUser());
        TestEventGeneration.assertEquals((String)coord.getAppName(), (String)event.getAppName());
        this.sleep(2000);
        wfJob.setStatus(WorkflowJob.Status.SUCCEEDED);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_MODTIME, (Object)wfJob);
        action.setStatus(CoordinatorAction.Status.RUNNING);
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_STATUS_PENDING_TIME, (Object)action);
        new CoordActionCheckXCommand(action.getId(), 0).call();
        action = (CoordinatorActionBean)this.jpaService.execute((JPAExecutor)coordGetCmd);
        TestEventGeneration.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)action.getStatus());
        List list = this.queue.pollBatch();
        event = (JobEvent)list.get(list.size() - 1);
        TestEventGeneration.assertEquals((Object)JobEvent.EventStatus.SUCCESS, (Object)event.getEventStatus());
        TestEventGeneration.assertEquals((Object)AppType.COORDINATOR_ACTION, (Object)event.getAppType());
        TestEventGeneration.assertEquals((String)action.getId(), (String)event.getId());
        TestEventGeneration.assertEquals((String)action.getJobId(), (String)event.getParentId());
        TestEventGeneration.assertEquals((Object)action.getNominalTime(), (Object)((CoordinatorActionEvent)event).getNominalTime());
        TestEventGeneration.assertEquals((Object)wfJob.getStartTime(), (Object)event.getStartTime());
        TestEventGeneration.assertEquals((String)coord.getUser(), (String)event.getUser());
        TestEventGeneration.assertEquals((String)coord.getAppName(), (String)event.getAppName());
        wfJob.setStatus(WorkflowJob.Status.FAILED);
        action.setStatus(CoordinatorAction.Status.RUNNING);
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_STATUS_PENDING_TIME, (Object)action);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_MODTIME, (Object)wfJob);
        new CoordActionCheckXCommand(action.getId(), 0).call();
        action = (CoordinatorActionBean)this.jpaService.execute((JPAExecutor)coordGetCmd);
        TestEventGeneration.assertEquals((Object)CoordinatorAction.Status.FAILED, (Object)action.getStatus());
        event = (JobEvent)this.queue.poll();
        TestEventGeneration.assertEquals((Object)JobEvent.EventStatus.FAILURE, (Object)event.getEventStatus());
        TestEventGeneration.assertEquals((Object)AppType.COORDINATOR_ACTION, (Object)event.getAppType());
        TestEventGeneration.assertEquals((String)action.getId(), (String)event.getId());
        TestEventGeneration.assertEquals((String)action.getJobId(), (String)event.getParentId());
        TestEventGeneration.assertEquals((Object)action.getNominalTime(), (Object)((CoordinatorActionEvent)event).getNominalTime());
        TestEventGeneration.assertEquals((Object)wfJob.getStartTime(), (Object)event.getStartTime());
        TestEventGeneration.assertEquals((String)coord.getUser(), (String)event.getUser());
        TestEventGeneration.assertEquals((String)coord.getAppName(), (String)event.getAppName());
        wfJob.setStatus(WorkflowJob.Status.SUSPENDED);
        action.setStatus(CoordinatorAction.Status.RUNNING);
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_STATUS_PENDING_TIME, (Object)action);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_MODTIME, (Object)wfJob);
        new CoordActionCheckXCommand(action.getId(), 0).call();
        action = (CoordinatorActionBean)this.jpaService.execute((JPAExecutor)coordGetCmd);
        TestEventGeneration.assertEquals((Object)CoordinatorAction.Status.SUSPENDED, (Object)action.getStatus());
        event = (JobEvent)this.queue.poll();
        TestEventGeneration.assertEquals((Object)JobEvent.EventStatus.SUSPEND, (Object)event.getEventStatus());
        TestEventGeneration.assertEquals((Object)AppType.COORDINATOR_ACTION, (Object)event.getAppType());
        TestEventGeneration.assertEquals((String)action.getId(), (String)event.getId());
        TestEventGeneration.assertEquals((String)action.getJobId(), (String)event.getParentId());
        TestEventGeneration.assertEquals((Object)action.getNominalTime(), (Object)((CoordinatorActionEvent)event).getNominalTime());
        TestEventGeneration.assertEquals((Object)wfJob.getStartTime(), (Object)event.getStartTime());
        TestEventGeneration.assertEquals((String)coord.getUser(), (String)event.getUser());
        TestEventGeneration.assertEquals((String)coord.getAppName(), (String)event.getAppName());
        coord.setStatus(Job.Status.SUSPENDED);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_STATUS, coord);
        action.setStatus(CoordinatorAction.Status.SUSPENDED);
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_STATUS_PENDING_TIME, (Object)action);
        wfJob.setStatus(WorkflowJob.Status.SUSPENDED);
        WorkflowInstance wfInstance = wfJob.getWorkflowInstance();
        ((LiteWorkflowInstance)wfInstance).setStatus(WorkflowInstance.Status.SUSPENDED);
        wfJob.setWorkflowInstance(wfInstance);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MODIFIED, (Object)wfJob);
        this.queue.clear();
        new CoordResumeXCommand(coord.getId()).call();
        this.waitForEventGeneration(1000);
        CoordinatorActionEvent cevent = (CoordinatorActionEvent)this.queue.poll();
        TestEventGeneration.assertEquals((Object)JobEvent.EventStatus.STARTED, (Object)cevent.getEventStatus());
        TestEventGeneration.assertEquals((Object)AppType.COORDINATOR_ACTION, (Object)cevent.getAppType());
        TestEventGeneration.assertEquals((String)action.getId(), (String)cevent.getId());
        TestEventGeneration.assertEquals((String)action.getJobId(), (String)cevent.getParentId());
        TestEventGeneration.assertEquals((Object)action.getNominalTime(), (Object)cevent.getNominalTime());
        coord = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{coord.getId()});
        TestEventGeneration.assertEquals((Object)coord.getLastModifiedTime(), (Object)cevent.getStartTime());
        action.setStatus(CoordinatorAction.Status.KILLED);
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_STATUS_PENDING_TIME, (Object)action);
        this.queue.clear();
        new CoordRerunXCommand(coord.getId(), "action", "1", false, true, false, null).call();
        this.waitFor(300, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return ((CoordinatorActionBean)TestEventGeneration.this.jpaService.execute((JPAExecutor)coordGetCmd)).getStatus() == CoordinatorAction.Status.WAITING;
            }
        });
        cevent = (CoordinatorActionEvent)this.queue.poll();
        TestEventGeneration.assertEquals((Object)JobEvent.EventStatus.WAITING, (Object)cevent.getEventStatus());
        TestEventGeneration.assertEquals((Object)AppType.COORDINATOR_ACTION, (Object)cevent.getAppType());
        TestEventGeneration.assertEquals((String)action.getId(), (String)cevent.getId());
        TestEventGeneration.assertEquals((String)action.getJobId(), (String)cevent.getParentId());
        TestEventGeneration.assertEquals((Object)action.getNominalTime(), (Object)cevent.getNominalTime());
        TestEventGeneration.assertEquals((Object)wfJob.getStartTime(), (Object)event.getStartTime());
        TestEventGeneration.assertNotNull((Object)cevent.getMissingDeps());
    }

    @Test
    public void testWorkflowActionEvent() throws Exception {
        TestEventGeneration.assertEquals((int)this.queue.size(), (int)0);
        this.ehs.setAppTypes(new HashSet<String>(Arrays.asList("workflow_action")));
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.PREP, true);
        action.setExternalChildIDs(null);
        WorkflowActionQueryExecutor.getInstance().executeUpdate((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_START, (Object)action);
        new ActionStartXCommand(action.getId(), "map-reduce").call();
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(action.getId());
        action = (WorkflowActionBean)this.jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestEventGeneration.assertEquals((Object)WorkflowAction.Status.RUNNING, (Object)action.getStatus());
        TestEventGeneration.assertEquals((int)1, (int)this.queue.size());
        WorkflowActionEvent event = (WorkflowActionEvent)this.queue.poll();
        TestEventGeneration.assertNotNull((Object)event);
        TestEventGeneration.assertEquals((Object)JobEvent.EventStatus.STARTED, (Object)event.getEventStatus());
        TestEventGeneration.assertEquals((Object)AppType.WORKFLOW_ACTION, (Object)event.getAppType());
        TestEventGeneration.assertEquals((String)action.getId(), (String)event.getId());
        TestEventGeneration.assertEquals((String)job.getUser(), (String)event.getUser());
        TestEventGeneration.assertEquals((String)action.getName(), (String)event.getAppName());
        TestEventGeneration.assertEquals((Object)action.getStartTime(), (Object)event.getStartTime());
        TestEventGeneration.assertEquals((int)0, (int)this.queue.size());
        ActionXCommand.ActionExecutorContext context = new ActionXCommand.ActionExecutorContext(job, action, false, false);
        ActionExecutor executor = ((ActionService)Services.get().get(ActionService.class)).getExecutor(action.getType());
        ActionCheckXCommandForTest dac = new ActionCheckXCommandForTest((ActionExecutor.Context)context, executor, action.getId());
        dac.execute();
        action = dac.getAction();
        TestEventGeneration.assertEquals((Object)WorkflowAction.Status.START_MANUAL, (Object)action.getStatus());
        TestEventGeneration.assertEquals((int)1, (int)this.queue.size());
        event = (WorkflowActionEvent)this.queue.poll();
        TestEventGeneration.assertNotNull((Object)event);
        TestEventGeneration.assertEquals((Object)JobEvent.EventStatus.SUSPEND, (Object)event.getEventStatus());
        TestEventGeneration.assertEquals((Object)AppType.WORKFLOW_ACTION, (Object)event.getAppType());
        TestEventGeneration.assertEquals((String)action.getId(), (String)event.getId());
        TestEventGeneration.assertEquals((String)job.getUser(), (String)event.getUser());
        TestEventGeneration.assertEquals((String)action.getName(), (String)event.getAppName());
        TestEventGeneration.assertEquals((int)0, (int)this.queue.size());
        action.setStatus(WorkflowAction.Status.KILLED);
        action.setPendingOnly();
        action.setEndTime(null);
        WorkflowActionQueryExecutor.getInstance().executeUpdate((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_END, (Object)action);
        new ActionKillXCommand(action.getId()).call();
        action = (WorkflowActionBean)this.jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestEventGeneration.assertEquals((Object)WorkflowAction.Status.KILLED, (Object)action.getStatus());
        TestEventGeneration.assertEquals((int)1, (int)this.queue.size());
        event = (WorkflowActionEvent)this.queue.poll();
        TestEventGeneration.assertNotNull((Object)event);
        TestEventGeneration.assertEquals((Object)JobEvent.EventStatus.FAILURE, (Object)event.getEventStatus());
        TestEventGeneration.assertEquals((Object)AppType.WORKFLOW_ACTION, (Object)event.getAppType());
        TestEventGeneration.assertEquals((String)action.getId(), (String)event.getId());
        TestEventGeneration.assertEquals((String)job.getUser(), (String)event.getUser());
        TestEventGeneration.assertEquals((String)action.getName(), (String)event.getAppName());
        TestEventGeneration.assertEquals((Object)action.getStartTime(), (Object)event.getStartTime());
        TestEventGeneration.assertNotNull((Object)action.getEndTime());
        TestEventGeneration.assertNotNull((Object)event.getEndTime());
        TestEventGeneration.assertEquals((Object)action.getEndTime(), (Object)event.getEndTime());
        TestEventGeneration.assertEquals((int)0, (int)this.queue.size());
    }

    @Test
    public void testWorkflowJobEventError() throws Exception {
        final WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.FAILED, WorkflowInstance.Status.FAILED);
        KillXCommand myCmd = new KillXCommand(job.getId()){

            protected Void execute() {
                WorkflowXCommand.generateEvent((WorkflowJobBean)job, (String)"errorCode", (String)"errorMsg");
                return null;
            }
        };
        myCmd.call();
        WorkflowJobEvent event = (WorkflowJobEvent)this.queue.poll();
        TestEventGeneration.assertNotNull((Object)event);
        TestEventGeneration.assertEquals((String)"errorCode", (String)event.getErrorCode());
        TestEventGeneration.assertEquals((String)"errorMsg", (String)event.getErrorMessage());
        TestEventGeneration.assertEquals((Object)JobEvent.EventStatus.FAILURE, (Object)event.getEventStatus());
    }

    @Test
    public void testCoordinatorActionEventDependencies() throws Exception {
        final CoordinatorJobBean coord = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        final CoordinatorActionBean action = this.addRecordToCoordActionTable(coord.getId(), 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        WorkflowJobBean wjb = new WorkflowJobBean();
        wjb.setId(action.getExternalId());
        wjb.setLastModifiedTime(new Date());
        WorkflowJobQueryExecutor.getInstance().insert((JsonBean)wjb);
        CoordActionCheckXCommand myCmd = new CoordActionCheckXCommand(action.getId(), 0){

            protected Void execute() {
                CoordinatorXCommand.generateEvent((CoordinatorActionBean)action, (String)coord.getUser(), (String)coord.getAppName(), null);
                return null;
            }
        };
        action.setMissingDependencies("pull");
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_DEPENDENCIES, (Object)action);
        myCmd.call();
        CoordinatorActionEvent event = (CoordinatorActionEvent)this.queue.poll();
        TestEventGeneration.assertNotNull((Object)event);
        TestEventGeneration.assertEquals((String)"pull", (String)event.getMissingDeps());
        action.setMissingDependencies(null);
        action.setPushMissingDependencies("push");
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_DEPENDENCIES, (Object)action);
        myCmd.call();
        event = (CoordinatorActionEvent)this.queue.poll();
        TestEventGeneration.assertNotNull((Object)event);
        TestEventGeneration.assertEquals((String)"push", (String)event.getMissingDeps());
        action.setMissingDependencies("pull");
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_DEPENDENCIES, (Object)action);
        myCmd.call();
        event = (CoordinatorActionEvent)this.queue.poll();
        TestEventGeneration.assertNotNull((Object)event);
        TestEventGeneration.assertEquals((String)"pull#push", (String)event.getMissingDeps());
    }

    @Test
    public void testForNoDuplicatesWorkflowEvents() throws Exception {
        Reader reader = IOUtils.getResourceAsReader((String)"wf-no-op.xml", (int)-1);
        FileWriter writer = new FileWriter(this.getTestCaseDir() + "/workflow.xml");
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        DagEngine engine = new DagEngine(TestEventGeneration.getTestUser());
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", this.getTestCaseFileUri("workflow.xml"));
        conf.set("user.name", TestEventGeneration.getTestUser());
        String jobId1 = engine.submitJob((Configuration)conf, true);
        final WorkflowJobGetJPAExecutor readCmd = new WorkflowJobGetJPAExecutor(jobId1);
        this.waitFor(100, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return ((WorkflowJobBean)TestEventGeneration.this.jpaService.execute((JPAExecutor)readCmd)).getStatus() == WorkflowJob.Status.SUCCEEDED;
            }
        });
        TestEventGeneration.assertEquals((int)2, (int)this.queue.size());
        TestEventGeneration.assertEquals((Object)JobEvent.EventStatus.STARTED, (Object)((JobEvent)this.queue.poll()).getEventStatus());
        TestEventGeneration.assertEquals((Object)JobEvent.EventStatus.SUCCESS, (Object)((JobEvent)this.queue.poll()).getEventStatus());
        this.queue.clear();
    }

    @Test
    public void testForNoDuplicatesCoordinatorActionEvents() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2009-02-01T23:59Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2009-02-02T23:59Z");
        CoordinatorJobBean coord = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, false, false, 0);
        this._modifyCoordForFailureAction(coord, "wf-invalid-fork.xml");
        new CoordMaterializeTransitionXCommand(coord.getId(), 3600).call();
        final CoordJobGetJPAExecutor readCmd1 = new CoordJobGetJPAExecutor(coord.getId());
        this.waitFor(100, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorJobBean bean = (CoordinatorJobBean)TestEventGeneration.this.jpaService.execute((JPAExecutor)readCmd1);
                return bean.getStatus() == Job.Status.SUCCEEDED || bean.getStatus() == Job.Status.KILLED;
            }
        });
        TestEventGeneration.assertEquals((int)2, (int)this.queue.size());
        TestEventGeneration.assertEquals((Object)JobEvent.EventStatus.WAITING, (Object)((JobEvent)this.queue.poll()).getEventStatus());
        TestEventGeneration.assertEquals((Object)JobEvent.EventStatus.FAILURE, (Object)((JobEvent)this.queue.poll()).getEventStatus());
        this.queue.clear();
    }

    @Test
    public void testInvalidXMLCoordinatorFailsForNoDuplicates() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2009-02-01T23:59Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2009-02-02T23:59Z");
        this.ehs.getAppTypes().add("workflow_action");
        CoordinatorJobBean coord = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, false, false, 0);
        CoordinatorActionBean action = this.addRecordToCoordActionTable(coord.getId(), 1, CoordinatorAction.Status.RUNNING, "coord-action-sla1.xml", 0);
        WorkflowJobBean wf = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING, action.getId());
        action.setExternalId(wf.getId());
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION, (Object)action);
        String waId = this._createWorkflowAction(wf.getId(), "wf-action");
        new ActionStartXCommand(waId, action.getType()).call();
        final CoordJobGetJPAExecutor readCmd2 = new CoordJobGetJPAExecutor(coord.getId());
        this.waitFor(100, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return ((CoordinatorJobBean)TestEventGeneration.this.jpaService.execute((JPAExecutor)readCmd2)).getStatus() == Job.Status.KILLED;
            }
        });
        TestEventGeneration.assertEquals((int)3, (int)this.queue.size());
        HashMap<AppType, JobEvent> eventsMap = new HashMap<AppType, JobEvent>();
        while (this.queue.size() > 0) {
            JobEvent event = (JobEvent)this.queue.poll();
            eventsMap.put(event.getAppType(), event);
        }
        TestEventGeneration.assertEquals((int)3, (int)eventsMap.size());
        JobEvent wfActionEvent = (JobEvent)eventsMap.get(AppType.WORKFLOW_ACTION);
        TestEventGeneration.assertNotNull((String)"There should be a WF action", (Object)wfActionEvent);
        TestEventGeneration.assertEquals((Object)JobEvent.EventStatus.FAILURE, (Object)wfActionEvent.getEventStatus());
        TestEventGeneration.assertEquals((String)waId, (String)wfActionEvent.getId());
        TestEventGeneration.assertEquals((Object)AppType.WORKFLOW_ACTION, (Object)wfActionEvent.getAppType());
        JobEvent wfJobEvent = (JobEvent)eventsMap.get(AppType.WORKFLOW_JOB);
        TestEventGeneration.assertNotNull((String)"There should be a WF job", (Object)wfJobEvent);
        TestEventGeneration.assertEquals((Object)JobEvent.EventStatus.FAILURE, (Object)wfJobEvent.getEventStatus());
        TestEventGeneration.assertEquals((String)wf.getId(), (String)wfJobEvent.getId());
        TestEventGeneration.assertEquals((Object)AppType.WORKFLOW_JOB, (Object)wfJobEvent.getAppType());
        JobEvent coordActionEvent = (JobEvent)eventsMap.get(AppType.COORDINATOR_ACTION);
        TestEventGeneration.assertNotNull((String)"There should be a Coordinator action", (Object)coordActionEvent);
        TestEventGeneration.assertEquals((Object)JobEvent.EventStatus.FAILURE, (Object)coordActionEvent.getEventStatus());
        TestEventGeneration.assertEquals((String)action.getId(), (String)coordActionEvent.getId());
        TestEventGeneration.assertEquals((Object)AppType.COORDINATOR_ACTION, (Object)coordActionEvent.getAppType());
        this.queue.clear();
    }

    private WorkflowJobBean _createWorkflowJob() throws Exception {
        LiteWorkflowApp app = new LiteWorkflowApp("my-app", "<workflow-app/>", new StartNodeDef(TestLiteWorkflowLib.TestControlNodeHandler.class, "one")).addNode((NodeDef)new ActionNodeDef("one", "<java></java>", TestLiteWorkflowLib.TestActionNodeHandler.class, "end", "end")).addNode((NodeDef)new EndNodeDef("end", TestLiteWorkflowLib.TestControlNodeHandler.class));
        Configuration conf = new Configuration();
        Path appUri = new Path(this.getAppPath(), "workflow.xml");
        conf.set("oozie.wf.application.path", appUri.toString());
        conf.set("oozie.wf.log.token", "testToken");
        conf.set("user.name", TestEventGeneration.getTestUser());
        WorkflowJobBean workflow = this.createWorkflow((WorkflowApp)app, conf, WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        String executionPath = "/";
        TestEventGeneration.assertNotNull((Object)this.jpaService);
        WorkflowJobInsertJPAExecutor wfInsertCmd = new WorkflowJobInsertJPAExecutor(workflow);
        this.jpaService.execute((JPAExecutor)wfInsertCmd);
        WorkflowActionBean wfAction = this.addRecordToWfActionTable(workflow.getId(), "one", WorkflowAction.Status.OK, executionPath, true);
        wfAction.setPending();
        wfAction.setSignalValue(WorkflowAction.Status.OK.name());
        WorkflowActionQueryExecutor.getInstance().executeUpdate((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION, (Object)wfAction);
        return workflow;
    }

    private void _modifyCoordForFailureAction(CoordinatorJobBean coord, String resourceXml) throws Exception {
        String wfXml = IOUtils.getResourceAsString((String)resourceXml, (int)-1);
        this.writeToFile(wfXml, this.getFsTestCaseDir(), "workflow.xml");
        String coordXml = coord.getJobXml();
        coord.setJobXml(coordXml.replace("hdfs:///tmp/workflows/", this.getFsTestCaseDir() + "/workflow.xml"));
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coord);
    }

    private String _createWorkflowAction(String wfId, String actionName) throws JPAExecutorException {
        WorkflowActionBean action = new WorkflowActionBean();
        action.setName(actionName);
        action.setId(((UUIDService)Services.get().get(UUIDService.class)).generateChildId(wfId, actionName));
        action.setJobId(wfId);
        action.setType("java");
        action.setTransition("transition");
        action.setStatus(WorkflowAction.Status.PREP);
        action.setStartTime(new Date());
        action.setEndTime(new Date());
        action.setLastCheckTime(new Date());
        action.setPendingOnly();
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><main-class>${dummy}</java>";
        action.setConf(actionXml);
        this.jpaService.execute((JPAExecutor)new WorkflowActionInsertJPAExecutor(action));
        return action.getId();
    }

    private void waitForEventGeneration(int wait) {
        this.waitFor(wait, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return TestEventGeneration.this.ehs.getEventQueue().peek() != null;
            }
        });
    }

    private class ActionCheckXCommandForTest
    extends ActionCheckXCommand {
        ActionExecutor.Context context;
        ActionExecutor executor;
        WorkflowActionBean action;
        JPAService jpa;

        public ActionCheckXCommandForTest(ActionExecutor.Context context, ActionExecutor executor, String actionId) throws JPAExecutorException {
            super(actionId);
            this.context = context;
            this.executor = executor;
            this.jpa = (JPAService)Services.get().get(JPAService.class);
            this.action = (WorkflowActionBean)this.jpa.execute((JPAExecutor)new WorkflowActionGetJPAExecutor(actionId));
        }

        public Void execute() throws CommandException {
            this.handleNonTransient(this.context, this.executor, WorkflowAction.Status.START_MANUAL);
            this.action = (WorkflowActionBean)((ActionXCommand.ActionExecutorContext)this.context).getAction();
            if (!(this.executor instanceof ControlNodeActionExecutor) && EventHandlerService.isEnabled()) {
                this.generateEvent(this.action, TestEventGeneration.getTestUser());
            }
            return null;
        }

        public WorkflowActionBean getAction() {
            return this.action;
        }
    }
}

